/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;

final class AutoValue_AsyncWriteChannelOptions
extends AsyncWriteChannelOptions {
    private final int bufferSize;
    private final int pipeBufferSize;
    private final AsyncWriteChannelOptions.PipeType pipeType;
    private final int uploadChunkSize;
    private final int uploadCacheSize;
    private final boolean directUploadEnabled;
    private final boolean grpcChecksumsEnabled;
    private final long grpcWriteTimeout;
    private final long numberOfBufferedRequests;
    private final long grpcWriteMessageTimeoutMillis;

    private AutoValue_AsyncWriteChannelOptions(int bufferSize, int pipeBufferSize, AsyncWriteChannelOptions.PipeType pipeType, int uploadChunkSize, int uploadCacheSize, boolean directUploadEnabled, boolean grpcChecksumsEnabled, long grpcWriteTimeout, long numberOfBufferedRequests, long grpcWriteMessageTimeoutMillis) {
        this.bufferSize = bufferSize;
        this.pipeBufferSize = pipeBufferSize;
        this.pipeType = pipeType;
        this.uploadChunkSize = uploadChunkSize;
        this.uploadCacheSize = uploadCacheSize;
        this.directUploadEnabled = directUploadEnabled;
        this.grpcChecksumsEnabled = grpcChecksumsEnabled;
        this.grpcWriteTimeout = grpcWriteTimeout;
        this.numberOfBufferedRequests = numberOfBufferedRequests;
        this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int getPipeBufferSize() {
        return this.pipeBufferSize;
    }

    @Override
    public AsyncWriteChannelOptions.PipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public int getUploadChunkSize() {
        return this.uploadChunkSize;
    }

    @Override
    public int getUploadCacheSize() {
        return this.uploadCacheSize;
    }

    @Override
    public boolean isDirectUploadEnabled() {
        return this.directUploadEnabled;
    }

    @Override
    public boolean isGrpcChecksumsEnabled() {
        return this.grpcChecksumsEnabled;
    }

    @Override
    public long getGrpcWriteTimeout() {
        return this.grpcWriteTimeout;
    }

    @Override
    public long getNumberOfBufferedRequests() {
        return this.numberOfBufferedRequests;
    }

    @Override
    public long getGrpcWriteMessageTimeoutMillis() {
        return this.grpcWriteMessageTimeoutMillis;
    }

    public String toString() {
        return "AsyncWriteChannelOptions{bufferSize=" + this.bufferSize + ", pipeBufferSize=" + this.pipeBufferSize + ", pipeType=" + (Object)((Object)this.pipeType) + ", uploadChunkSize=" + this.uploadChunkSize + ", uploadCacheSize=" + this.uploadCacheSize + ", directUploadEnabled=" + this.directUploadEnabled + ", grpcChecksumsEnabled=" + this.grpcChecksumsEnabled + ", grpcWriteTimeout=" + this.grpcWriteTimeout + ", numberOfBufferedRequests=" + this.numberOfBufferedRequests + ", grpcWriteMessageTimeoutMillis=" + this.grpcWriteMessageTimeoutMillis + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AsyncWriteChannelOptions) {
            AsyncWriteChannelOptions that = (AsyncWriteChannelOptions)o;
            return this.bufferSize == that.getBufferSize() && this.pipeBufferSize == that.getPipeBufferSize() && this.pipeType.equals((Object)that.getPipeType()) && this.uploadChunkSize == that.getUploadChunkSize() && this.uploadCacheSize == that.getUploadCacheSize() && this.directUploadEnabled == that.isDirectUploadEnabled() && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled() && this.grpcWriteTimeout == that.getGrpcWriteTimeout() && this.numberOfBufferedRequests == that.getNumberOfBufferedRequests() && this.grpcWriteMessageTimeoutMillis == that.getGrpcWriteMessageTimeoutMillis();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeBufferSize;
        h$ *= 1000003;
        h$ ^= this.pipeType.hashCode();
        h$ *= 1000003;
        h$ ^= this.uploadChunkSize;
        h$ *= 1000003;
        h$ ^= this.uploadCacheSize;
        h$ *= 1000003;
        h$ ^= this.directUploadEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.grpcChecksumsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.grpcWriteTimeout >>> 32 ^ this.grpcWriteTimeout);
        h$ *= 1000003;
        h$ ^= (int)(this.numberOfBufferedRequests >>> 32 ^ this.numberOfBufferedRequests);
        h$ *= 1000003;
        return h$ ^= (int)(this.grpcWriteMessageTimeoutMillis >>> 32 ^ this.grpcWriteMessageTimeoutMillis);
    }

    @Override
    public AsyncWriteChannelOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AsyncWriteChannelOptions.Builder {
        private int bufferSize;
        private int pipeBufferSize;
        private AsyncWriteChannelOptions.PipeType pipeType;
        private int uploadChunkSize;
        private int uploadCacheSize;
        private boolean directUploadEnabled;
        private boolean grpcChecksumsEnabled;
        private long grpcWriteTimeout;
        private long numberOfBufferedRequests;
        private long grpcWriteMessageTimeoutMillis;
        private short set$0;

        Builder() {
        }

        private Builder(AsyncWriteChannelOptions source) {
            this.bufferSize = source.getBufferSize();
            this.pipeBufferSize = source.getPipeBufferSize();
            this.pipeType = source.getPipeType();
            this.uploadChunkSize = source.getUploadChunkSize();
            this.uploadCacheSize = source.getUploadCacheSize();
            this.directUploadEnabled = source.isDirectUploadEnabled();
            this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
            this.grpcWriteTimeout = source.getGrpcWriteTimeout();
            this.numberOfBufferedRequests = source.getNumberOfBufferedRequests();
            this.grpcWriteMessageTimeoutMillis = source.getGrpcWriteMessageTimeoutMillis();
            this.set$0 = (short)511;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            this.set$0 = (short)(this.set$0 | 1);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeBufferSize(int pipeBufferSize) {
            this.pipeBufferSize = pipeBufferSize;
            this.set$0 = (short)(this.set$0 | 2);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setPipeType(AsyncWriteChannelOptions.PipeType pipeType) {
            if (pipeType == null) {
                throw new NullPointerException("Null pipeType");
            }
            this.pipeType = pipeType;
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadChunkSize(int uploadChunkSize) {
            this.uploadChunkSize = uploadChunkSize;
            this.set$0 = (short)(this.set$0 | 4);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setUploadCacheSize(int uploadCacheSize) {
            this.uploadCacheSize = uploadCacheSize;
            this.set$0 = (short)(this.set$0 | 8);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setDirectUploadEnabled(boolean directUploadEnabled) {
            this.directUploadEnabled = directUploadEnabled;
            this.set$0 = (short)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
            this.grpcChecksumsEnabled = grpcChecksumsEnabled;
            this.set$0 = (short)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcWriteTimeout(long grpcWriteTimeout) {
            this.grpcWriteTimeout = grpcWriteTimeout;
            this.set$0 = (short)(this.set$0 | 0x40);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setNumberOfBufferedRequests(long numberOfBufferedRequests) {
            this.numberOfBufferedRequests = numberOfBufferedRequests;
            this.set$0 = (short)(this.set$0 | 0x80);
            return this;
        }

        @Override
        public AsyncWriteChannelOptions.Builder setGrpcWriteMessageTimeoutMillis(long grpcWriteMessageTimeoutMillis) {
            this.grpcWriteMessageTimeoutMillis = grpcWriteMessageTimeoutMillis;
            this.set$0 = (short)(this.set$0 | 0x100);
            return this;
        }

        @Override
        AsyncWriteChannelOptions autoBuild() {
            if (this.set$0 != 511 || this.pipeType == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" bufferSize");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" pipeBufferSize");
                }
                if (this.pipeType == null) {
                    missing.append(" pipeType");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" uploadChunkSize");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" uploadCacheSize");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" directUploadEnabled");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" grpcChecksumsEnabled");
                }
                if ((this.set$0 & 0x40) == 0) {
                    missing.append(" grpcWriteTimeout");
                }
                if ((this.set$0 & 0x80) == 0) {
                    missing.append(" numberOfBufferedRequests");
                }
                if ((this.set$0 & 0x100) == 0) {
                    missing.append(" grpcWriteMessageTimeoutMillis");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AsyncWriteChannelOptions(this.bufferSize, this.pipeBufferSize, this.pipeType, this.uploadChunkSize, this.uploadCacheSize, this.directUploadEnabled, this.grpcChecksumsEnabled, this.grpcWriteTimeout, this.numberOfBufferedRequests, this.grpcWriteMessageTimeoutMillis);
        }
    }
}

