/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.adapter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.beam.runners.flink.FlinkBatchPortablePipelineTranslator;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.adapter.BeamAdapterCoderUtils;
import org.apache.beam.runners.flink.adapter.BeamAdapterUtils;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.PipelineOptionsTranslation;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamFlinkDataSetAdapter {
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry = CoderRegistry.createDefault();

    public BeamFlinkDataSetAdapter() {
        this(PipelineOptionsFactory.create());
    }

    public BeamFlinkDataSetAdapter(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public <InputT, OutputT, CollectionT extends PCollection<? extends InputT>> @UnknownKeyFor @NonNull @Initialized DataSet<OutputT> applyBeamPTransform(@UnknownKeyFor @NonNull @Initialized DataSet<InputT> input, @UnknownKeyFor @NonNull @Initialized PTransform<CollectionT, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> transform) {
        return this.getNonNull(this.applyBeamPTransformInternal((Map<String, ? extends DataSet<?>>)ImmutableMap.of((Object)"input", input), (BiFunction)(pipeline, map) -> (PCollection)this.getNonNull((Map)map, (Object)"input"), (Function)output -> ImmutableMap.of((Object)"output", (Object)output), (PTransform)transform, input.getExecutionEnvironment()), "output");
    }

    public <OutputT> @UnknownKeyFor @NonNull @Initialized DataSet<OutputT> applyBeamPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> transform) {
        return this.getNonNull(this.applyBeamPTransformInternal(inputs, BeamAdapterUtils::mapToTuple, output -> ImmutableMap.of((Object)"output", (Object)output), transform, inputs.values().stream().findAny().get().getExecutionEnvironment()), "output");
    }

    public <OutputT> @UnknownKeyFor @NonNull @Initialized DataSet<OutputT> applyBeamPTransform(@UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> transform) {
        return this.getNonNull(this.applyBeamPTransformInternal((Map<String, ? extends DataSet<?>>)ImmutableMap.of(), (BiFunction)(pipeline, map) -> PBegin.in((Pipeline)pipeline), (Function)output -> ImmutableMap.of((Object)"output", (Object)output), (PTransform)transform, executionEnvironment), "output");
    }

    public <InputT, CollectionT extends PCollection<? extends InputT>> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyMultiOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized DataSet<InputT> input, @UnknownKeyFor @NonNull @Initialized PTransform<CollectionT, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform) {
        return this.applyBeamPTransformInternal((Map<String, ? extends DataSet<?>>)ImmutableMap.of((Object)"input", input), (BiFunction)(pipeline, map) -> (PCollection)this.getNonNull((Map)map, (Object)"input"), (Function)BeamAdapterUtils::tupleToMap, (PTransform)transform, input.getExecutionEnvironment());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyMultiOutputBeamPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform) {
        return this.applyBeamPTransformInternal(inputs, BeamAdapterUtils::mapToTuple, BeamAdapterUtils::tupleToMap, transform, inputs.values().stream().findAny().get().getExecutionEnvironment());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyMultiOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> transform) {
        return this.applyBeamPTransformInternal((Map<String, ? extends DataSet<?>>)ImmutableMap.of(), (BiFunction)(pipeline, map) -> PBegin.in((Pipeline)pipeline), (Function)BeamAdapterUtils::tupleToMap, (PTransform)transform, executionEnvironment);
    }

    public <InputT, CollectionT extends PCollection<? extends InputT>> void applyNoOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized DataSet<InputT> input, @UnknownKeyFor @NonNull @Initialized PTransform<CollectionT, @UnknownKeyFor @NonNull @Initialized PDone> transform) {
        this.applyBeamPTransformInternal((Map<String, ? extends DataSet<?>>)ImmutableMap.of((Object)"input", input), (BiFunction)(pipeline, map) -> (PCollection)this.getNonNull((Map)map, (Object)"input"), (Function)pDone -> ImmutableMap.of(), (PTransform)transform, input.getExecutionEnvironment());
    }

    public void applyNoOutputBeamPTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized PDone> transform) {
        this.applyBeamPTransformInternal(inputs, BeamAdapterUtils::mapToTuple, pDone -> ImmutableMap.of(), transform, inputs.values().stream().findAny().get().getExecutionEnvironment());
    }

    public void applyNoOutputBeamPTransform(@UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PDone> transform) {
        this.applyBeamPTransformInternal((Map<String, ? extends DataSet<?>>)ImmutableMap.of(), (BiFunction)(pipeline, map) -> PBegin.in((Pipeline)pipeline), (Function)pDone -> ImmutableMap.of(), (PTransform)transform, executionEnvironment);
    }

    private <BeamInputT extends PInput, BeamOutputT extends POutput> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> applyBeamPTransformInternal(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized Pipeline, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>, BeamInputT> toBeamInput, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Function<BeamOutputT, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> fromBeamOutput, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super BeamInputT, BeamOutputT> transform, @UnknownKeyFor @NonNull @Initialized ExecutionEnvironment executionEnvironment) {
        return BeamAdapterUtils.applyBeamPTransformInternal(inputs, toBeamInput, fromBeamOutput, transform, executionEnvironment, true, dataSet -> dataSet.getType(), this.pipelineOptions, this.coderRegistry, (flinkInputs, pipelineProto, env) -> {
            HashMap flinkOutputs = new HashMap();
            FlinkBatchPortablePipelineTranslator translator = FlinkBatchPortablePipelineTranslator.createTranslator((Map<String, FlinkBatchPortablePipelineTranslator.PTransformTranslator>)ImmutableMap.of((Object)"beam:flink:internal:translation_input", (Object)this.flinkInputTranslator(flinkInputs), (Object)"beam:flink:internal:translation_output", (Object)this.flinkOutputTranslator(flinkOutputs)));
            FlinkBatchPortablePipelineTranslator.BatchTranslationContext context = FlinkBatchPortablePipelineTranslator.createTranslationContext(JobInfo.create((String)"unusedJobId", (String)"unusedJobName", (String)"unusedRetrievalToken", (Struct)PipelineOptionsTranslation.toProto((PipelineOptions)this.pipelineOptions)), (FlinkPipelineOptions)this.pipelineOptions.as(FlinkPipelineOptions.class), env);
            translator.translate(context, translator.prepareForTranslation(pipelineProto));
            return flinkOutputs;
        });
    }

    private <InputT> @UnknownKeyFor @NonNull @Initialized FlinkBatchPortablePipelineTranslator.PTransformTranslator flinkInputTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputMap) {
        return (t, p, context) -> {
            String inputId = t.getTransform().getSpec().getPayload().toStringUtf8();
            DataSet flinkInput = (DataSet)Preconditions.checkStateNotNull((Object)((DataSet)inputMap.get(inputId)), (String)"missing input referenced in proto: ", (Object)inputId);
            context.addDataSet((String)Iterables.getOnlyElement(t.getTransform().getOutputsMap().values()), new MapOperator(flinkInput, BeamAdapterCoderUtils.coderToTypeInformation(WindowedValue.getValueOnlyCoder(BeamAdapterCoderUtils.typeInformationToCoder(flinkInput.getType(), this.coderRegistry)), this.pipelineOptions), (MapFunction & Serializable)x -> WindowedValue.valueInGlobalWindow((Object)x), "AddGlobalWindows"));
        };
    }

    private <InputT> @UnknownKeyFor @NonNull @Initialized FlinkBatchPortablePipelineTranslator.PTransformTranslator flinkOutputTranslator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DataSet<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputMap) {
        return (t, p, context) -> {
            DataSet inputDataSet = context.getDataSetOrThrow((String)Iterables.getOnlyElement(t.getTransform().getInputsMap().values()));
            String outputId = t.getTransform().getSpec().getPayload().toStringUtf8();
            Coder outputCoder = BeamAdapterCoderUtils.lookupCoder(p, (String)Iterables.getOnlyElement(t.getTransform().getInputsMap().values()));
            outputMap.put(outputId, (DataSet<?>)new MapOperator(inputDataSet, BeamAdapterCoderUtils.coderToTypeInformation(outputCoder, this.pipelineOptions), (MapFunction & Serializable)w -> w.getValue(), "StripWindows"));
        };
    }

    private <K, V> V getNonNull(@UnknownKeyFor @NonNull @Initialized Map<K, V> map, K key) {
        return (V)Preconditions.checkStateNotNull(map.get(Preconditions.checkArgumentNotNull(key)));
    }
}

