/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.spark.api.java.JavaSparkContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SparkTranslationContext {
    private final @UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc;
    final @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> consumptionCount = new HashMap<String, Integer>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Coder> coderMap = new HashMap<String, Coder>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Dataset> datasets = new LinkedHashMap<String, Dataset>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Dataset> leaves = new LinkedHashSet<Dataset>();
    final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializablePipelineOptions;
    private @UnknownKeyFor @NonNull @Initialized int sinkId = 0;

    public SparkTranslationContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized JobInfo jobInfo) {
        this.jsc = jsc;
        this.serializablePipelineOptions = new SerializablePipelineOptions(options);
        this.jobInfo = jobInfo;
    }

    public @UnknownKeyFor @NonNull @Initialized JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions getSerializableOptions() {
        return this.serializablePipelineOptions;
    }

    public void pushDataset(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized Dataset dataset) {
        dataset.setName(pCollectionId);
        SparkPipelineOptions sparkOptions = (SparkPipelineOptions)this.serializablePipelineOptions.get().as(SparkPipelineOptions.class);
        if (!sparkOptions.isCacheDisabled() && this.consumptionCount.getOrDefault(pCollectionId, 0) > 1) {
            String storageLevel = sparkOptions.getStorageLevel();
            @Nullable Coder coder = this.coderMap.get(pCollectionId);
            dataset.cache(storageLevel, coder);
        }
        this.datasets.put(pCollectionId, dataset);
        this.leaves.add(dataset);
    }

    public @UnknownKeyFor @NonNull @Initialized Dataset popDataset(@UnknownKeyFor @NonNull @Initialized String pCollectionId) {
        Dataset dataset = this.datasets.get(pCollectionId);
        this.leaves.remove(dataset);
        return dataset;
    }

    public void computeOutputs() {
        for (Dataset dataset : this.leaves) {
            dataset.action();
        }
    }

    void incrementConsumptionCountBy(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized int addend) {
        int count = this.consumptionCount.getOrDefault(pCollectionId, 0);
        this.consumptionCount.put(pCollectionId, count + addend);
    }

    void putCoder(@UnknownKeyFor @NonNull @Initialized String pCollectionId, @UnknownKeyFor @NonNull @Initialized Coder coder) {
        this.coderMap.put(pCollectionId, coder);
    }

    public @UnknownKeyFor @NonNull @Initialized int nextSinkId() {
        return this.sinkId++;
    }
}

