/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

public abstract class HandshakeOption<T> {
    protected final int level;
    protected final String handshakeField;
    boolean sent = false;
    T desiredValue;

    protected HandshakeOption(int n, String string, T t) {
        if (t == null) {
            throw new IllegalArgumentException("initial value must not be null");
        }
        this.level = n;
        this.handshakeField = string;
        this.desiredValue = t;
    }

    public void set(T t) {
        if (t == null) {
            throw new IllegalArgumentException("new value must not be null");
        }
        this.desiredValue = t;
    }

    public T get() {
        return this.desiredValue;
    }

    public int getLevel() {
        return this.level;
    }

    public String getFieldName() {
        return this.handshakeField;
    }

    public boolean isSent() {
        return this.sent;
    }

    public void setSent(boolean bl) {
        this.sent = bl;
    }

    public boolean mustSend(T t) {
        if (this.sent) {
            return false;
        }
        return !t.equals(this.desiredValue);
    }

    abstract long numericValue();

    public static class TimeZone
    extends HandshakeOption<Integer> {
        public TimeZone(int n) {
            super(5, "time_zone", n);
        }

        @Override
        long numericValue() {
            return ((Integer)this.desiredValue).intValue();
        }
    }

    public static class SizeHeader
    extends BooleanOption {
        public SizeHeader(boolean bl) {
            super(3, "size_header", bl);
            this.set(bl);
        }
    }

    public static class ReplySize
    extends HandshakeOption<Integer> {
        public ReplySize(int n) {
            super(2, "reply_size", n);
        }

        @Override
        long numericValue() {
            return ((Integer)this.desiredValue).intValue();
        }
    }

    public static class AutoCommit
    extends BooleanOption {
        public AutoCommit(boolean bl) {
            super(1, "auto_commit", bl);
        }
    }

    protected static class BooleanOption
    extends HandshakeOption<Boolean> {
        protected BooleanOption(int n, String string, Boolean bl) {
            super(n, string, bl);
        }

        @Override
        long numericValue() {
            return (Boolean)this.desiredValue != false ? 1L : 0L;
        }
    }
}

