/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.Closeable;
import org.apache.cassandra.utils.TimeUUID;

public class CollatedViewIndexBuilder
extends SecondaryIndexBuilder
implements Closeable {
    private final ColumnFamilyStore cfs;
    private final Set<Index> indexers;
    private final ReducingKeyIterator iter;
    private final TimeUUID compactionId;
    private final Collection<SSTableReader> sstables;

    public CollatedViewIndexBuilder(ColumnFamilyStore cfs, Set<Index> indexers, ReducingKeyIterator iter, Collection<SSTableReader> sstables) {
        this.cfs = cfs;
        this.indexers = indexers;
        this.iter = iter;
        this.compactionId = TimeUUID.Generator.nextTimeUUID();
        this.sstables = sstables;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.cfs.metadata(), OperationType.INDEX_BUILD, this.iter.getBytesRead(), this.iter.getTotalBytes(), this.compactionId, this.sstables);
    }

    @Override
    public void build() {
        int pageSize = this.cfs.indexManager.calculateIndexingPageSize();
        RegularAndStaticColumns targetPartitionColumns = this.extractIndexedColumns();
        while (this.iter.hasNext()) {
            if (this.isStopRequested()) {
                throw new CompactionInterruptedException(this.getCompactionInfo());
            }
            DecoratedKey key = this.iter.next();
            this.cfs.indexManager.indexPartition(key, this.indexers, pageSize, targetPartitionColumns);
        }
    }

    @Override
    public void close() {
        this.iter.close();
    }

    private RegularAndStaticColumns extractIndexedColumns() {
        RegularAndStaticColumns.Builder builder = RegularAndStaticColumns.builder();
        for (Index index : this.indexers) {
            boolean isPartitionIndex = true;
            for (ColumnMetadata column : this.cfs.metadata().regularAndStaticColumns()) {
                if (!index.dependsOn(column)) continue;
                builder.add(column);
                isPartitionIndex = false;
            }
            if (!isPartitionIndex) continue;
            return this.cfs.metadata().regularAndStaticColumns();
        }
        return builder.build();
    }
}

