/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.webserviceavailable;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.webserviceavailable.ActionWebServiceAvailable;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionWebServiceAvailableDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionWebServiceAvailable.class;
    private Text wName;
    private TextVar wURL;
    private TextVar wConnectTimeOut;
    private TextVar wReadTimeOut;
    private ActionWebServiceAvailable action;
    private boolean changed;

    public ActionWebServiceAvailableDialog(Shell parent, ActionWebServiceAvailable action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        this.shell = new Shell(this.getParent(), 3312);
        this.shell.setMinimumSize(400, 220);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"System.ActionName.Label", (String[])new String[0]));
        wlName.setToolTipText(BaseMessages.getString(PKG, (String)"System.ActionName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlURL = new Label((Composite)this.shell, 131072);
        wlURL.setText(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.URL.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlURL);
        FormData fdlURL = new FormData();
        fdlURL.left = new FormAttachment(0, 0);
        fdlURL.top = new FormAttachment((Control)this.wName, margin);
        fdlURL.right = new FormAttachment(middle, -margin);
        wlURL.setLayoutData((Object)fdlURL);
        this.wURL = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wURL);
        this.wURL.addModifyListener(lsMod);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(middle, 0);
        fdURL.top = new FormAttachment((Control)this.wName, margin);
        fdURL.right = new FormAttachment(100, -margin);
        this.wURL.setLayoutData((Object)fdURL);
        this.wURL.addModifyListener(e -> this.wURL.setToolTipText(this.variables.resolve(this.wURL.getText())));
        Label wlConnectTimeOut = new Label((Composite)this.shell, 131072);
        wlConnectTimeOut.setText(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.ConnectTimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConnectTimeOut);
        FormData fdlConnectTimeOut = new FormData();
        fdlConnectTimeOut.left = new FormAttachment(0, 0);
        fdlConnectTimeOut.top = new FormAttachment((Control)this.wURL, margin);
        fdlConnectTimeOut.right = new FormAttachment(middle, -margin);
        wlConnectTimeOut.setLayoutData((Object)fdlConnectTimeOut);
        this.wConnectTimeOut = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wConnectTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.ConnectTimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wConnectTimeOut);
        this.wConnectTimeOut.addModifyListener(lsMod);
        FormData fdConnectTimeOut = new FormData();
        fdConnectTimeOut.left = new FormAttachment(middle, 0);
        fdConnectTimeOut.top = new FormAttachment((Control)this.wURL, margin);
        fdConnectTimeOut.right = new FormAttachment(100, -margin);
        this.wConnectTimeOut.setLayoutData((Object)fdConnectTimeOut);
        this.wConnectTimeOut.addModifyListener(e -> this.wConnectTimeOut.setToolTipText(this.variables.resolve(this.wConnectTimeOut.getText())));
        Label wlReadTimeOut = new Label((Composite)this.shell, 131072);
        wlReadTimeOut.setText(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.ReadTimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReadTimeOut);
        FormData fdlReadTimeOut = new FormData();
        fdlReadTimeOut.left = new FormAttachment(0, 0);
        fdlReadTimeOut.top = new FormAttachment((Control)this.wConnectTimeOut, margin);
        fdlReadTimeOut.right = new FormAttachment(middle, -margin);
        wlReadTimeOut.setLayoutData((Object)fdlReadTimeOut);
        this.wReadTimeOut = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wReadTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWebServiceAvailable.ReadTimeOut.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wReadTimeOut);
        this.wReadTimeOut.addModifyListener(lsMod);
        FormData fdReadTimeOut = new FormData();
        fdReadTimeOut.left = new FormAttachment(middle, 0);
        fdReadTimeOut.top = new FormAttachment((Control)this.wConnectTimeOut, margin);
        fdReadTimeOut.right = new FormAttachment(100, -margin);
        this.wReadTimeOut.setLayoutData((Object)fdReadTimeOut);
        this.wReadTimeOut.addModifyListener(e -> this.wReadTimeOut.setToolTipText(this.variables.resolve(this.wReadTimeOut.getText())));
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wURL.setText(Const.nullToEmpty((String)this.action.getURL()));
        this.wConnectTimeOut.setText(Const.NVL((String)this.action.getConnectTimeOut(), (String)"0"));
        this.wReadTimeOut.setText(Const.NVL((String)this.action.getReadTimeOut(), (String)"0"));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setURL(this.wURL.getText());
        this.action.setConnectTimeOut(this.wConnectTimeOut.getText());
        this.action.setReadTimeOut(this.wReadTimeOut.getText());
        this.dispose();
    }
}

