/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.hop.mongo.AuthContext;
import org.apache.hop.mongo.MongoDbException;

public class KerberosInvocationHandler
implements InvocationHandler {
    private final AuthContext authContext;
    private final Object delegate;

    public KerberosInvocationHandler(AuthContext authContext, Object delegate) {
        this.authContext = authContext;
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws MongoDbException {
        try {
            return this.authContext.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        return method.invoke(KerberosInvocationHandler.this.delegate, args);
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Exception) {
                            throw (Exception)cause;
                        }
                        throw e;
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof MongoDbException) {
                throw (MongoDbException)e.getCause();
            }
            throw new MongoDbException(e.getCause());
        }
    }

    public static <T> T wrap(Class<T> iface, AuthContext authContext, Object delegate) {
        return (T)Proxy.newProxyInstance(KerberosInvocationHandler.class.getClassLoader(), new Class[]{iface}, (InvocationHandler)new KerberosInvocationHandler(authContext, delegate));
    }
}

