/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.loginfo;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfo;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoData;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoMetaInjectionTypeConverter;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoTypes;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

@Transform(id="GetLoggingInfo", name="i18n::GetLoggingInfoDialog.DialogTitle", description="i18n::GetLoggingInfoDialog.Description", categoryDescription="Neo4j", image="systeminfo.svg", keywords={"i18n::GetLoggingInfoMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-getloginfo.html")
@InjectionSupported(localizationPrefix="GetLoggingInfoMeta.Injection.")
public class GetLoggingInfoMeta
extends BaseTransformMeta<GetLoggingInfo, GetLoggingInfoData> {
    private static final Class<?> PKG = GetLoggingInfoMeta.class;
    public static final String CONST_SPACES = "        ";
    @Injection(name="FIELD_NAME")
    private String[] fieldName;
    @Injection(name="FIELD_TYPE", converter=GetLoggingInfoMetaInjectionTypeConverter.class)
    private GetLoggingInfoTypes[] fieldType;
    @Injection(name="FIELD_ARGUMENT")
    private String[] fieldArgument;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public GetLoggingInfoTypes[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(GetLoggingInfoTypes[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldArgument() {
        return this.fieldArgument;
    }

    public void setFieldArgument(String[] fieldArgument) {
        this.fieldArgument = fieldArgument;
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new GetLoggingInfoTypes[count];
        this.fieldArgument = new String[count];
    }

    public Object clone() {
        GetLoggingInfoMeta retval = (GetLoggingInfoMeta)((Object)super.clone());
        int count = this.fieldName.length;
        retval.allocate(count);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, count);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, count);
        System.arraycopy(this.fieldArgument, 0, retval.fieldArgument, 0, count);
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                String type = XmlHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldType[i] = GetLoggingInfoTypes.getTypeFromString(type);
                this.fieldArgument[i] = XmlHandler.getTagValue((Node)fnode, (String)"argument");
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read transform information from Xml", (Throwable)e);
        }
    }

    public void setDefault() {
        this.allocate(4);
        this.fieldName[0] = "startOfPipelineDelta";
        this.fieldType[0] = GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM;
        this.fieldName[1] = "endOfPipelineDelta";
        this.fieldType[1] = GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_TO;
        this.fieldName[2] = "startOfWorkflowDelta";
        this.fieldType[2] = GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_FROM;
        this.fieldName[3] = "endOfWorkflowDelta";
        this.fieldType[3] = GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMetaDate v = switch (this.fieldType[i]) {
                case GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_DATE_TO, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_FROM, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_PREVIOUS_EXECUTION_DATE, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_PIPELINE_PREVIOUS_SUCCESS_DATE, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_PREVIOUS_EXECUTION_DATE, GetLoggingInfoTypes.TYPE_SYSTEM_INFO_WORKFLOW_PREVIOUS_SUCCESS_DATE -> new ValueMetaDate(this.fieldName[i]);
                default -> new ValueMetaNone(this.fieldName[i]);
            };
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"type", (String)(this.fieldType[i] != null ? this.fieldType[i].getCode() : "")));
            retval.append(CONST_SPACES + XmlHandler.addTagValue((String)"argument", (String)this.fieldArgument[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldType[i].ordinal() > GetLoggingInfoTypes.TYPE_SYSTEM_INFO_NONE.ordinal()) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.FieldHasNoType", (String[])new String[]{this.fieldName[i]}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLoggingInfoMeta)) {
            return false;
        }
        GetLoggingInfoMeta that = (GetLoggingInfoMeta)((Object)o);
        if (!Arrays.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        return Arrays.equals((Object[])this.fieldType, (Object[])that.fieldType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fieldName);
        result = 31 * result + Arrays.hashCode((Object[])this.fieldType);
        return result;
    }
}

