/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class CachingFactory<@UnknownKeyFor CreatedT>
implements Factory<CreatedT> {
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, CreatedT> cache = null;
    private final @UnknownKeyFor @NonNull @Initialized Factory<CreatedT> innerFactory;

    public CachingFactory(@UnknownKeyFor @NonNull @Initialized Factory<CreatedT> innerFactory) {
        this.innerFactory = innerFactory;
    }

    @Override
    public CreatedT create(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        CreatedT cached;
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        if ((cached = this.cache.get(typeDescriptor)) != null) {
            return cached;
        }
        cached = this.innerFactory.create(typeDescriptor, schema);
        this.cache.put(typeDescriptor, cached);
        return cached;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingFactory that = (CachingFactory)o;
        return this.innerFactory.equals(that.innerFactory);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.innerFactory);
    }
}

