/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.metrics.StringSet;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class Lineage {
    public static final @UnknownKeyFor @NonNull @Initialized String LINEAGE_NAMESPACE = "lineage";
    private static final @UnknownKeyFor @NonNull @Initialized Lineage SOURCES = new Lineage(Type.SOURCE);
    private static final @UnknownKeyFor @NonNull @Initialized Lineage SINKS = new Lineage(Type.SINK);
    private static final @UnknownKeyFor @NonNull @Initialized Pattern RESERVED_CHARS = Pattern.compile("[:\\s.]");
    private final @UnknownKeyFor @NonNull @Initialized StringSet metric;

    private Lineage(@UnknownKeyFor @NonNull @Initialized Type type) {
        this.metric = Metrics.stringSet(LINEAGE_NAMESPACE, type.toString());
    }

    public static @UnknownKeyFor @NonNull @Initialized Lineage getSources() {
        return SOURCES;
    }

    public static @UnknownKeyFor @NonNull @Initialized Lineage getSinks() {
        return SINKS;
    }

    private static @UnknownKeyFor @NonNull @Initialized String wrapSegment(@UnknownKeyFor @NonNull @Initialized String value) {
        if (value.startsWith("`") && value.endsWith("`")) {
            return value;
        }
        if (RESERVED_CHARS.matcher(value).find()) {
            return String.format("`%s`", value);
        }
        return value;
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized String getFqName(@UnknownKeyFor @NonNull @Initialized String system, @Nullable @UnknownKeyFor @Initialized String routine, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments) {
        StringBuilder builder = new StringBuilder(system);
        if (!Strings.isNullOrEmpty((String)routine)) {
            builder.append(":").append(routine);
        }
        int idx = 0;
        for (String segment : segments) {
            if (idx == 0) {
                builder.append(":");
            } else {
                builder.append(".");
            }
            builder.append(Lineage.wrapSegment(segment));
            ++idx;
        }
        return builder.toString();
    }

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized String getFqName(@UnknownKeyFor @NonNull @Initialized String system, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments) {
        return Lineage.getFqName(system, null, segments);
    }

    public void add(@UnknownKeyFor @NonNull @Initialized String system, @Nullable @UnknownKeyFor @Initialized String routine, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments) {
        this.metric.add(Lineage.getFqName(system, routine, segments));
    }

    public void add(@UnknownKeyFor @NonNull @Initialized String system, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments) {
        this.add(system, null, segments);
    }

    public static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> query(@UnknownKeyFor @NonNull @Initialized MetricResults results, @UnknownKeyFor @NonNull @Initialized Type type) {
        MetricsFilter filter = MetricsFilter.builder().addNameFilter(MetricNameFilter.named(LINEAGE_NAMESPACE, type.toString())).build();
        HashSet<String> result = new HashSet<String>();
        for (MetricResult<StringSetResult> metrics : results.queryMetrics(filter).getStringSets()) {
            result.addAll(metrics.getCommitted().getStringSet());
            result.addAll(metrics.getAttempted().getStringSet());
        }
        return result;
    }

    public static enum Type {
        SOURCE("sources"),
        SINK("sinks");

        private final @UnknownKeyFor @NonNull @Initialized String name;

        private Type(String name) {
            this.name = name;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return this.name;
        }
    }
}

