/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.v1;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.CountDownLatch;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public abstract class AbstractPaxosCallback<T>
implements RequestCallback<T> {
    protected final CountDownLatch latch;
    protected final int targets;
    private final ConsistencyLevel consistency;
    private final long queryStartNanoTime;

    public AbstractPaxosCallback(int targets, ConsistencyLevel consistency, long queryStartNanoTime) {
        this.targets = targets;
        this.consistency = consistency;
        this.latch = CountDownLatch.newCountDownLatch(targets);
        this.queryStartNanoTime = queryStartNanoTime;
    }

    public int getResponseCount() {
        return this.targets - this.latch.count();
    }

    public void await() throws WriteTimeoutException {
        try {
            long timeout = DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS) - (Clock.Global.nanoTime() - this.queryStartNanoTime);
            if (!this.latch.await(timeout, TimeUnit.NANOSECONDS)) {
                throw new WriteTimeoutException(WriteType.CAS, this.consistency, this.getResponseCount(), this.targets);
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
    }
}

