/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AlterTableStatement
extends AlterSchemaStatement {
    protected final String tableName;
    private final boolean ifExists;

    public AlterTableStatement(String keyspaceName, String tableName, boolean ifExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        TableMetadata table;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        TableMetadata tableMetadata = table = null == keyspace ? null : keyspace.getTableOrViewNullable(this.tableName);
        if (null == table) {
            if (!this.ifExists) {
                throw AlterTableStatement.ire("Table '%s.%s' doesn't exist", this.keyspaceName, this.tableName);
            }
            return schema;
        }
        if (table.isView()) {
            throw AlterTableStatement.ire("Cannot use ALTER TABLE on a materialized view; use ALTER MATERIALIZED VIEW instead", new Object[0]);
        }
        return schema.withAddedOrUpdated(this.apply(keyspace, table));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureTablePermission(this.keyspaceName, this.tableName, Permission.ALTER);
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.ALTER_TABLE, this.keyspaceName, this.tableName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.tableName);
    }

    abstract KeyspaceMetadata apply(KeyspaceMetadata var1, TableMetadata var2);

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final boolean ifTableExists;
        private boolean ifColumnExists;
        private boolean ifColumnNotExists;
        private Kind kind;
        private final List<AddColumns.Column> addedColumns = new ArrayList<AddColumns.Column>();
        private final Set<ColumnIdentifier> droppedColumns = new HashSet<ColumnIdentifier>();
        private Long timestamp = null;
        private final Map<ColumnIdentifier, ColumnIdentifier> renamedColumns = new HashMap<ColumnIdentifier, ColumnIdentifier>();
        public final TableAttributes attrs = new TableAttributes();

        public Raw(QualifiedName name, boolean ifTableExists) {
            this.name = name;
            this.ifTableExists = ifTableExists;
        }

        @Override
        public AlterTableStatement prepare(ClientState state) {
            String keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            String tableName = this.name.getName();
            switch (this.kind) {
                case ALTER_COLUMN: {
                    return new AlterColumn(keyspaceName, tableName, this.ifTableExists);
                }
                case ADD_COLUMNS: {
                    return new AddColumns(keyspaceName, tableName, this.addedColumns, this.ifTableExists, this.ifColumnNotExists);
                }
                case DROP_COLUMNS: {
                    return new DropColumns(keyspaceName, tableName, this.droppedColumns, this.ifTableExists, this.ifColumnExists, this.timestamp);
                }
                case RENAME_COLUMNS: {
                    return new RenameColumns(keyspaceName, tableName, this.renamedColumns, this.ifTableExists, this.ifColumnExists);
                }
                case ALTER_OPTIONS: {
                    return new AlterOptions(keyspaceName, tableName, this.attrs, this.ifTableExists);
                }
                case DROP_COMPACT_STORAGE: {
                    return new DropCompactStorage(keyspaceName, tableName, this.ifTableExists);
                }
            }
            throw new AssertionError();
        }

        public void alter(ColumnIdentifier name, CQL3Type.Raw type) {
            this.kind = Kind.ALTER_COLUMN;
        }

        public void add(ColumnIdentifier name, CQL3Type.Raw type, boolean isStatic) {
            this.kind = Kind.ADD_COLUMNS;
            this.addedColumns.add(new AddColumns.Column(name, type, isStatic));
        }

        public void drop(ColumnIdentifier name) {
            this.kind = Kind.DROP_COLUMNS;
            this.droppedColumns.add(name);
        }

        public void ifColumnNotExists(boolean ifNotExists) {
            this.ifColumnNotExists = ifNotExists;
        }

        public void ifColumnExists(boolean ifExists) {
            this.ifColumnExists = ifExists;
        }

        public void dropCompactStorage() {
            this.kind = Kind.DROP_COMPACT_STORAGE;
        }

        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void rename(ColumnIdentifier from, ColumnIdentifier to) {
            this.kind = Kind.RENAME_COLUMNS;
            this.renamedColumns.put(from, to);
        }

        public void attrs() {
            this.kind = Kind.ALTER_OPTIONS;
        }

        private static enum Kind {
            ALTER_COLUMN,
            ADD_COLUMNS,
            DROP_COLUMNS,
            RENAME_COLUMNS,
            ALTER_OPTIONS,
            DROP_COMPACT_STORAGE;

        }
    }

    private static class DropCompactStorage
    extends AlterTableStatement {
        private static final Logger logger = LoggerFactory.getLogger(AlterTableStatement.class);
        private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 5L, TimeUnit.MINUTES);

        private DropCompactStorage(String keyspaceName, String tableName, boolean ifTableExists) {
            super(keyspaceName, tableName, ifTableExists);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            if (!DatabaseDescriptor.enableDropCompactStorage()) {
                throw new InvalidRequestException("DROP COMPACT STORAGE is disabled. Enable in cassandra.yaml to use.");
            }
            if (!table.isCompactTable()) {
                throw AlterTableStatement.ire("Cannot DROP COMPACT STORAGE on table without COMPACT STORAGE", new Object[0]);
            }
            this.validateCanDropCompactStorage();
            ImmutableSet flags = table.isCounter() ? ImmutableSet.of((Object)((Object)TableMetadata.Flag.COMPOUND), (Object)((Object)TableMetadata.Flag.COUNTER)) : ImmutableSet.of((Object)((Object)TableMetadata.Flag.COMPOUND));
            return keyspace.withSwapped(keyspace.tables.withSwapped(table.withSwapped((Set<TableMetadata.Flag>)flags)));
        }

        private void validateCanDropCompactStorage() {
            HashSet<InetAddressAndPort> before4 = new HashSet<InetAddressAndPort>();
            HashSet<InetAddressAndPort> preC15897nodes = new HashSet<InetAddressAndPort>();
            HashSet<InetAddressAndPort> with2xSStables = new HashSet<InetAddressAndPort>();
            Splitter onComma = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (InetAddressAndPort node : StorageService.instance.getTokenMetadata().getAllEndpoints()) {
                if (MessagingService.instance().versions.knows(node) && MessagingService.instance().versions.getRaw(node) < 12) {
                    before4.add(node);
                    continue;
                }
                String sstableVersionsString = Gossiper.instance.getApplicationState(node, ApplicationState.SSTABLE_VERSIONS);
                if (sstableVersionsString == null) {
                    preC15897nodes.add(node);
                    continue;
                }
                try {
                    boolean has2xSStables = onComma.splitToList((CharSequence)sstableVersionsString).stream().anyMatch(v -> v.compareTo("big-ma") <= 0);
                    if (!has2xSStables) continue;
                    with2xSStables.add(node);
                }
                catch (IllegalArgumentException e) {
                    noSpamLogger.error("Unexpected error parsing sstable versions from gossip for {} (gossiped value is '{}'). This is a bug and should be reported. Cannot ensure that {} has no non-upgraded 2.x sstables anymore. If after this DROP COMPACT STORAGE some old sstables cannot be read anymore, please use `upgradesstables` with the `--force-compact-storage-on` option.", node, sstableVersionsString, node);
                }
            }
            if (!before4.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot DROP COMPACT STORAGE as some nodes in the cluster (%s) are not on 4.0+ yet. Please upgrade those nodes and run `upgradesstables` before retrying.", before4));
            }
            if (!preC15897nodes.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot guarantee that DROP COMPACT STORAGE is safe as some nodes in the cluster (%s) do not have https://issues.apache.org/jira/browse/CASSANDRA-15897. Please upgrade those nodes and retry.", preC15897nodes));
            }
            if (!with2xSStables.isEmpty()) {
                throw new InvalidRequestException(String.format("Cannot DROP COMPACT STORAGE as some nodes in the cluster (%s) has some non-upgraded 2.x sstables. Please run `upgradesstables` on those nodes before retrying", with2xSStables));
            }
        }
    }

    private static class AlterOptions
    extends AlterTableStatement {
        private final TableAttributes attrs;

        private AlterOptions(String keyspaceName, String tableName, TableAttributes attrs, boolean ifTableExists) {
            super(keyspaceName, tableName, ifTableExists);
            this.attrs = attrs;
        }

        @Override
        public void validate(ClientState state) {
            super.validate(state);
            Guardrails.tableProperties.guard(this.attrs.updatedProperties(), this.attrs::removeProperty, state);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            this.attrs.validate();
            TableParams params = this.attrs.asAlteredTableParams(table.params);
            if (table.isCounter() && params.defaultTimeToLive > 0) {
                throw AlterOptions.ire("Cannot set default_time_to_live on a table with counters", new Object[0]);
            }
            if (!Iterables.isEmpty(keyspace.views.forTable(table.id)) && params.gcGraceSeconds == 0) {
                throw AlterOptions.ire("Cannot alter gc_grace_seconds of the base table of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.", new Object[0]);
            }
            if (keyspace.createReplicationStrategy().hasTransientReplicas() && params.readRepair != ReadRepairStrategy.NONE) {
                throw AlterOptions.ire("read_repair must be set to 'NONE' for transiently replicated keyspaces", new Object[0]);
            }
            if (!params.compression.isEnabled()) {
                Guardrails.uncompressedTablesEnabled.ensureEnabled(this.state);
            }
            return keyspace.withSwapped(keyspace.tables.withSwapped(table.withSwapped(params)));
        }
    }

    private static class RenameColumns
    extends AlterTableStatement {
        private final Map<ColumnIdentifier, ColumnIdentifier> renamedColumns;
        private final boolean ifColumnsExists;

        private RenameColumns(String keyspaceName, String tableName, Map<ColumnIdentifier, ColumnIdentifier> renamedColumns, boolean ifTableExists, boolean ifColumnsExists) {
            super(keyspaceName, tableName, ifTableExists);
            this.renamedColumns = renamedColumns;
            this.ifColumnsExists = ifColumnsExists;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder tableBuilder = table.unbuild();
            Views.Builder viewsBuilder = keyspace.views.unbuild();
            this.renamedColumns.forEach((o, n) -> this.renameColumn(keyspace, table, (ColumnIdentifier)o, (ColumnIdentifier)n, this.ifColumnsExists, tableBuilder, viewsBuilder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(tableBuilder.build())).withSwapped(viewsBuilder.build());
        }

        private void renameColumn(KeyspaceMetadata keyspace, TableMetadata table, ColumnIdentifier oldName, ColumnIdentifier newName, boolean ifColumnsExists, TableMetadata.Builder tableBuilder, Views.Builder viewsBuilder) {
            ColumnMetadata column = table.getExistingColumn(oldName);
            if (null == column) {
                if (!ifColumnsExists) {
                    throw RenameColumns.ire("Column %s was not found in table %s", oldName, table);
                }
                return;
            }
            if (!column.isPrimaryKeyColumn()) {
                throw RenameColumns.ire("Cannot rename non PRIMARY KEY column %s", oldName);
            }
            if (null != table.getColumn(newName)) {
                throw RenameColumns.ire("Cannot rename column %s to %s in table '%s'; another column with that name already exists", oldName, newName, table);
            }
            Set<IndexMetadata> dependentIndexes = Keyspace.openAndGetStore((TableMetadata)table).indexManager.getDependentIndexes(column);
            if (!dependentIndexes.isEmpty()) {
                throw RenameColumns.ire("Can't rename column %s because it has dependent secondary indexes (%s)", oldName, String.join((CharSequence)", ", Iterables.transform(dependentIndexes, i -> i.name)));
            }
            for (ViewMetadata view : keyspace.views.forTable(table.id)) {
                if (!view.includes(oldName)) continue;
                viewsBuilder.put(viewsBuilder.get(view.name()).withRenamedPrimaryKeyColumn(oldName, newName));
            }
            tableBuilder.renamePrimaryKeyColumn(oldName, newName);
        }
    }

    private static class DropColumns
    extends AlterTableStatement {
        private final Set<ColumnIdentifier> removedColumns;
        private final boolean ifColumnExists;
        private final Long timestamp;

        private DropColumns(String keyspaceName, String tableName, Set<ColumnIdentifier> removedColumns, boolean ifTableExists, boolean ifColumnExists, Long timestamp) {
            super(keyspaceName, tableName, ifTableExists);
            this.removedColumns = removedColumns;
            this.ifColumnExists = ifColumnExists;
            this.timestamp = timestamp;
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder builder = table.unbuild();
            this.removedColumns.forEach(c -> this.dropColumn(keyspace, table, (ColumnIdentifier)c, this.ifColumnExists, builder));
            return keyspace.withSwapped(keyspace.tables.withSwapped(builder.build()));
        }

        private void dropColumn(KeyspaceMetadata keyspace, TableMetadata table, ColumnIdentifier column, boolean ifExists, TableMetadata.Builder builder) {
            ColumnMetadata currentColumn = table.getColumn(column);
            if (null == currentColumn) {
                if (!ifExists) {
                    throw DropColumns.ire("Column %s was not found in table '%s'", column, table);
                }
                return;
            }
            if (currentColumn.isPrimaryKeyColumn()) {
                throw DropColumns.ire("Cannot drop PRIMARY KEY column %s", column);
            }
            if (currentColumn.type.isUDT() && currentColumn.type.isMultiCell()) {
                throw DropColumns.ire("Cannot drop non-frozen column %s of user type %s", column, currentColumn.type.asCQL3Type());
            }
            Set<IndexMetadata> dependentIndexes = Keyspace.openAndGetStore((TableMetadata)table).indexManager.getDependentIndexes(currentColumn);
            if (!dependentIndexes.isEmpty()) {
                throw DropColumns.ire("Cannot drop column %s because it has dependent secondary indexes (%s)", currentColumn, String.join((CharSequence)", ", Iterables.transform(dependentIndexes, i -> i.name)));
            }
            if (!Iterables.isEmpty(keyspace.views.forTable(table.id))) {
                throw DropColumns.ire("Cannot drop column %s on base table %s with materialized views", currentColumn, table.name);
            }
            builder.removeRegularOrStaticColumn(column);
            builder.recordColumnDrop(currentColumn, this.getTimestamp());
        }

        private long getTimestamp() {
            return this.timestamp == null ? ClientState.getTimestamp() : this.timestamp;
        }
    }

    private static class AddColumns
    extends AlterTableStatement {
        private final Collection<Column> newColumns;
        private final boolean ifColumnNotExists;

        private AddColumns(String keyspaceName, String tableName, Collection<Column> newColumns, boolean ifTableExists, boolean ifColumnNotExists) {
            super(keyspaceName, tableName, ifTableExists);
            this.newColumns = newColumns;
            this.ifColumnNotExists = ifColumnNotExists;
        }

        @Override
        public void validate(ClientState state) {
            super.validate(state);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            TableMetadata.Builder tableBuilder = table.unbuild();
            Views.Builder viewsBuilder = keyspace.views.unbuild();
            this.newColumns.forEach(c -> this.addColumn(keyspace, table, (Column)c, this.ifColumnNotExists, tableBuilder, viewsBuilder));
            Guardrails.columnsPerTable.guard(tableBuilder.numColumns(), this.tableName, false, this.state);
            TableMetadata tableMetadata = tableBuilder.build();
            tableMetadata.validate();
            return keyspace.withSwapped(keyspace.tables.withSwapped(tableMetadata)).withSwapped(viewsBuilder.build());
        }

        private void addColumn(KeyspaceMetadata keyspace, TableMetadata table, Column column, boolean ifColumnNotExists, TableMetadata.Builder tableBuilder, Views.Builder viewsBuilder) {
            ColumnIdentifier name = column.name;
            AbstractType<?> type = column.type.prepare(this.keyspaceName, keyspace.types).getType();
            boolean isStatic = column.isStatic;
            if (null != tableBuilder.getColumn(name)) {
                if (!ifColumnNotExists) {
                    throw AddColumns.ire("Column with name '%s' already exists", name);
                }
                return;
            }
            if (table.isCompactTable()) {
                throw AddColumns.ire("Cannot add new column to a COMPACT STORAGE table", new Object[0]);
            }
            if (isStatic && table.clusteringColumns().isEmpty()) {
                throw AddColumns.ire("Static columns are only useful (and thus allowed) if the table has at least one clustering column", new Object[0]);
            }
            ColumnMetadata droppedColumn = table.getDroppedColumn(name.bytes);
            if (null != droppedColumn) {
                if (!type.isSerializationCompatibleWith(droppedColumn.type)) {
                    throw AddColumns.ire("Cannot re-add previously dropped column '%s' of type %s, incompatible with previous type %s", name, type.asCQL3Type(), droppedColumn.type.asCQL3Type());
                }
                if (droppedColumn.isStatic() != isStatic) {
                    throw AddColumns.ire("Cannot re-add previously dropped column '%s' of kind %s, incompatible with previous kind %s", new Object[]{name, isStatic ? ColumnMetadata.Kind.STATIC : ColumnMetadata.Kind.REGULAR, droppedColumn.kind});
                }
                if (table.isCounter()) {
                    throw AddColumns.ire("Cannot re-add previously dropped counter column %s", name);
                }
            }
            if (isStatic) {
                tableBuilder.addStaticColumn(name, type);
            } else {
                tableBuilder.addRegularColumn(name, type);
            }
            if (!isStatic) {
                for (ViewMetadata view : keyspace.views.forTable(table.id)) {
                    if (!view.includeAllColumns) continue;
                    ColumnMetadata viewColumn = ColumnMetadata.regularColumn(view.metadata, name.bytes, type);
                    viewsBuilder.put(viewsBuilder.get(view.name()).withAddedRegularColumn(viewColumn));
                }
            }
        }

        private static class Column {
            private final ColumnIdentifier name;
            private final CQL3Type.Raw type;
            private final boolean isStatic;

            Column(ColumnIdentifier name, CQL3Type.Raw type, boolean isStatic) {
                this.name = name;
                this.type = type;
                this.isStatic = isStatic;
            }
        }
    }

    public static class AlterColumn
    extends AlterTableStatement {
        AlterColumn(String keyspaceName, String tableName, boolean ifTableExists) {
            super(keyspaceName, tableName, ifTableExists);
        }

        @Override
        public KeyspaceMetadata apply(KeyspaceMetadata keyspace, TableMetadata table) {
            throw AlterColumn.ire("Altering column types is no longer supported", new Object[0]);
        }
    }
}

