/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopPluginClassMapException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.HopSelectiveParentFirstClassLoader;
import org.apache.hop.core.plugins.HopURLClassLoader;
import org.apache.hop.core.plugins.IClassLoadingPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginRegistryExtension;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.IPluginTypeListener;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.plugins.Plugin;
import org.apache.hop.core.plugins.PluginAnnotationType;
import org.apache.hop.core.plugins.SupplementalPlugin;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;

public class PluginRegistry {
    private static final Class<?> PKG = PluginRegistry.class;
    private static final PluginRegistry pluginRegistry = new PluginRegistry();
    private static final String CONST_PUGIN_CLASS = "Plugin class ";
    private static final List<IPluginType> pluginTypes = new ArrayList<IPluginType>();
    private static final List<IPluginRegistryExtension> extensions = new ArrayList<IPluginRegistryExtension>();
    private static final String SUPPLEMENTALS_SUFFIX = "-supplementals";
    public static final ILogChannel log = new LogChannel((Object)"PluginRegistry", true);
    private final Map<Class<? extends IPluginType>, Set<IPlugin>> pluginMap = new HashMap<Class<? extends IPluginType>, Set<IPlugin>>();
    private final Map<Class<? extends IPluginType>, Map<IPlugin, URLClassLoader>> classLoaderMap = new HashMap<Class<? extends IPluginType>, Map<IPlugin, URLClassLoader>>();
    private final Map<URLClassLoader, Set<IPlugin>> inverseClassLoaderLookup = new HashMap<URLClassLoader, Set<IPlugin>>();
    private final Map<String, URLClassLoader> classLoaderGroupsMap = new HashMap<String, URLClassLoader>();
    private final Map<String, URLClassLoader> folderBasedClassLoaderMap = new HashMap<String, URLClassLoader>();
    private final Map<IPlugin, String[]> parentClassloaderPatternMap = new HashMap<IPlugin, String[]>();
    private final Map<Class<? extends IPluginType>, Set<IPluginTypeListener>> listeners = new HashMap<Class<? extends IPluginType>, Set<IPluginTypeListener>>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final int WAIT_FOR_PLUGIN_TO_BE_AVAILABLE_LIMIT = 5;

    private PluginRegistry() {
    }

    public static PluginRegistry getInstance() {
        return pluginRegistry;
    }

    public void registerPluginType(Class<? extends IPluginType> pluginType) {
        this.lock.writeLock().lock();
        try {
            this.pluginMap.computeIfAbsent(pluginType, k -> new TreeSet<IPlugin>(Plugin.nullStringComparator));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(Class<? extends IPluginType> pluginType, IPlugin plugin) {
        this.lock.writeLock().lock();
        try {
            URLClassLoader ucl;
            Map<IPlugin, URLClassLoader> classLoaders;
            Set<IPlugin> list = this.pluginMap.get(pluginType);
            if (list != null) {
                list.remove(plugin);
            }
            if ((classLoaders = this.classLoaderMap.get(plugin.getPluginType())) != null) {
                classLoaders.remove(plugin);
            }
            if (!StringUtils.isEmpty((String)plugin.getClassLoaderGroup()) && (ucl = this.classLoaderGroupsMap.remove(plugin.getClassLoaderGroup())) != null && classLoaders != null) {
                for (IPlugin p : this.inverseClassLoaderLookup.remove(ucl)) {
                    classLoaders.remove(p);
                }
                try {
                    ucl.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (plugin.getPluginDirectory() != null) {
                this.folderBasedClassLoaderMap.remove(plugin.getPluginDirectory().toString());
            }
        }
        finally {
            this.lock.writeLock().unlock();
            Set<IPluginTypeListener> listeners = this.listeners.get(pluginType);
            if (listeners != null) {
                for (IPluginTypeListener listener : listeners) {
                    listener.pluginRemoved(plugin);
                }
            }
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                this.notifyAll();
            }
        }
    }

    public void addParentClassLoaderPatterns(IPlugin plugin, String[] patterns) {
        this.lock.writeLock().lock();
        try {
            this.parentClassloaderPatternMap.put(plugin, patterns);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(Class<? extends IPluginType> pluginType, IPlugin plugin) throws HopPluginException {
        boolean changed = false;
        this.lock.writeLock().lock();
        try {
            if (plugin.getIds()[0] == null) {
                throw new HopPluginException("Not a valid id specified in plugin :" + plugin);
            }
            Set list = this.pluginMap.computeIfAbsent(pluginType, k -> new TreeSet<IPlugin>(Plugin.nullStringComparator));
            if (!list.add(plugin)) {
                list.remove(plugin);
                list.add(plugin);
                changed = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
            Set<IPluginTypeListener> listeners = this.listeners.get(pluginType);
            if (listeners != null) {
                for (IPluginTypeListener listener : listeners) {
                    if (changed) {
                        listener.pluginChanged(plugin);
                        continue;
                    }
                    listener.pluginAdded(plugin);
                }
            }
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                this.notifyAll();
            }
        }
    }

    public List<Class<? extends IPluginType>> getPluginTypes() {
        this.lock.readLock().lock();
        try {
            List<Class<? extends IPluginType>> list = Collections.unmodifiableList(new ArrayList<Class<? extends IPluginType>>(this.pluginMap.keySet()));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends IPlugin, K extends IPluginType> List<T> getPlugins(Class<K> type) {
        List result;
        this.lock.readLock().lock();
        try {
            result = this.pluginMap.keySet().stream().filter(pi -> Const.classIsOrExtends(pi, type)).flatMap(pi -> this.pluginMap.get(pi).stream()).map(p -> p).collect(Collectors.toList());
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public IPlugin getPlugin(Class<? extends IPluginType> pluginType, String id) {
        if (Utils.isEmpty(id)) {
            return null;
        }
        return this.getPlugins(pluginType).stream().filter(plugin -> plugin.matches(id)).findFirst().orElse(null);
    }

    public <T extends IPluginType> List<IPlugin> getPluginsByCategory(Class<T> pluginType, String pluginCategory) {
        List plugins = this.getPlugins(pluginType).stream().filter(plugin -> plugin.getCategory() != null && plugin.getCategory().equals(pluginCategory)).collect(Collectors.toList());
        return Collections.unmodifiableList(plugins);
    }

    public List<Class<?>> listMainTypes(Class<? extends IPluginType> pluginType) {
        ArrayList classes = new ArrayList();
        for (IPlugin plugin : this.getPlugins(pluginType)) {
            classes.add(plugin.getMainType());
        }
        return classes;
    }

    public Object loadClass(IPlugin plugin) throws HopPluginException {
        return this.loadClass(plugin, plugin.getMainType());
    }

    public <T> T loadClass(Class<? extends IPluginType> pluginType, Object object, Class<T> classType) throws HopPluginException {
        IPlugin plugin = this.getPlugin(pluginType, object);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    public <T> T loadClass(Class<? extends IPluginType> pluginType, String pluginId, Class<T> classType) throws HopPluginException {
        IPlugin plugin = this.getPlugin(pluginType, pluginId);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    private HopURLClassLoader createClassLoader(IPlugin plugin) throws MalformedURLException {
        List<String> jarFiles = plugin.getLibraries();
        URL[] urls = new URL[jarFiles.size()];
        for (int i = 0; i < jarFiles.size(); ++i) {
            File jarFile = new File(jarFiles.get(i));
            urls[i] = new URL(URLDecoder.decode(jarFile.toURI().toURL().toString(), StandardCharsets.UTF_8));
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        String[] patterns = this.parentClassloaderPatternMap.get(plugin);
        if (patterns != null) {
            return new HopSelectiveParentFirstClassLoader(urls, classLoader, plugin.getDescription(), patterns);
        }
        return new HopURLClassLoader(urls, classLoader, plugin.getDescription());
    }

    private void addToClassLoader(IPlugin plugin, HopURLClassLoader ucl) throws MalformedURLException {
        String[] patterns = this.parentClassloaderPatternMap.get(plugin);
        if (ucl instanceof HopSelectiveParentFirstClassLoader) {
            ((HopSelectiveParentFirstClassLoader)ucl).addPatterns(patterns);
        }
        for (String jarFile : plugin.getLibraries()) {
            File jarfile = new File(jarFile);
            ucl.addURL(new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), StandardCharsets.UTF_8)));
        }
    }

    public <T> void addClassFactory(Class<? extends IPluginType> pluginType, Class<T> tClass, String id, Callable<T> callable) throws HopPluginException {
        String key = this.createSupplemantalKey(pluginType.getName(), id);
        SupplementalPlugin supplementalPlugin = (SupplementalPlugin)this.getPlugin(pluginType, key);
        if (supplementalPlugin == null) {
            supplementalPlugin = new SupplementalPlugin(pluginType, key);
            this.registerPlugin(pluginType, supplementalPlugin);
        }
        supplementalPlugin.addFactory(tClass, callable);
    }

    private String createSupplemantalKey(String pluginName, String id) {
        return pluginName + "-" + id + SUPPLEMENTALS_SUFFIX;
    }

    public <T> T loadClass(IPlugin plugin, Class<T> pluginClass) throws HopPluginException {
        if (plugin == null) {
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidTransformOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        if (plugin instanceof IClassLoadingPlugin) {
            T aClass = ((IClassLoadingPlugin)((Object)plugin)).loadClass(pluginClass);
            if (aClass == null) {
                throw new HopPluginClassMapException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidClassRequested.PLUGINREGISTRY002", plugin.getName(), pluginClass.getName()));
            }
            return aClass;
        }
        String className = plugin.getClassMap().get(pluginClass);
        if (className == null) {
            for (String id : plugin.getIds()) {
                try {
                    T aClass = this.loadClass(plugin.getPluginType(), this.createSupplemantalKey(plugin.getPluginType().getName(), id), pluginClass);
                    if (aClass == null) continue;
                    return aClass;
                }
                catch (HopPluginException hopPluginException) {
                    // empty catch block
                }
            }
            throw new HopPluginClassMapException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidClassRequested.PLUGINREGISTRY002", plugin.getName(), pluginClass.getName()));
        }
        try {
            Class<?> cl;
            if (plugin.isNativePlugin()) {
                cl = Class.forName(className);
            } else {
                ClassLoader ucl = this.getClassLoader(plugin);
                cl = ucl.loadClass(className);
            }
            return (T)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.ClassNotFound.PLUGINREGISTRY003", new String[0]), e);
        }
        catch (InstantiationException e) {
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnableToInstantiateClass.PLUGINREGISTRY004", new String[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.IllegalAccessToClass.PLUGINREGISTRY005", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedErrorLoadingClass.PLUGINREGISTRY007", new String[0]), e);
        }
    }

    public static synchronized void addPluginType(IPluginType type) {
        pluginTypes.add(type);
    }

    public static List<IPluginType> getAddedPluginTypes() {
        return Collections.unmodifiableList(pluginTypes);
    }

    public static synchronized void init() throws HopPluginException {
        PluginRegistry registry = PluginRegistry.getInstance();
        for (IPluginType pluginType : pluginTypes) {
            registry.registerType(pluginType);
        }
    }

    public void registerType(IPluginType pluginType) throws HopPluginException {
        if (this.pluginMap.get(pluginType.getClass()) != null) {
            return;
        }
        this.registerPluginType(pluginType.getClass());
        long startScan = System.currentTimeMillis();
        pluginType.searchPlugins();
        for (IPluginRegistryExtension ext : extensions) {
            ext.searchForType(pluginType);
        }
        HashSet pluginClassNames = new HashSet();
        String pluginClasses = EnvUtil.getSystemProperty("HOP_PLUGIN_CLASSES");
        if (!Utils.isEmpty(pluginClasses)) {
            String[] classNames = pluginClasses.split(",");
            Collections.addAll(pluginClassNames, classNames);
        }
        for (String className : pluginClassNames) {
            try {
                PluginAnnotationType annotationType = pluginType.getClass().getAnnotation(PluginAnnotationType.class);
                if (annotationType != null) {
                    Class<? extends Annotation> annotationClass = annotationType.value();
                    Class<?> clazz = Class.forName(className);
                    Annotation annotation = clazz.getAnnotation(annotationClass);
                    if (annotation != null) {
                        pluginType.handlePluginAnnotation(clazz, annotation, new ArrayList<String>(), true, null);
                        LogChannel.GENERAL.logBasic(CONST_PUGIN_CLASS + className + " registered for plugin type '" + pluginType.getName() + "'");
                        continue;
                    }
                    if (!HopLogStore.isInitialized() || !LogChannel.GENERAL.isDebug()) continue;
                    LogChannel.GENERAL.logDebug(CONST_PUGIN_CLASS + className + " doesn't contain annotation for plugin type '" + pluginType.getName() + "'");
                    continue;
                }
                if (!HopLogStore.isInitialized() || !LogChannel.GENERAL.isDebug()) continue;
                LogChannel.GENERAL.logDebug(CONST_PUGIN_CLASS + className + " doesn't contain valid class for plugin type '" + pluginType.getName() + "'");
            }
            catch (Exception e) {
                if (!HopLogStore.isInitialized()) continue;
                LogChannel.GENERAL.logError("Error registring plugin class from HOP_PLUGIN_CLASSES: " + className + Const.CR + Const.getSimpleStackTrace(e) + Const.CR + Const.getStackTracker(e));
            }
        }
        if (LogChannel.GENERAL.isDetailed()) {
            LogChannel.GENERAL.logDetailed("Registered " + this.getPlugins(pluginType.getClass()).size() + " plugins of type '" + pluginType.getName() + "' in " + (System.currentTimeMillis() - startScan) + "ms.");
        }
    }

    public String getPluginId(Object pluginClass) {
        return this.getPluginTypes().stream().map(pluginType -> this.getPluginId((Class<? extends IPluginType>)pluginType, pluginClass)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getPluginId(Class<? extends IPluginType> pluginType, Object pluginClass) {
        String className = pluginClass.getClass().getName();
        IPlugin plugin = this.getPlugins(pluginType).stream().filter(p -> p.getClassMap().containsValue(className)).findFirst().orElse(null);
        if (plugin != null) {
            return plugin.getIds()[0];
        }
        return extensions.stream().map(ext -> ext.getPluginId(pluginType, pluginClass)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public IPlugin getPlugin(Class<? extends IPluginType> pluginType, Object pluginClass) {
        String pluginId = this.getPluginId(pluginType, pluginClass);
        if (pluginId == null) {
            return null;
        }
        return this.getPlugin(pluginType, pluginId);
    }

    public IPlugin findPluginWithName(Class<? extends IPluginType> pluginType, String pluginName) {
        return this.getPlugins(pluginType).stream().filter(plugin -> plugin.getName().equals(pluginName)).findFirst().orElse(null);
    }

    public IPlugin findPluginWithDescription(Class<? extends IPluginType> pluginType, String pluginDescription) {
        return this.getPlugins(pluginType).stream().filter(plugin -> plugin.getDescription().equals(pluginDescription)).findFirst().orElse(null);
    }

    public IPlugin findPluginWithId(Class<? extends IPluginType> pluginType, String pluginId) {
        return this.getPlugin(pluginType, pluginId);
    }

    public List<String> getPluginPackages(Class<? extends IPluginType> pluginType) {
        TreeSet<String> list = new TreeSet<String>();
        for (IPlugin plugin : this.getPlugins(pluginType)) {
            for (String className : plugin.getClassMap().values()) {
                int lastIndex = className.lastIndexOf(".");
                if (lastIndex <= -1) continue;
                list.add(className.substring(0, lastIndex));
            }
        }
        return new ArrayList<String>(list);
    }

    private IRowMeta getPluginInformationRowMeta() {
        RowMeta row = new RowMeta();
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Type.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.ID.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Name.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Description.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.ImageFile.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Category.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Keywords.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.DocumentationUrl.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.ClassName.Label", new String[0])));
        row.addValueMeta(new ValueMetaString(BaseMessages.getString(PKG, "PluginRegistry.Information.Libraries.Label", new String[0])));
        return row;
    }

    public RowBuffer getPluginInformation(Class<? extends IPluginType> pluginType) throws HopPluginException {
        RowBuffer rowBuffer = new RowBuffer(this.getPluginInformationRowMeta());
        for (IPlugin plugin : this.getPlugins(pluginType)) {
            Object[] row = new Object[this.getPluginInformationRowMeta().size()];
            int rowIndex = 0;
            row[rowIndex++] = this.getPluginType(plugin.getPluginType()).getName();
            row[rowIndex++] = plugin.getIds()[0];
            row[rowIndex++] = plugin.getName();
            row[rowIndex++] = Const.NVL(plugin.getDescription(), "");
            row[rowIndex++] = Const.NVL(plugin.getImageFile(), "");
            row[rowIndex++] = Const.NVL(plugin.getCategory(), "");
            row[rowIndex++] = String.join((CharSequence)",", plugin.getKeywords());
            row[rowIndex++] = Const.NVL(plugin.getDocumentationUrl(), "");
            row[rowIndex++] = plugin.getClassMap().values().toString();
            row[rowIndex++] = String.join((CharSequence)",", plugin.getLibraries());
            rowBuffer.getBuffer().add(row);
        }
        return rowBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getClass(IPlugin plugin, String className) throws HopPluginException {
        try {
            URLClassLoader ucl;
            if (plugin.isNativePlugin()) {
                return (T)Class.forName(className);
            }
            if (plugin instanceof IClassLoadingPlugin && ((IClassLoadingPlugin)((Object)plugin)).getClassLoader() != null) {
                return (T)((IClassLoadingPlugin)((Object)plugin)).getClassLoader().loadClass(className);
            }
            this.lock.writeLock().lock();
            try {
                Map classLoaders = this.classLoaderMap.computeIfAbsent(plugin.getPluginType(), k -> new HashMap());
                ucl = (URLClassLoader)classLoaders.get(plugin);
                if (ucl == null) {
                    ucl = !Utils.isEmpty(plugin.getClassLoaderGroup()) ? this.classLoaderGroupsMap.get(plugin.getClassLoaderGroup()) : this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                }
                if (ucl != null) {
                    classLoaders.put(plugin, ucl);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (ucl == null) {
                throw new HopPluginException("Unable to find class loader for plugin: " + plugin);
            }
            return (T)ucl.loadClass(className);
        }
        catch (Exception e) {
            throw new HopPluginException("Unexpected error loading class with name: " + className, e);
        }
    }

    public <T> T getClass(IPlugin plugin, T classType) throws HopPluginException {
        String className = plugin.getClassMap().get(classType);
        if (className == null) {
            throw new HopPluginException("Unable to find the classname for class type " + classType.getClass().getName());
        }
        return (T)this.getClass(plugin, (T)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassLoader getClassLoader(IPlugin plugin) throws HopPluginException {
        if (plugin == null) {
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidTransformOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        try {
            if (plugin.isNativePlugin()) {
                return this.getClass().getClassLoader();
            }
            this.lock.writeLock().lock();
            try {
                URLClassLoader ucl;
                if (plugin.isSeparateClassLoaderNeeded()) {
                    ucl = this.createClassLoader(plugin);
                    return ucl;
                }
                Map classLoaders = this.classLoaderMap.computeIfAbsent(plugin.getPluginType(), k -> new HashMap());
                ucl = (URLClassLoader)classLoaders.get(plugin);
                if (ucl != null) return ucl;
                if (!Utils.isEmpty(plugin.getClassLoaderGroup())) {
                    ucl = this.classLoaderGroupsMap.get(plugin.getClassLoaderGroup());
                    if (ucl == null) {
                        ucl = this.createClassLoader(plugin);
                        classLoaders.put(plugin, ucl);
                        this.inverseClassLoaderLookup.computeIfAbsent(ucl, k -> new HashSet()).add(plugin);
                        this.classLoaderGroupsMap.put(plugin.getClassLoaderGroup(), ucl);
                        return ucl;
                    }
                    try {
                        ucl.loadClass(plugin.getClassMap().values().iterator().next());
                        return ucl;
                    }
                    catch (ClassNotFoundException ignored) {
                        this.addToClassLoader(plugin, (HopURLClassLoader)ucl);
                        return ucl;
                    }
                }
                if (!plugin.isUsingLibrariesOutsidePluginFolder() && plugin.getPluginDirectory() != null) {
                    ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                    if (ucl == null) {
                        ucl = this.createClassLoader(plugin);
                        classLoaders.put(plugin, ucl);
                        this.inverseClassLoaderLookup.computeIfAbsent(ucl, k -> new HashSet()).add(plugin);
                        this.folderBasedClassLoaderMap.put(plugin.getPluginDirectory().toString(), ucl);
                        return ucl;
                    }
                    try {
                        ucl.loadClass(plugin.getClassMap().values().iterator().next());
                        return ucl;
                    }
                    catch (ClassNotFoundException ignored) {
                        this.addToClassLoader(plugin, (HopURLClassLoader)ucl);
                        return ucl;
                    }
                }
                ucl = (URLClassLoader)classLoaders.get(plugin);
                if (ucl != null) return ucl;
                if (plugin.getLibraries().isEmpty() && plugin instanceof IClassLoadingPlugin) {
                    ClassLoader classLoader = ((IClassLoadingPlugin)((Object)plugin)).getClassLoader();
                    return classLoader;
                }
                ucl = this.createClassLoader(plugin);
                classLoaders.put(plugin, ucl);
                this.inverseClassLoaderLookup.computeIfAbsent(ucl, k -> new HashSet()).add(plugin);
                return ucl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (MalformedURLException e) {
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.MalformedURL.PLUGINREGISTRY006", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new HopPluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedCreatingClassLoader.PLUGINREGISTRY008", new String[0]), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IPluginType> void addPluginListener(Class<T> typeToTrack, IPluginTypeListener listener) {
        this.lock.writeLock().lock();
        try {
            Set list = this.listeners.computeIfAbsent(typeToTrack, k -> new HashSet());
            list.add(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public IPluginType getPluginType(Class<? extends IPluginType> pluginTypeClass) throws HopPluginException {
        try {
            Method method = pluginTypeClass.getMethod("getInstance", new Class[0]);
            return (IPluginType)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new HopPluginException("Unable to get instance of plugin type: " + pluginTypeClass.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPlugin> findPluginsByFolder(URL folder) {
        String path = folder.getPath();
        try {
            path = folder.toURI().normalize().getPath();
        }
        catch (URISyntaxException e) {
            log.logError(e.getLocalizedMessage(), e);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ArrayList<IPlugin> result = new ArrayList<IPlugin>();
        this.lock.readLock().lock();
        try {
            for (Set<IPlugin> typeInterfaces : this.pluginMap.values()) {
                for (IPlugin plugin : typeInterfaces) {
                    URL pluginFolder = plugin.getPluginDirectory();
                    try {
                        if (pluginFolder == null || !pluginFolder.toURI().normalize().getPath().startsWith(path)) continue;
                        result.add(plugin);
                    }
                    catch (URISyntaxException e) {
                        log.logError(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public void reset() {
        this.lock.writeLock().lock();
        try {
            pluginTypes.clear();
            extensions.clear();
            this.pluginMap.clear();
            this.classLoaderMap.clear();
            this.classLoaderGroupsMap.clear();
            this.folderBasedClassLoaderMap.clear();
            this.inverseClassLoaderLookup.forEach((key, value) -> {
                try {
                    key.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.inverseClassLoaderLookup.clear();
            this.parentClassloaderPatternMap.clear();
            this.listeners.clear();
            JarCache.getInstance().clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public IPlugin findPluginWithId(Class<? extends IPluginType> pluginType, String pluginId, boolean waitForPluginToBeAvailable) {
        IPlugin plugin = this.findPluginWithId(pluginType, pluginId);
        return waitForPluginToBeAvailable && plugin == null ? this.waitForPluginToBeAvailable(pluginType, pluginId, 5) : plugin;
    }

    private IPlugin waitForPluginToBeAvailable(Class<? extends IPluginType> pluginType, String pluginId, int waitLimit) {
        int timeToSleep = 50;
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            log.logError(e.getLocalizedMessage(), e);
            Thread.currentThread().interrupt();
            return null;
        }
        IPlugin plugin = this.findPluginWithId(pluginType, pluginId);
        return (waitLimit -= timeToSleep) <= 0 && plugin == null ? null : (plugin != null ? plugin : this.waitForPluginToBeAvailable(pluginType, pluginId, waitLimit));
    }

    public void registerPluginClass(String pluginClassName, Class<? extends IPluginType> pluginTypeClass, Class<? extends Annotation> annotationClass) throws HopPluginException {
        this.registerPluginClass(this.getClass().getClassLoader(), Collections.emptyList(), null, pluginClassName, pluginTypeClass, annotationClass, true);
    }

    public void registerPluginClass(ClassLoader classLoader, List<String> libraries, URL pluginUrl, String pluginClassName, Class<? extends IPluginType> pluginTypeClass, Class<? extends Annotation> annotationClass, boolean isNative) throws HopPluginException {
        IPluginType pluginType = this.getPluginType(pluginTypeClass);
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            Annotation annotation = pluginClass.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new HopPluginException("The requested annotation '" + annotationClass.getName() + " couldn't be found in the plugin class");
            }
            pluginType.handlePluginAnnotation(pluginClass, annotation, libraries, isNative, pluginUrl);
        }
        catch (ClassNotFoundException e) {
            throw new HopPluginException("Sorry, the plugin class you want to register '" + pluginClassName + "' can't be found in the classpath", e);
        }
    }

    public String findPluginIdWithMainClassName(Class<? extends IPluginType> pluginTypeClass, String className) {
        List plugins = this.getPlugins(pluginTypeClass);
        for (IPlugin plugin : plugins) {
            String mainClassName = plugin.getClassMap().get(plugin.getMainType());
            if (mainClassName == null || !mainClassName.equals(className)) continue;
            return plugin.getIds()[0];
        }
        return null;
    }
}

