/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.metainject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.ISubPipelineAwareMeta;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMetaChangeListener;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.metainject.MetaInject;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectData;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectMapping;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectMigration;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectOutputField;
import org.apache.hop.pipeline.transforms.metainject.SourceTransformField;
import org.apache.hop.pipeline.transforms.metainject.TargetTransformAttribute;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

@Transform(id="MetaInject", image="GenericTransform.svg", name="i18n::MetaInject.Name", description="i18n::MetaInject.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::MetaInjectMeta.keyword"}, documentationUrl="/pipeline/transforms/metainject.html")
@InjectionSupported(localizationPrefix="MetaInject.Injection.", groups={"SOURCE_OUTPUT_FIELDS", "MAPPING_FIELDS"})
public class MetaInjectMeta
extends BaseTransformMeta<MetaInject, MetaInjectData>
implements ITransformMetaChangeListener,
ISubPipelineAwareMeta {
    private static final Class<?> PKG = MetaInjectMeta.class;
    private static final String MAPPINGS = "mappings";
    private static final String MAPPING = "mapping";
    private static final String FILENAME = "filename";
    private static final String RUN_CONFIG = "run_configuration";
    private static final String TARGET_FILE = "target_file";
    private static final String CREATE_PARENT_FOLDER = "create_parent_folder";
    private static final String NO_EXECUTION = "no_execution";
    private static final String SOURCE_TRANSFORM = "source_transform";
    private static final String STREAM_SOURCE_TRANSFORM = "stream_source_transform";
    private static final String STREAM_TARGET_TRANSFORM = "stream_target_transform";
    private static final String TARGET_TRANSFORM_NAME = "target_transform_name";
    private static final String TARGET_ATTRIBUTE_KEY = "target_attribute_key";
    private static final String TARGET_DETAIL = "target_detail";
    private static final String SOURCE_FIELD = "source_field";
    private static final String SOURCE_OUTPUT_FIELDS = "source_output_fields";
    private static final String SOURCE_OUTPUT_FIELD = "source_output_field";
    private static final String SOURCE_OUTPUT_FIELD_NAME = "source_output_field_name";
    private static final String SOURCE_OUTPUT_FIELD_TYPE = "source_output_field_type";
    private static final String SOURCE_OUTPUT_FIELD_LENGTH = "source_output_field_length";
    private static final String SOURCE_OUTPUT_FIELD_PRECISION = "source_output_field_precision";
    private static final String GROUP_AND_NAME_DELIMITER = ".";
    private static final String CONST_SPACE = "      ";
    private static final String CONST_SPACE_LONG = "        ";
    @Injection(name="FILE_NAME")
    private String fileName;
    @Injection(name="SOURCE_TRANSFORM_NAME")
    private String sourceTransformName;
    @InjectionDeep
    private List<MetaInjectOutputField> sourceOutputFields;
    private Map<TargetTransformAttribute, SourceTransformField> targetSourceMapping = new HashMap<TargetTransformAttribute, SourceTransformField>();
    @InjectionDeep
    private List<MetaInjectMapping> metaInjectMapping;
    @Injection(name="TARGET_FILE")
    private String targetFile;
    @Injection(name="NO_EXECUTION")
    private boolean noExecution;
    @Injection(name="STREAMING_SOURCE_TRANSFORM")
    private String streamSourceTransformName;
    private TransformMeta streamSourceTransform;
    @Injection(name="STREAMING_TARGET_TRANSFORM")
    private String streamTargetTransformName;
    private String runConfigurationName;
    private boolean createParentFolder;

    public MetaInjectMeta() {
        this.sourceOutputFields = new ArrayList<MetaInjectOutputField>();
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public String getXml() {
        this.actualizeMetaInjectMapping();
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)FILENAME, (String)this.fileName));
        retval.append("    ").append(XmlHandler.addTagValue((String)RUN_CONFIG, (String)this.runConfigurationName));
        retval.append("    ").append(XmlHandler.addTagValue((String)SOURCE_TRANSFORM, (String)this.sourceTransformName));
        retval.append("    ").append(XmlHandler.openTag((String)SOURCE_OUTPUT_FIELDS));
        for (MetaInjectOutputField field : this.sourceOutputFields) {
            retval.append(CONST_SPACE).append(XmlHandler.openTag((String)SOURCE_OUTPUT_FIELD));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_NAME, (String)field.getName()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_TYPE, (String)field.getTypeDescription()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_LENGTH, (int)field.getLength()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)SOURCE_OUTPUT_FIELD_PRECISION, (int)field.getPrecision()));
            retval.append(CONST_SPACE).append(XmlHandler.closeTag((String)SOURCE_OUTPUT_FIELD));
        }
        retval.append("    ").append(XmlHandler.closeTag((String)SOURCE_OUTPUT_FIELDS));
        retval.append("    ").append(XmlHandler.addTagValue((String)TARGET_FILE, (String)this.targetFile));
        retval.append("    ").append(XmlHandler.addTagValue((String)CREATE_PARENT_FOLDER, (boolean)this.createParentFolder));
        retval.append("    ").append(XmlHandler.addTagValue((String)NO_EXECUTION, (boolean)this.noExecution));
        if (this.streamSourceTransformName == null && this.streamSourceTransform != null) {
            this.streamSourceTransformName = this.streamSourceTransform.getName();
        }
        retval.append("    ").append(XmlHandler.addTagValue((String)STREAM_SOURCE_TRANSFORM, (String)this.streamSourceTransformName));
        retval.append("    ").append(XmlHandler.addTagValue((String)STREAM_TARGET_TRANSFORM, (String)this.streamTargetTransformName));
        retval.append("    ").append(XmlHandler.openTag((String)MAPPINGS));
        for (TargetTransformAttribute target : this.targetSourceMapping.keySet()) {
            retval.append(CONST_SPACE).append(XmlHandler.openTag((String)MAPPING));
            SourceTransformField source = this.targetSourceMapping.get(target);
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)TARGET_TRANSFORM_NAME, (String)target.getTransformName()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)TARGET_ATTRIBUTE_KEY, (String)target.getAttributeKey()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)TARGET_DETAIL, (boolean)target.isDetail()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)SOURCE_TRANSFORM, (String)source.getTransformName()));
            retval.append(CONST_SPACE_LONG).append(XmlHandler.addTagValue((String)SOURCE_FIELD, (String)source.getField()));
            retval.append(CONST_SPACE).append(XmlHandler.closeTag((String)MAPPING));
        }
        retval.append("    ").append(XmlHandler.closeTag((String)MAPPINGS));
        return retval.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.fileName = XmlHandler.getTagValue((Node)transformNode, (String)FILENAME);
            this.runConfigurationName = XmlHandler.getTagValue((Node)transformNode, (String)RUN_CONFIG);
            this.sourceTransformName = XmlHandler.getTagValue((Node)transformNode, (String)SOURCE_TRANSFORM);
            Node outputFieldsNode = XmlHandler.getSubNode((Node)transformNode, (String)SOURCE_OUTPUT_FIELDS);
            List outputFieldNodes = XmlHandler.getNodes((Node)outputFieldsNode, (String)SOURCE_OUTPUT_FIELD);
            this.sourceOutputFields = new ArrayList<MetaInjectOutputField>();
            for (Node outputFieldNode : outputFieldNodes) {
                String name = XmlHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_NAME);
                String typeName = XmlHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_TYPE);
                int length = Const.toInt((String)XmlHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_LENGTH), (int)-1);
                int precision = Const.toInt((String)XmlHandler.getTagValue((Node)outputFieldNode, (String)SOURCE_OUTPUT_FIELD_PRECISION), (int)-1);
                int type = ValueMetaFactory.getIdForValueMeta((String)typeName);
                this.sourceOutputFields.add(new MetaInjectOutputField(name, type, length, precision));
            }
            this.targetFile = XmlHandler.getTagValue((Node)transformNode, (String)TARGET_FILE);
            this.createParentFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)CREATE_PARENT_FOLDER));
            this.noExecution = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)NO_EXECUTION));
            this.streamSourceTransformName = XmlHandler.getTagValue((Node)transformNode, (String)STREAM_SOURCE_TRANSFORM);
            this.streamTargetTransformName = XmlHandler.getTagValue((Node)transformNode, (String)STREAM_TARGET_TRANSFORM);
            Node mappingsNode = XmlHandler.getSubNode((Node)transformNode, (String)MAPPINGS);
            int nrMappings = XmlHandler.countNodes((Node)mappingsNode, (String)MAPPING);
            for (int i = 0; i < nrMappings; ++i) {
                Node mappingNode = XmlHandler.getSubNodeByNr((Node)mappingsNode, (String)MAPPING, (int)i);
                String targetTransformName = XmlHandler.getTagValue((Node)mappingNode, (String)TARGET_TRANSFORM_NAME);
                String targetAttributeKey = XmlHandler.getTagValue((Node)mappingNode, (String)TARGET_ATTRIBUTE_KEY);
                boolean targetDetail = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)mappingNode, (String)TARGET_DETAIL));
                String sourceTransformName = XmlHandler.getTagValue((Node)mappingNode, (String)SOURCE_TRANSFORM);
                String sourceField = XmlHandler.getTagValue((Node)mappingNode, (String)SOURCE_FIELD);
                TargetTransformAttribute target = new TargetTransformAttribute(targetTransformName, targetAttributeKey, targetDetail);
                SourceTransformField source = new SourceTransformField(sourceTransformName, sourceField);
                this.targetSourceMapping.put(target, source);
            }
            MetaInjectMigration.migrateFrom70(this.targetSourceMapping);
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        rowMeta.clear();
        if (!Utils.isEmpty((CharSequence)this.sourceTransformName)) {
            for (MetaInjectOutputField field : this.sourceOutputFields) {
                try {
                    rowMeta.addValueMeta(field.createValueMeta());
                }
                catch (HopPluginException e) {
                    throw new HopTransformException("Error creating value meta for output field '" + field.getName() + "'", (Throwable)e);
                }
            }
        }
    }

    public Map<TargetTransformAttribute, SourceTransformField> getTargetSourceMapping() {
        return this.targetSourceMapping;
    }

    public void setTargetSourceMapping(Map<TargetTransformAttribute, SourceTransformField> targetSourceMapping) {
        this.targetSourceMapping = targetSourceMapping;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static final synchronized PipelineMeta loadPipelineMeta(MetaInjectMeta injectMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        PipelineMeta mappingPipelineMeta = null;
        CurrentDirectoryResolver resolver = new CurrentDirectoryResolver();
        IVariables tmpSpace = resolver.resolveCurrentDirectory(variables, injectMeta.getParentTransformMeta(), injectMeta.getFileName());
        String realFilename = tmpSpace.resolve(injectMeta.getFileName());
        try {
            if (mappingPipelineMeta == null) {
                mappingPipelineMeta = new PipelineMeta(realFilename, metadataProvider, tmpSpace);
                LogChannel.GENERAL.logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation was loaded from XML file [" + realFilename + "]"});
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadPipelineFromFile", (String[])new String[]{realFilename}), (Throwable)e);
        }
        mappingPipelineMeta.setFilename(mappingPipelineMeta.getFilename());
        return mappingPipelineMeta;
    }

    PipelineMeta loadPipelineMeta(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return MetaInjectMeta.loadPipelineMeta(this, metadataProvider, variables);
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        String realFilename = variables.resolve(this.fileName);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        if (!Utils.isEmpty((CharSequence)realFilename)) {
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.ACTIONFILE));
        }
        return references;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming resourceNamingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            String proposedNewFilename;
            PipelineMeta executorPipelineMeta = this.loadPipelineMeta(metadataProvider, variables);
            String newFilename = proposedNewFilename = executorPipelineMeta.exportResources(variables, definitions, resourceNamingInterface, metadataProvider);
            executorPipelineMeta.setFilename(newFilename);
            this.fileName = newFilename;
            return proposedNewFilename;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadTrans", (String[])new String[]{this.fileName}));
        }
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public String getSourceTransformName() {
        return this.sourceTransformName;
    }

    public void setSourceTransformName(String sourceTransformName) {
        this.sourceTransformName = sourceTransformName;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isNoExecution() {
        return this.noExecution;
    }

    public void setNoExecution(boolean noExecution) {
        this.noExecution = noExecution;
    }

    public String getRunConfigurationName() {
        return this.runConfigurationName;
    }

    public void setRunConfigurationName(String runConfigurationName) {
        this.runConfigurationName = runConfigurationName;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"MetaInjectMeta.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isTransformationDefined() {
        return !Utils.isEmpty((CharSequence)this.fileName);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isTransformationDefined()};
    }

    public String getActiveReferencedObjectDescription() {
        return BaseMessages.getString(PKG, (String)"MetaInjectMeta.ReferencedObjectAfterInjection.Description", (String[])new String[0]);
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return MetaInjectMeta.loadPipelineMeta(this, metadataProvider, variables);
    }

    public String getStreamSourceTransformName() {
        return this.streamSourceTransformName;
    }

    public void setStreamSourceTransformName(String streamSourceTransformName) {
        this.streamSourceTransformName = streamSourceTransformName;
    }

    public TransformMeta getStreamSourceTransform() {
        return this.streamSourceTransform;
    }

    public void setStreamSourceTransform(TransformMeta streamSourceTransform) {
        this.streamSourceTransform = streamSourceTransform;
    }

    public String getStreamTargetTransformName() {
        return this.streamTargetTransformName;
    }

    public void setStreamTargetTransformName(String streamTargetTransformName) {
        this.streamTargetTransformName = streamTargetTransformName;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.streamSourceTransform = TransformMeta.findTransform(transforms, (String)this.streamSourceTransformName);
    }

    public List<MetaInjectOutputField> getSourceOutputFields() {
        return this.sourceOutputFields;
    }

    public void setSourceOutputFields(List<MetaInjectOutputField> sourceOutputFields) {
        this.sourceOutputFields = sourceOutputFields;
    }

    public List<MetaInjectMapping> getMetaInjectMapping() {
        return this.metaInjectMapping;
    }

    public void setMetaInjectMapping(List<MetaInjectMapping> metaInjectMapping) {
        this.metaInjectMapping = metaInjectMapping;
    }

    public void actualizeMetaInjectMapping() {
        if (this.metaInjectMapping == null || this.metaInjectMapping.isEmpty()) {
            return;
        }
        Map<TargetTransformAttribute, SourceTransformField> targetToSourceMap = MetaInjectMeta.convertToMap(this.metaInjectMapping);
        this.setTargetSourceMapping(targetToSourceMap);
    }

    static Map<TargetTransformAttribute, SourceTransformField> convertToMap(List<MetaInjectMapping> metaInjectMapping) {
        HashMap<TargetTransformAttribute, SourceTransformField> targetToSourceMap = new HashMap<TargetTransformAttribute, SourceTransformField>();
        for (MetaInjectMapping mappingEntry : metaInjectMapping) {
            if (!MetaInjectMeta.isMappingEntryFilled(mappingEntry)) continue;
            TargetTransformAttribute targetTransformAttribute = MetaInjectMeta.createTargetTransformAttribute(mappingEntry);
            SourceTransformField sourceTransformField = MetaInjectMeta.createSourceTransformField(mappingEntry);
            targetToSourceMap.put(targetTransformAttribute, sourceTransformField);
        }
        return targetToSourceMap;
    }

    private static TargetTransformAttribute createTargetTransformAttribute(MetaInjectMapping mappingEntry) {
        String targetFieldName = mappingEntry.getTargetField();
        if (targetFieldName.contains(GROUP_AND_NAME_DELIMITER)) {
            String[] targetFieldGroupAndName = targetFieldName.split("\\.");
            return new TargetTransformAttribute(mappingEntry.getTargetTransform(), targetFieldGroupAndName[1], true);
        }
        return new TargetTransformAttribute(mappingEntry.getTargetTransform(), mappingEntry.getTargetField(), false);
    }

    private static boolean isMappingEntryFilled(MetaInjectMapping mappingEntry) {
        return mappingEntry.getSourceTransform() != null && mappingEntry.getSourceField() != null && mappingEntry.getTargetTransform() != null && mappingEntry.getTargetField() != null;
    }

    private static SourceTransformField createSourceTransformField(MetaInjectMapping mappingEntry) {
        return new SourceTransformField(mappingEntry.getSourceTransform(), mappingEntry.getSourceField());
    }

    public void setDefault() {
        super.setDefault();
        this.createParentFolder = true;
    }

    public void onTransformChange(PipelineMeta pipelineMeta, TransformMeta oldMeta, TransformMeta newMeta) {
        for (int i = 0; i < pipelineMeta.nrPipelineHops(); ++i) {
            TransformMeta toTransformMeta;
            PipelineHopMeta hopMeta = pipelineMeta.getPipelineHop(i);
            if (!hopMeta.getFromTransform().equals((Object)oldMeta) || !((toTransformMeta = hopMeta.getToTransform()).getTransform() instanceof MetaInjectMeta) || !toTransformMeta.equals((Object)this.getParentTransformMeta())) continue;
            MetaInjectMeta toMeta = (MetaInjectMeta)toTransformMeta.getTransform();
            Map<TargetTransformAttribute, SourceTransformField> sourceMapping = toMeta.getTargetSourceMapping();
            for (Map.Entry<TargetTransformAttribute, SourceTransformField> entry : sourceMapping.entrySet()) {
                SourceTransformField value = entry.getValue();
                if (value.getTransformName() == null || !value.getTransformName().equals(oldMeta.getName())) continue;
                value.setTransformName(newMeta.getName());
            }
        }
    }

    public String getFilename() {
        return null;
    }
}

