/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.dropbox.config;

import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.dropbox.config.DropboxConfig;
import org.apache.hop.vfs.dropbox.config.DropboxConfigSingleton;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="DropboxConfigPlugin", description="Configuration options for Dropbox", category="config")
@GuiPlugin(description="Dropbox")
public class DropboxConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_DROPBOX_ACCESS_TOKEN = "10000-dropbox-access-token";
    @GuiWidgetElement(id="10000-dropbox-access-token", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="Access token")
    @CommandLine.Option(names={"-dbxt", "--dropbox-access-token"}, description={"The Dropbox access token to use for VFS"})
    private String accessToken;

    public static DropboxConfigPlugin getInstance() {
        DropboxConfigPlugin instance = new DropboxConfigPlugin();
        DropboxConfig config = DropboxConfigSingleton.getConfig();
        instance.accessToken = config.getAccessToken();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        DropboxConfig config = DropboxConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.accessToken != null) {
                config.setAccessToken(this.accessToken);
                log.logBasic("The Dropbox access token is set to '" + this.accessToken + "'");
                changed = true;
            }
            if (changed) {
                DropboxConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling Dropbox configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-dropbox-access-token": {
                    this.accessToken = ((TextVar)control).getText();
                    DropboxConfigSingleton.getConfig().setAccessToken(this.accessToken);
                }
            }
        }
        try {
            DropboxConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }
}

