/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.ReaderInfo;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.groups.SplitEnumeratorMetricGroup;
import org.apache.flink.runtime.operators.coordination.ComponentClosingUtils;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.source.coordinator.ExecutorNotifier;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorProvider;
import org.apache.flink.runtime.source.coordinator.SplitAssignmentTracker;
import org.apache.flink.runtime.source.event.AddSplitEvent;
import org.apache.flink.runtime.source.event.NoMoreSplitsEvent;
import org.apache.flink.runtime.source.event.SourceEventWrapper;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ThrowableCatchingRunnable;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SourceCoordinatorContext<SplitT extends SourceSplit>
implements SplitEnumeratorContext<SplitT>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SourceCoordinatorContext.class);
    private final ScheduledExecutorService workerExecutor;
    private final ScheduledExecutorService coordinatorExecutor;
    private final ExecutorNotifier notifier;
    private final OperatorCoordinator.Context operatorCoordinatorContext;
    private final SimpleVersionedSerializer<SplitT> splitSerializer;
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, ReaderInfo>> registeredReaders;
    private final SplitAssignmentTracker<SplitT> assignmentTracker;
    private final SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory;
    private final SubtaskGateways subtaskGateways;
    private final String coordinatorThreadName;
    private final boolean supportsConcurrentExecutionAttempts;
    private final boolean[] subtaskHasNoMoreSplits;
    private volatile boolean closed;

    public SourceCoordinatorContext(SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory, int numWorkerThreads, OperatorCoordinator.Context operatorCoordinatorContext, SimpleVersionedSerializer<SplitT> splitSerializer, boolean supportsConcurrentExecutionAttempts) {
        this(Executors.newScheduledThreadPool(1, coordinatorThreadFactory), Executors.newScheduledThreadPool(numWorkerThreads, (ThreadFactory)new ExecutorThreadFactory(coordinatorThreadFactory.getCoordinatorThreadName() + "-worker")), coordinatorThreadFactory, operatorCoordinatorContext, splitSerializer, new SplitAssignmentTracker(), supportsConcurrentExecutionAttempts);
    }

    @VisibleForTesting
    SourceCoordinatorContext(ScheduledExecutorService coordinatorExecutor, ScheduledExecutorService workerExecutor, SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory, OperatorCoordinator.Context operatorCoordinatorContext, SimpleVersionedSerializer<SplitT> splitSerializer, SplitAssignmentTracker<SplitT> splitAssignmentTracker, boolean supportsConcurrentExecutionAttempts) {
        this.workerExecutor = workerExecutor;
        this.coordinatorExecutor = coordinatorExecutor;
        this.coordinatorThreadFactory = coordinatorThreadFactory;
        this.operatorCoordinatorContext = operatorCoordinatorContext;
        this.splitSerializer = splitSerializer;
        this.registeredReaders = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, ReaderInfo>>();
        this.assignmentTracker = splitAssignmentTracker;
        this.coordinatorThreadName = coordinatorThreadFactory.getCoordinatorThreadName();
        this.supportsConcurrentExecutionAttempts = supportsConcurrentExecutionAttempts;
        int parallelism = operatorCoordinatorContext.currentParallelism();
        this.subtaskGateways = new SubtaskGateways(parallelism);
        this.subtaskHasNoMoreSplits = new boolean[parallelism];
        Arrays.fill(this.subtaskHasNoMoreSplits, false);
        Executor errorHandlingCoordinatorExecutor = runnable -> coordinatorExecutor.execute((Runnable)new ThrowableCatchingRunnable(this::handleUncaughtExceptionFromAsyncCall, runnable));
        this.notifier = new ExecutorNotifier(workerExecutor, errorHandlingCoordinatorExecutor);
    }

    boolean isConcurrentExecutionAttemptsSupported() {
        return this.supportsConcurrentExecutionAttempts;
    }

    public SplitEnumeratorMetricGroup metricGroup() {
        return null;
    }

    public void sendEventToSourceReader(int subtaskId, SourceEvent event) {
        Preconditions.checkState((!this.supportsConcurrentExecutionAttempts ? 1 : 0) != 0, (Object)"The split enumerator must invoke SplitEnumeratorContext#sendEventToSourceReader(int, int, SourceEvent) instead of SplitEnumeratorContext#sendEventToSourceReader(int, SourceEvent) to send custom source events in concurrent execution attempts scenario (e.g. if speculative execution is enabled).");
        this.checkSubtaskIndex(subtaskId);
        this.callInCoordinatorThread(() -> {
            OperatorCoordinator.SubtaskGateway gateway = this.subtaskGateways.getOnlyGatewayAndCheckReady(subtaskId);
            gateway.sendEvent(new SourceEventWrapper(event));
            return null;
        }, String.format("Failed to send event %s to subtask %d", event, subtaskId));
    }

    public void sendEventToSourceReader(int subtaskId, int attemptNumber, SourceEvent event) {
        this.checkSubtaskIndex(subtaskId);
        this.callInCoordinatorThread(() -> {
            OperatorCoordinator.SubtaskGateway gateway = this.subtaskGateways.getGatewayAndCheckReady(subtaskId, attemptNumber);
            gateway.sendEvent(new SourceEventWrapper(event));
            return null;
        }, String.format("Failed to send event %s to subtask %d (#%d)", event, subtaskId, attemptNumber));
    }

    void sendEventToSourceOperator(int subtaskId, OperatorEvent event) {
        this.checkSubtaskIndex(subtaskId);
        this.callInCoordinatorThread(() -> {
            OperatorCoordinator.SubtaskGateway gateway = this.subtaskGateways.getOnlyGatewayAndCheckReady(subtaskId);
            gateway.sendEvent(event);
            return null;
        }, String.format("Failed to send event %s to subtask %d", event, subtaskId));
    }

    ScheduledExecutorService getCoordinatorExecutor() {
        return this.coordinatorExecutor;
    }

    public int currentParallelism() {
        return this.operatorCoordinatorContext.currentParallelism();
    }

    public Map<Integer, ReaderInfo> registeredReaders() {
        HashMap readers = new HashMap();
        for (Map.Entry entry : this.registeredReaders.entrySet()) {
            int subtaskIndex = (Integer)entry.getKey();
            Map attemptReaders = (Map)entry.getValue();
            int earliestAttempt = Integer.MAX_VALUE;
            Iterator iterator = attemptReaders.keySet().iterator();
            while (iterator.hasNext()) {
                int attemptNumber = (Integer)iterator.next();
                if (attemptNumber >= earliestAttempt) continue;
                earliestAttempt = attemptNumber;
            }
            readers.put(subtaskIndex, attemptReaders.get(earliestAttempt));
        }
        return Collections.unmodifiableMap(readers);
    }

    public Map<Integer, Map<Integer, ReaderInfo>> registeredReadersOfAttempts() {
        return Collections.unmodifiableMap(this.registeredReaders);
    }

    public void assignSplits(SplitsAssignment<SplitT> assignment) {
        this.callInCoordinatorThread(() -> {
            assignment.assignment().forEach((id, splits) -> {
                if (!this.registeredReaders.containsKey(id)) {
                    throw new IllegalArgumentException(String.format("Cannot assign splits %s to subtask %d because the subtask is not registered.", splits, id));
                }
            });
            this.assignmentTracker.recordSplitAssignment(assignment);
            this.assignSplitsToAttempts(assignment);
            return null;
        }, String.format("Failed to assign splits %s due to ", assignment));
    }

    public void signalNoMoreSplits(int subtask) {
        this.checkSubtaskIndex(subtask);
        this.callInCoordinatorThread(() -> {
            this.subtaskHasNoMoreSplits[subtask] = true;
            this.signalNoMoreSplitsToAttempts(subtask);
            return null;
        }, "Failed to send 'NoMoreSplits' to reader " + subtask);
    }

    public <T> void callAsync(Callable<T> callable, BiConsumer<T, Throwable> handler, long initialDelay, long period) {
        this.notifier.notifyReadyAsync(callable, handler, initialDelay, period);
    }

    public <T> void callAsync(Callable<T> callable, BiConsumer<T, Throwable> handler) {
        this.notifier.notifyReadyAsync(callable, handler);
    }

    public void runInCoordinatorThread(Runnable runnable) {
        this.coordinatorExecutor.execute((Runnable)new ThrowableCatchingRunnable(throwable -> this.coordinatorThreadFactory.uncaughtException(Thread.currentThread(), (Throwable)throwable), runnable));
    }

    @Override
    public void close() throws InterruptedException {
        this.closed = true;
        ComponentClosingUtils.shutdownExecutorForcefully(this.workerExecutor, Duration.ofNanos(Long.MAX_VALUE));
        ComponentClosingUtils.shutdownExecutorForcefully(this.coordinatorExecutor, Duration.ofNanos(Long.MAX_VALUE));
    }

    void attemptReady(OperatorCoordinator.SubtaskGateway gateway) {
        Preconditions.checkState((boolean)this.coordinatorThreadFactory.isCurrentThreadCoordinatorThread());
        this.subtaskGateways.registerSubtaskGateway(gateway);
    }

    void attemptFailed(int subtaskIndex, int attemptNumber) {
        Preconditions.checkState((boolean)this.coordinatorThreadFactory.isCurrentThreadCoordinatorThread());
        this.subtaskGateways.unregisterSubtaskGateway(subtaskIndex, attemptNumber);
    }

    void subtaskReset(int subtaskIndex) {
        Preconditions.checkState((boolean)this.coordinatorThreadFactory.isCurrentThreadCoordinatorThread());
        this.subtaskGateways.reset(subtaskIndex);
        this.registeredReaders.remove(subtaskIndex);
        this.subtaskHasNoMoreSplits[subtaskIndex] = false;
    }

    boolean hasNoMoreSplits(int subtaskIndex) {
        return this.subtaskHasNoMoreSplits[subtaskIndex];
    }

    void failJob(Throwable cause) {
        this.operatorCoordinatorContext.failJob(cause);
    }

    void handleUncaughtExceptionFromAsyncCall(Throwable t) {
        if (this.closed) {
            return;
        }
        ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
        LOG.error("Exception while handling result from async call in {}. Triggering job failover.", (Object)this.coordinatorThreadName, (Object)t);
        this.failJob(t);
    }

    void onCheckpoint(long checkpointId) throws Exception {
        this.assignmentTracker.onCheckpoint(checkpointId);
    }

    void registerSourceReader(int subtaskId, int attemptNumber, String location) {
        Map attemptReaders = this.registeredReaders.computeIfAbsent(subtaskId, k -> new ConcurrentHashMap());
        Preconditions.checkState((!attemptReaders.containsKey(attemptNumber) ? 1 : 0) != 0, (String)"ReaderInfo of subtask %s (#%s) already exists.", (Object[])new Object[]{subtaskId, attemptNumber});
        attemptReaders.put(attemptNumber, new ReaderInfo(subtaskId, location));
        this.sendCachedSplitsToNewlyRegisteredReader(subtaskId, attemptNumber);
    }

    void unregisterSourceReader(int subtaskId, int attemptNumber) {
        Map attemptReaders = (Map)this.registeredReaders.get(subtaskId);
        if (attemptReaders != null) {
            attemptReaders.remove(attemptNumber);
            if (attemptReaders.isEmpty()) {
                this.registeredReaders.remove(subtaskId);
            }
        }
    }

    List<SplitT> getAndRemoveUncheckpointedAssignment(int subtaskId, long restoredCheckpointId) {
        return this.assignmentTracker.getAndRemoveUncheckpointedAssignment(subtaskId, restoredCheckpointId);
    }

    void onCheckpointComplete(long checkpointId) {
        this.assignmentTracker.onCheckpointComplete(checkpointId);
    }

    OperatorCoordinator.Context getCoordinatorContext() {
        return this.operatorCoordinatorContext;
    }

    private void checkSubtaskIndex(int subtaskIndex) {
        if (subtaskIndex < 0 || subtaskIndex >= this.getCoordinatorContext().currentParallelism()) {
            throw new IllegalArgumentException(String.format("Subtask index %d is out of bounds [0, %s)", subtaskIndex, this.getCoordinatorContext().currentParallelism()));
        }
    }

    private <V> V callInCoordinatorThread(Callable<V> callable, String errorMessage) {
        if (!this.coordinatorThreadFactory.isCurrentThreadCoordinatorThread()) {
            try {
                Callable<Object> guardedCallable = () -> {
                    try {
                        return callable.call();
                    }
                    catch (Throwable t) {
                        LOG.error("Uncaught Exception in Source Coordinator Executor", t);
                        ExceptionUtils.rethrowException((Throwable)t);
                        return null;
                    }
                };
                return (V)this.coordinatorExecutor.submit(guardedCallable).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new FlinkRuntimeException(errorMessage, (Throwable)e);
            }
        }
        try {
            return callable.call();
        }
        catch (Throwable t) {
            LOG.error("Uncaught Exception in Source Coordinator Executor", t);
            throw new FlinkRuntimeException(errorMessage, t);
        }
    }

    private void assignSplitsToAttempts(SplitsAssignment<SplitT> assignment) {
        assignment.assignment().forEach((index, splits) -> this.assignSplitsToAttempts((int)index, (List<SplitT>)splits));
    }

    private void assignSplitsToAttempts(int subtaskIndex, List<SplitT> splits) {
        this.getRegisteredAttempts(subtaskIndex).forEach(attempt -> this.assignSplitsToAttempt(subtaskIndex, (int)attempt, splits));
    }

    private void assignSplitsToAttempt(int subtaskIndex, int attemptNumber, List<SplitT> splits) {
        AddSplitEvent<SplitT> addSplitEvent;
        if (splits.isEmpty()) {
            return;
        }
        this.checkAttemptReaderReady(subtaskIndex, attemptNumber);
        try {
            addSplitEvent = new AddSplitEvent<SplitT>(splits, this.splitSerializer);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Failed to serialize splits.", (Throwable)e);
        }
        OperatorCoordinator.SubtaskGateway gateway = this.subtaskGateways.getGatewayAndCheckReady(subtaskIndex, attemptNumber);
        gateway.sendEvent(addSplitEvent);
    }

    private void signalNoMoreSplitsToAttempts(int subtaskIndex) {
        this.getRegisteredAttempts(subtaskIndex).forEach(attemptNumber -> this.signalNoMoreSplitsToAttempt(subtaskIndex, (int)attemptNumber));
    }

    private void signalNoMoreSplitsToAttempt(int subtaskIndex, int attemptNumber) {
        this.checkAttemptReaderReady(subtaskIndex, attemptNumber);
        OperatorCoordinator.SubtaskGateway gateway = this.subtaskGateways.getGatewayAndCheckReady(subtaskIndex, attemptNumber);
        gateway.sendEvent(new NoMoreSplitsEvent());
    }

    private void checkAttemptReaderReady(int subtaskIndex, int attemptNumber) {
        Preconditions.checkState((boolean)this.registeredReaders.containsKey(subtaskIndex));
        Preconditions.checkState((boolean)this.getRegisteredAttempts(subtaskIndex).contains(attemptNumber));
    }

    private Set<Integer> getRegisteredAttempts(int subtaskIndex) {
        return ((ConcurrentMap)this.registeredReaders.get(subtaskIndex)).keySet();
    }

    private void sendCachedSplitsToNewlyRegisteredReader(int subtaskIndex, int attemptNumber) {
        LinkedHashSet<SplitT> cachedSplits = this.assignmentTracker.uncheckpointedAssignments().get(subtaskIndex);
        if (cachedSplits != null) {
            if (this.supportsConcurrentExecutionAttempts) {
                this.assignSplitsToAttempt(subtaskIndex, attemptNumber, new ArrayList<SplitT>(cachedSplits));
                if (this.hasNoMoreSplits(subtaskIndex)) {
                    this.signalNoMoreSplitsToAttempt(subtaskIndex, attemptNumber);
                }
            } else {
                throw new IllegalStateException("No cached split is expected.");
            }
        }
    }

    private static class SubtaskGateways {
        private final Map<Integer, OperatorCoordinator.SubtaskGateway>[] gateways;

        private SubtaskGateways(int parallelism) {
            this.gateways = new Map[parallelism];
            for (int i = 0; i < parallelism; ++i) {
                this.gateways[i] = new HashMap<Integer, OperatorCoordinator.SubtaskGateway>();
            }
        }

        private void registerSubtaskGateway(OperatorCoordinator.SubtaskGateway gateway) {
            int attemptNumber;
            int subtaskIndex = gateway.getSubtask();
            Preconditions.checkState((!this.gateways[subtaskIndex].containsKey(attemptNumber = gateway.getExecution().getAttemptNumber()) ? 1 : 0) != 0, (String)"Already have a subtask gateway for %s (#%s).", (Object[])new Object[]{subtaskIndex, attemptNumber});
            this.gateways[subtaskIndex].put(attemptNumber, gateway);
        }

        private void unregisterSubtaskGateway(int subtaskIndex, int attemptNumber) {
            this.gateways[subtaskIndex].remove(attemptNumber);
        }

        private OperatorCoordinator.SubtaskGateway getOnlyGatewayAndCheckReady(int subtaskIndex) {
            Preconditions.checkState((this.gateways[subtaskIndex].size() > 0 ? 1 : 0) != 0, (String)"Subtask %s is not ready yet to receive events.", (Object[])new Object[]{subtaskIndex});
            return (OperatorCoordinator.SubtaskGateway)Iterables.getOnlyElement(this.gateways[subtaskIndex].values());
        }

        private OperatorCoordinator.SubtaskGateway getGatewayAndCheckReady(int subtaskIndex, int attemptNumber) {
            OperatorCoordinator.SubtaskGateway gateway = this.gateways[subtaskIndex].get(attemptNumber);
            if (gateway != null) {
                return gateway;
            }
            throw new IllegalStateException(String.format("Subtask %d (#%d) is not ready yet to receive events.", subtaskIndex, attemptNumber));
        }

        private void reset(int subtaskIndex) {
            this.gateways[subtaskIndex].clear();
        }
    }
}

