/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.highavailability.ClientHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesFactory;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneClientHAServices;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneHaServices;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperClientHAServices;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperMultipleComponentLeaderElectionHaServices;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcServiceUtils;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class HighAvailabilityServicesUtils {
    public static HighAvailabilityServices createAvailableOrEmbeddedServices(Configuration config, Executor executor, FatalErrorHandler fatalErrorHandler) throws Exception {
        HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.fromConfig(config);
        switch (highAvailabilityMode) {
            case NONE: {
                return new EmbeddedHaServices(executor);
            }
            case ZOOKEEPER: {
                return HighAvailabilityServicesUtils.createZooKeeperHaServices(config, executor, fatalErrorHandler);
            }
            case KUBERNETES: {
                return HighAvailabilityServicesUtils.createCustomHAServices("org.apache.flink.kubernetes.highavailability.KubernetesHaServicesFactory", config, executor);
            }
            case FACTORY_CLASS: {
                return HighAvailabilityServicesUtils.createCustomHAServices(config, executor);
            }
        }
        throw new Exception("High availability mode " + (Object)((Object)highAvailabilityMode) + " is not supported.");
    }

    private static HighAvailabilityServices createZooKeeperHaServices(Configuration configuration, Executor executor, FatalErrorHandler fatalErrorHandler) throws Exception {
        BlobStoreService blobStoreService = BlobUtils.createBlobStoreFromConfig(configuration);
        CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework(configuration, fatalErrorHandler);
        return new ZooKeeperMultipleComponentLeaderElectionHaServices(curatorFrameworkWrapper, configuration, executor, blobStoreService, fatalErrorHandler);
    }

    public static HighAvailabilityServices createHighAvailabilityServices(Configuration configuration, Executor executor, AddressResolution addressResolution, RpcSystemUtils rpcSystemUtils, FatalErrorHandler fatalErrorHandler) throws Exception {
        HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.fromConfig(configuration);
        switch (highAvailabilityMode) {
            case NONE: {
                Tuple2<String, Integer> hostnamePort = HighAvailabilityServicesUtils.getJobManagerAddress(configuration);
                String resourceManagerRpcUrl = rpcSystemUtils.getRpcUrl((String)hostnamePort.f0, ((Integer)hostnamePort.f1).intValue(), RpcServiceUtils.createWildcardName((String)"resourcemanager"), addressResolution, configuration);
                String dispatcherRpcUrl = rpcSystemUtils.getRpcUrl((String)hostnamePort.f0, ((Integer)hostnamePort.f1).intValue(), RpcServiceUtils.createWildcardName((String)"dispatcher"), addressResolution, configuration);
                String webMonitorAddress = HighAvailabilityServicesUtils.getWebMonitorAddress(configuration, addressResolution);
                return new StandaloneHaServices(resourceManagerRpcUrl, dispatcherRpcUrl, webMonitorAddress);
            }
            case ZOOKEEPER: {
                return HighAvailabilityServicesUtils.createZooKeeperHaServices(configuration, executor, fatalErrorHandler);
            }
            case KUBERNETES: {
                return HighAvailabilityServicesUtils.createCustomHAServices("org.apache.flink.kubernetes.highavailability.KubernetesHaServicesFactory", configuration, executor);
            }
            case FACTORY_CLASS: {
                return HighAvailabilityServicesUtils.createCustomHAServices(configuration, executor);
            }
        }
        throw new Exception("Recovery mode " + (Object)((Object)highAvailabilityMode) + " is not supported.");
    }

    public static ClientHighAvailabilityServices createClientHAService(Configuration configuration, FatalErrorHandler fatalErrorHandler) throws Exception {
        HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.fromConfig(configuration);
        switch (highAvailabilityMode) {
            case NONE: {
                String webMonitorAddress = HighAvailabilityServicesUtils.getWebMonitorAddress(configuration, AddressResolution.TRY_ADDRESS_RESOLUTION);
                return new StandaloneClientHAServices(webMonitorAddress);
            }
            case ZOOKEEPER: {
                return new ZooKeeperClientHAServices(ZooKeeperUtils.startCuratorFramework(configuration, fatalErrorHandler), configuration);
            }
            case KUBERNETES: {
                return HighAvailabilityServicesUtils.createCustomClientHAServices("org.apache.flink.kubernetes.highavailability.KubernetesHaServicesFactory", configuration);
            }
            case FACTORY_CLASS: {
                return HighAvailabilityServicesUtils.createCustomClientHAServices(configuration);
            }
        }
        throw new Exception("Recovery mode " + (Object)((Object)highAvailabilityMode) + " is not supported.");
    }

    public static Tuple2<String, Integer> getJobManagerAddress(Configuration configuration) throws ConfigurationException {
        String hostname = configuration.getString(JobManagerOptions.ADDRESS);
        int port = configuration.getInteger(JobManagerOptions.PORT);
        if (hostname == null) {
            throw new ConfigurationException("Config parameter '" + JobManagerOptions.ADDRESS + "' is missing (hostname/address of JobManager to connect to).");
        }
        if (port <= 0 || port >= 65536) {
            throw new ConfigurationException("Invalid value for '" + JobManagerOptions.PORT + "' (port of the JobManager actor system) : " + port + ".  it must be greater than 0 and less than 65536.");
        }
        return Tuple2.of((Object)hostname, (Object)port);
    }

    public static String getWebMonitorAddress(Configuration configuration, AddressResolution resolution) throws UnknownHostException {
        String address = (String)Preconditions.checkNotNull((Object)configuration.getString(RestOptions.ADDRESS), (String)"%s must be set", (Object[])new Object[]{RestOptions.ADDRESS.key()});
        if (resolution == AddressResolution.TRY_ADDRESS_RESOLUTION) {
            InetAddress.getByName(address);
        }
        int port = configuration.getInteger(RestOptions.PORT);
        boolean enableSSL = SecurityOptions.isRestSSLEnabled((Configuration)configuration);
        String protocol = enableSSL ? "https://" : "http://";
        return String.format("%s%s:%s", protocol, address, port);
    }

    public static Path getClusterHighAvailableStoragePath(Configuration configuration) {
        Path clusterStoragePath;
        Path path;
        String storagePath = configuration.getValue(HighAvailabilityOptions.HA_STORAGE_PATH);
        if (StringUtils.isNullOrWhitespaceOnly((String)storagePath)) {
            throw new IllegalConfigurationException("Configuration is missing the mandatory parameter: " + HighAvailabilityOptions.HA_STORAGE_PATH);
        }
        try {
            path = new Path(storagePath);
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Invalid path for highly available storage (" + HighAvailabilityOptions.HA_STORAGE_PATH.key() + ')', (Throwable)e);
        }
        String clusterId = configuration.getValue(HighAvailabilityOptions.HA_CLUSTER_ID);
        try {
            clusterStoragePath = new Path(path, clusterId);
        }
        catch (Exception e) {
            throw new IllegalConfigurationException(String.format("Cannot create cluster high available storage path '%s/%s'. This indicates that an invalid cluster id (%s) has been specified.", storagePath, clusterId, HighAvailabilityOptions.HA_CLUSTER_ID.key()), (Throwable)e);
        }
        return clusterStoragePath;
    }

    private static HighAvailabilityServices createCustomHAServices(Configuration config, Executor executor) throws FlinkException {
        return HighAvailabilityServicesUtils.createCustomHAServices(config.getString(HighAvailabilityOptions.HA_MODE), config, executor);
    }

    private static HighAvailabilityServices createCustomHAServices(String factoryClassName, Configuration config, Executor executor) throws FlinkException {
        HighAvailabilityServicesFactory highAvailabilityServicesFactory = HighAvailabilityServicesUtils.loadCustomHighAvailabilityServicesFactory(factoryClassName);
        try {
            return highAvailabilityServicesFactory.createHAServices(config, executor);
        }
        catch (Exception e) {
            throw new FlinkException(String.format("Could not create the ha services from the instantiated HighAvailabilityServicesFactory %s.", highAvailabilityServicesFactory.getClass().getName()), (Throwable)e);
        }
    }

    private static HighAvailabilityServicesFactory loadCustomHighAvailabilityServicesFactory(String highAvailabilityServicesFactoryClassName) throws FlinkException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (HighAvailabilityServicesFactory)InstantiationUtil.instantiate((String)highAvailabilityServicesFactoryClassName, HighAvailabilityServicesFactory.class, (ClassLoader)classLoader);
    }

    private static ClientHighAvailabilityServices createCustomClientHAServices(Configuration config) throws FlinkException {
        return HighAvailabilityServicesUtils.createCustomClientHAServices(config.getString(HighAvailabilityOptions.HA_MODE), config);
    }

    private static ClientHighAvailabilityServices createCustomClientHAServices(String factoryClassName, Configuration config) throws FlinkException {
        HighAvailabilityServicesFactory highAvailabilityServicesFactory = HighAvailabilityServicesUtils.loadCustomHighAvailabilityServicesFactory(factoryClassName);
        try {
            return highAvailabilityServicesFactory.createClientHAServices(config);
        }
        catch (Exception e) {
            throw new FlinkException(String.format("Could not create the client ha services from the instantiated HighAvailabilityServicesFactory %s.", highAvailabilityServicesFactory.getClass().getName()), (Throwable)e);
        }
    }
}

