/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.DirectRetryingExecutor;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.RetryHelper;
import com.google.cloud.bigquery.BigQueryRetryAlgorithm;
import com.google.cloud.bigquery.BigQueryRetryConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BigQueryRetryHelper
extends RetryHelper {
    private static final Logger LOG = Logger.getLogger(BigQueryRetryHelper.class.getName());

    public static <V> V runWithRetries(Callable<V> callable, RetrySettings retrySettings, ResultRetryAlgorithm<?> resultRetryAlgorithm, ApiClock clock, BigQueryRetryConfig bigQueryRetryConfig) throws RetryHelper.RetryHelperException {
        try {
            ResultRetryAlgorithm<?> algorithm = resultRetryAlgorithm;
            return BigQueryRetryHelper.run(callable, (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(retrySettings, clock), algorithm, bigQueryRetryConfig);
        }
        catch (Exception e) {
            throw new BigQueryRetryHelperException(e.getCause());
        }
    }

    private static <V> V run(Callable<V> callable, TimedRetryAlgorithm timedAlgorithm, ResultRetryAlgorithm<V> resultAlgorithm, BigQueryRetryConfig bigQueryRetryConfig) throws ExecutionException, InterruptedException {
        BigQueryRetryAlgorithm<V> retryAlgorithm = new BigQueryRetryAlgorithm<V>(resultAlgorithm, timedAlgorithm, bigQueryRetryConfig);
        DirectRetryingExecutor executor = new DirectRetryingExecutor(retryAlgorithm);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Retrying with:\n{0}\n{1}", new Object[]{"BigQuery retried method: " + callable.getClass().getEnclosingMethod().getName(), "BigQuery retry settings: " + timedAlgorithm.createFirstAttempt().getGlobalSettings()});
        }
        RetryingFuture retryingFuture = executor.createFuture(callable);
        executor.submit(retryingFuture);
        return (V)retryingFuture.get();
    }

    public static class BigQueryRetryHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -8519852520090965314L;

        BigQueryRetryHelperException(Throwable cause) {
            super(cause);
        }
    }
}

