/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.schemas.Schema;

final class AutoValue_PubsubMessageToRow
extends PubsubMessageToRow {
    private final Schema messageSchema;
    private final boolean useDlq;
    private final boolean useFlatSchema;
    private final PubsubMessageToRow.SerializerProvider serializerProvider;

    private AutoValue_PubsubMessageToRow(Schema messageSchema, boolean useDlq, boolean useFlatSchema, @Nullable PubsubMessageToRow.SerializerProvider serializerProvider) {
        this.messageSchema = messageSchema;
        this.useDlq = useDlq;
        this.useFlatSchema = useFlatSchema;
        this.serializerProvider = serializerProvider;
    }

    @Override
    public Schema messageSchema() {
        return this.messageSchema;
    }

    @Override
    public boolean useDlq() {
        return this.useDlq;
    }

    @Override
    public boolean useFlatSchema() {
        return this.useFlatSchema;
    }

    @Override
    @Nullable
    public PubsubMessageToRow.SerializerProvider serializerProvider() {
        return this.serializerProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubMessageToRow) {
            PubsubMessageToRow that = (PubsubMessageToRow)o;
            return this.messageSchema.equals((Object)that.messageSchema()) && this.useDlq == that.useDlq() && this.useFlatSchema == that.useFlatSchema() && (this.serializerProvider == null ? that.serializerProvider() == null : this.serializerProvider.equals(that.serializerProvider()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.messageSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.useDlq ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.useFlatSchema ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.serializerProvider == null ? 0 : this.serializerProvider.hashCode();
    }

    static final class Builder
    extends PubsubMessageToRow.Builder {
        private Schema messageSchema;
        private Boolean useDlq;
        private Boolean useFlatSchema;
        private PubsubMessageToRow.SerializerProvider serializerProvider;

        Builder() {
        }

        @Override
        public PubsubMessageToRow.Builder messageSchema(Schema messageSchema) {
            if (messageSchema == null) {
                throw new NullPointerException("Null messageSchema");
            }
            this.messageSchema = messageSchema;
            return this;
        }

        @Override
        public PubsubMessageToRow.Builder useDlq(boolean useDlq) {
            this.useDlq = useDlq;
            return this;
        }

        @Override
        public PubsubMessageToRow.Builder useFlatSchema(boolean useFlatSchema) {
            this.useFlatSchema = useFlatSchema;
            return this;
        }

        @Override
        public PubsubMessageToRow.Builder serializerProvider(PubsubMessageToRow.SerializerProvider serializerProvider) {
            this.serializerProvider = serializerProvider;
            return this;
        }

        @Override
        public PubsubMessageToRow build() {
            if (this.messageSchema == null || this.useDlq == null || this.useFlatSchema == null) {
                StringBuilder missing = new StringBuilder();
                if (this.messageSchema == null) {
                    missing.append(" messageSchema");
                }
                if (this.useDlq == null) {
                    missing.append(" useDlq");
                }
                if (this.useFlatSchema == null) {
                    missing.append(" useFlatSchema");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubMessageToRow(this.messageSchema, this.useDlq, this.useFlatSchema, this.serializerProvider);
        }
    }
}

