/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.model;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Internal
public class NewPartition
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -6530725494713332884L;
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition;
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> changeStreamContinuationTokens;
    @UnknownKeyFor @NonNull @Initialized Instant lowWatermark;
    @UnknownKeyFor @NonNull @Initialized Instant lastUpdated;

    public NewPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> changeStreamContinuationTokens, @UnknownKeyFor @NonNull @Initialized Instant lowWatermark, @UnknownKeyFor @NonNull @Initialized Instant lastUpdated) {
        this.partition = partition;
        this.changeStreamContinuationTokens = changeStreamContinuationTokens;
        this.lowWatermark = lowWatermark;
        this.lastUpdated = lastUpdated;
    }

    public NewPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange partition, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> changeStreamContinuationTokens, @UnknownKeyFor @NonNull @Initialized Instant lowWatermark) {
        this(partition, changeStreamContinuationTokens, lowWatermark, Instant.EPOCH);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange getPartition() {
        return this.partition;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ChangeStreamContinuationToken> getChangeStreamContinuationTokens() {
        return this.changeStreamContinuationTokens;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getLowWatermark() {
        return this.lowWatermark;
    }

    public @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> getParentPartitions() {
        return this.getChangeStreamContinuationTokens().stream().map(ChangeStreamContinuationToken::getPartition).collect(Collectors.toList());
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getLastUpdated() {
        return this.lastUpdated;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized NewPartition getSingleTokenNewPartition(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange parentPartition) {
        for (ChangeStreamContinuationToken parentToken : this.getChangeStreamContinuationTokens()) {
            if (!parentToken.getPartition().equals((Object)parentPartition)) continue;
            return new NewPartition(this.getPartition(), Collections.singletonList(parentToken), this.getLowWatermark(), this.getLastUpdated());
        }
        return null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NewPartition)) {
            return false;
        }
        NewPartition that = (NewPartition)o;
        return Objects.equals(this.getPartition(), that.getPartition()) && Objects.equals(this.getChangeStreamContinuationTokens(), that.getChangeStreamContinuationTokens()) && Objects.equals(this.getLowWatermark(), that.getLowWatermark()) && Objects.equals(this.getLastUpdated(), that.getLastUpdated());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getPartition(), this.getChangeStreamContinuationTokens(), this.getLowWatermark(), this.getLastUpdated());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "NewPartition{partition=" + ByteStringRangeHelper.formatByteStringRange(this.partition) + ", changeStreamContinuationTokens=" + this.changeStreamContinuationTokens.stream().map(t -> ByteStringRangeHelper.formatByteStringRange(t.getPartition()) + " => {" + t.getToken() + "}").collect(Collectors.joining(", ", "{", "}")) + ", lowWatermark=" + this.lowWatermark + ", lastUpdated=" + this.lastUpdated + '}';
    }
}

