/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dbproc;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dbproc.DBProcData;
import org.apache.hop.pipeline.transforms.dbproc.DBProcMeta;

public class DBProc
extends BaseTransform<DBProcMeta, DBProcData> {
    private static final Class<?> PKG = DBProcMeta.class;

    public DBProc(TransformMeta transformMeta, DBProcMeta meta, DBProcData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] runProc(IRowMeta rowMeta, Object[] rowData) throws HopException {
        if (this.first) {
            this.first = false;
            ((DBProcData)this.data).outputMeta = ((DBProcData)this.data).inputRowMeta.clone();
            ((DBProcMeta)this.meta).getFields(((DBProcData)this.data).outputMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((DBProcData)this.data).argnrs = new int[((DBProcMeta)this.meta).getArguments().size()];
            for (int i = 0; i < ((DBProcMeta)this.meta).getArguments().size(); ++i) {
                DBProcMeta.ProcArgument argument = ((DBProcMeta)this.meta).getArguments().get(i);
                if (!argument.getDirection().equalsIgnoreCase("OUT")) {
                    ((DBProcData)this.data).argnrs[i] = rowMeta.indexOfValue(argument.getName());
                    if (((DBProcData)this.data).argnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.ErrorFindingField", (String[])new String[0]) + argument.getName() + "]");
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DBProc.Exception.CouldnotFindField", (String[])new String[]{argument.getName()}));
                }
                ((DBProcData)this.data).argnrs[i] = -1;
            }
            ((DBProcData)this.data).db.setProcLookup(this.resolve(((DBProcMeta)this.meta).getProcedure()), ((DBProcMeta)this.meta).argumentNames(), ((DBProcMeta)this.meta).argumentDirections(), ((DBProcMeta)this.meta).argumentTypes(), ((DBProcMeta)this.meta).getResult().getName(), ((DBProcMeta)this.meta).getResult().getHopType());
        }
        Object[] outputRowData = RowDataUtil.resizeArray((Object[])rowData, (int)((DBProcData)this.data).outputMeta.size());
        int outputIndex = rowMeta.size();
        ((DBProcData)this.data).db.setProcValues(rowMeta, rowData, ((DBProcData)this.data).argnrs, ((DBProcMeta)this.meta).argumentDirections(), StringUtils.isNotEmpty((String)((DBProcMeta)this.meta).getResult().getName()));
        RowMetaAndData add = ((DBProcData)this.data).db.callProcedure(((DBProcMeta)this.meta).argumentNames(), ((DBProcMeta)this.meta).argumentDirections(), ((DBProcMeta)this.meta).argumentTypes(), ((DBProcMeta)this.meta).getResult().getName(), ((DBProcMeta)this.meta).getResult().getHopType());
        int addIndex = 0;
        if (StringUtils.isNotEmpty((String)((DBProcMeta)this.meta).getResult().getName())) {
            outputRowData[outputIndex++] = add.getData()[addIndex++];
        }
        for (int i = 0; i < ((DBProcData)this.data).argnrs.length; ++i) {
            DBProcMeta.ProcArgument argument = ((DBProcMeta)this.meta).getArguments().get(i);
            if ("OUT".equalsIgnoreCase(argument.getDirection())) {
                outputRowData[outputIndex++] = add.getData()[addIndex++];
                continue;
            }
            if (!"INOUT".equalsIgnoreCase(argument.getDirection())) continue;
            outputRowData[((DBProcData)this.data).argnrs[i]] = add.getData()[addIndex];
            ++addIndex;
        }
        return outputRowData;
    }

    public boolean processRow() throws HopException {
        block10: {
            Object[] r;
            boolean sendToErrorRow = false;
            Object errorMessage = null;
            if (((DBProcData)this.data).readsRows) {
                r = this.getRow();
                if (r == null) {
                    this.setOutputDone();
                    return false;
                }
                ((DBProcData)this.data).inputRowMeta = this.getInputRowMeta();
            } else {
                r = new Object[]{};
                this.incrementLinesRead();
                ((DBProcData)this.data).inputRowMeta = new RowMeta();
                ((DBProcData)this.data).readsRows = true;
            }
            try {
                Object[] outputRowData = this.runProc(((DBProcData)this.data).inputRowMeta, r);
                this.putRow(((DBProcData)this.data).outputMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DBProc.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (this.getTransformMeta().isDoingErrorHandling()) {
                    sendToErrorRow = true;
                    errorMessage = e.toString();
                    SQLException nextSqlExOnChain = null;
                    if (e.getCause() != null && e.getCause() instanceof SQLException) {
                        for (nextSqlExOnChain = ((SQLException)e.getCause()).getNextException(); nextSqlExOnChain != null; nextSqlExOnChain = nextSqlExOnChain.getNextException()) {
                            errorMessage = (String)errorMessage + nextSqlExOnChain.getMessage() + Const.CR;
                        }
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, (String)errorMessage, null, "DBP001");
            }
        }
        return true;
    }

    public boolean init() {
        block7: {
            if (super.init()) {
                List previous = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
                if (previous != null && !previous.isEmpty()) {
                    ((DBProcData)this.data).readsRows = true;
                }
                DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((DBProcMeta)this.meta).getConnection(), this.variables);
                ((DBProcData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
                try {
                    ((DBProcData)this.data).db.connect();
                    if (!((DBProcMeta)this.meta).isAutoCommit()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"DBProc.Log.AutoCommit", (String[])new String[0]));
                        }
                        ((DBProcData)this.data).db.setCommit(9999);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DBProc.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.DBException", (String[])new String[0]) + e.getMessage());
                    if (((DBProcData)this.data).db == null) break block7;
                    ((DBProcData)this.data).db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (((DBProcData)this.data).db != null) {
            try {
                ((DBProcData)this.data).db.closeProcedureStatement();
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.CloseProcedureError", (String[])new String[0]) + e.getMessage());
            }
            try {
                if (!((DBProcMeta)this.meta).isAutoCommit()) {
                    ((DBProcData)this.data).db.commit();
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.CommitError", (String[])new String[0]) + e.getMessage());
            }
            finally {
                ((DBProcData)this.data).db.disconnect();
            }
        }
        super.dispose();
    }
}

