/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.pubsub;

import org.apache.hop.beam.core.BeamDefaults;
import org.apache.hop.beam.transforms.pubsub.BeamPublish;
import org.apache.hop.beam.transforms.pubsub.BeamPublishMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BeamPublishDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BeamPublish.class;
    private final BeamPublishMeta input;
    int middle;
    int margin;
    private TextVar wTopic;
    private Combo wMessageType;
    private TextVar wMessageField;

    public BeamPublishDialog(Shell parent, IVariables variables, BeamPublishMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamPublishDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlTopic = new Label((Composite)this.shell, 131072);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"BeamPublishDialog.Topic", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTopic);
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)lastControl, this.margin);
        fdlTopic.right = new FormAttachment(this.middle, -this.margin);
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wTopic = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTopic);
        FormData fdTopic = new FormData();
        fdTopic.left = new FormAttachment(this.middle, 0);
        fdTopic.top = new FormAttachment((Control)wlTopic, 0, 0x1000000);
        fdTopic.right = new FormAttachment(100, 0);
        this.wTopic.setLayoutData((Object)fdTopic);
        lastControl = this.wTopic;
        Label wlMessageType = new Label((Composite)this.shell, 131072);
        wlMessageType.setText(BaseMessages.getString(PKG, (String)"BeamPublishDialog.MessageType", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMessageType);
        FormData fdlMessageType = new FormData();
        fdlMessageType.left = new FormAttachment(0, 0);
        fdlMessageType.top = new FormAttachment((Control)lastControl, this.margin);
        fdlMessageType.right = new FormAttachment(this.middle, -this.margin);
        wlMessageType.setLayoutData((Object)fdlMessageType);
        this.wMessageType = new Combo((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMessageType);
        this.wMessageType.setItems(BeamDefaults.PUBSUB_MESSAGE_TYPES);
        FormData fdMessageType = new FormData();
        fdMessageType.left = new FormAttachment(this.middle, 0);
        fdMessageType.top = new FormAttachment((Control)wlMessageType, 0, 0x1000000);
        fdMessageType.right = new FormAttachment(100, 0);
        this.wMessageType.setLayoutData((Object)fdMessageType);
        lastControl = this.wMessageType;
        Label wlMessageField = new Label((Composite)this.shell, 131072);
        wlMessageField.setText(BaseMessages.getString(PKG, (String)"BeamPublishDialog.MessageField", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMessageField);
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.top = new FormAttachment((Control)lastControl, this.margin);
        fdlMessageField.right = new FormAttachment(this.middle, -this.margin);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMessageField);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(this.middle, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, 0, 0x1000000);
        fdMessageField.right = new FormAttachment(100, 0);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        lastControl = this.wMessageField;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wTopic.setText(Const.NVL((String)this.input.getTopic(), (String)""));
        this.wMessageType.setText(Const.NVL((String)this.input.getMessageType(), (String)""));
        this.wMessageField.setText(Const.NVL((String)this.input.getMessageField(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamPublishMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setTopic(this.wTopic.getText());
        in.setMessageType(this.wMessageType.getText());
        in.setMessageField(this.wMessageField.getText());
        this.input.setChanged();
    }
}

