/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.vertica.bulkloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderField;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.VerticaBulkLoaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class VerticaBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = VerticaBulkLoaderMeta.class;
    public static final String CONST_SYSTEM_DIALOG_ERROR_TITLE = "System.Dialog.Error.Title";
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Button wTruncate;
    private Button wOnlyWhenHaveRows;
    private TextVar wSchema;
    private TextVar wTable;
    private TextVar wExceptionsLogFile;
    private TextVar wRejectedDataLogFile;
    private TextVar wStreamName;
    private Button wAbortOnError;
    private Button wDirect;
    private Button wSpecifyFields;
    private TableView wFields;
    private Button wGetFields;
    private Button wDoMapping;
    private VerticaBulkLoaderMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciFields;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public VerticaBulkLoaderDialog(Shell parent, IVariables variables, VerticaBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                VerticaBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DialogTitle", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString((String)"System.Label.TransformName"));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta dbm = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabaseMeta(), null);
        if (this.input.getDatabaseMeta() == null && this.pipelineMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addModifyListener(event -> this.setFlags());
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                VerticaBulkLoaderDialog.this.input.setChanged();
            }
        };
        Label wlTruncate = new Label((Composite)this.shell, 131072);
        wlTruncate.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.TruncateTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTruncate);
        FormData fdlTruncate = new FormData();
        fdlTruncate.left = new FormAttachment(0, 0);
        fdlTruncate.top = new FormAttachment((Control)this.wTable, margin);
        fdlTruncate.right = new FormAttachment(middle, -margin);
        wlTruncate.setLayoutData((Object)fdlTruncate);
        this.wTruncate = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wTruncate);
        FormData fdTruncate = new FormData();
        fdTruncate.left = new FormAttachment(middle, 0);
        fdTruncate.top = new FormAttachment((Control)wlTruncate, 0, 0x1000000);
        fdTruncate.right = new FormAttachment(100, 0);
        this.wTruncate.setLayoutData((Object)fdTruncate);
        SelectionAdapter lsTruncMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                VerticaBulkLoaderDialog.this.input.setChanged();
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsTruncMod);
        this.wTruncate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VerticaBulkLoaderDialog.this.setFlags();
            }
        });
        Label wlOnlyWhenHaveRows = new Label((Composite)this.shell, 131072);
        wlOnlyWhenHaveRows.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.OnlyWhenHaveRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOnlyWhenHaveRows);
        FormData fdlOnlyWhenHaveRows = new FormData();
        fdlOnlyWhenHaveRows.left = new FormAttachment(0, 0);
        fdlOnlyWhenHaveRows.top = new FormAttachment((Control)this.wTruncate, margin);
        fdlOnlyWhenHaveRows.right = new FormAttachment(middle, -margin);
        wlOnlyWhenHaveRows.setLayoutData((Object)fdlOnlyWhenHaveRows);
        this.wOnlyWhenHaveRows = new Button((Composite)this.shell, 32);
        this.wOnlyWhenHaveRows.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.OnlyWhenHaveRows.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wOnlyWhenHaveRows);
        FormData fdTruncateWhenHaveRows = new FormData();
        fdTruncateWhenHaveRows.left = new FormAttachment(middle, 0);
        fdTruncateWhenHaveRows.top = new FormAttachment((Control)wlOnlyWhenHaveRows, 0, 0x1000000);
        fdTruncateWhenHaveRows.right = new FormAttachment(100, 0);
        this.wOnlyWhenHaveRows.setLayoutData((Object)fdTruncateWhenHaveRows);
        this.wOnlyWhenHaveRows.addSelectionListener((SelectionListener)lsSelMod);
        Label wlSpecifyFields = new Label((Composite)this.shell, 131072);
        wlSpecifyFields.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.SpecifyFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpecifyFields);
        FormData fdlSpecifyFields = new FormData();
        fdlSpecifyFields.left = new FormAttachment(0, 0);
        fdlSpecifyFields.top = new FormAttachment((Control)this.wOnlyWhenHaveRows, margin);
        fdlSpecifyFields.right = new FormAttachment(middle, -margin);
        wlSpecifyFields.setLayoutData((Object)fdlSpecifyFields);
        this.wSpecifyFields = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSpecifyFields);
        FormData fdSpecifyFields = new FormData();
        fdSpecifyFields.left = new FormAttachment(middle, 0);
        fdSpecifyFields.top = new FormAttachment((Control)wlSpecifyFields, 0, 0x1000000);
        fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)lsSelMod);
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                VerticaBulkLoaderDialog.this.setFlags();
            }
        });
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wMainTab = new CTabItem(wTabFolder, 0);
        wMainTab.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.MainTab.CTabItem", (String[])new String[0]));
        FormLayout mainLayout = new FormLayout();
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        Composite wMainComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wMainComp);
        wMainComp.setLayout((Layout)mainLayout);
        FormData fdMainComp = new FormData();
        fdMainComp.left = new FormAttachment(0, 0);
        fdMainComp.top = new FormAttachment(0, 0);
        fdMainComp.right = new FormAttachment(100, 0);
        fdMainComp.bottom = new FormAttachment(100, 0);
        wMainComp.setLayoutData((Object)fdMainComp);
        Label wlDirect = new Label(wMainComp, 131072);
        wlDirect.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertDirect.Label", (String[])new String[0]));
        wlDirect.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertDirect.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDirect);
        FormData fdlDirect = new FormData();
        fdlDirect.left = new FormAttachment(0, 0);
        fdlDirect.top = new FormAttachment(0, margin);
        fdlDirect.right = new FormAttachment(middle, -margin);
        wlDirect.setLayoutData((Object)fdlDirect);
        this.wDirect = new Button(wMainComp, 32);
        this.wDirect.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertDirect.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDirect);
        FormData fdDirect = new FormData();
        fdDirect.left = new FormAttachment(middle, 0);
        fdDirect.top = new FormAttachment(0, margin);
        fdDirect.right = new FormAttachment(100, 0);
        this.wDirect.setLayoutData((Object)fdDirect);
        this.wDirect.addSelectionListener((SelectionListener)lsSelMod);
        this.wDirect.setSelection(true);
        Label wlAbortOnError = new Label(wMainComp, 131072);
        wlAbortOnError.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.AbortOnError.Label", (String[])new String[0]));
        wlAbortOnError.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.AbortOnError.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAbortOnError);
        FormData fdlAbortOnError = new FormData();
        fdlAbortOnError.left = new FormAttachment(0, 0);
        fdlAbortOnError.top = new FormAttachment((Control)wlDirect, margin);
        fdlAbortOnError.right = new FormAttachment(middle, -margin);
        wlAbortOnError.setLayoutData((Object)fdlAbortOnError);
        this.wAbortOnError = new Button(wMainComp, 32);
        this.wAbortOnError.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.AbortOnError.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAbortOnError);
        FormData fdAbortOnError = new FormData();
        fdAbortOnError.left = new FormAttachment(middle, 0);
        fdAbortOnError.top = new FormAttachment((Control)wlDirect, margin);
        fdAbortOnError.right = new FormAttachment(100, 0);
        this.wAbortOnError.setLayoutData((Object)fdAbortOnError);
        this.wAbortOnError.addSelectionListener((SelectionListener)lsSelMod);
        this.wAbortOnError.setSelection(true);
        Label wlExceptionsLogFile = new Label(wMainComp, 131072);
        wlExceptionsLogFile.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ExceptionsLogFile.Label", (String[])new String[0]));
        wlExceptionsLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ExceptionsLogFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExceptionsLogFile);
        FormData fdlExceptionsLogFile = new FormData();
        fdlExceptionsLogFile.left = new FormAttachment(0, 0);
        fdlExceptionsLogFile.right = new FormAttachment(middle, -margin);
        fdlExceptionsLogFile.top = new FormAttachment((Control)wlAbortOnError, margin * 2);
        wlExceptionsLogFile.setLayoutData((Object)fdlExceptionsLogFile);
        this.wExceptionsLogFile = new TextVar(this.variables, wMainComp, 18436);
        this.wExceptionsLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ExceptionsLogFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wExceptionsLogFile);
        this.wExceptionsLogFile.addModifyListener(lsMod);
        this.wExceptionsLogFile.addFocusListener((FocusListener)lsFocusLost);
        FormData fdExceptionsLogFile = new FormData();
        fdExceptionsLogFile.left = new FormAttachment(middle, 0);
        fdExceptionsLogFile.top = new FormAttachment((Control)wlAbortOnError, margin * 2);
        fdExceptionsLogFile.right = new FormAttachment(100, 0);
        this.wExceptionsLogFile.setLayoutData((Object)fdExceptionsLogFile);
        Label wlRejectedDataLogFile = new Label(wMainComp, 131072);
        wlRejectedDataLogFile.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.RejectedDataLogFile.Label", (String[])new String[0]));
        wlRejectedDataLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.RejectedDataLogFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRejectedDataLogFile);
        FormData fdlRejectedDataLogFile = new FormData();
        fdlRejectedDataLogFile.left = new FormAttachment(0, 0);
        fdlRejectedDataLogFile.right = new FormAttachment(middle, -margin);
        fdlRejectedDataLogFile.top = new FormAttachment((Control)wlExceptionsLogFile, margin * 2);
        wlRejectedDataLogFile.setLayoutData((Object)fdlRejectedDataLogFile);
        this.wRejectedDataLogFile = new TextVar(this.variables, wMainComp, 18436);
        this.wRejectedDataLogFile.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.RejectedDataLogFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wRejectedDataLogFile);
        this.wRejectedDataLogFile.addModifyListener(lsMod);
        this.wRejectedDataLogFile.addFocusListener((FocusListener)lsFocusLost);
        FormData fdRejectedDataLogFile = new FormData();
        fdRejectedDataLogFile.left = new FormAttachment(middle, 0);
        fdRejectedDataLogFile.top = new FormAttachment((Control)wlExceptionsLogFile, margin * 2);
        fdRejectedDataLogFile.right = new FormAttachment(100, 0);
        this.wRejectedDataLogFile.setLayoutData((Object)fdRejectedDataLogFile);
        Label wlStreamName = new Label(wMainComp, 131072);
        wlStreamName.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.StreamName.Label", (String[])new String[0]));
        wlStreamName.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.StreamName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStreamName);
        FormData fdlStreamName = new FormData();
        fdlStreamName.left = new FormAttachment(0, 0);
        fdlStreamName.right = new FormAttachment(middle, -margin);
        fdlStreamName.top = new FormAttachment((Control)wlRejectedDataLogFile, margin * 2);
        wlStreamName.setLayoutData((Object)fdlStreamName);
        this.wStreamName = new TextVar(this.variables, wMainComp, 18436);
        this.wStreamName.setToolTipText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.StreamName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wStreamName);
        this.wStreamName.addModifyListener(lsMod);
        this.wStreamName.addFocusListener((FocusListener)lsFocusLost);
        FormData fdStreamName = new FormData();
        fdStreamName.left = new FormAttachment(middle, 0);
        fdStreamName.top = new FormAttachment((Control)wlRejectedDataLogFile, margin * 2);
        fdStreamName.right = new FormAttachment(100, 0);
        this.wStreamName.setLayoutData((Object)fdStreamName);
        wMainComp.layout();
        wMainTab.setControl((Control)wMainComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FieldsTab.CTabItem.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = 5;
        fieldsCompLayout.marginHeight = 5;
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        Label wlFields = new Label(wFieldsComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.InsertFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int upInsRows = this.input.getFields() != null && !this.input.getFields().equals(Collections.emptyList()) ? this.input.getFields().size() : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciFields[0]);
        this.wFields = new TableView(this.variables, wFieldsComp, 68354, this.ciFields, upInsRows, lsMod, this.props);
        this.wGetFields = new Button(wFieldsComp, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.top = new FormAttachment((Control)wlFields, margin);
        fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)fdGetFields);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.Button", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                VerticaBulkLoaderDialog.this.generateMappings();
            }
        });
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment(100, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = VerticaBulkLoaderDialog.this.pipelineMeta.findTransform(VerticaBulkLoaderDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta row = VerticaBulkLoaderDialog.this.pipelineMeta.getPrevTransformFields(VerticaBulkLoaderDialog.this.variables, transformMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            VerticaBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        VerticaBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (HopException e) {
                        VerticaBulkLoaderDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message")});
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString((String)"System.Button.SQL"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wCreate}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)wlSpecifyFields, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        this.wCreate.addListener(13, c -> this.sql());
        this.wGetFields.addListener(13, c -> this.get());
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setTablename(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMetaInterface = this.transformMeta.getTransform();
        try {
            targetFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            block11: {
                DatabaseMeta databaseMeta;
                for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                    ColumnInfo colInfo = this.tableFieldColumns.get(i);
                    colInfo.setComboValues(new String[0]);
                }
                if (!StringUtil.isEmpty((String)this.wTable.getText()) && (databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables)) != null) {
                    try (Database db = new Database(loggingObject, this.variables, databaseMeta);){
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.variables.resolve(this.wSchema.getText()), this.variables.resolve(this.wTable.getText()));
                        IRowMeta r = db.getTableFields(schemaTable);
                        if (null == r || null == (fieldNames = r.getFieldNames())) break block11;
                        for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                            ColumnInfo colInfo = this.tableFieldColumns.get(i);
                            colInfo.setComboValues(fieldNames);
                        }
                    }
                    catch (Exception e) {
                        for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                            ColumnInfo colInfo = this.tableFieldColumns.get(i);
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        if (PropsUi.getInstance().isSortFieldByName()) {
            Const.sortStrings((String[])fieldNames);
        }
        this.ciFields[1].setComboValues(fieldNames);
    }

    public void setFlags() {
        boolean specifyFields = this.wSpecifyFields.getSelection();
        this.wFields.setEnabled(specifyFields);
        this.wGetFields.setEnabled(specifyFields);
        this.wDoMapping.setEnabled(specifyFields);
    }

    public void getData() {
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (this.input.getExceptionsFileName() != null) {
            this.wExceptionsLogFile.setText(this.input.getExceptionsFileName());
        }
        if (this.input.getRejectedDataFileName() != null) {
            this.wRejectedDataLogFile.setText(this.input.getRejectedDataFileName());
        }
        if (this.input.getStreamName() != null) {
            this.wStreamName.setText(this.input.getStreamName());
        }
        this.wTruncate.setSelection(this.input.isTruncateTable());
        this.wOnlyWhenHaveRows.setSelection(this.input.isOnlyWhenHaveRows());
        this.wDirect.setSelection(this.input.isDirect());
        this.wAbortOnError.setSelection(this.input.isAbortOnError());
        this.wSpecifyFields.setSelection(this.input.specifyFields());
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            VerticaBulkLoaderField vbf = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            if (vbf.getFieldDatabase() != null) {
                item.setText(1, vbf.getFieldDatabase());
            }
            if (vbf.getFieldStream() == null) continue;
            item.setText(2, vbf.getFieldStream());
        }
        this.setFlags();
        this.wTransformName.selectAll();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(VerticaBulkLoaderMeta info) {
        info.setSchemaName(this.wSchema.getText());
        info.setTablename(this.wTable.getText());
        info.setConnection(this.wConnection.getText());
        info.setTruncateTable(this.wTruncate.getSelection());
        info.setOnlyWhenHaveRows(this.wOnlyWhenHaveRows.getSelection());
        info.setExceptionsFileName(this.wExceptionsLogFile.getText());
        info.setRejectedDataFileName(this.wRejectedDataLogFile.getText());
        info.setStreamName(this.wStreamName.getText());
        info.setDirect(this.wDirect.getSelection());
        info.setAbortOnError(this.wAbortOnError.getSelection());
        info.setSpecifyFields(this.wSpecifyFields.getSelection());
        int nrRows = this.wFields.nrNonEmpty();
        info.getFields().clear();
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            VerticaBulkLoaderField vbf = new VerticaBulkLoaderField(Const.NVL((String)item.getText(1), (String)""), Const.NVL((String)item.getText(2), (String)""));
            info.getFields().add(vbf);
        }
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        if (Utils.isEmpty((CharSequence)this.input.getConnection())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)CONST_SYSTEM_DIALOG_ERROR_TITLE));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtil.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[]{databaseMeta.toString()})});
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)CONST_SYSTEM_DIALOG_ERROR_TITLE));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void sql() {
        try {
            SqlStatement sql;
            VerticaBulkLoaderMeta info = new VerticaBulkLoaderMeta();
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            this.getInfo(info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (info.specifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getFields().size(); ++i) {
                    VerticaBulkLoaderField vbf = info.getFields().get(i);
                    IValueMeta insValue = prev.searchValueMeta(vbf.getFieldStream());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.FailedToFindField.Message", (String[])new String[]{vbf.getFieldStream()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(vbf.getFieldDatabase());
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            if (!(sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider)).hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString((String)CONST_SYSTEM_DIALOG_ERROR_TITLE));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"VerticaBulkLoaderDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

