/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefiles;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="DELETE_FILES", name="i18n::ActionDeleteFiles.Name", description="i18n::ActionDeleteFiles.Description", image="DeleteFiles.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDeleteFiles.keyword"}, documentationUrl="/workflow/actions/deletefiles.html")
public class ActionDeleteFiles
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionDeleteFiles.class;
    private boolean argFromPrevious = false;
    private boolean includeSubfolders = false;
    private String[] arguments = null;
    private String[] filemasks;

    public ActionDeleteFiles(String workflowName) {
        super(workflowName, "");
    }

    public ActionDeleteFiles() {
        this("");
    }

    public void allocate(int numberOfFields) {
        this.arguments = new String[numberOfFields];
        this.filemasks = new String[numberOfFields];
    }

    public Object clone() {
        ActionDeleteFiles action = (ActionDeleteFiles)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            action.allocate(nrFields);
            System.arraycopy(this.arguments, 0, action.arguments, 0, nrFields);
            System.arraycopy(this.filemasks, 0, action.filemasks, 0, nrFields);
        }
        return action;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int numberOfFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(numberOfFields);
            for (int i = 0; i < numberOfFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XmlHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    public Result execute(Result result, int nr) throws HopException {
        List resultRows = result.getRows();
        int numberOfErrFiles = 0;
        result.setResult(false);
        result.setNrErrors(1L);
        if (this.argFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.FoundPreviousRows", (String[])new String[]{String.valueOf(resultRows != null ? resultRows.size() : 0)}));
        }
        Multimap<String, String> pathToMaskMap = this.populateDataForJobExecution(resultRows);
        for (Map.Entry pathToMask : pathToMaskMap.entries()) {
            String filePath = this.resolve((String)pathToMask.getKey());
            if (filePath.trim().isEmpty()) {
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.NoPathProvided", (String[])new String[0]));
                continue;
            }
            String fileMask = this.resolve((String)pathToMask.getValue());
            if (this.parentWorkflow.isStopped()) break;
            if (this.processFile(filePath, fileMask, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow)) continue;
            ++numberOfErrFiles;
        }
        if (numberOfErrFiles == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)numberOfErrFiles);
            result.setResult(false);
        }
        return result;
    }

    private Multimap<String, String> populateDataForJobExecution(List<RowMetaAndData> rowsFromPreviousMeta) throws HopValueException {
        ArrayListMultimap pathToMaskMap;
        block6: {
            block5: {
                pathToMaskMap = ArrayListMultimap.create();
                if (!this.argFromPrevious || rowsFromPreviousMeta == null) break block5;
                for (RowMetaAndData resultRow : rowsFromPreviousMeta) {
                    if (resultRow.size() < 2) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Error.InvalidNumberOfRowsFromPrevMeta", (Object[])new Object[]{resultRow.size()}));
                        return pathToMaskMap;
                    }
                    String pathToFile = resultRow.getString(0, null);
                    String fileMask = resultRow.getString(1, null);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingRow", (String[])new String[]{pathToFile, fileMask}));
                    }
                    pathToMaskMap.put((Object)pathToFile, (Object)fileMask);
                }
                break block6;
            }
            if (this.arguments == null) break block6;
            for (int i = 0; i < this.arguments.length; ++i) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                }
                pathToMaskMap.put((Object)this.arguments[i], (Object)this.filemasks[i]);
            }
        }
        return pathToMaskMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processFile(String path, String wildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        boolean isDeleted = false;
        FileObject fileFolder = null;
        try {
            fileFolder = HopVfs.getFileObject((String)path, (IVariables)this.getVariables());
            if (fileFolder.exists()) {
                if (fileFolder.getType() == FileType.FOLDER) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingFolder", (String[])new String[]{path}));
                    }
                    int totalDeleted = fileFolder.delete((FileSelector)new TextFileSelector(fileFolder.toString(), wildcard, parentWorkflow));
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.TotalDeleted", (String[])new String[]{String.valueOf(totalDeleted)}));
                    }
                    isDeleted = true;
                } else {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingFile", (String[])new String[]{path}));
                    }
                    if (!(isDeleted = fileFolder.delete())) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.CouldNotDeleteFile", (String[])new String[]{path}));
                    } else if (this.log.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.FileDeleted", (String[])new String[]{path}));
                    }
                }
            } else {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.FileAlreadyDeleted", (String[])new String[]{path}));
                }
                isDeleted = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.CouldNotProcess", (String[])new String[]{path, e.getMessage()}), e);
        }
        finally {
            if (fileFolder != null) {
                try {
                    fileFolder.close();
                }
                catch (IOException iOException) {}
            }
        }
        return isDeleted;
    }

    private boolean getFileWildcard(String selectedfile, String wildcard) {
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard)) {
            Pattern pattern = Pattern.compile(wildcard);
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean isValid = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!isValid) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.arguments.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = this.resolve(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference((IResourceHolder)this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setFilemasks(String[] filemasks) {
        this.filemasks = filemasks;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;
        IWorkflowEngine<WorkflowMeta> parentjob;

        public TextFileSelector(String sourcefolderin, String filewildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
            this.parentjob = parentWorkflow;
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean doReturnCode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder) && !this.parentjob.isStopped()) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (ActionDeleteFiles.this.includeSubfolders && info.getFile().getType() == FileType.FILE && ActionDeleteFiles.this.getFileWildcard(shortFilename, this.fileWildcard)) {
                            if (ActionDeleteFiles.this.log.isDetailed()) {
                                ActionDeleteFiles.this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                            }
                            doReturnCode = true;
                        }
                    } else if (info.getFile().getType() == FileType.FILE && ActionDeleteFiles.this.getFileWildcard(shortFilename, this.fileWildcard)) {
                        if (ActionDeleteFiles.this.log.isDetailed()) {
                            ActionDeleteFiles.this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                        }
                        doReturnCode = true;
                    }
                }
            }
            catch (Exception e) {
                ActionDeleteFiles.this.log.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Error.Exception.DeleteProcessError", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobDeleteFiles.Error.Exception.DeleteProcess", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
                doReturnCode = false;
            }
            return doReturnCode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

