/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.staticschema.metadata;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.metadata.SchemaFieldDefinition;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SchemaDefinitionEditor
extends MetadataEditor<SchemaDefinition> {
    private static final Class<?> PKG = SchemaDefinitionEditor.class;
    private Text wName;
    private Text wDescription;
    private Text wSeparator;
    private Text wEnclosure;
    private TableView wFields;

    public SchemaDefinitionEditor(HopGui hopGui, MetadataManager<SchemaDefinition> manager, SchemaDefinition metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin() + 2;
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlDescription = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Description.Label", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, margin);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, -margin);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        fdDescription.left = new FormAttachment(middle, 0);
        fdDescription.right = new FormAttachment(95, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        Label wlSeparator = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlSeparator);
        wlSeparator.setText(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Separator.Label", (String[])new String[0]));
        FormData fdlSeparator = new FormData();
        fdlSeparator.top = new FormAttachment((Control)lastControl, margin);
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.right = new FormAttachment(middle, -margin);
        wlSeparator.setLayoutData((Object)fdlSeparator);
        this.wSeparator = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wSeparator);
        FormData fdSeparator = new FormData();
        fdSeparator.top = new FormAttachment((Control)wlSeparator, 0, 0x1000000);
        fdSeparator.left = new FormAttachment(middle, 0);
        fdSeparator.right = new FormAttachment(95, 0);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        lastControl = this.wSeparator;
        Label wlEnclosure = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlEnclosure);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Enclosure.Label", (String[])new String[0]));
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wEnclosure);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)wlEnclosure, 0, 0x1000000);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(95, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        lastControl = this.wEnclosure;
        Label wlFields = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlFields);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Label", (String[])new String[0]));
        FormData fdlFields = new FormData();
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(100, 0);
        wlFields.setLayoutData((Object)fdlFields);
        ColumnInfo[] columnInfos = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldName", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldFormat", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldLength", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldPrecision", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldCurrency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldDecimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldGroup", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldIfNull", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldTrimType", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SchemaDefinitionDialog.Fields.Column.FieldComment", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((IVariables)new Variables(), parent, 2048, columnInfos, ((SchemaDefinition)this.getMetadata()).getFieldDefinitions().size(), null, props);
        PropsUi.setLook((Widget)this.wFields);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, -margin * 2);
        this.wFields.setLayoutData((Object)fdFields);
        this.setWidgetsContent();
        this.wName.addModifyListener(e -> this.setChanged());
        this.wDescription.addModifyListener(e -> this.setChanged());
        this.wSeparator.addModifyListener(e -> this.setChanged());
        this.wEnclosure.addModifyListener(e -> this.setChanged());
        this.wFields.addModifyListener(e -> this.setChanged());
    }

    public void setWidgetsContent() {
        SchemaDefinition SchemaDefinition2 = (SchemaDefinition)this.getMetadata();
        this.wName.setText(Const.NVL((String)SchemaDefinition2.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)SchemaDefinition2.getDescription(), (String)""));
        this.wSeparator.setText(Const.NVL((String)SchemaDefinition2.getSeparator(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)SchemaDefinition2.getEnclosure(), (String)""));
        List<SchemaFieldDefinition> fields = SchemaDefinition2.getFieldDefinitions();
        for (int i = 0; i < fields.size(); ++i) {
            SchemaFieldDefinition field = fields.get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            item.setText(2, Const.NVL((String)field.getHopType(), (String)""));
            item.setText(3, Const.NVL((String)field.getFormatMask(), (String)""));
            item.setText(4, field.getLength() < 0 ? "" : Integer.toString(field.getLength()));
            item.setText(5, field.getPrecision() < 0 ? "" : Integer.toString(field.getPrecision()));
            item.setText(6, Const.NVL((String)field.getCurrencySymbol(), (String)""));
            item.setText(7, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(8, Const.NVL((String)field.getGroupingSymbol(), (String)""));
            item.setText(9, Const.NVL((String)field.getIfNullValue(), (String)""));
            String trimType = Const.NVL((String)ValueMetaBase.getTrimTypeDesc((int)field.getTrimType()), (String)"");
            item.setText(10, trimType);
            item.setText(11, Const.NVL((String)field.getComment(), (String)""));
        }
    }

    public void getWidgetsContent(SchemaDefinition SchemaDefinition2) {
        SchemaDefinition2.setName(this.wName.getText());
        SchemaDefinition2.setDescription(this.wDescription.getText());
        SchemaDefinition2.setSeparator(this.wSeparator.getText());
        SchemaDefinition2.setEnclosure(this.wEnclosure.getText());
        SchemaDefinition2.getFieldDefinitions().clear();
        for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String name = item.getText(1);
            String hopType = item.getText(2);
            SchemaFieldDefinition sfd = new SchemaFieldDefinition(name, hopType);
            sfd.setFormatMask(item.getText(3));
            sfd.setLength(Const.toInt((String)item.getText(4), (int)-1));
            sfd.setPrecision(Const.toInt((String)item.getText(5), (int)-1));
            sfd.setCurrencySymbol(item.getText(6));
            sfd.setDecimalSymbol(item.getText(7));
            sfd.setGroupingSymbol(item.getText(8));
            sfd.setIfNullValue(item.getText(9));
            sfd.setTrimType(ValueMetaString.getTrimTypeByDesc((String)item.getText(10)));
            sfd.setComment(item.getText(11));
            SchemaDefinition2.getFieldDefinitions().add(sfd);
        }
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

