/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.tab.GuiTabItem;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateComponentMetrics;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainter;
import org.apache.hop.pipeline.engine.IEngineMetric;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.SelectRowDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.CanvasFacade;
import org.apache.hop.ui.hopgui.CanvasListener;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.apache.hop.ui.hopgui.perspective.execution.IExecutionViewer;
import org.apache.hop.ui.hopgui.shared.BaseExecutionViewer;
import org.apache.hop.ui.hopgui.shared.SwtGc;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Node;

@GuiPlugin
public class PipelineExecutionViewer
extends BaseExecutionViewer
implements IExecutionViewer,
PaintListener,
MouseListener {
    private static final Class<?> PKG = PipelineExecutionViewer.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "PipelineExecutionViewer-Toolbar";
    public static final String TOOLBAR_ITEM_REFRESH = "PipelineExecutionViewer-Toolbar-10100-Refresh";
    public static final String TOOLBAR_ITEM_ZOOM_LEVEL = "PipelineExecutionViewer-ToolBar-10500-Zoom-Level";
    public static final String TOOLBAR_ITEM_ZOOM_FIT_TO_SCREEN = "PipelineExecutionViewer-ToolBar-10600-Zoom-Fit-To-Screen";
    public static final String TOOLBAR_ITEM_TO_EDITOR = "PipelineExecutionViewer-Toolbar-11100-GoToEditor";
    public static final String TOOLBAR_ITEM_DRILL_DOWN = "PipelineExecutionViewer-Toolbar-11200-DrillDown";
    public static final String TOOLBAR_ITEM_GO_UP = "PipelineExecutionViewer-Toolbar-11300-GoUp";
    public static final String TOOLBAR_ITEM_VIEW_EXECUTOR = "PipelineExecutionViewer-Toolbar-12000-ViewExecutor";
    public static final String TOOLBAR_ITEM_VIEW_METADATA = "PipelineExecutionViewer-Toolbar-12100-ViewMetadata";
    public static final String PIPELINE_EXECUTION_VIEWER_TABS = "PipelineExecutionViewer.Tabs.ID";
    public static final String CONST_ERROR = "Error";
    protected final PipelineMeta pipelineMeta;
    protected TransformMeta selectedTransform;
    private ExecutionData selectedTransformData;
    private CTabItem infoTab;
    private TableView infoView;
    private CTabItem logTab;
    private CTabItem dataTab;
    private SashForm dataSash;
    private org.eclipse.swt.widgets.List dataList;
    private TableView dataView;
    private CTabItem metricsTab;
    private TableView metricsView;

    public PipelineExecutionViewer(Composite parent, HopGui hopGui, PipelineMeta pipelineMeta, String locationName, ExecutionPerspective perspective, Execution execution, ExecutionState executionState) {
        super(parent, hopGui, perspective, locationName, execution, executionState);
        this.pipelineMeta = pipelineMeta;
        this.maximum = pipelineMeta.getMaximum();
        this.addWidgets();
    }

    public void addWidgets() {
        this.setLayout((Layout)new FormLayout());
        this.toolBar = new ToolBar((Composite)this, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)layoutData);
        this.toolBar.pack();
        PropsUi.setLook((Widget)this.toolBar, 5);
        this.sash = new SashForm((Composite)this, 512);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment((Control)this.toolBar, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fdSash);
        this.canvas = new Canvas((Composite)this.sash, 264192);
        Listener listener = CanvasListener.getInstance();
        this.canvas.addListener(3, listener);
        this.canvas.addListener(5, listener);
        this.canvas.addListener(4, listener);
        this.canvas.addListener(9, listener);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.canvas.addMouseMoveListener((MouseMoveListener)this);
            this.canvas.addMouseWheelListener(this::mouseScrolled);
        }
        this.tabFolder = new CTabFolder((Composite)this.sash, 2);
        PropsUi.setLook((Widget)this.tabFolder, 4);
        this.addInfoTab();
        this.addLogTab();
        this.addMetricsTab();
        this.addDataTab();
        this.addPluginTabs();
        this.layout();
        this.refresh();
        this.hopGui.replaceKeyboardShortcutListeners(this);
        this.tabFolder.setSelection(0);
        this.sash.setWeights(new int[]{60, 40});
    }

    private void addInfoTab() {
        this.infoTab = new CTabItem(this.tabFolder, 0);
        this.infoTab.setFont(GuiResource.getInstance().getFontDefault());
        this.infoTab.setImage(GuiResource.getInstance().getImageInfo());
        this.infoTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionViewer.InfoTab.Title", (String[])new String[0]));
        ColumnInfo[] infoCols = new ColumnInfo[]{new ColumnInfo("Item", 1, false, true), new ColumnInfo("Value", 1, false, true)};
        this.infoView = new TableView(this.hopGui.getVariables(), (Composite)this.tabFolder, 768, infoCols, 1, true, null, this.props);
        PropsUi.setLook((Widget)this.infoView);
        this.infoTab.setControl((Control)this.infoView);
    }

    private void refreshStatus() {
        try {
            this.infoView.clearAll();
            ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
            if (location == null) {
                return;
            }
            IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
            this.executionState = iLocation.getExecutionState(this.execution.getId(), false);
            if (this.executionState == null) {
                return;
            }
            String statusDescription = this.executionState.getStatusDescription();
            if ("Running".equalsIgnoreCase(statusDescription) || "Initializing".equalsIgnoreCase(statusDescription)) {
                long loggingInterval = Const.toLong((String)location.getDataLoggingInterval(), (long)20000L);
                if (System.currentTimeMillis() - this.executionState.getUpdateTime().getTime() > loggingInterval) {
                    TableItem item = this.infoView.add("Update state", "Stale");
                    item.setBackground(GuiResource.getInstance().getColorLightBlue());
                    item.setForeground(GuiResource.getInstance().getColorWhite());
                }
            }
            this.infoView.add("Name", this.execution.getName());
            this.infoView.add("Type", this.execution.getExecutionType().name());
            this.infoView.add("Filename", this.execution.getFilename());
            this.infoView.add("ID", this.execution.getId());
            this.infoView.add("Parent ID", this.execution.getParentId());
            this.infoView.add("Registration", this.formatDate(this.execution.getRegistrationDate()));
            this.infoView.add("Start", this.formatDate(this.execution.getExecutionStartDate()));
            this.infoView.add("Type", this.executionState.getExecutionType().name());
            this.infoView.add("Status", statusDescription);
            this.infoView.add("Status Last updated", this.formatDate(this.executionState.getUpdateTime()));
            this.infoView.add("Container ID", this.executionState.getContainerId());
            this.infoView.optimizeTableView();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.hopGui.getVariables(), (String)HopGuiExtensionPoint.PipelineExecutionViewerUpdate.id, (Object)this);
            }
            catch (Exception xe) {
                LogChannel.UI.logError("Error handling extension point 'PipelineExecutionViewerUpdate'", (Throwable)xe);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error refreshing pipeline status", e);
        }
    }

    private void addPluginTabs() {
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        List tabsList = (List)guiRegistry.getGuiTabsMap().get(PIPELINE_EXECUTION_VIEWER_TABS);
        if (tabsList != null) {
            tabsList.sort(Comparator.comparing(GuiTabItem::getId));
            for (GuiTabItem tabItem : tabsList) {
                try {
                    Class<?> pluginTabClass = tabItem.getMethod().getDeclaringClass();
                    boolean showTab = true;
                    try {
                        Method showTabMethod = pluginTabClass.getMethod("showTab", PipelineExecutionViewer.class);
                        showTab = (Boolean)showTabMethod.invoke(null, this);
                    }
                    catch (NoSuchMethodException showTabMethod) {
                        // empty catch block
                    }
                    if (!showTab) continue;
                    Constructor<?> constructor = pluginTabClass.getConstructor(PipelineExecutionViewer.class);
                    Object object = constructor.newInstance(this);
                    tabItem.getMethod().invoke(object, this.tabFolder);
                }
                catch (Exception e) {
                    new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Hop was unable to invoke @GuiTab method " + tabItem.getMethod().getName() + " with the parent composite as argument", e);
                }
            }
            this.tabFolder.layout();
        }
    }

    private void addDataTab() {
        this.dataTab = new CTabItem(this.tabFolder, 0);
        this.dataTab.setFont(GuiResource.getInstance().getFontDefault());
        this.dataTab.setImage(GuiResource.getInstance().getImageData());
        this.dataTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionViewer.DataTab.Title", (String[])new String[0]));
        this.dataSash = new SashForm((Composite)this.tabFolder, 256);
        this.dataList = new org.eclipse.swt.widgets.List((Composite)this.dataSash, 17156);
        PropsUi.setLook((Widget)this.dataList);
        this.dataList.addListener(13, e -> this.showDataRows());
        ColumnInfo[] dataColumns = new ColumnInfo[]{};
        this.dataView = new TableView(this.hopGui.getVariables(), (Composite)this.dataSash, 768, dataColumns, 0, true, null, this.props);
        PropsUi.setLook((Widget)this.dataView);
        this.dataView.optimizeTableView();
        this.dataSash.setWeights(new int[]{30, 70});
        this.dataTab.setControl((Control)this.dataSash);
    }

    private void addMetricsTab() {
        this.metricsTab = new CTabItem(this.tabFolder, 0);
        this.metricsTab.setFont(GuiResource.getInstance().getFontDefault());
        this.metricsTab.setImage(GuiResource.getInstance().getImageData());
        this.metricsTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionViewer.MetricsTab.Title", (String[])new String[0]));
        ColumnInfo[] dataColumns = new ColumnInfo[]{};
        this.metricsView = new TableView(this.hopGui.getVariables(), (Composite)this.tabFolder, 768, dataColumns, 0, true, null, this.props);
        PropsUi.setLook((Widget)this.metricsView);
        this.metricsView.optimizeTableView();
        this.metricsTab.setControl((Control)this.metricsView);
    }

    private void refreshMetrics() {
        this.metricsView.clearAll();
        if (this.executionState != null) {
            HashSet<String> metricNames = new HashSet<String>();
            this.executionState.getMetrics().forEach(m -> metricNames.addAll(m.getMetrics().keySet()));
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
            columns.add(new ColumnInfo("Name", 1, false, true));
            columns.add(new ColumnInfo("Copy", 1, false, true));
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_INIT);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_INPUT);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_READ);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_WRITTEN);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_OUTPUT);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_UPDATED);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_REJECTED);
            this.addColumn(columns, indexMap, metricNames, Pipeline.METRIC_ERROR);
            this.metricsView = new TableView(this.hopGui.getVariables(), (Composite)this.tabFolder, 768, columns.toArray(new ColumnInfo[0]), this.executionState.getMetrics().size(), true, null, this.props);
            for (int i = 0; i < this.executionState.getMetrics().size(); ++i) {
                ExecutionStateComponentMetrics metrics = (ExecutionStateComponentMetrics)this.executionState.getMetrics().get(i);
                TableItem item = this.metricsView.table.getItem(i);
                item.setText(1, Const.NVL((String)metrics.getComponentName(), (String)""));
                item.setText(2, Const.NVL((String)metrics.getComponentCopy(), (String)""));
                for (String metricHeader : metrics.getMetrics().keySet()) {
                    Integer index = (Integer)indexMap.get(metricHeader);
                    Long value = (Long)metrics.getMetrics().get(metricHeader);
                    if (value == null || index == null || index <= 1 || index > columns.size()) continue;
                    item.setText(index.intValue(), value.toString());
                }
            }
            this.metricsTab.setControl((Control)this.metricsView);
            this.metricsView.layout(true, true);
            this.metricsView.optimizeTableView();
        }
    }

    private void addColumn(List<ColumnInfo> columns, Map<String, Integer> indexMap, Set<String> metricNames, IEngineMetric metric) {
        if (metricNames.contains(metric.getHeader())) {
            columns.add(new ColumnInfo(metric.getHeader(), 1, true, true));
            indexMap.put(metric.getHeader(), columns.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDataRows() {
        int[] weights = this.dataSash.getWeights();
        Cursor busyCursor = new Cursor((Device)this.getShell().getDisplay(), 1);
        try {
            this.getShell().setCursor(busyCursor);
            String[] selection = this.dataList.getSelection();
            if (selection.length != 1) {
                return;
            }
            String setDescription = selection[0];
            this.dataView.clearAll(false);
            ExecutionData data = this.loadSelectedTransformData();
            for (ExecutionDataSetMeta setMeta : data.getSetMetaData().values()) {
                RowBuffer rowBuffer;
                if (!setDescription.equals(setMeta.getDescription()) || (rowBuffer = (RowBuffer)data.getDataSets().get(setMeta.getSetKey())) == null) continue;
                ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
                IRowMeta rowMeta = rowBuffer.getRowMeta();
                for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
                    ColumnInfo columnInfo = new ColumnInfo(valueMeta.getName(), 1, valueMeta.isNumeric());
                    columnInfo.setValueMeta(valueMeta);
                    columnInfo.setToolTip(valueMeta.toStringMeta());
                    columns.add(columnInfo);
                }
                this.dataView.dispose();
                this.dataView = new TableView(this.hopGui.getVariables(), (Composite)this.dataSash, 768, columns.toArray(new ColumnInfo[0]), rowBuffer.size(), true, null, this.props);
                for (int r = 0; r < rowBuffer.size(); ++r) {
                    Object[] row = (Object[])rowBuffer.getBuffer().get(r);
                    TableItem item = this.dataView.table.getItem(r);
                    item.setText(0, Integer.toString(r + 1));
                    for (int c = 0; c < rowMeta.size(); ++c) {
                        String value = rowMeta.getString(row, c);
                        if (value == null) {
                            value = "";
                        }
                        item.setText(c + 1, value);
                    }
                }
                this.dataView.optWidth(true);
                break;
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error showing transform data rows", e);
        }
        finally {
            this.layout(true, true);
            this.dataSash.setWeights(weights);
            this.getShell().setCursor(null);
        }
    }

    private void addLogTab() {
        this.logTab = new CTabItem(this.tabFolder, 0);
        this.logTab.setFont(GuiResource.getInstance().getFontDefault());
        this.logTab.setImage(GuiResource.getInstance().getImageShowLog());
        this.logTab.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionViewer.LogTab.Title", (String[])new String[0]));
        this.loggingText = new Text((Composite)this.tabFolder, 778);
        PropsUi.setLook((Widget)this.loggingText);
        this.logTab.setControl((Control)this.loggingText);
        this.tabFolder.addListener(13, e -> {
            if (this.tabFolder.getSelection() == this.logTab) {
                this.refreshLoggingText();
            }
        });
    }

    @Override
    public Image getTitleImage() {
        return GuiResource.getInstance().getImagePipeline();
    }

    @Override
    public String getTitleToolTip() {
        return this.pipelineMeta.getDescription();
    }

    public void paintControl(PaintEvent e) {
        Point area = this.getArea();
        if (area.x == 0 || area.y == 0) {
            return;
        }
        boolean needsDoubleBuffering = Const.isWindows() && "GUI".equalsIgnoreCase(Const.getHopPlatformRuntime());
        Image image = null;
        GC swtGc = e.gc;
        if (needsDoubleBuffering) {
            image = new Image((Device)this.hopDisplay(), area.x, area.y);
            swtGc = new GC((Drawable)image);
        }
        this.drawPipelineImage(swtGc, area.x, area.y, this.magnification);
        if (needsDoubleBuffering) {
            e.gc.drawImage(image, 0, 0);
            swtGc.dispose();
            image.dispose();
        }
        this.setZoomLabel();
    }

    @Override
    public void setZoomLabel() {
        String oldString;
        Combo combo = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (combo == null || combo.isDisposed()) {
            return;
        }
        String newString = Math.round(this.magnification * 100.0f) + "%";
        if (!newString.equals(oldString = combo.getText())) {
            combo.setText(Math.round(this.magnification * 100.0f) + "%");
        }
    }

    @Override
    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-ToolBar-10600-Zoom-Fit-To-Screen", toolTip="i18n::ExecutionViewer.GuiAction.ZoomFitToScreen.Tooltip", type=GuiToolbarElementType.BUTTON, image="ui/images/zoom-fit.svg")
    public void zoomFitToScreen() {
        super.zoomFitToScreen();
    }

    @Override
    protected Point getArea() {
        Rectangle rect = this.canvas.getClientArea();
        return new Point(rect.width, rect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawPipelineImage(GC swtGc, int width, int height, float magnificationFactor) {
        SwtGc gc = new SwtGc(swtGc, width, height, this.iconSize);
        try {
            PropsUi propsUi = PropsUi.getInstance();
            int gridSize = propsUi.isShowCanvasGridEnabled() ? propsUi.getCanvasGridSize() : 1;
            PipelinePainter pipelinePainter = new PipelinePainter((IGc)gc, this.hopGui.getVariables(), this.pipelineMeta, new Point(width, height), new DPoint(0.0, 0.0), null, null, this.areaOwners, propsUi.getIconSize(), propsUi.getLineWidth(), gridSize, propsUi.getNoteFont().getName(), propsUi.getNoteFont().getHeight(), null, propsUi.isIndicateSlowPipelineTransformsEnabled(), propsUi.getZoomFactor(), Collections.emptyMap(), false, null, Collections.emptyMap());
            float correctedMagnification = (float)((double)magnificationFactor * propsUi.getZoomFactor());
            pipelinePainter.setMagnification(correctedMagnification);
            pipelinePainter.setOffset(this.offset);
            pipelinePainter.setMaximum(this.maximum);
            pipelinePainter.setShowingNavigationView(true);
            pipelinePainter.setScreenMagnification(this.magnification);
            try {
                pipelinePainter.drawPipelineImage();
                this.viewPort = pipelinePainter.getViewPort();
                this.graphPort = pipelinePainter.getGraphPort();
            }
            catch (Exception e) {
                new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error drawing pipeline image", e);
            }
        }
        finally {
            gc.dispose();
        }
        CanvasFacade.setData(this.canvas, this.magnification, this.offset, this.pipelineMeta);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-10100-Refresh", toolTip="i18n::PipelineExecutionViewer.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg", separator=true)
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        this.refreshStatus();
        this.refreshMetrics();
        this.refreshTransformData();
        this.setFocus();
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-ToolBar-10500-Zoom-Level", label="i18n:org.apache.hop.ui.hopgui:HopGui.Toolbar.Zoom", toolTip="i18n::HopGuiPipelineGraph.GuiAction.ZoomInOut.Tooltip", type=GuiToolbarElementType.COMBO, alignRight=true, comboValuesMethod="getZoomLevels")
    public void zoomLevel() {
        this.readMagnification();
        this.redraw();
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-11100-GoToEditor", toolTip="i18n::PipelineExecutionViewer.ToolbarElement.NavigateToEditor.Tooltip", image="ui/images/data_orch.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void navigateToEditor() {
        try {
            HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
            TabItemHandler item = perspective.findPipeline(this.execution.getId());
            if (item != null) {
                perspective.switchToTab(item);
                perspective.activate();
                return;
            }
            String filename = this.execution.getFilename();
            if (filename != null) {
                this.hopGui.fileDelegate.fileOpen(filename);
                return;
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error navigating to pipeline in Hop GUI", e);
        }
    }

    public List<String> getZoomLevels() {
        return Arrays.asList(PipelinePainter.magnificationDescriptions);
    }

    private void readMagnification() {
        Combo zoomLabel = (Combo)this.toolBarWidgets.getWidgetsMap().get(TOOLBAR_ITEM_ZOOM_LEVEL);
        if (zoomLabel == null) {
            return;
        }
        String possibleText = zoomLabel.getText().replace("%", "");
        try {
            float possibleFloatMagnification;
            this.magnification = possibleFloatMagnification = Float.parseFloat(possibleText) / 100.0f;
            if (zoomLabel.getText().indexOf(37) < 0) {
                zoomLabel.setText(zoomLabel.getText().concat("%"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refresh();
    }

    @Override
    public String getName() {
        return this.pipelineMeta.getName();
    }

    @Override
    public String getLogChannelId() {
        return this.execution.getId();
    }

    public void mouseDown(MouseEvent event) {
        boolean control;
        this.pipelineMeta.unselectAll();
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.mouseHover(event);
        }
        Point real = this.screen2real(event.x, event.y);
        this.lastClick = new Point(real.x, real.y);
        boolean bl = control = (event.stateMask & SWT.MOD1) != 0;
        if (this.setupDragView(event.button, control, new Point(event.x, event.y))) {
            return;
        }
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner == null) {
            this.selectedTransform = null;
        } else {
            switch (areaOwner.getAreaType()) {
                case TRANSFORM_ICON: {
                    this.selectedTransform = (TransformMeta)areaOwner.getOwner();
                    this.refreshTransformData();
                    break;
                }
                case TRANSFORM_NAME: {
                    this.selectedTransform = (TransformMeta)areaOwner.getParent();
                    this.refreshTransformData();
                }
            }
        }
        this.redraw();
    }

    public void refreshTransformData() {
        if (this.selectedTransform != null) {
            this.showTransformData(this.selectedTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTransformData(TransformMeta transformMeta) {
        Cursor busyCursor = new Cursor((Device)this.getShell().getDisplay(), 1);
        try {
            String previousListSelection;
            block11: {
                this.getShell().setCursor(busyCursor);
                transformMeta.setSelected(true);
                previousListSelection = null;
                if (this.dataList.getSelectionCount() == 1) {
                    previousListSelection = this.dataList.getSelection()[0];
                }
                this.dataList.removeAll();
                this.dataView.clearAll();
                this.selectedTransformData = this.loadSelectedTransformData();
                if (this.selectedTransformData != null) break block11;
                return;
            }
            try {
                Map setMetaData = this.selectedTransformData.getSetMetaData();
                ArrayList<String> items = new ArrayList<String>();
                for (String key : setMetaData.keySet()) {
                    ExecutionDataSetMeta setMeta = (ExecutionDataSetMeta)setMetaData.get(key);
                    if (!transformMeta.getName().equals(setMeta.getName())) continue;
                    items.add(setMeta.getDescription());
                }
                Collections.sort(items);
                this.dataList.setItems(items.toArray(new String[0]));
                this.tabFolder.setSelection(this.dataTab);
                if (previousListSelection != null && items.contains(previousListSelection)) {
                    this.dataList.setSelection(items.indexOf(previousListSelection));
                } else {
                    this.dataList.setSelection(0);
                }
                this.showDataRows();
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), CONST_ERROR, "Error showing transform data", e);
            }
        }
        finally {
            this.getShell().setCursor(null);
            busyCursor.dispose();
        }
    }

    private ExecutionData loadSelectedTransformData() throws HopException {
        ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
        if (location == null) {
            return null;
        }
        IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
        ExecutionData data = iLocation.getExecutionData(this.execution.getId(), null);
        if (data == null) {
            ExecutionDataBuilder builder = ExecutionDataBuilder.of().withParentId(this.execution.getId());
            List childIds = location.getExecutionInfoLocation().findChildIds(ExecutionType.Pipeline, this.execution.getId());
            if (childIds != null) {
                for (String childId : childIds) {
                    try {
                        ExecutionData childData = location.getExecutionInfoLocation().getExecutionData(this.execution.getId(), childId);
                        if (childData == null) continue;
                        builder.addDataSets(childData.getDataSets()).addSetMeta(childData.getSetMetaData());
                    }
                    catch (Exception e) {
                        LogChannel.GENERAL.logDetailed("Error find transform data for child ID " + childId + " : " + e.getMessage());
                    }
                }
            }
            data = builder.build();
        }
        return data;
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-11200-DrillDown", toolTip="i18n::PipelineExecutionViewer.ToolbarElement.DrillDown.Tooltip", image="ui/images/down.svg")
    public void drillDown() {
        if (this.selectedTransform == null) {
            return;
        }
        ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
        if (location == null) {
            return;
        }
        IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
        try {
            List executions;
            for (ExecutionDataSetMeta setMeta : this.selectedTransformData.getSetMetaData().values()) {
                if (!setMeta.getName().equals(this.selectedTransform.getName())) continue;
                String parentId = setMeta.getLogChannelId();
                List childExecutions = iLocation.findExecutions(parentId);
                if (childExecutions.isEmpty()) break;
                Execution child = (Execution)childExecutions.get(0);
                ExecutionState executionState = iLocation.getExecutionState(this.execution.getId(), false);
                this.perspective.createExecutionViewer(this.locationName, child, executionState);
                return;
            }
            if ((executions = iLocation.findExecutions(e -> this.selectedTransform.getName().equals(e.getName()) && e.getExecutionType() == ExecutionType.Transform && this.execution.getId().equals(e.getParentId()))).isEmpty()) {
                return;
            }
            Execution transformExecution = executions.size() == 1 ? (Execution)executions.get(0) : this.selectExecution(executions);
            if (transformExecution == null) {
                return;
            }
            List childExecutions = iLocation.findExecutions(transformExecution.getId());
            if (childExecutions.isEmpty()) {
                return;
            }
            Execution childExecution = childExecutions.size() == 1 ? (Execution)childExecutions.get(0) : this.selectExecution(childExecutions);
            ExecutionState executionState = iLocation.getExecutionState(this.execution.getId(), false);
            this.perspective.createExecutionViewer(this.locationName, childExecution, executionState);
        }
        catch (Exception e2) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error drilling down into selected action", e2);
        }
    }

    private Execution selectExecution(List<Execution> executions) {
        IRowMeta rowMeta = new RowMetaBuilder().addString("Type").addString("Name").addString("Copy").addDate("Start date").build();
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        for (Execution execution : executions) {
            rows.add(new RowMetaAndData(rowMeta, new Object[]{execution.getExecutionType().name(), execution.getName(), execution.getCopyNr(), execution.getExecutionStartDate()}));
        }
        SelectRowDialog dialog = new SelectRowDialog(this.getShell(), this.hopGui.getVariables(), 772, rows);
        RowMetaAndData selectedRow = dialog.open();
        if (selectedRow == null) {
            return null;
        }
        int index = rows.indexOf(selectedRow);
        if (index < 0) {
            return null;
        }
        return executions.get(index);
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-11300-GoUp", toolTip="i18n::PipelineExecutionViewer.ToolbarElement.GoUp.Tooltip", image="ui/images/up.svg")
    public void goUp() {
        try {
            String parentId = this.execution.getParentId();
            if (parentId == null) {
                return;
            }
            ExecutionInfoLocation location = this.perspective.getLocationMap().get(this.locationName);
            if (location == null) {
                return;
            }
            IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
            String grandParentId = iLocation.findParentId(parentId);
            if (grandParentId == null) {
                return;
            }
            Execution grandParent = iLocation.getExecution(grandParentId);
            ExecutionState executionState = iLocation.getExecutionState(grandParent.getId(), false);
            this.perspective.createExecutionViewer(this.locationName, grandParent, executionState);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error navigating up to parent execution", e);
        }
    }

    @Override
    public void drillDownOnLocation(Point location) {
        if (location == null) {
            return;
        }
        AreaOwner areaOwner = this.getVisibleAreaOwner(location.x, location.y);
        if (areaOwner == null) {
            return;
        }
        if (areaOwner.getAreaType() == AreaOwner.AreaType.TRANSFORM_ICON) {
            this.selectedTransform = (TransformMeta)areaOwner.getOwner();
            this.refreshTransformData();
            this.drillDown();
        }
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-12000-ViewExecutor", toolTip="i18n::PipelineExecutionViewer.ToolbarElement.ViewExecutor.Tooltip", image="ui/images/view.svg", separator=true)
    public void viewExecutor() {
        try {
            String pipelineXml = this.execution.getExecutorXml();
            Node pipelineNode = XmlHandler.loadXmlString((String)pipelineXml, (String)"pipeline");
            String metadataJson = this.execution.getMetadataJson();
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metadataJson);
            IVariables variables = Variables.getADefaultVariableSpace();
            variables.setVariables(this.execution.getVariableValues());
            variables.setVariables(this.execution.getParameterValues());
            PipelineMeta pipelineMeta = new PipelineMeta(pipelineNode, (IHopMetadataProvider)metadataProvider);
            HopDataOrchestrationPerspective p = HopGui.getDataOrchestrationPerspective();
            HopGuiPipelineGraph graph = (HopGuiPipelineGraph)p.addPipeline(this.hopGui, pipelineMeta, new HopPipelineFileType());
            graph.setVariables(variables);
            p.activate();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), CONST_ERROR, "Error viewing the executor", e);
        }
    }

    @GuiToolbarElement(root="PipelineExecutionViewer-Toolbar", id="PipelineExecutionViewer-Toolbar-12100-ViewMetadata", toolTip="i18n::PipelineExecutionViewer.ToolbarElement.ViewMetadata.Tooltip", image="ui/images/metadata.svg")
    public void viewMetadata() {
        super.viewMetadata(this.execution);
    }

    @Override
    public String getActiveId() {
        if (this.selectedTransform != null) {
            for (ExecutionDataSetMeta setMeta : this.selectedTransformData.getSetMetaData().values()) {
                if (!this.selectedTransform.getName().equals(setMeta.getName())) continue;
                return setMeta.getLogChannelId();
            }
        }
        return this.getLogChannelId();
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    @Override
    public Execution getExecution() {
        return this.execution;
    }

    public TransformMeta getSelectedTransform() {
        return this.selectedTransform;
    }

    public void setSelectedTransform(TransformMeta selectedTransform) {
        this.selectedTransform = selectedTransform;
    }

    @Override
    public String getLocationName() {
        return this.locationName;
    }

    public ExecutionData getSelectedTransformData() {
        return this.selectedTransformData;
    }

    public void setSelectedTransformData(ExecutionData selectedTransformData) {
        this.selectedTransformData = selectedTransformData;
    }

    public org.eclipse.swt.widgets.List getDataList() {
        return this.dataList;
    }

    public void setDataList(org.eclipse.swt.widgets.List dataList) {
        this.dataList = dataList;
    }

    @Override
    public ExecutionPerspective getPerspective() {
        return this.perspective;
    }
}

