/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.stateful;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.MultimapState;
import org.apache.beam.sdk.state.OrderedListState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.ReadableStates;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

class SparkStateInternals<@UnknownKeyFor K>
implements StateInternals {
    private final K key;
    private final @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> stateTable;

    private SparkStateInternals(K key) {
        this.key = key;
        this.stateTable = HashBasedTable.create();
    }

    private SparkStateInternals(K key, @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> stateTable) {
        this.key = key;
        this.stateTable = stateTable;
    }

    static <K> @UnknownKeyFor @NonNull @Initialized SparkStateInternals<K> forKey(K key) {
        return new SparkStateInternals<K>(key);
    }

    static <K> @UnknownKeyFor @NonNull @Initialized SparkStateInternals<K> forKeyAndState(K key, @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> stateTable) {
        return new SparkStateInternals<K>(key, stateTable);
    }

    public @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getState() {
        return this.stateTable;
    }

    public K getKey() {
        return this.key;
    }

    public <T extends State> T state(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized StateTag<T> address, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> c) {
        return (T)address.getSpec().bind(address.getId(), (StateBinder)new SparkStateBinder(namespace, c));
    }

    private final class SparkBagState<@UnknownKeyFor T>
    extends AbstractState<List<T>>
    implements BagState<T> {
        private SparkBagState(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String id, Coder<T> coder) {
            super(namespace, id, (Coder)ListCoder.of(coder));
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkBagState<T> readLater() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized List<T> read() {
            ArrayList value = (ArrayList)super.readValue();
            if (value == null) {
                value = new ArrayList();
            }
            return value;
        }

        public void add(T input) {
            Iterable value = this.read();
            value.add(input);
            this.writeValue(value);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkBagState.this.namespace.stringKey(), (Object)SparkBagState.this.id) == null;
                }
            };
        }
    }

    private final class SparkMapState<@UnknownKeyFor MapKeyT, @UnknownKeyFor MapValueT>
    extends AbstractState<Map<MapKeyT, MapValueT>>
    implements MapState<MapKeyT, MapValueT> {
        private SparkMapState(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized String id, Coder<Map<MapKeyT, MapValueT>> coder) {
            super(namespace, id, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<MapValueT> get(MapKeyT key) {
            return this.getOrDefault(key, null);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<MapValueT> getOrDefault(final MapKeyT key, final @Nullable MapValueT defaultValue) {
            return new ReadableState<MapValueT>(){

                public MapValueT read() {
                    Map sparkMapState = (Map)SparkMapState.this.readValue();
                    if (sparkMapState == null) {
                        return defaultValue;
                    }
                    return sparkMapState.getOrDefault(key, defaultValue);
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<MapValueT> readLater() {
                    return this;
                }
            };
        }

        public void put(MapKeyT key, MapValueT value) {
            HashMap<MapKeyT, MapValueT> sparkMapState = (HashMap<MapKeyT, MapValueT>)this.readValue();
            if (sparkMapState == null) {
                sparkMapState = new HashMap<MapKeyT, MapValueT>();
            }
            sparkMapState.put(key, value);
            this.writeValue(sparkMapState);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<MapValueT> computeIfAbsent(MapKeyT key, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @Nullable @Initialized ? super MapKeyT, @KeyForBottom @NonNull @Initialized ? extends MapValueT> mappingFunction) {
            Map sparkMapState = (Map)this.readValue();
            Object current = sparkMapState.get(key);
            if (current == null) {
                this.put(key, mappingFunction.apply(key));
            }
            return ReadableStates.immediate(current);
        }

        public void remove(MapKeyT key) {
            Map sparkMapState = (Map)this.readValue();
            sparkMapState.remove(key);
            this.writeValue(sparkMapState);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Iterable<MapKeyT>> keys() {
            return new ReadableState<Iterable<MapKeyT>>(){

                public @UnknownKeyFor @NonNull @Initialized Iterable<MapKeyT> read() {
                    Map sparkMapState = (Map)SparkMapState.this.readValue();
                    if (sparkMapState == null) {
                        return Collections.emptyList();
                    }
                    return sparkMapState.keySet();
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Iterable<MapKeyT>> readLater() {
                    return this;
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Iterable<MapValueT>> values() {
            return new ReadableState<Iterable<MapValueT>>(){

                public @UnknownKeyFor @NonNull @Initialized Iterable<MapValueT> read() {
                    Map sparkMapState = (Map)SparkMapState.this.readValue();
                    if (sparkMapState == null) {
                        return Collections.emptyList();
                    }
                    Collection result = ((Map)SparkMapState.this.readValue()).values();
                    return result != null ? ImmutableList.copyOf(result) : Collections.emptyList();
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Iterable<MapValueT>> readLater() {
                    return this;
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Map.Entry<MapKeyT, MapValueT>>> entries() {
            return new ReadableState<Iterable<Map.Entry<MapKeyT, MapValueT>>>(){

                public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Map.Entry<MapKeyT, MapValueT>> read() {
                    Map sparkMapState = (Map)SparkMapState.this.readValue();
                    if (sparkMapState == null) {
                        return Collections.emptyList();
                    }
                    return sparkMapState.entrySet();
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Map.Entry<MapKeyT, MapValueT>>> readLater() {
                    return this;
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkMapState.this.namespace.stringKey(), (Object)SparkMapState.this.id) == null;
                }

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }
            };
        }
    }

    private class SparkCombiningState<@UnknownKeyFor KeyT, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends AbstractState<AccumT>
    implements CombiningState<InputT, AccumT, OutputT> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private SparkCombiningState(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> coder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            super(namespace, id, coder);
            this.combineFn = combineFn;
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkCombiningState<KeyT, InputT, AccumT, OutputT> readLater() {
            return this;
        }

        public OutputT read() {
            return (OutputT)this.combineFn.extractOutput(this.getAccum());
        }

        public void add(InputT input) {
            Object accum = this.combineFn.addInput(this.getAccum(), input);
            this.writeValue(accum);
        }

        public AccumT getAccum() {
            Object accum = this.readValue();
            if (accum == null) {
                accum = this.combineFn.createAccumulator();
            }
            return (AccumT)accum;
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkCombiningState.this.namespace.stringKey(), (Object)SparkCombiningState.this.id) == null;
                }
            };
        }

        public void addAccum(AccumT accum) {
            accum = this.combineFn.mergeAccumulators(Arrays.asList(this.getAccum(), accum));
            this.writeValue(accum);
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }
    }

    private class SparkWatermarkHoldState
    extends AbstractState<Instant>
    implements WatermarkHoldState {
        private final @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner;

        SparkWatermarkHoldState(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String id, TimestampCombiner timestampCombiner) {
            super(namespace, id, (Coder)InstantCoder.of());
            this.timestampCombiner = timestampCombiner;
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkWatermarkHoldState readLater() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant read() {
            return (Instant)this.readValue();
        }

        public void add(@UnknownKeyFor @NonNull @Initialized Instant outputTime) {
            Instant combined = this.read();
            combined = combined == null ? outputTime : this.getTimestampCombiner().combine(new Instant[]{combined, outputTime});
            this.writeValue(combined);
        }

        public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized Boolean> readLater() {
                    return this;
                }

                public @UnknownKeyFor @NonNull @Initialized Boolean read() {
                    return SparkStateInternals.this.stateTable.get((Object)SparkWatermarkHoldState.this.namespace.stringKey(), (Object)SparkWatermarkHoldState.this.id) == null;
                }
            };
        }

        public @UnknownKeyFor @NonNull @Initialized TimestampCombiner getTimestampCombiner() {
            return this.timestampCombiner;
        }
    }

    private class SparkValueState<@UnknownKeyFor T>
    extends AbstractState<T>
    implements ValueState<T> {
        private SparkValueState(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String id, Coder<T> coder) {
            super(namespace, id, coder);
        }

        public @UnknownKeyFor @NonNull @Initialized SparkStateInternals. @UnknownKeyFor @NonNull @Initialized SparkValueState<T> readLater() {
            return this;
        }

        public T read() {
            return this.readValue();
        }

        public void write(T input) {
            this.writeValue(input);
        }
    }

    private class AbstractState<@UnknownKeyFor T> {
        final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        final @UnknownKeyFor @NonNull @Initialized String id;
        final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        private AbstractState(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String id, Coder<T> coder) {
            this.namespace = namespace;
            this.id = id;
            this.coder = coder;
        }

        T readValue() {
            byte[] buf = (byte[])SparkStateInternals.this.stateTable.get((Object)this.namespace.stringKey(), (Object)this.id);
            if (buf != null) {
                return CoderHelpers.fromByteArray(buf, this.coder);
            }
            return null;
        }

        void writeValue(T input) {
            SparkStateInternals.this.stateTable.put((Object)this.namespace.stringKey(), (Object)this.id, (Object)CoderHelpers.toByteArray(input, this.coder));
        }

        public void clear() {
            SparkStateInternals.this.stateTable.remove((Object)this.namespace.stringKey(), (Object)this.id);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractState that = (AbstractState)o;
            return this.namespace.equals(that.namespace) && this.id.equals(that.id);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }
    }

    private class SparkStateBinder
    implements StateBinder {
        private final @UnknownKeyFor @NonNull @Initialized StateNamespace namespace;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized StateContext<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> stateContext;

        private SparkStateBinder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized StateNamespace namespace, StateContext<?> stateContext) {
            this.namespace = namespace;
            this.stateContext = stateContext;
        }

        public <T> @UnknownKeyFor @NonNull @Initialized ValueState<T> bindValue(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return new SparkValueState(this.namespace, id, coder);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized BagState<T> bindBag(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
            return new SparkBagState(this.namespace, id, elemCoder);
        }

        public <T> @UnknownKeyFor @NonNull @Initialized SetState<T> bindSet(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized SetState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", SetState.class.getSimpleName()));
        }

        public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT> bindMap(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> mapKeyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> mapValueCoder) {
            return new SparkMapState(this.namespace, id, (Coder)MapCoder.of(mapKeyCoder, mapValueCoder));
        }

        public <KeyT, ValueT> @UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT> bindMultimap(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized MultimapState<KeyT, ValueT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<KeyT> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> valueCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", MultimapState.class.getSimpleName()));
        }

        public <T> @UnknownKeyFor @NonNull @Initialized OrderedListState<T> bindOrderedList(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized OrderedListState<T>> spec, @UnknownKeyFor @NonNull @Initialized Coder<T> elemCoder) {
            throw new UnsupportedOperationException(String.format("%s is not supported", OrderedListState.class.getSimpleName()));
        }

        public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombining(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            return new SparkCombiningState(this.namespace, id, accumCoder, combineFn);
        }

        public <InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT> bindCombiningWithContext(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<InputT, AccumT, OutputT>> spec, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
            return new SparkCombiningState(this.namespace, id, accumCoder, CombineFnUtil.bindContext(combineFn, this.stateContext));
        }

        public @UnknownKeyFor @NonNull @Initialized WatermarkHoldState bindWatermark(@UnknownKeyFor @NonNull @Initialized String id, @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized WatermarkHoldState> spec, @UnknownKeyFor @NonNull @Initialized TimestampCombiner timestampCombiner) {
            return new SparkWatermarkHoldState(this.namespace, id, timestampCombiner);
        }
    }
}

