/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforcedelete;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformDialog;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforcedelete.SalesforceDeleteMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SalesforceDeleteDialog
extends SalesforceTransformDialog {
    private static final Class<?> PKG = SalesforceDeleteMeta.class;
    private SalesforceDeleteMeta input;
    private LabelTextVar wUserName;
    private LabelTextVar wURL;
    private LabelTextVar wPassword;
    private TextVar wBatchSize;
    private ComboVar wModule;
    private ComboVar wDeleteField;
    private boolean gotPrevious = false;
    private boolean gotModule = false;
    private boolean getModulesListError = false;
    private Button wUseCompression;
    private TextVar wTimeOut;
    private Button wRollbackAllChangesOnError;

    public SalesforceDeleteDialog(Shell parent, IVariables variables, SalesforceDeleteMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wConnectionGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wConnectionGroup);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.ConnectionGroup.Label", (String[])new String[0]));
        FormLayout connectionGroupLayout = new FormLayout();
        connectionGroupLayout.marginWidth = 10;
        connectionGroupLayout.marginHeight = 10;
        wConnectionGroup.setLayout((Layout)connectionGroupLayout);
        this.wURL = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.URL.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.URL.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wURL);
        this.wURL.addModifyListener(lsMod);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(0, 0);
        fdURL.top = new FormAttachment((Control)this.wTransformName, margin);
        fdURL.right = new FormAttachment(100, 0);
        this.wURL.setLayoutData((Object)fdURL);
        this.wUserName = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.User.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(0, 0);
        fdUserName.top = new FormAttachment((Control)this.wURL, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wPassword = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.Password.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(0, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Button wTest = new Button((Composite)wConnectionGroup, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wPassword, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, margin);
        fdConnectionGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdConnectionGroup.right = new FormAttachment(100, -margin);
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        Group wSettingsGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingGroupLayout);
        Label wlTimeOut = new Label((Composite)wSettingsGroup, 131072);
        wlTimeOut.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.TimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTimeOut);
        FormData fdlTimeOut = new FormData();
        fdlTimeOut.left = new FormAttachment(0, 0);
        fdlTimeOut.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlTimeOut.right = new FormAttachment(middle, -margin);
        wlTimeOut.setLayoutData((Object)fdlTimeOut);
        this.wTimeOut = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        FormData fdTimeOut = new FormData();
        fdTimeOut.left = new FormAttachment(middle, 0);
        fdTimeOut.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData((Object)fdTimeOut);
        Label wlUseCompression = new Label((Composite)wSettingsGroup, 131072);
        wlUseCompression.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.UseCompression.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseCompression);
        FormData fdlUseCompression = new FormData();
        fdlUseCompression.left = new FormAttachment(0, 0);
        fdlUseCompression.top = new FormAttachment((Control)this.wTimeOut, margin);
        fdlUseCompression.right = new FormAttachment(middle, -margin);
        wlUseCompression.setLayoutData((Object)fdlUseCompression);
        this.wUseCompression = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wUseCompression);
        this.wUseCompression.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.UseCompression.Tooltip", (String[])new String[0]));
        FormData fdUseCompression = new FormData();
        fdUseCompression.left = new FormAttachment(middle, 0);
        fdUseCompression.top = new FormAttachment((Control)wlUseCompression, 0, 0x1000000);
        this.wUseCompression.setLayoutData((Object)fdUseCompression);
        this.wUseCompression.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlRollbackAllChangesOnError = new Label((Composite)wSettingsGroup, 131072);
        wlRollbackAllChangesOnError.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.RollbackAllChangesOnError.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRollbackAllChangesOnError);
        FormData fdlRollbackAllChangesOnError = new FormData();
        fdlRollbackAllChangesOnError.left = new FormAttachment(0, 0);
        fdlRollbackAllChangesOnError.top = new FormAttachment((Control)this.wUseCompression, margin);
        fdlRollbackAllChangesOnError.right = new FormAttachment(middle, -margin);
        wlRollbackAllChangesOnError.setLayoutData((Object)fdlRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.RollbackAllChangesOnError.Tooltip", (String[])new String[0]));
        FormData fdRollbackAllChangesOnError = new FormData();
        fdRollbackAllChangesOnError.left = new FormAttachment(middle, 0);
        fdRollbackAllChangesOnError.top = new FormAttachment((Control)wlRollbackAllChangesOnError, 0, 0x1000000);
        this.wRollbackAllChangesOnError.setLayoutData((Object)fdRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlBatchSize = new Label((Composite)wSettingsGroup, 131072);
        wlBatchSize.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wRollbackAllChangesOnError, margin);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wRollbackAllChangesOnError, margin);
        fdBatchSize.right = new FormAttachment(100, 0);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        Label wlModule = new Label((Composite)wSettingsGroup, 131072);
        wlModule.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.Module.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlModule);
        FormData fdlModule = new FormData();
        fdlModule.left = new FormAttachment(0, 0);
        fdlModule.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdlModule.right = new FormAttachment(middle, -margin);
        wlModule.setLayoutData((Object)fdlModule);
        this.wModule = new ComboVar(this.variables, (Composite)wSettingsGroup, 2060);
        this.wModule.setEditable(true);
        PropsUi.setLook((Widget)this.wModule);
        this.wModule.addModifyListener(lsTableMod);
        FormData fdModule = new FormData();
        fdModule.left = new FormAttachment(middle, 0);
        fdModule.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdModule.right = new FormAttachment(100, -margin);
        this.wModule.setLayoutData((Object)fdModule);
        this.wModule.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SalesforceDeleteDialog.this.getModulesListError = false;
            }

            public void focusGained(FocusEvent e) {
                if (Utils.isEmpty((CharSequence)SalesforceDeleteDialog.this.wURL.getText()) || Utils.isEmpty((CharSequence)SalesforceDeleteDialog.this.wUserName.getText()) || Utils.isEmpty((CharSequence)SalesforceDeleteDialog.this.wPassword.getText()) || SalesforceDeleteDialog.this.getModulesListError) {
                    return;
                }
                Cursor busy = new Cursor((Device)SalesforceDeleteDialog.this.shell.getDisplay(), 1);
                SalesforceDeleteDialog.this.shell.setCursor(busy);
                SalesforceDeleteDialog.this.getModulesList();
                SalesforceDeleteDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlDeleteField = new Label((Composite)wSettingsGroup, 131072);
        wlDeleteField.setText(BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.KeyField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDeleteField);
        FormData fdlDeleteField = new FormData();
        fdlDeleteField.left = new FormAttachment(0, 0);
        fdlDeleteField.top = new FormAttachment((Control)this.wModule, margin);
        fdlDeleteField.right = new FormAttachment(middle, -margin);
        wlDeleteField.setLayoutData((Object)fdlDeleteField);
        this.wDeleteField = new ComboVar(this.variables, (Composite)wSettingsGroup, 2060);
        this.wDeleteField.setEditable(true);
        PropsUi.setLook((Widget)this.wDeleteField);
        this.wDeleteField.addModifyListener(lsMod);
        FormData fdDeleteField = new FormData();
        fdDeleteField.left = new FormAttachment(middle, 0);
        fdDeleteField.top = new FormAttachment((Control)this.wModule, margin);
        fdDeleteField.right = new FormAttachment(100, -margin);
        this.wDeleteField.setLayoutData((Object)fdDeleteField);
        this.wDeleteField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                SalesforceDeleteDialog.this.getPreviousFields();
            }
        });
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)wConnectionGroup, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        Listener lsTest = e -> this.test();
        this.wOk.addListener(13, e -> this.ok());
        wTest.addListener(13, lsTest);
        this.wCancel.addListener(13, e -> this.cancel());
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getPreviousFields() {
        if (!this.gotPrevious) {
            try {
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    String value = this.wDeleteField.getText();
                    this.wDeleteField.removeAll();
                    this.wDeleteField.setItems(r.getFieldNames());
                    if (value != null) {
                        this.wDeleteField.setText(value);
                    }
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPrevious = true;
        }
    }

    public void getData(SalesforceDeleteMeta in) {
        this.wURL.setText(Const.NVL((String)in.getTargetUrl(), (String)""));
        this.wUserName.setText(Const.NVL((String)in.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)in.getPassword(), (String)""));
        this.wBatchSize.setText(in.getBatchSize());
        this.wModule.setText(Const.NVL((String)in.getModule(), (String)"Account"));
        if (in.getDeleteField() != null) {
            this.wDeleteField.setText(in.getDeleteField());
        }
        this.wBatchSize.setText(in.getBatchSize());
        this.wTimeOut.setText(Const.NVL((String)in.getTimeout(), (String)"60000"));
        this.wUseCompression.setSelection(in.isCompression());
        this.wRollbackAllChangesOnError.setSelection(in.isRollbackAllChangesOnError());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.ErrorValidateData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.ErrorValidateData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    @Override
    protected void getInfo(SalesforceTransformMeta in) throws HopException {
        SalesforceDeleteMeta meta = (SalesforceDeleteMeta)in;
        this.transformName = this.wTransformName.getText();
        meta.setTargetUrl(Const.NVL((String)this.wURL.getText(), (String)"https://login.salesforce.com/services/Soap/u/50.0"));
        meta.setUsername(this.wUserName.getText());
        meta.setPassword(this.wPassword.getText());
        meta.setModule(this.wModule.getText());
        meta.setDeleteField(this.wDeleteField.getText());
        meta.setBatchSize(this.wBatchSize.getText());
        meta.setCompression(this.wUseCompression.getSelection());
        meta.setTimeout(Const.NVL((String)this.wTimeOut.getText(), (String)"0"));
        meta.setRollbackAllChangesOnError(this.wRollbackAllChangesOnError.getSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getModulesList() {
        if (!this.gotModule) {
            SalesforceConnection connection = null;
            try {
                SalesforceDeleteMeta meta = new SalesforceDeleteMeta();
                this.getInfo(meta);
                String url = this.variables.resolve(meta.getTargetUrl());
                String selectedField = this.wModule.getText();
                this.wModule.removeAll();
                connection = new SalesforceConnection((ILogChannel)this.log, url, this.variables.resolve(meta.getUsername()), Utils.resolvePassword((IVariables)this.variables, (String)meta.getPassword()));
                int realTimeOut = Const.toInt((String)this.variables.resolve(meta.getTimeout()), (int)0);
                connection.setTimeOut(realTimeOut);
                connection.connect();
                this.wModule.setItems(connection.getAllAvailableObjects(false));
                if (!Utils.isEmpty((CharSequence)selectedField)) {
                    this.wModule.setText(selectedField);
                }
                this.gotModule = true;
                this.getModulesListError = false;
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.ErrorRetrieveModules.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceDeleteDialog.ErrorRetrieveData.ErrorRetrieveModules", (String[])new String[0]), e);
                this.getModulesListError = true;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

