/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.vfs.azure.AzureCustomFileNameParser;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.AzureFileNameParser;
import org.apache.hop.vfs.azure.AzureFileSystem;
import org.apache.hop.vfs.azure.config.AzureConfig;
import org.apache.hop.vfs.azure.config.AzureConfigSingleton;
import org.apache.hop.vfs.azure.metadatatype.AzureMetadataType;

public class AzureFileProvider
extends AbstractOriginatingFileProvider {
    public static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.ATTRIBUTES, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT));
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    public static final String AZURE_ENDPOINT_SUFFIX = "core.windows.net";
    private static final FileSystemOptions defaultOptions = new FileSystemOptions();
    private final Log logger = LogFactory.getLog(AzureFileProvider.class);
    private IVariables variables;
    private AzureMetadataType azureMetadataType;

    public static FileSystemOptions getDefaultFileSystemOptions() {
        return defaultOptions;
    }

    public AzureFileProvider() {
        this.setFileNameParser((FileNameParser)AzureFileNameParser.getInstance());
    }

    public AzureFileProvider(IVariables variables, AzureMetadataType azureMetadataType) {
        this.variables = variables;
        this.azureMetadataType = azureMetadataType;
        this.setFileNameParser((FileNameParser)new AzureCustomFileNameParser(azureMetadataType.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        AzureFileSystem azureFileSystem;
        FileSystemOptions fsOptions = fileSystemOptions != null ? fileSystemOptions : AzureFileProvider.getDefaultFileSystemOptions();
        UserAuthenticationData authData = null;
        try {
            String endpoint;
            String key;
            String account;
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fsOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            this.logger.info((Object)"Initialize Azure client");
            AzureFileName azureRootName = (AzureFileName)fileName;
            if (this.azureMetadataType != null) {
                if (StringUtils.isEmpty((String)this.azureMetadataType.getStorageAccountName())) {
                    throw new FileSystemException("Azure configuration \"" + this.azureMetadataType.getName() + "\" is missing a storage account name");
                }
                if (StringUtils.isEmpty((String)this.azureMetadataType.getStorageAccountKey())) {
                    throw new FileSystemException("Azure configuration \"" + this.azureMetadataType.getName() + "\" is missing a storage account key");
                }
                account = this.variables.resolve(this.azureMetadataType.getStorageAccountName());
                key = Encr.decryptPasswordOptionallyEncrypted((String)this.variables.resolve(this.azureMetadataType.getStorageAccountKey()));
                endpoint = !Utils.isEmpty((CharSequence)this.azureMetadataType.getStorageAccountEndpoint()) ? this.variables.resolve(this.azureMetadataType.getStorageAccountEndpoint()) : String.format(Locale.ROOT, "https://%s.dfs.core.windows.net", account);
            } else {
                AzureConfig config = AzureConfigSingleton.getConfig();
                if (StringUtils.isEmpty((String)config.getAccount())) {
                    throw new FileSystemException("Please configure the Azure account to use in the configuration (Options dialog or with hop-conf)");
                }
                if (StringUtils.isEmpty((String)config.getKey())) {
                    throw new FileSystemException("Please configure the Azure key to use in the configuration (Options dialog or with hop-conf)");
                }
                IVariables newVariables = Variables.getADefaultVariableSpace();
                account = newVariables.resolve(config.getAccount());
                key = Encr.decryptPasswordOptionallyEncrypted((String)newVariables.resolve(config.getKey()));
                endpoint = !Utils.isEmpty((CharSequence)config.getEmulatorUrl()) ? newVariables.resolve(config.getEmulatorUrl()) : String.format(Locale.ROOT, "https://%s.dfs.core.windows.net", account);
            }
            StorageSharedKeyCredential storageCreds = new StorageSharedKeyCredential(account, key);
            DataLakeServiceClient serviceClient = new DataLakeServiceClientBuilder().endpoint(endpoint).credential(storageCreds).buildClient();
            azureFileSystem = new AzureFileSystem(azureRootName, serviceClient, ((AzureFileName)fileName).getContainer(), fileSystemOptions, account);
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
        return azureFileSystem;
    }

    public FileObject findFile(FileObject baseFileObject, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return super.findFile(baseFileObject, uri, fileSystemOptions);
    }

    protected FileObject findFile(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return super.findFile(fileName, fileSystemOptions);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

