/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutputenhanced;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputData;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputField;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputKeyField;
import org.apache.hop.pipeline.transforms.jsonoutputenhanced.JsonOutputMeta;

public class JsonOutput
extends BaseTransform<JsonOutputMeta, JsonOutputData> {
    private static final Class<?> PKG = JsonOutput.class;
    public Object[] prevRow;
    private JsonNodeFactory nc;
    private ObjectMapper mapper;
    private ObjectNode currentNode;

    public JsonOutput(TransformMeta transformMeta, JsonOutputMeta meta, JsonOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)this.resolve(((JsonOutputMeta)this.meta).getOutputValue()))) {
                this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
            if (((JsonOutputMeta)this.meta).getOperationType() == 1 || ((JsonOutputMeta)this.meta).getOperationType() == 2) {
                ((JsonOutputData)this.data).jsonItems = new ArrayList<ObjectNode>();
                ((JsonOutputData)this.data).isWriteToFile = true;
                if (!((JsonOutputMeta)this.meta).isDoNotOpenNewFileInit() && ((JsonOutputData)this.data).isWriteToFile && !this.openNewFile()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpenNewFile", (String[])new String[]{this.buildFilename()}));
                    this.stopAll();
                    this.setErrors(1L);
                    return false;
                }
            }
            ((JsonOutputData)this.data).realBlocName = Const.NVL((String)this.resolve(((JsonOutputMeta)this.meta).getJsonBloc()), (String)"");
            return true;
        }
        return false;
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.outputRow(this.prevRow);
            if (((JsonOutputData)this.data).isWriteToFile && !this.first && ((JsonOutputMeta)this.meta).getSplitOutputAfter() == 0) {
                this.writeJsonFile();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first && this.onFirstRecord(r)) {
            return false;
        }
        ((JsonOutputData)this.data).rowsAreSafe = false;
        this.manageRowItems(r);
        return true;
    }

    public void manageRowItems(Object[] row) throws HopException {
        ObjectNode itemNode;
        boolean sameGroup = this.sameGroup(this.prevRow, row);
        if (((JsonOutputMeta)this.meta).isUseSingleItemPerGroup()) {
            if (!sameGroup || this.currentNode == null) {
                this.currentNode = new ObjectNode(this.nc);
            }
            itemNode = this.currentNode;
        } else {
            itemNode = new ObjectNode(this.nc);
        }
        if (!sameGroup && !((JsonOutputData)this.data).jsonKeyGroupItems.isEmpty()) {
            this.logDebug("Record Num: " + ((JsonOutputData)this.data).nrRow + " - Generating JSON chunk");
            this.outputRow(this.prevRow);
            ((JsonOutputData)this.data).jsonKeyGroupItems = new ArrayList<ObjectNode>();
        }
        block8: for (int i = 0; i < ((JsonOutputData)this.data).nrFields; ++i) {
            JsonOutputField outputField = ((JsonOutputMeta)this.meta).getOutputFields()[i];
            String jsonAttributeName = this.getJsonAttributeName(outputField);
            boolean putBlank = !outputField.isRemoveIfBlank();
            ArrayNode arNode = null;
            if (((JsonOutputMeta)this.meta).isUseSingleItemPerGroup() && !outputField.isKeyField) {
                arNode = !itemNode.has(jsonAttributeName) ? itemNode.putArray(jsonAttributeName) : (ArrayNode)itemNode.get(jsonAttributeName);
                putBlank = false;
            }
            IValueMeta v = ((JsonOutputData)this.data).inputRowMeta.getValueMeta(((JsonOutputData)this.data).fieldIndexes[i]);
            switch (v.getType()) {
                case 4: {
                    Boolean boolValue = ((JsonOutputData)this.data).inputRowMeta.getBoolean(row, ((JsonOutputData)this.data).fieldIndexes[i]);
                    if (putBlank) {
                        itemNode.put(jsonAttributeName, boolValue);
                        continue block8;
                    }
                    if (boolValue == null) continue block8;
                    if (arNode == null) {
                        itemNode.put(jsonAttributeName, boolValue);
                        continue block8;
                    }
                    arNode.add(boolValue);
                    continue block8;
                }
                case 5: {
                    Long integerValue = ((JsonOutputData)this.data).inputRowMeta.getInteger(row, ((JsonOutputData)this.data).fieldIndexes[i]);
                    if (putBlank) {
                        itemNode.put(jsonAttributeName, integerValue);
                        continue block8;
                    }
                    if (integerValue == null) continue block8;
                    if (arNode == null) {
                        itemNode.put(jsonAttributeName, integerValue);
                        continue block8;
                    }
                    arNode.add(integerValue);
                    continue block8;
                }
                case 1: {
                    Double numberValue = ((JsonOutputData)this.data).inputRowMeta.getNumber(row, ((JsonOutputData)this.data).fieldIndexes[i]);
                    if (putBlank) {
                        itemNode.put(jsonAttributeName, numberValue);
                        continue block8;
                    }
                    if (numberValue == null) continue block8;
                    if (arNode == null) {
                        itemNode.put(jsonAttributeName, numberValue);
                        continue block8;
                    }
                    arNode.add(numberValue);
                    continue block8;
                }
                case 6: {
                    BigDecimal bignumberValue = ((JsonOutputData)this.data).inputRowMeta.getBigNumber(row, ((JsonOutputData)this.data).fieldIndexes[i]);
                    if (putBlank) {
                        itemNode.put(jsonAttributeName, bignumberValue);
                        continue block8;
                    }
                    if (bignumberValue == null) continue block8;
                    if (arNode == null) {
                        itemNode.put(jsonAttributeName, bignumberValue);
                        continue block8;
                    }
                    arNode.add(bignumberValue);
                    continue block8;
                }
                default: {
                    String value = ((JsonOutputData)this.data).inputRowMeta.getString(row, ((JsonOutputData)this.data).fieldIndexes[i]);
                    if (putBlank) {
                        itemNode.put(jsonAttributeName, value);
                        continue block8;
                    }
                    if (value == null) continue block8;
                    if (outputField.isJSONFragment()) {
                        try {
                            JsonNode jsonNode = this.mapper.readTree(value);
                            if (outputField.isWithoutEnclosing()) {
                                itemNode.setAll((ObjectNode)jsonNode);
                                continue block8;
                            }
                            if (arNode == null) {
                                itemNode.set(jsonAttributeName, jsonNode);
                                continue block8;
                            }
                            arNode.add(jsonNode);
                            continue block8;
                        }
                        catch (IOException e) {
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.Casting", (String[])new String[0]), (Throwable)e);
                        }
                    }
                    if (arNode == null) {
                        itemNode.put(jsonAttributeName, value);
                        continue block8;
                    }
                    arNode.add(value);
                }
            }
        }
        if (((JsonOutputMeta)this.meta).getSplitOutputAfter() > 0) {
            ((JsonOutputData)this.data).jsonItems.add(itemNode);
        }
        if (!((JsonOutputMeta)this.meta).isUseSingleItemPerGroup() || ((JsonOutputData)this.data).jsonKeyGroupItems.isEmpty()) {
            ((JsonOutputData)this.data).jsonKeyGroupItems.add(itemNode);
        }
        this.prevRow = ((JsonOutputData)this.data).inputRowMeta.cloneRow(row);
        ++((JsonOutputData)this.data).nrRow;
        if (((JsonOutputMeta)this.meta).getSplitOutputAfter() > 0 && ((JsonOutputData)this.data).nrRow % ((JsonOutputMeta)this.meta).getSplitOutputAfter() == 0) {
            this.logDebug("Record Num: " + ((JsonOutputData)this.data).nrRow + " - Generating JSON chunk");
            this.serializeJson(((JsonOutputData)this.data).jsonItems);
            this.writeJsonFile();
            ((JsonOutputData)this.data).jsonItems = new ArrayList<ObjectNode>();
        }
    }

    private String getJsonAttributeName(JsonOutputField field) {
        String elementName = this.variables.resolve(field.getElementName());
        return elementName != null && elementName.length() > 0 ? elementName : field.getFieldName();
    }

    private String getKeyJsonAttributeName(JsonOutputKeyField field) {
        String elementName = this.variables.resolve(field.getElementName());
        return elementName != null && elementName.length() > 0 ? elementName : field.getFieldName();
    }

    private void outputRow(Object[] rowData) throws HopException {
        ObjectNode globalItemNode = null;
        if (((JsonOutputData)this.data).jsonKeyGroupItems == null || ((JsonOutputData)this.data).jsonKeyGroupItems.isEmpty()) {
            return;
        }
        if (((JsonOutputData)this.data).jsonKeyGroupItems != null && !((JsonOutputData)this.data).jsonKeyGroupItems.isEmpty()) {
            this.serializeJson(((JsonOutputData)this.data).jsonKeyGroupItems);
        }
        ((JsonOutputData)this.data).jsonLength = ((JsonOutputData)this.data).jsonSerialized.length();
        if (((JsonOutputData)this.data).outputRowMeta != null) {
            Object[] keyRow = new Object[((JsonOutputMeta)this.meta).getKeyFields().length];
            if (((JsonOutputData)this.data).isWriteToFile) {
                globalItemNode = new ObjectNode(this.nc);
            }
            block10: for (int i = 0; i < ((JsonOutputMeta)this.meta).getKeyFields().length; ++i) {
                try {
                    IValueMeta vmi = ((JsonOutputData)this.data).inputRowMeta.getValueMeta(((JsonOutputData)this.data).keysGroupIndexes[i]);
                    switch (vmi.getType()) {
                        case 4: {
                            keyRow[i] = ((JsonOutputData)this.data).inputRowMeta.getBoolean(rowData, ((JsonOutputData)this.data).keysGroupIndexes[i]);
                            if (!((JsonOutputData)this.data).isWriteToFile) continue block10;
                            globalItemNode.put(this.getKeyJsonAttributeName(((JsonOutputMeta)this.meta).getKeyFields()[i]), (Boolean)keyRow[i]);
                            break;
                        }
                        case 5: {
                            keyRow[i] = ((JsonOutputData)this.data).inputRowMeta.getInteger(rowData, ((JsonOutputData)this.data).keysGroupIndexes[i]);
                            if (!((JsonOutputData)this.data).isWriteToFile) continue block10;
                            globalItemNode.put(this.getKeyJsonAttributeName(((JsonOutputMeta)this.meta).getKeyFields()[i]), (Long)keyRow[i]);
                            break;
                        }
                        case 1: {
                            keyRow[i] = ((JsonOutputData)this.data).inputRowMeta.getNumber(rowData, ((JsonOutputData)this.data).keysGroupIndexes[i]);
                            if (!((JsonOutputData)this.data).isWriteToFile) continue block10;
                            globalItemNode.put(this.getKeyJsonAttributeName(((JsonOutputMeta)this.meta).getKeyFields()[i]), (Double)keyRow[i]);
                            break;
                        }
                        case 6: {
                            keyRow[i] = ((JsonOutputData)this.data).inputRowMeta.getBigNumber(rowData, ((JsonOutputData)this.data).keysGroupIndexes[i]);
                            if (!((JsonOutputData)this.data).isWriteToFile) continue block10;
                            globalItemNode.put(this.getKeyJsonAttributeName(((JsonOutputMeta)this.meta).getKeyFields()[i]), (BigDecimal)keyRow[i]);
                            break;
                        }
                        default: {
                            keyRow[i] = ((JsonOutputData)this.data).inputRowMeta.getString(rowData, ((JsonOutputData)this.data).keysGroupIndexes[i]);
                            if (!((JsonOutputData)this.data).isWriteToFile) continue block10;
                            globalItemNode.put(this.getKeyJsonAttributeName(((JsonOutputMeta)this.meta).getKeyFields()[i]), (String)keyRow[i]);
                            break;
                        }
                    }
                    continue;
                }
                catch (HopValueException vmi) {
                    // empty catch block
                }
            }
            if (((JsonOutputData)this.data).isWriteToFile) {
                try {
                    JsonNode jsonNode = this.mapper.readTree(((JsonOutputData)this.data).jsonSerialized);
                    if (((JsonOutputMeta)this.meta).getOutputValue() != null) {
                        globalItemNode.set(((JsonOutputMeta)this.meta).getOutputValue(), jsonNode);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ((JsonOutputData)this.data).jsonItems.add(globalItemNode);
            }
            Object[] additionalRowFields = new Object[]{((JsonOutputData)this.data).jsonSerialized};
            int nextFieldPos = 1;
            if (((JsonOutputMeta)this.meta).getJsonSizeFieldname() != null && ((JsonOutputMeta)this.meta).getJsonSizeFieldname().length() > 0) {
                additionalRowFields[nextFieldPos] = ((JsonOutputData)this.data).jsonLength;
                ++nextFieldPos;
            }
            Object[] outputRowData = RowDataUtil.addRowData((Object[])keyRow, (int)keyRow.length, (Object[])additionalRowFields);
            this.incrementLinesOutput();
            this.putRow(((JsonOutputData)this.data).outputRowMeta, outputRowData);
        }
        ((JsonOutputData)this.data).rowsAreSafe = true;
    }

    private void writeJsonFile() throws HopTransformException {
        if (((JsonOutputData)this.data).isWriteToFile && !this.openNewFile()) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpenNewFile", (String[])new String[]{this.buildFilename()}));
        }
        try {
            ((JsonOutputData)this.data).writer.write(((JsonOutputData)this.data).jsonSerialized);
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.Writing", (String[])new String[0]), (Throwable)e);
        }
        this.closeFile();
    }

    private void serializeJson(List<ObjectNode> jsonItemsList) {
        ObjectNode theNode = new ObjectNode(this.nc);
        try {
            if (((JsonOutputMeta)this.meta).getJsonBloc() != null && ((JsonOutputMeta)this.meta).getJsonBloc().length() > 0) {
                theNode.set(((JsonOutputMeta)this.meta).getJsonBloc(), this.mapper.readTree(this.mapper.writeValueAsString(jsonItemsList.size() > 1 ? jsonItemsList : (!((JsonOutputMeta)this.meta).isUseArrayWithSingleInstance() ? jsonItemsList.get(0) : jsonItemsList))));
                ((JsonOutputData)this.data).jsonSerialized = ((JsonOutputMeta)this.meta).isJsonPrittified() ? this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)theNode) : this.mapper.writeValueAsString((Object)theNode);
            } else {
                ((JsonOutputData)this.data).jsonSerialized = ((JsonOutputMeta)this.meta).isJsonPrittified() ? this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonItemsList.size() > 1 ? jsonItemsList : (!((JsonOutputMeta)this.meta).isUseArrayWithSingleInstance() ? jsonItemsList.get(0) : jsonItemsList)) : this.mapper.writeValueAsString(jsonItemsList.size() > 1 ? jsonItemsList : (!((JsonOutputMeta)this.meta).isUseArrayWithSingleInstance() ? jsonItemsList.get(0) : jsonItemsList));
            }
        }
        catch (IOException e) {
            this.logError("Error while serializing JSON", e);
            e.printStackTrace();
        }
    }

    private boolean sameGroup(Object[] previous, Object[] r) throws HopValueException {
        return ((JsonOutputData)this.data).inputRowMeta.compare(previous, r, ((JsonOutputData)this.data).keysGroupIndexes) == 0;
    }

    private boolean onFirstRecord(Object[] r) throws HopException {
        this.nc = HopJson.newMapper().getNodeFactory();
        this.mapper = HopJson.newMapper();
        this.first = false;
        ((JsonOutputData)this.data).inputRowMeta = this.getInputRowMeta();
        ((JsonOutputData)this.data).inputRowMetaSize = ((JsonOutputData)this.data).inputRowMeta.size();
        this.prevRow = ((JsonOutputData)this.data).inputRowMeta.cloneRow(r);
        ((JsonOutputData)this.data).outputRowMeta = new RowMeta();
        JsonOutputKeyField[] keyFields = ((JsonOutputMeta)this.meta).getKeyFields();
        for (int i = 0; i < ((JsonOutputMeta)this.meta).getKeyFields().length; ++i) {
            IValueMeta vmi = ((JsonOutputData)this.data).inputRowMeta.getValueMeta(((JsonOutputData)this.data).inputRowMeta.indexOfValue(keyFields[i].getFieldName()));
            ((JsonOutputData)this.data).outputRowMeta.addValueMeta(i, vmi);
        }
        ((JsonOutputData)this.data).outputRowMeta.addValueMeta(((JsonOutputMeta)this.meta).getKeyFields().length, (IValueMeta)new ValueMetaString(((JsonOutputMeta)this.meta).getOutputValue()));
        int fieldLength = ((JsonOutputMeta)this.meta).getKeyFields().length + 1;
        if (((JsonOutputMeta)this.meta).getJsonSizeFieldname() != null && ((JsonOutputMeta)this.meta).getJsonSizeFieldname().length() > 0) {
            ((JsonOutputData)this.data).outputRowMeta.addValueMeta(fieldLength, (IValueMeta)new ValueMetaInteger(((JsonOutputMeta)this.meta).getJsonSizeFieldname()));
            ++fieldLength;
        }
        this.initDataFieldsPositionsArray();
        return this.initKeyFieldsPositionArray(r);
    }

    private void initDataFieldsPositionsArray() throws HopException {
        ((JsonOutputData)this.data).nrFields = ((JsonOutputMeta)this.meta).getOutputFields().length;
        ((JsonOutputData)this.data).fieldIndexes = new int[((JsonOutputData)this.data).nrFields];
        block0: for (int i = 0; i < ((JsonOutputData)this.data).nrFields; ++i) {
            ((JsonOutputData)this.data).fieldIndexes[i] = ((JsonOutputData)this.data).inputRowMeta.indexOfValue(((JsonOutputMeta)this.meta).getOutputFields()[i].getFieldName());
            if (((JsonOutputData)this.data).fieldIndexes[i] < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"JsonOutput.Exception.FieldNotFound", (String[])new String[0]));
            }
            JsonOutputField field = ((JsonOutputMeta)this.meta).getOutputFields()[i];
            field.setElementName(this.variables.resolve(field.getElementName()));
            for (JsonOutputKeyField jsonOutputKeyField : ((JsonOutputMeta)this.meta).getKeyFields()) {
                if (!jsonOutputKeyField.getFieldName().equals(field.getFieldName())) continue;
                field.isKeyField = true;
                continue block0;
            }
        }
    }

    private boolean initKeyFieldsPositionArray(Object[] r) {
        ((JsonOutputData)this.data).keysGroupIndexes = new int[((JsonOutputMeta)this.meta).getKeyFields().length];
        for (int i = 0; i < ((JsonOutputMeta)this.meta).getKeyFields().length; ++i) {
            ((JsonOutputData)this.data).keysGroupIndexes[i] = ((JsonOutputData)this.data).inputRowMeta.indexOfValue(((JsonOutputMeta)this.meta).getKeyFields()[i].getFieldName());
            if (r == null || ((JsonOutputData)this.data).keysGroupIndexes[i] >= 0) continue;
            this.setErrors(1L);
            this.stopAll();
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((JsonOutputData)this.data).jsonKeyGroupItems != null) {
            ((JsonOutputData)this.data).jsonKeyGroupItems = null;
        }
        this.closeFile();
        super.dispose();
    }

    private void createParentFolder(String filename) throws HopTransformException {
        if (!((JsonOutputMeta)this.meta).isCreateParentFolder()) {
            return;
        }
        FileObject parentfolder = null;
        try {
            parentfolder = HopVfs.getFileObject((String)filename).getParent();
            if (!parentfolder.exists()) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ParentFolderNotExist", (Object[])new Object[]{parentfolder.getName()}));
                }
                parentfolder.createFolder();
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutput.Log.ParentFolderCreated", (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ErrorCreatingParentFolder", (Object[])new Object[]{parentfolder.getName()}));
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean openNewFile() {
        if (((JsonOutputData)this.data).writer != null) {
            return true;
        }
        boolean retval = false;
        try {
            OutputStream fos;
            String filename = this.buildFilename();
            this.createParentFolder(filename);
            if (((JsonOutputMeta)this.meta).addToResult()) {
                ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filename), this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"JsonOutput.ResultFilenames.Comment", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            OutputStream outputStream = fos = HopVfs.getOutputStream((String)filename, (boolean)((JsonOutputMeta)this.meta).isFileAppended());
            ((JsonOutputData)this.data).writer = !Utils.isEmpty((CharSequence)((JsonOutputMeta)this.meta).getEncoding()) ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream, 5000), this.resolve(((JsonOutputMeta)this.meta).getEncoding())) : new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JsonOutput.FileOpened", (String[])new String[]{filename}));
            }
            ++((JsonOutputData)this.data).splitnr;
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpeningFile", (String[])new String[]{e.toString()}));
        }
        return retval;
    }

    public String buildFilename() {
        return ((JsonOutputMeta)this.meta).buildFilename(this.variables, "" + this.getCopy(), null, "" + ((JsonOutputData)this.data).splitnr, false);
    }

    private boolean closeFile() {
        if (((JsonOutputData)this.data).writer == null) {
            return true;
        }
        boolean retval = false;
        try {
            ((JsonOutputData)this.data).writer.close();
            ((JsonOutputData)this.data).writer = null;
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ClosingFile", (String[])new String[]{e.toString()}));
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }
}

