/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.functions;

import java.util.Collections;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalProcessAllWindowContext;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.Collector;

public final class InternalSingleValueProcessAllWindowFunction<IN, OUT, W extends Window>
extends WrappingFunction<ProcessAllWindowFunction<IN, OUT, W>>
implements InternalWindowFunction<IN, OUT, Byte, W> {
    private static final long serialVersionUID = 1L;
    private transient InternalProcessAllWindowContext<IN, OUT, W> ctx;

    public InternalSingleValueProcessAllWindowFunction(ProcessAllWindowFunction<IN, OUT, W> wrappedFunction) {
        super(wrappedFunction);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        ProcessAllWindowFunction wrappedFunction = (ProcessAllWindowFunction)this.wrappedFunction;
        this.ctx = new InternalProcessAllWindowContext(wrappedFunction);
    }

    @Override
    public void process(Byte key, W window, InternalWindowFunction.InternalWindowContext context, IN input, Collector<OUT> out) throws Exception {
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessAllWindowFunction wrappedFunction = (ProcessAllWindowFunction)this.wrappedFunction;
        wrappedFunction.process(this.ctx, Collections.singletonList(input), out);
    }

    @Override
    public void clear(W window, InternalWindowFunction.InternalWindowContext context) throws Exception {
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessAllWindowFunction wrappedFunction = (ProcessAllWindowFunction)this.wrappedFunction;
        wrappedFunction.clear(this.ctx);
    }

    public RuntimeContext getRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }

    public IterationRuntimeContext getIterationRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }
}

