/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.operators.sort.MultiInputSortingDataInput;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.MultipleInputSelectionHandler;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.io.StreamMultipleInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamOneInputProcessor;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.streaming.runtime.io.StreamTaskNetworkInputFactory;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.metrics.WatermarkGauge;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;
import org.apache.flink.streaming.runtime.watermarkstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

public class StreamTwoInputProcessorFactory {
    public static <IN1, IN2> StreamMultipleInputProcessor create(TaskInvokable ownerTask, CheckpointedInputGate[] checkpointedInputGates, IOManager ioManager, MemoryManager memoryManager, TaskIOMetricGroup taskIOMetricGroup, TwoInputStreamOperator<IN1, IN2, ?> streamOperator, WatermarkGauge input1WatermarkGauge, WatermarkGauge input2WatermarkGauge, OperatorChain<?, ?> operatorChain, StreamConfig streamConfig, Configuration taskManagerConfig, Configuration jobConfig, ExecutionConfig executionConfig, ClassLoader userClassloader, Counter numRecordsIn, InflightDataRescalingDescriptor inflightDataRescalingDescriptor, Function<Integer, StreamPartitioner<?>> gatePartitioners, TaskInfo taskInfo) {
        Preconditions.checkNotNull(operatorChain);
        taskIOMetricGroup.reuseRecordsInputCounter(numRecordsIn);
        TypeSerializer typeSerializer1 = streamConfig.getTypeSerializerIn(0, userClassloader);
        StreamTaskInput<Object> input1 = StreamTaskNetworkInputFactory.create(checkpointedInputGates[0], typeSerializer1, ioManager, new StatusWatermarkValve(checkpointedInputGates[0].getNumberOfInputChannels()), 0, inflightDataRescalingDescriptor, gatePartitioners, taskInfo);
        TypeSerializer typeSerializer2 = streamConfig.getTypeSerializerIn(1, userClassloader);
        StreamTaskInput<Object> input2 = StreamTaskNetworkInputFactory.create(checkpointedInputGates[1], typeSerializer2, ioManager, new StatusWatermarkValve(checkpointedInputGates[1].getNumberOfInputChannels()), 1, inflightDataRescalingDescriptor, gatePartitioners, taskInfo);
        InputSelectable inputSelectable = streamOperator instanceof InputSelectable ? (InputSelectable)((Object)streamOperator) : null;
        StreamConfig.InputConfig[] inputConfigs = streamConfig.getInputs(userClassloader);
        boolean input1IsSorted = StreamConfig.requiresSorting(inputConfigs[0]);
        boolean input2IsSorted = StreamConfig.requiresSorting(inputConfigs[1]);
        if (input1IsSorted || input2IsSorted) {
            if (inputSelectable != null) {
                throw new IllegalStateException("The InputSelectable interface is not supported with sorting inputs");
            }
            ArrayList sortedTaskInputs = new ArrayList();
            ArrayList keySelectors = new ArrayList();
            ArrayList passThroughTaskInputs = new ArrayList();
            if (input1IsSorted) {
                sortedTaskInputs.add(input1);
                keySelectors.add(streamConfig.getStatePartitioner(0, userClassloader));
            } else {
                passThroughTaskInputs.add(input1);
            }
            if (input2IsSorted) {
                sortedTaskInputs.add(input2);
                keySelectors.add(streamConfig.getStatePartitioner(1, userClassloader));
            } else {
                passThroughTaskInputs.add(input2);
            }
            MultiInputSortingDataInput.SelectableSortingInputs selectableSortingInputs = MultiInputSortingDataInput.wrapInputs(ownerTask, sortedTaskInputs.toArray(new StreamTaskInput[0]), keySelectors.toArray(new KeySelector[0]), new TypeSerializer[]{typeSerializer1, typeSerializer2}, streamConfig.getStateKeySerializer(userClassloader), passThroughTaskInputs.toArray(new StreamTaskInput[0]), memoryManager, ioManager, executionConfig.isObjectReuseEnabled(), streamConfig.getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.OPERATOR, taskManagerConfig, userClassloader), jobConfig, executionConfig);
            inputSelectable = selectableSortingInputs.getInputSelectable();
            StreamTaskInput<?>[] sortedInputs = selectableSortingInputs.getSortedInputs();
            StreamTaskInput<?>[] passThroughInputs = selectableSortingInputs.getPassThroughInputs();
            input1 = input1IsSorted ? StreamTwoInputProcessorFactory.toTypedInput(sortedInputs[0]) : StreamTwoInputProcessorFactory.toTypedInput(passThroughInputs[0]);
            input2 = input2IsSorted ? StreamTwoInputProcessorFactory.toTypedInput(sortedInputs[sortedInputs.length - 1]) : StreamTwoInputProcessorFactory.toTypedInput(passThroughInputs[passThroughInputs.length - 1]);
        }
        FinishedOnRestoreWatermarkBypass watermarkBypass = operatorChain.isTaskDeployedAsFinished() ? new FinishedOnRestoreWatermarkBypass(operatorChain.getStreamOutputs()) : null;
        StreamTaskNetworkOutput output1 = new StreamTaskNetworkOutput(streamOperator, record -> StreamTwoInputProcessorFactory.processRecord1(record, streamOperator), input1WatermarkGauge, 0, numRecordsIn, watermarkBypass);
        StreamOneInputProcessor processor1 = new StreamOneInputProcessor(input1, output1, operatorChain);
        StreamTaskNetworkOutput output2 = new StreamTaskNetworkOutput(streamOperator, record -> StreamTwoInputProcessorFactory.processRecord2(record, streamOperator), input2WatermarkGauge, 1, numRecordsIn, watermarkBypass);
        StreamOneInputProcessor processor2 = new StreamOneInputProcessor(input2, output2, operatorChain);
        return new StreamMultipleInputProcessor(new MultipleInputSelectionHandler(inputSelectable, 2), new StreamOneInputProcessor[]{processor1, processor2});
    }

    private static <IN1> StreamTaskInput<IN1> toTypedInput(StreamTaskInput<?> multiInput) {
        return multiInput;
    }

    private static <T> void processRecord1(StreamRecord<T> record, TwoInputStreamOperator<T, ?, ?> streamOperator) throws Exception {
        streamOperator.setKeyContextElement1(record);
        streamOperator.processElement1(record);
    }

    private static <T> void processRecord2(StreamRecord<T> record, TwoInputStreamOperator<?, T, ?> streamOperator) throws Exception {
        streamOperator.setKeyContextElement2(record);
        streamOperator.processElement2(record);
    }

    private static class FinishedOnRestoreWatermarkBypass {
        private final RecordWriterOutput<?>[] streamOutputs;
        private boolean receivedFirstMaxWatermark;
        private boolean receivedSecondMaxWatermark;

        public FinishedOnRestoreWatermarkBypass(RecordWriterOutput<?>[] streamOutputs) {
            this.streamOutputs = streamOutputs;
        }

        public void processWatermark1(Watermark watermark) {
            this.receivedFirstMaxWatermark = true;
            this.checkAndForward(watermark);
        }

        public void processWatermark2(Watermark watermark) {
            this.receivedSecondMaxWatermark = true;
            this.checkAndForward(watermark);
        }

        private void checkAndForward(Watermark watermark) {
            if (watermark.getTimestamp() != Watermark.MAX_WATERMARK.getTimestamp()) {
                throw new IllegalStateException(String.format("We should not receive any watermarks [%s] other than the MAX_WATERMARK if finished on restore", watermark));
            }
            if (this.receivedFirstMaxWatermark && this.receivedSecondMaxWatermark) {
                for (RecordWriterOutput<?> streamOutput : this.streamOutputs) {
                    streamOutput.emitWatermark(watermark);
                }
            }
        }
    }

    private static class StreamTaskNetworkOutput<T>
    implements PushingAsyncDataInput.DataOutput<T> {
        private final TwoInputStreamOperator<?, ?, ?> operator;
        private final ThrowingConsumer<StreamRecord<T>, Exception> recordConsumer;
        private final WatermarkGauge inputWatermarkGauge;
        private final int inputIndex;
        private final Counter numRecordsIn;
        @Nullable
        private final FinishedOnRestoreWatermarkBypass watermarkBypass;

        private StreamTaskNetworkOutput(TwoInputStreamOperator<?, ?, ?> operator, ThrowingConsumer<StreamRecord<T>, Exception> recordConsumer, WatermarkGauge inputWatermarkGauge, int inputIndex, Counter numRecordsIn, @Nullable FinishedOnRestoreWatermarkBypass watermarkBypass) {
            this.operator = (TwoInputStreamOperator)Preconditions.checkNotNull(operator);
            this.recordConsumer = (ThrowingConsumer)Preconditions.checkNotNull(recordConsumer);
            this.inputWatermarkGauge = (WatermarkGauge)Preconditions.checkNotNull((Object)inputWatermarkGauge);
            this.inputIndex = inputIndex;
            this.numRecordsIn = numRecordsIn;
            this.watermarkBypass = watermarkBypass;
        }

        @Override
        public void emitRecord(StreamRecord<T> record) throws Exception {
            this.numRecordsIn.inc();
            this.recordConsumer.accept(record);
        }

        @Override
        public void emitWatermark(Watermark watermark) throws Exception {
            this.inputWatermarkGauge.setCurrentWatermark(watermark.getTimestamp());
            if (this.inputIndex == 0) {
                if (this.watermarkBypass == null) {
                    this.operator.processWatermark1(watermark);
                } else {
                    this.watermarkBypass.processWatermark1(watermark);
                }
            } else if (this.watermarkBypass == null) {
                this.operator.processWatermark2(watermark);
            } else {
                this.watermarkBypass.processWatermark2(watermark);
            }
        }

        @Override
        public void emitWatermarkStatus(WatermarkStatus watermarkStatus) throws Exception {
            if (this.inputIndex == 0) {
                this.operator.processWatermarkStatus1(watermarkStatus);
            } else {
                this.operator.processWatermarkStatus2(watermarkStatus);
            }
        }

        @Override
        public void emitLatencyMarker(LatencyMarker latencyMarker) throws Exception {
            if (this.inputIndex == 0) {
                this.operator.processLatencyMarker1(latencyMarker);
            } else {
                this.operator.processLatencyMarker2(latencyMarker);
            }
        }
    }
}

