/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.testing.DataSetCsvUtil;
import org.apache.hop.testing.DataSetField;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;
import org.apache.hop.testing.PipelineUnitTestSetLocation;

@HopMetadata(key="dataset", name="i18n::DataSet.name", description="i18n::DataSet.description", image="dataset.svg", documentationUrl="/metadata-types/data-set.html")
public class DataSet
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    public static final String VARIABLE_HOP_DATASETS_FOLDER = "HOP_DATASETS_FOLDER";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty(key="folder_name")
    private String folderName;
    @HopMetadataProperty(key="base_filename")
    private String baseFilename = "data-set-filename.csv";
    @HopMetadataProperty(key="dataset_fields")
    private List<DataSetField> fields = new ArrayList<DataSetField>();

    public DataSet() {
    }

    public DataSet(String name, String description, String folderName, String baseFilename, List<DataSetField> fields) {
        this();
        this.name = name;
        this.description = description;
        this.folderName = folderName;
        this.baseFilename = baseFilename;
        this.fields = fields;
    }

    public IRowMeta getSetRowMeta() throws HopPluginException {
        RowMeta rowMeta = new RowMeta();
        for (DataSetField field : this.getFields()) {
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)field.getFieldName(), (int)field.getType(), (int)field.getLength(), (int)field.getPrecision());
            valueMeta.setComments(field.getComment());
            valueMeta.setConversionMask(field.getFormat());
            rowMeta.addValueMeta(valueMeta);
        }
        return rowMeta;
    }

    public DataSetField findFieldWithName(String fieldName) {
        for (DataSetField field : this.fields) {
            if (!field.getFieldName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    public int indexOfField(String fieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            DataSetField field = this.fields.get(i);
            if (!field.getFieldName().equalsIgnoreCase(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public List<Object[]> getAllRows(IVariables variables, ILogChannel log, PipelineUnitTestSetLocation location) throws HopException {
        return DataSetCsvUtil.getAllRows(variables, log, this, location);
    }

    public List<Object[]> getAllRows(IVariables variables, ILogChannel log) throws HopException {
        return DataSetCsvUtil.getAllRows(variables, this);
    }

    public IRowMeta getMappedDataSetFieldsRowMeta(PipelineUnitTestSetLocation location) throws HopPluginException {
        IRowMeta setRowMeta = this.getSetRowMeta();
        RowMeta rowMeta = new RowMeta();
        for (PipelineUnitTestFieldMapping fieldMapping : location.getFieldMappings()) {
            IValueMeta valueMeta = setRowMeta.searchValueMeta(fieldMapping.getDataSetFieldName());
            rowMeta.addValueMeta(valueMeta);
        }
        return rowMeta;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    public String getBaseFilename() {
        return this.baseFilename;
    }

    public void setBaseFilename(String baseFilename) {
        this.baseFilename = baseFilename;
    }

    public List<DataSetField> getFields() {
        return this.fields;
    }

    public void setFields(List<DataSetField> fields) {
        this.fields = fields;
    }

    public String getActualDataSetFolder(IVariables variables) {
        Object folder = Const.NVL((String)this.folderName, (String)"");
        if (StringUtils.isEmpty((String)folder)) {
            folder = variables.getVariable(VARIABLE_HOP_DATASETS_FOLDER);
        }
        if (!((String)(folder = StringUtils.isEmpty((String)folder) ? "." : variables.resolve((String)folder))).endsWith("/") && !((String)folder).endsWith("\\")) {
            folder = (String)folder + "/";
        }
        return folder;
    }

    public String getActualDataSetFilename(IVariables variables) {
        Object filename = this.getActualDataSetFolder(variables);
        filename = (String)filename + this.baseFilename;
        return filename;
    }
}

