/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.observability.SignalListener;
import org.neo4j.driver.internal.shaded.reactor.core.observability.SignalListenerFactory;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ContextPropagation;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ContextPropagationSupport;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxTapFuseable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;

final class MonoTapFuseable<T, STATE>
extends InternalMonoOperator<T, T>
implements Fuseable {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTapFuseable(Mono<? extends T> source, SignalListenerFactory<T, STATE> tapFactory) {
        super(source);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source);
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) throws Throwable {
        Context ctx;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return null;
        }
        signalListener = ContextPropagationSupport.isContextPropagationAvailable() ? ContextPropagation.contextRestoreForTap(signalListener, actual::currentContext) : signalListener;
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return null;
        }
        try {
            ctx = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            IllegalStateException listenerError = new IllegalStateException("Unable to augment tap Context at subscription via addToContext", e);
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return null;
        }
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new FluxTapFuseable.TapConditionalFuseableSubscriber<T>((Fuseable.ConditionalSubscriber)actual, signalListener, ctx);
        }
        return new FluxTapFuseable.TapFuseableSubscriber<T>(actual, signalListener, ctx);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

