/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.AnnotationMirrors;
import autovalue.shaded.com.google.auto.common.AnnotationValues;
import autovalue.shaded.com.google.auto.common.GeneratedAnnotations;
import autovalue.shaded.com.google.auto.common.MoreElements;
import autovalue.shaded.com.google.auto.common.MoreStreams;
import autovalue.shaded.com.google.auto.common.MoreTypes;
import autovalue.shaded.com.google.auto.common.Visibility;
import autovalue.shaded.com.google.auto.service.AutoService;
import autovalue.shaded.com.google.common.base.Ascii;
import autovalue.shaded.com.google.common.collect.ImmutableCollection;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.kotlinx.metadata.Flag;
import autovalue.shaded.kotlinx.metadata.KmClass;
import autovalue.shaded.kotlinx.metadata.KmConstructor;
import autovalue.shaded.kotlinx.metadata.KmValueParameter;
import autovalue.shaded.kotlinx.metadata.jvm.KotlinClassHeader;
import autovalue.shaded.kotlinx.metadata.jvm.KotlinClassMetadata;
import autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import com.google.auto.value.processor.AnnotationOutput;
import com.google.auto.value.processor.AutoBuilderAnnotationTemplateVars;
import com.google.auto.value.processor.AutoBuilderTemplateVars;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.BuilderMethodClassifierForAutoBuilder;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.ClassNames;
import com.google.auto.value.processor.Executable;
import com.google.auto.value.processor.ForwardingClassGenerator;
import com.google.auto.value.processor.MissingTypes;
import com.google.auto.value.processor.Nullables;
import com.google.auto.value.processor.Reformatter;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.google.auto.value.AutoBuilder"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public class AutoBuilderProcessor
extends AutoValueishProcessor {
    private static final String ALLOW_OPTION = "com.google.auto.value.AutoBuilderIsUnstable";
    private static final String AUTO_ANNOTATION_CLASS_PREFIX = "AutoBuilderAnnotation_";
    private TypeMirror javaLangVoid;
    private static final ElementKind ELEMENT_KIND_RECORD = AutoBuilderProcessor.elementKindRecord();

    public AutoBuilderProcessor() {
        super("com.google.auto.value.AutoBuilder", true);
    }

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of("com.google.auto.value.OmitIdentifiers", ALLOW_OPTION);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.javaLangVoid = this.elementUtils().getTypeElement("java.lang.Void").asType();
    }

    @Override
    void processType(TypeElement autoBuilderType) {
        if (this.processingEnv.getOptions().containsKey(ALLOW_OPTION)) {
            this.errorReporter().reportWarning(autoBuilderType, "The -A%s option is obsolete", ALLOW_OPTION);
        }
        AnnotationMirror autoBuilderAnnotation = AutoBuilderProcessor.getAnnotationMirror(autoBuilderType, "com.google.auto.value.AutoBuilder").get();
        TypeElement ofClass = this.getOfClass(autoBuilderType, autoBuilderAnnotation);
        this.checkModifiersIfNested(ofClass, autoBuilderType, "AutoBuilder ofClass");
        String callMethod = this.findCallMethodValue(autoBuilderAnnotation);
        if (ofClass.getKind() == ElementKind.ANNOTATION_TYPE) {
            this.buildAnnotation(autoBuilderType, ofClass, callMethod);
        } else {
            this.processType(autoBuilderType, ofClass, callMethod);
        }
    }

    private void processType(TypeElement autoBuilderType, TypeElement ofClass, String callMethod) {
        BuilderSpec builderSpec;
        ImmutableSet<ExecutableElement> methods = AutoBuilderProcessor.abstractMethodsIn(MoreElements.getLocalAndInheritedMethods(autoBuilderType, this.typeUtils(), this.elementUtils()));
        Executable executable = this.findExecutable(ofClass, callMethod, autoBuilderType, methods);
        BuilderSpec builderSpec2 = builderSpec = new BuilderSpec(ofClass, this.processingEnv, this.errorReporter());
        Objects.requireNonNull(builderSpec2);
        BuilderSpec.Builder builder = builderSpec2.new BuilderSpec.Builder(autoBuilderType);
        TypeMirror builtType = executable.builtType();
        ImmutableMap<String, String> propertyInitializers = this.propertyInitializers(autoBuilderType, executable);
        Nullables nullables = Nullables.fromMethods(this.processingEnv, methods);
        Optional<BuilderMethodClassifier<VariableElement>> maybeClassifier = BuilderMethodClassifierForAutoBuilder.classify(methods, this.errorReporter(), this.processingEnv, executable, builtType, autoBuilderType, (ImmutableSet<String>)propertyInitializers.keySet(), nullables);
        if (!maybeClassifier.isPresent() || this.errorReporter().errorCount() > 0) {
            return;
        }
        BuilderMethodClassifier<VariableElement> classifier = maybeClassifier.get();
        ImmutableMap<String, String> propertyToGetterName = this.propertyToGetterName(executable, autoBuilderType);
        AutoBuilderTemplateVars vars = new AutoBuilderTemplateVars();
        vars.props = this.propertySet(executable, propertyToGetterName, propertyInitializers, nullables);
        builder.defineVars(vars, classifier);
        vars.identifiers = !this.processingEnv.getOptions().containsKey("com.google.auto.value.OmitIdentifiers");
        String generatedClassName = AutoBuilderProcessor.generatedClassName(autoBuilderType, "AutoBuilder_");
        vars.builderName = TypeSimplifier.simpleNameOf(generatedClassName);
        vars.builtType = TypeEncoder.encode(builtType);
        vars.builderAnnotations = this.copiedClassAnnotations(autoBuilderType);
        Optional<String> forwardingClassName = this.maybeForwardingClass(autoBuilderType, executable);
        vars.build = forwardingClassName.map(n -> TypeSimplifier.simpleNameOf(n) + ".of").orElseGet(executable::invoke);
        vars.toBuilderConstructor = !propertyToGetterName.isEmpty();
        vars.toBuilderMethods = ImmutableList.of();
        this.defineSharedVarsForType(autoBuilderType, ImmutableSet.of(), nullables, vars);
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, autoBuilderType.asType());
        text = Reformatter.fixup(text);
        this.writeSourceFile(generatedClassName, text, autoBuilderType);
        forwardingClassName.ifPresent(n -> this.generateForwardingClass((String)n, executable, builtType, autoBuilderType));
    }

    private void generateForwardingClass(String forwardingClassName, Executable executable, TypeMirror builtType, TypeElement autoBuilderType) {
        ImmutableList.Builder constructorParameters = ImmutableList.builder();
        executable.parameters().stream().map(Element::asType).map(this.typeUtils()::erasure).forEach(constructorParameters::add);
        int bitmaskCount = (executable.optionalParameterCount() + 31) / 32;
        constructorParameters.addAll(Collections.nCopies(bitmaskCount, this.typeUtils().getPrimitiveType(TypeKind.INT)));
        String marker = "kot".concat("lin.jvm.internal.DefaultConstructorMarker");
        constructorParameters.add(this.elementUtils().getTypeElement(marker).asType());
        byte[] classBytes = ForwardingClassGenerator.makeConstructorForwarder(forwardingClassName, builtType, (ImmutableList<TypeMirror>)constructorParameters.build());
        try {
            JavaFileObject trampoline = this.processingEnv.getFiler().createClassFile(forwardingClassName, autoBuilderType);
            try (OutputStream out = trampoline.openOutputStream();){
                out.write(classBytes);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<String> maybeForwardingClass(TypeElement autoBuilderType, Executable executable) {
        return executable.optionalParameterCount() == 0 ? Optional.empty() : Optional.of(AutoBuilderProcessor.generatedClassName(autoBuilderType, "AutoBuilderBridge_"));
    }

    private ImmutableSet<AutoValueishProcessor.Property> propertySet(Executable executable, Map<String, String> propertyToGetterName, ImmutableMap<String, String> builderInitializers, Nullables nullables) {
        Map<VariableElement, String> identifiers = executable.parameters().stream().collect(Collectors.toMap(v -> v, v -> v.getSimpleName().toString()));
        AutoBuilderProcessor.fixReservedIdentifiers(identifiers);
        return executable.parameters().stream().map(v -> {
            String name = v.getSimpleName().toString();
            return this.newProperty((VariableElement)v, (String)identifiers.get(v), (String)propertyToGetterName.get(name), Optional.ofNullable((String)builderInitializers.get(name)), executable.isOptional(name), nullables);
        }).collect(MoreStreams.toImmutableSet());
    }

    private AutoValueishProcessor.Property newProperty(VariableElement var, String identifier, String getterName, Optional<String> builderInitializer, boolean hasDefault, Nullables nullables) {
        String name = var.getSimpleName().toString();
        TypeMirror type = var.asType();
        Optional<String> nullableAnnotation = AutoBuilderProcessor.nullableAnnotationFor(var, var.asType());
        return new AutoValueishProcessor.Property(name, identifier, TypeEncoder.encode(type), type, nullableAnnotation, nullables, getterName, builderInitializer, hasDefault);
    }

    private ImmutableMap<String, String> propertyInitializers(TypeElement autoBuilderType, Executable executable) {
        boolean autoAnnotation = MoreElements.getAnnotationMirror((Element)executable.executableElement(), "com.google.auto.value.AutoAnnotation").isPresent();
        if (!autoAnnotation) {
            return ImmutableMap.of();
        }
        TypeMirror returnType = executable.builtType();
        if (!returnType.getKind().equals((Object)TypeKind.DECLARED)) {
            return ImmutableMap.of();
        }
        TypeElement annotation = MoreTypes.asTypeElement(returnType);
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getEnclosedElements())) {
            AnnotationValue defaultValue = method.getDefaultValue();
            if (defaultValue == null) continue;
            String memberName = method.getSimpleName().toString();
            builder.put(memberName, AnnotationOutput.sourceFormForInitializer(defaultValue, this.processingEnv, memberName, autoBuilderType));
        }
        return builder.build();
    }

    private ImmutableMap<String, String> propertyToGetterName(Executable executable, TypeElement autoBuilderType) {
        TypeMirror builtType = executable.builtType();
        if (builtType.getKind() != TypeKind.DECLARED) {
            return ImmutableMap.of();
        }
        TypeElement type = MoreTypes.asTypeElement(builtType);
        Map nameToMethod = MoreElements.getLocalAndInheritedMethods(type, this.typeUtils(), this.elementUtils()).stream().filter(m -> m.getParameters().isEmpty()).filter(m -> !m.getModifiers().contains((Object)Modifier.STATIC)).filter(m -> this.visibleFrom(autoBuilderType, MoreElements.getPackage(autoBuilderType))).collect(Collectors.toMap(m -> m.getSimpleName().toString(), m -> m, (a, b) -> a, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
        ImmutableMap<String, String> propertyToGetterName = executable.parameters().stream().map(param -> {
            String name = param.getSimpleName().toString();
            ExecutableElement getter = (ExecutableElement)nameToMethod.get(name);
            if (getter == null && (getter = (ExecutableElement)nameToMethod.get("get" + name)) == null && param.asType().getKind() == TypeKind.BOOLEAN) {
                getter = (ExecutableElement)nameToMethod.get("is" + name);
            }
            if (getter != null && !this.typeUtils().isAssignable(getter.getReturnType(), param.asType()) && !MoreTypes.equivalence().equivalent(getter.getReturnType(), param.asType())) {
                getter = null;
            }
            return new AbstractMap.SimpleEntry<String, ExecutableElement>(name, getter);
        }).filter(entry -> entry.getValue() != null).collect(MoreStreams.toImmutableMap(Map.Entry::getKey, entry -> ((ExecutableElement)entry.getValue()).getSimpleName().toString()));
        return propertyToGetterName.size() == executable.parameters().size() ? propertyToGetterName : ImmutableMap.of();
    }

    private Executable findExecutable(TypeElement ofClass, String callMethod, TypeElement autoBuilderType, ImmutableSet<ExecutableElement> methodsInAutoBuilderType) {
        ImmutableList<Executable> executables = this.findRelevantExecutables(ofClass, callMethod, autoBuilderType);
        String description = callMethod.isEmpty() ? "constructor" : "static method named \"" + callMethod + "\"";
        switch (executables.size()) {
            case 0: {
                throw this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderNoVisible] No visible %s for %s", description, ofClass);
            }
            case 1: {
                return (Executable)executables.get(0);
            }
        }
        return this.matchingExecutable(autoBuilderType, executables, methodsInAutoBuilderType, description);
    }

    private ImmutableList<Executable> findRelevantExecutables(TypeElement ofClass, String callMethod, TypeElement autoBuilderType) {
        Optional<AnnotationMirror> kotlinMetadata = this.kotlinMetadataAnnotation(ofClass);
        List<? extends Element> elements = ofClass.getEnclosedElements();
        Stream<Executable> relevantExecutables = callMethod.isEmpty() ? kotlinMetadata.map(a -> this.kotlinConstructorsIn((AnnotationMirror)a, ofClass).stream()).orElseGet(() -> ElementFilter.constructorsIn(elements).stream().map(Executable::of)) : ElementFilter.methodsIn(elements).stream().filter(m -> m.getSimpleName().contentEquals(callMethod)).filter(m -> m.getModifiers().contains((Object)Modifier.STATIC)).map(Executable::of);
        return relevantExecutables.filter(e -> this.visibleFrom(e.executableElement(), MoreElements.getPackage(autoBuilderType))).collect(MoreStreams.toImmutableList());
    }

    private Executable matchingExecutable(TypeElement autoBuilderType, List<Executable> executables, ImmutableSet<ExecutableElement> methodsInAutoBuilderType, String description) {
        ImmutableList matches = executables.stream().filter(x -> this.executableMatches((Executable)x, methodsInAutoBuilderType)).collect(MoreStreams.toImmutableList());
        switch (matches.size()) {
            case 0: {
                throw this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderNoMatch] Property names do not correspond to the parameter names of any %s:\n%s", description, this.executableListString(executables));
            }
            case 1: {
                return (Executable)matches.get(0);
            }
        }
        int max = matches.stream().mapToInt(e -> e.parameters().size()).max().getAsInt();
        ImmutableList<Executable> maxMatches = matches.stream().filter(c -> c.parameters().size() == max).collect(MoreStreams.toImmutableList());
        if (maxMatches.size() > 1) {
            throw this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderAmbiguous] Property names correspond to more than one %s:\n%s", description, this.executableListString(maxMatches));
        }
        return (Executable)maxMatches.get(0);
    }

    private String executableListString(List<Executable> executables) {
        return executables.stream().map(Object::toString).collect(Collectors.joining("\n  ", "  ", ""));
    }

    private boolean executableMatches(Executable executable, ImmutableSet<ExecutableElement> methodsInAutoBuilderType) {
        TreeSet<String> parameterNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        parameterNames.addAll(executable.parameterNames());
        for (ExecutableElement method : methodsInAutoBuilderType) {
            String name = method.getSimpleName().toString();
            if (name.endsWith("Builder")) {
                String property = name.substring(0, name.length() - "Builder".length());
                parameterNames.remove(property);
            }
            if (method.getParameters().size() == 1) {
                parameterNames.remove(name);
                if (name.startsWith("set")) {
                    parameterNames.remove(name.substring(3));
                }
            }
            if (!parameterNames.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean visibleFrom(Element element, PackageElement fromPackage) {
        Visibility visibility2 = Visibility.effectiveVisibilityOfElement(element);
        switch (visibility2) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: 
            case DEFAULT: {
                return MoreElements.getPackage(element).equals(fromPackage);
            }
        }
        return false;
    }

    private Optional<AnnotationMirror> kotlinMetadataAnnotation(Element element) {
        return element.getAnnotationMirrors().stream().filter(a -> MoreTypes.asTypeElement(a.getAnnotationType()).getQualifiedName().contentEquals(ClassNames.KOTLIN_METADATA_NAME)).map(a -> a).findFirst();
    }

    private ImmutableList<Executable> kotlinConstructorsIn(AnnotationMirror metadata, TypeElement ofClass) {
        ImmutableMap<String, AnnotationValue> annotationValues = AnnotationMirrors.getAnnotationValuesWithDefaults(metadata).entrySet().stream().collect(MoreStreams.toImmutableMap(e -> ((ExecutableElement)e.getKey()).getSimpleName().toString(), e -> (AnnotationValue)e.getValue()));
        Map map = ElementFilter.constructorsIn(ofClass.getEnclosedElements()).stream().collect(Collectors.toMap(c -> AutoBuilderProcessor.parameterNames(c), c -> c, (a, b) -> a, LinkedHashMap::new));
        ImmutableMap paramNamesToConstructor = ImmutableMap.copyOf(map);
        KotlinClassHeader header = new KotlinClassHeader((Integer)annotationValues.get("k").getValue(), AutoBuilderProcessor.intArrayValue(annotationValues.get("mv")), AutoBuilderProcessor.stringArrayValue(annotationValues.get("d1")), AutoBuilderProcessor.stringArrayValue(annotationValues.get("d2")), (String)annotationValues.get("xs").getValue(), (String)annotationValues.get("pn").getValue(), (Integer)annotationValues.get("xi").getValue());
        KotlinClassMetadata.Class classMetadata = (KotlinClassMetadata.Class)KotlinClassMetadata.read(header);
        KmClass kmClass = classMetadata.toKmClass();
        ImmutableList.Builder kotlinConstructorsBuilder = ImmutableList.builder();
        for (KmConstructor constructor : kmClass.getConstructors()) {
            ImmutableSet.Builder allBuilder = ImmutableSet.builder();
            ImmutableSet.Builder optionalBuilder = ImmutableSet.builder();
            for (KmValueParameter param : constructor.getValueParameters()) {
                String name = param.getName();
                allBuilder.add(name);
                if (!Flag.ValueParameter.DECLARES_DEFAULT_VALUE.invoke(param.getFlags())) continue;
                optionalBuilder.add(name);
            }
            ImmutableCollection optional = optionalBuilder.build();
            ImmutableCollection all = allBuilder.build();
            ExecutableElement javaConstructor = (ExecutableElement)paramNamesToConstructor.get(all);
            if (javaConstructor == null) continue;
            kotlinConstructorsBuilder.add(Executable.of(javaConstructor, (ImmutableSet<String>)optional));
        }
        return kotlinConstructorsBuilder.build();
    }

    private static int[] intArrayValue(AnnotationValue value) {
        List list = (List)value.getValue();
        return list.stream().mapToInt(v -> (Integer)v.getValue()).toArray();
    }

    private static String[] stringArrayValue(AnnotationValue value) {
        List list = (List)value.getValue();
        return (String[])list.stream().map(AnnotationValue::getValue).toArray(String[]::new);
    }

    private static ImmutableSet<String> parameterNames(ExecutableElement executableElement) {
        return executableElement.getParameters().stream().map(v -> v.getSimpleName().toString()).collect(MoreStreams.toImmutableSet());
    }

    private static ElementKind elementKindRecord() {
        try {
            Field record = ElementKind.class.getField("RECORD");
            return (ElementKind)((Object)record.get(null));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private TypeElement getOfClass(TypeElement autoBuilderType, AnnotationMirror autoBuilderAnnotation) {
        TypeElement ofClassValue = this.findOfClassValue(autoBuilderAnnotation);
        boolean isDefault = this.typeUtils().isSameType(ofClassValue.asType(), this.javaLangVoid);
        if (!isDefault) {
            return ofClassValue;
        }
        Element enclosing = autoBuilderType.getEnclosingElement();
        ElementKind enclosingKind = enclosing.getKind();
        if (enclosing.getKind() != ElementKind.CLASS && enclosingKind != ELEMENT_KIND_RECORD) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderEnclosing] @AutoBuilder must specify ofClass=Something.class or it must be nested inside the class to be built; actually nested inside %s %s.", Ascii.toLowerCase(enclosingKind.name()), enclosing);
        }
        return MoreElements.asType(enclosing);
    }

    private TypeElement findOfClassValue(AnnotationMirror autoBuilderAnnotation) {
        AnnotationValue ofClassValue = AnnotationMirrors.getAnnotationValue(autoBuilderAnnotation, "ofClass");
        Object value = ofClassValue.getValue();
        if (value instanceof TypeMirror) {
            TypeMirror ofClassType = (TypeMirror)value;
            switch (ofClassType.getKind()) {
                case DECLARED: {
                    return MoreTypes.asTypeElement(ofClassType);
                }
                case ERROR: {
                    throw new MissingTypes.MissingTypeException(MoreTypes.asError(ofClassType));
                }
            }
        }
        throw new MissingTypes.MissingTypeException(null);
    }

    private String findCallMethodValue(AnnotationMirror autoBuilderAnnotation) {
        AnnotationValue callMethodValue = AnnotationMirrors.getAnnotationValue(autoBuilderAnnotation, "callMethod");
        return AnnotationValues.getString(callMethodValue);
    }

    @Override
    Optional<String> nullableAnnotationForMethod(ExecutableElement propertyMethod) {
        return Optional.empty();
    }

    private void buildAnnotation(TypeElement autoBuilderType, TypeElement annotationType, String callMethod) {
        if (!callMethod.isEmpty()) {
            this.errorReporter().abortWithError(autoBuilderType, "[AutoBuilderAnnotationMethod] @AutoBuilder for an annotation must have an empty callMethod, not \"%s\"", callMethod);
        }
        String autoAnnotationClassName = AutoBuilderProcessor.generatedClassName(autoBuilderType, AUTO_ANNOTATION_CLASS_PREFIX);
        TypeElement autoAnnotationClass = this.elementUtils().getTypeElement(autoAnnotationClassName);
        if (autoAnnotationClass != null) {
            this.processType(autoBuilderType, autoAnnotationClass, "newAnnotation");
            return;
        }
        AutoBuilderAnnotationTemplateVars vars = new AutoBuilderAnnotationTemplateVars();
        vars.autoBuilderType = TypeEncoder.encode(autoBuilderType.asType());
        vars.props = this.annotationBuilderPropertySet(annotationType);
        vars.pkg = TypeSimplifier.packageNameOf(autoBuilderType);
        vars.generated = GeneratedAnnotations.generatedAnnotation(this.elementUtils(), this.processingEnv.getSourceVersion()).map(annotation -> TypeEncoder.encode(annotation.asType())).orElse("");
        vars.className = TypeSimplifier.simpleNameOf(autoAnnotationClassName);
        vars.annotationType = TypeEncoder.encode(annotationType.asType());
        String text = vars.toText();
        text = TypeEncoder.decode(text, this.processingEnv, vars.pkg, this.javaLangVoid);
        text = Reformatter.fixup(text);
        this.writeSourceFile(autoAnnotationClassName, text, autoBuilderType);
        this.addDeferredType(autoBuilderType, autoAnnotationClassName);
    }

    private ImmutableSet<AutoValueishProcessor.Property> annotationBuilderPropertySet(TypeElement annotationType) {
        Nullables nullables = Nullables.fromMethods(this.processingEnv, ImmutableList.of());
        return ElementFilter.methodsIn(annotationType.getEnclosedElements()).stream().filter(m -> m.getParameters().isEmpty() && !m.getModifiers().contains((Object)Modifier.STATIC)).map(method -> AutoBuilderProcessor.annotationBuilderProperty(method, nullables)).collect(MoreStreams.toImmutableSet());
    }

    private static AutoValueishProcessor.Property annotationBuilderProperty(ExecutableElement annotationMethod, Nullables nullables) {
        String name = annotationMethod.getSimpleName().toString();
        TypeMirror type = annotationMethod.getReturnType();
        return new AutoValueishProcessor.Property(name, name, TypeEncoder.encode(type), type, Optional.empty(), nullables, "", Optional.empty(), false);
    }
}

