/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execprocess;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessData;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessMeta;
import org.apache.hop.pipeline.transforms.execprocess.ProcessResult;

public class ExecProcess
extends BaseTransform<ExecProcessMeta, ExecProcessData> {
    private static final Class<?> PKG = ExecProcessMeta.class;
    public static final String CONST_EXEC_PROCESS_EXCEPTION_COULD_NOT_FIND_FIELD = "ExecProcess.Exception.CouldNotFindField";
    private boolean killing;
    private CountDownLatch waitForLatch;

    public ExecProcess(TransformMeta transformMeta, ExecProcessMeta meta, ExecProcessData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.initializeAndLookup();
        }
        Object[] outputRow = RowDataUtil.createResizedCopy((Object[])r, (int)((ExecProcessData)this.data).outputRowMeta.size());
        String processString = this.getInputRowMeta().getString(r, ((ExecProcessData)this.data).indexOfProcess);
        if (StringUtils.isEmpty((String)processString)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ExecProcess.ProcessEmpty", (String[])new String[0]));
        }
        ProcessResult processResult = new ProcessResult();
        try {
            if (((ExecProcessMeta)this.meta).isArgumentsInFields()) {
                ArrayList<String> cmdArray = new ArrayList<String>();
                cmdArray.add(processString);
                for (int argumentIndex : ((ExecProcessData)this.data).argumentIndexes) {
                    String argString = this.getInputRowMeta().getString(r, argumentIndex);
                    cmdArray.add(Const.NVL((String)argString, (String)""));
                }
                this.execProcess(cmdArray.toArray(new String[0]), processResult);
            } else {
                this.execProcess(processString, processResult);
            }
            if (((ExecProcessMeta)this.meta).isFailWhenNotSuccess() && processResult.getExistStatus() != 0L) {
                String errorString = processResult.getErrorStream();
                if (StringUtils.isEmpty((String)errorString)) {
                    errorString = processResult.getOutputStream();
                }
                throw new HopException(errorString);
            }
            int rowIndex = this.getInputRowMeta().size();
            outputRow[rowIndex++] = processResult.getOutputStream();
            outputRow[rowIndex++] = processResult.getErrorStream();
            outputRow[rowIndex] = processResult.getExistStatus();
            this.putRow(((ExecProcessData)this.data).outputRowMeta, outputRow);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"ExecProcess.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
            }
        }
        catch (HopException e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.toString(), ((ExecProcessMeta)this.meta).getResultFieldName(), "ExecProcess001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void initializeAndLookup() throws HopException {
        ((ExecProcessData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        ((ExecProcessMeta)this.meta).getFields(((ExecProcessData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        if (StringUtils.isEmpty((String)((ExecProcessMeta)this.meta).getProcessField())) {
            this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ProcessFieldMissing", (String[])new String[0]));
            throw new HopException(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ProcessFieldMissing", (String[])new String[0]));
        }
        if (((ExecProcessData)this.data).indexOfProcess < 0) {
            ((ExecProcessData)this.data).indexOfProcess = this.getInputRowMeta().indexOfValue(((ExecProcessMeta)this.meta).getProcessField());
            if (((ExecProcessData)this.data).indexOfProcess < 0) {
                this.logError(BaseMessages.getString(PKG, (String)CONST_EXEC_PROCESS_EXCEPTION_COULD_NOT_FIND_FIELD, (String[])new String[0]) + "[" + ((ExecProcessMeta)this.meta).getProcessField() + "]");
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_EXEC_PROCESS_EXCEPTION_COULD_NOT_FIND_FIELD, (String[])new String[]{((ExecProcessMeta)this.meta).getProcessField()}));
            }
        }
        if (((ExecProcessMeta)this.meta).isArgumentsInFields() && ((ExecProcessData)this.data).argumentIndexes == null) {
            ((ExecProcessData)this.data).argumentIndexes = new ArrayList<Integer>();
            for (ExecProcessMeta.EPField field : ((ExecProcessMeta)this.meta).getArgumentFields()) {
                String fieldName = field.getName();
                int argumentIndex = this.getInputRowMeta().indexOfValue(fieldName);
                if (argumentIndex < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)CONST_EXEC_PROCESS_EXCEPTION_COULD_NOT_FIND_FIELD, (String[])new String[0]) + "[" + fieldName + "]");
                    throw new HopException(BaseMessages.getString(PKG, (String)CONST_EXEC_PROCESS_EXCEPTION_COULD_NOT_FIND_FIELD, (String[])new String[]{fieldName}));
                }
                ((ExecProcessData)this.data).argumentIndexes.add(argumentIndex);
            }
        }
    }

    public void stopRunning() throws HopException {
        if (this.waitForLatch != null) {
            this.killing = true;
            try {
                this.waitForLatch.await();
            }
            catch (InterruptedException e) {
                throw new HopException("Interrupted exception while kill the process", (Throwable)e);
            }
        }
    }

    private void execProcess(String process, ProcessResult processresult) throws HopException {
        this.execProcess(new String[]{process}, processresult);
    }

    private void execProcess(String[] process, ProcessResult processresult) throws HopException {
        Process p = null;
        this.waitForLatch = new CountDownLatch(1);
        try {
            String errorMsg = null;
            try {
                p = !((ExecProcessMeta)this.meta).isArgumentsInFields() ? ((ExecProcessData)this.data).runtime.exec(process[0]) : ((ExecProcessData)this.data).runtime.exec(process);
            }
            catch (Exception e) {
                errorMsg = e.getMessage();
            }
            if (p == null) {
                processresult.setErrorStream(errorMsg);
            } else {
                IOException exception;
                CompletionStage future = p.onExit().thenApply(processRef -> {
                    try {
                        processresult.setOutputStream(this.getOutputString(new BufferedReader(new InputStreamReader(processRef.getInputStream()))));
                        processresult.setErrorStream(this.getOutputString(new BufferedReader(new InputStreamReader(processRef.getErrorStream()))));
                    }
                    catch (IOException e) {
                        return e;
                    }
                    return null;
                });
                while (true) {
                    try {
                        exception = (IOException)((CompletableFuture)future).get(1L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException ignore) {
                        if (!this.killing) continue;
                        p.children().forEach(ProcessHandle::destroy);
                        if (p.isAlive()) {
                            p.destroy();
                        }
                        exception = (IOException)((CompletableFuture)future).get();
                        this.logMinimal(BaseMessages.getString(PKG, (String)"ExecProcess.AbortProcess", (String[])new String[0]));
                    }
                    break;
                }
                if (exception != null) {
                    throw exception;
                }
                processresult.setExistStatus(p.exitValue());
            }
        }
        catch (IOException ioe) {
            throw new HopException("IO exception while running the process " + Arrays.toString(process) + "!", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new HopException("Interrupted exception while running the process " + Arrays.toString(process) + "!", (Throwable)ie);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (this.killing || this.waitForLatch.getCount() > 0L) {
                this.waitForLatch.countDown();
                this.killing = false;
            }
            if (p != null) {
                p.destroy();
            }
        }
    }

    private String getOutputString(BufferedReader b) throws IOException {
        String line;
        StringBuilder returnValueBuffer = new StringBuilder();
        String delim = ((ExecProcessMeta)this.meta).getOutputLineDelimiter();
        delim = delim == null ? "" : this.resolve(delim);
        while ((line = b.readLine()) != null) {
            if (returnValueBuffer.length() > 0) {
                returnValueBuffer.append(delim);
            }
            returnValueBuffer.append(line);
        }
        return returnValueBuffer.toString();
    }

    public boolean init() {
        if (super.init()) {
            if (StringUtils.isEmpty((String)((ExecProcessMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            ((ExecProcessData)this.data).runtime = Runtime.getRuntime();
            return true;
        }
        return false;
    }
}

