/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.Materialization;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Ints;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.checker.nullness.qual.EnsuresKeyFor;
import org.checkerframework.checker.nullness.qual.EnsuresKeyForIf;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public class PCollectionViews {
    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<T> singletonView(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized boolean hasDefault, @Nullable T defaultValue, @UnknownKeyFor @NonNull @Initialized Coder<T> defaultValueCoder) {
        return new SimplePCollectionView(pCollection, new SingletonViewFn2(hasDefault, defaultValue, defaultValueCoder, typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<T> singletonViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, T>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized boolean hasDefault, @Nullable T defaultValue, @UnknownKeyFor @NonNull @Initialized Coder<T> defaultValueCoder) {
        return new SimplePCollectionView(pCollection, tag, new SingletonViewFn(hasDefault, defaultValue, defaultValueCoder, typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Iterable<T>> iterableView(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new IterableViewFn2<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Iterable<T>> iterableViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, T>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new IterableViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> listView(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new IterableBackedListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> inMemoryListView(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new InMemoryListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> listView(@UnknownKeyFor @NonNull @Initialized PCollection<T> pCollection, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T>> tag, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new IterableBackedListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> listViewWithRandomAccess(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new ListViewFn2<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> listViewWithRandomAccess(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>>> pCollection, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>>> tag, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new ListViewFn2<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> listViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, T>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new ListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> listViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, T>> pCollection, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> tag, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new ListViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> inMemoryListViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, T>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new InMemoryListFromMultimapViewFn<T>(typeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> mapView(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new MapViewFn2<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> inMemoryMapView(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new InMemoryMapViewFn<K, V>(keyCoder, valueCoder), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> mapViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new MapViewFn<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> inMemoryMapViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> pCollection, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new InMemoryMapFromVoidKeyViewFn<K, V>(keyCoder, valueCoder), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> multimapView(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new MultimapViewFn2<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> inMemoryMultimapView(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> pCollection, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new InMemoryMultimapViewFn<K, V>(keyCoder, valueCoder), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    @Deprecated
    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> multimapViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> pCollection, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, tag, new MultimapViewFn<K, V>(keyTypeDescriptorSupplier, valueTypeDescriptorSupplier), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> inMemoryMultimapViewUsingVoidKey(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> pCollection, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new InMemoryMultimapFromVoidKeyViewFn<K, V>(keyCoder, valueCoder), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> toAdditionalInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views) {
        ImmutableMap.Builder<TupleTag<?>, PCollection<?>> additionalInputs = ImmutableMap.builder();
        for (PCollectionView<?> view : views) {
            additionalInputs.put(view.getTagInternal(), view.getPCollection());
        }
        return additionalInputs.build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Integer> computeOverlappingRanges(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized OffsetRange> ranges) {
        OffsetRange current;
        ImmutableSortedMap.Builder rval = ImmutableSortedMap.orderedBy(OffsetRangeComparator.INSTANCE);
        ArrayList<OffsetRange> sortedRanges = Lists.newArrayList(ranges);
        if (sortedRanges.isEmpty()) {
            return rval.build();
        }
        Collections.sort(sortedRanges, OffsetRangeComparator.INSTANCE);
        PriorityQueue<OffsetRange> rangesWithSameFrom = new PriorityQueue<OffsetRange>(OffsetRangeComparator.INSTANCE);
        Iterator iterator = sortedRanges.iterator();
        ArrayList<OffsetRange> rangesToProcess = new ArrayList<OffsetRange>();
        while (iterator.hasNext()) {
            current = (OffsetRange)iterator.next();
            if (current.getFrom() == current.getTo()) continue;
            while (!rangesWithSameFrom.isEmpty() && rangesWithSameFrom.peek().getFrom() != current.getFrom()) {
                int i;
                rangesToProcess.addAll(rangesWithSameFrom);
                Collections.sort(rangesToProcess, OffsetRangeComparator.INSTANCE);
                rangesWithSameFrom.clear();
                long lastTo = ((OffsetRange)rangesToProcess.get(i)).getFrom();
                for (i = 0; i < rangesToProcess.size() && ((OffsetRange)rangesToProcess.get(i)).getTo() <= current.getFrom(); ++i) {
                    if (i != 0 && ((OffsetRange)rangesToProcess.get(i - 1)).getTo() == ((OffsetRange)rangesToProcess.get(i)).getTo()) continue;
                    rval.put(new OffsetRange(lastTo, ((OffsetRange)rangesToProcess.get(i)).getTo()), (Object)(rangesToProcess.size() - i));
                    lastTo = ((OffsetRange)rangesToProcess.get(i)).getTo();
                }
                if (lastTo < current.getFrom() && i != rangesToProcess.size()) {
                    rval.put(new OffsetRange(lastTo, current.getFrom()), (Object)(rangesToProcess.size() - i));
                }
                while (i < rangesToProcess.size()) {
                    rangesWithSameFrom.add(new OffsetRange(current.getFrom(), ((OffsetRange)rangesToProcess.get(i)).getTo()));
                    ++i;
                }
                rangesToProcess.clear();
            }
            rangesWithSameFrom.add(current);
        }
        while (!rangesWithSameFrom.isEmpty()) {
            current = (OffsetRange)rangesWithSameFrom.remove();
            rangesToProcess.addAll(rangesWithSameFrom);
            Collections.sort(rangesToProcess, OffsetRangeComparator.INSTANCE);
            rangesWithSameFrom.clear();
            rval.put(current, (Object)(rangesToProcess.size() + 1));
            for (OffsetRange rangeWithDifferentFrom : rangesToProcess) {
                if (rangeWithDifferentFrom.getTo() <= current.getTo()) continue;
                rangesWithSameFrom.add(new OffsetRange(current.getTo(), rangeWithDifferentFrom.getTo()));
            }
            rangesToProcess.clear();
        }
        return rval.build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized int computeTotalNumElements(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Integer> nonOverlappingRangesToNumElementsPerPosition) {
        long sum = 0L;
        for (Map.Entry<OffsetRange, Integer> range : nonOverlappingRangesToNumElementsPerPosition.entrySet()) {
            sum += Math.multiplyExact(Math.subtractExact(range.getKey().getTo(), range.getKey().getFrom()), (long)range.getValue().intValue());
        }
        return Ints.checkedCast(sum);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Integer> computePositionForIndex(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Integer> nonOverlappingRangesToNumElementsPerPosition, @UnknownKeyFor @NonNull @Initialized int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("Position %s was out of bounds for ranges %s.", index, nonOverlappingRangesToNumElementsPerPosition));
        }
        for (Map.Entry<OffsetRange, Integer> range : nonOverlappingRangesToNumElementsPerPosition.entrySet()) {
            int numElementsInRange = Ints.checkedCast(Math.multiplyExact(Math.subtractExact(range.getKey().getTo(), range.getKey().getFrom()), (long)range.getValue().intValue()));
            if (numElementsInRange <= index) {
                index -= numElementsInRange;
                continue;
            }
            long position = range.getKey().getFrom() + (long)(index / range.getValue());
            int subPosition = index % range.getValue();
            return KV.of(position, subPosition);
        }
        throw new IndexOutOfBoundsException(String.format("Position %s was out of bounds for ranges %s.", index, nonOverlappingRangesToNumElementsPerPosition));
    }

    private static class MultimapViewToMultimapAdapter<@UnknownKeyFor K, @UnknownKeyFor V>
    extends AbstractMap<K, Iterable<V>> {
        private final @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> primitiveViewT;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> size;

        private MultimapViewToMultimapAdapter(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> primitiveViewT) {
            this.primitiveViewT = primitiveViewT;
            this.size = Suppliers.memoize(() -> Iterables.size(primitiveViewT.get()));
        }

        @Override
        @EnsuresKeyForIf(expression={"#1"}, result=true, map={"this"})
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean containsKey(@UnknownKeyFor @NonNull @Initialized Object key) {
            return this.primitiveViewT.get(key).iterator().hasNext();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(@UnknownKeyFor @NonNull @Initialized Object key) {
            Iterable<V> values = this.primitiveViewT.get(key);
            if (values.iterator().hasNext()) {
                return values;
            }
            return null;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int size() {
            return this.size.get();
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Map.Entry<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> entrySet() {
            return new AbstractSet<Map.Entry<K, Iterable<V>>>(){

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Map.Entry<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> iterator() {
                    return FluentIterable.from(primitiveViewT.get()).transform(key -> new AbstractMap.SimpleEntry(key, primitiveViewT.get(key))).iterator();
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    if (!(entry.getValue() instanceof Iterable)) {
                        return false;
                    }
                    Iterable value = primitiveViewT.get(entry.getKey());
                    if (value.iterator().hasNext()) {
                        return false;
                    }
                    return Iterables.elementsEqual((Iterable)entry.getValue(), value);
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int size() {
                    return (Integer)size.get();
                }
            };
        }
    }

    private static class MultimapViewToMapAdapter<@UnknownKeyFor K, @UnknownKeyFor V>
    extends AbstractMap<K, V> {
        private final @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> primitiveViewT;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> size;

        private MultimapViewToMapAdapter(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> primitiveViewT) {
            this.primitiveViewT = primitiveViewT;
            this.size = Suppliers.memoize(() -> Iterables.size(primitiveViewT.get()));
        }

        @Override
        @EnsuresKeyForIf(expression={"#1"}, result=true, map={"this"})
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean containsKey(@UnknownKeyFor @NonNull @Initialized Object key) {
            return this.primitiveViewT.get(key).iterator().hasNext();
        }

        @Override
        @Pure
        public V get(@UnknownKeyFor @NonNull @Initialized Object key) {
            Iterator<V> iterator = this.primitiveViewT.get(key).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            V value = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("Duplicate values for " + key);
            }
            return value;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int size() {
            return this.size.get();
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Map.Entry<K, V>> iterator() {
                    return FluentIterable.from(primitiveViewT.get()).transform(key -> new AbstractMap.SimpleEntry(key, this.get(key))).iterator();
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Iterable value = primitiveViewT.get(entry.getKey());
                    if (value.iterator().hasNext()) {
                        return false;
                    }
                    return Objects.equals(entry.getValue(), value);
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int size() {
                    return (Integer)size.get();
                }
            };
        }
    }

    public static class SimplePCollectionView<@UnknownKeyFor ElemT, @UnknownKeyFor PrimitiveViewT, @UnknownKeyFor ViewT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends PValueBase
    implements PCollectionView<ViewT> {
        private transient @UnknownKeyFor @NonNull @Initialized PCollection<ElemT> pCollection;
        private @UnknownKeyFor @NonNull @Initialized TupleTag<PrimitiveViewT> tag;
        private @UnknownKeyFor @NonNull @Initialized WindowMappingFn<W> windowMappingFn;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy;
        private @Nullable @UnknownKeyFor @Initialized Coder<ElemT> coder;
        private @UnknownKeyFor @NonNull @Initialized ViewFn<PrimitiveViewT, ViewT> viewFn;

        private SimplePCollectionView(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> pCollection, @UnknownKeyFor @NonNull @Initialized TupleTag<PrimitiveViewT> tag, @UnknownKeyFor @NonNull @Initialized ViewFn<PrimitiveViewT, ViewT> viewFn, @UnknownKeyFor @NonNull @Initialized WindowMappingFn<W> windowMappingFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
            super(pCollection.getPipeline());
            this.pCollection = pCollection;
            this.windowMappingFn = windowMappingFn;
            this.tag = tag;
            this.windowingStrategy = windowingStrategy;
            this.viewFn = viewFn;
            this.coder = pCollection.getCoder();
        }

        private SimplePCollectionView(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> pCollection, @UnknownKeyFor @NonNull @Initialized ViewFn<PrimitiveViewT, ViewT> viewFn, @UnknownKeyFor @NonNull @Initialized WindowMappingFn<W> windowMappingFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
            this(pCollection, new TupleTag(), viewFn, windowMappingFn, windowingStrategy);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ViewFn<PrimitiveViewT, ViewT> getViewFn() {
            return this.viewFn;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowMappingFn<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowMappingFn() {
            return this.windowMappingFn;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getPCollection() {
            return this.pCollection;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getTagInternal() {
            return this.tag;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowingStrategyInternal() {
            return this.windowingStrategy;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCoderInternal() {
            return this.coder;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.tag);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            if (!(other instanceof PCollectionView)) {
                return false;
            }
            PCollectionView otherView = (PCollectionView)other;
            return this.tag.equals(otherView.getTagInternal());
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this).add("tag", this.tag).add("viewFn", this.viewFn).add("coder", this.coder).add("windowMappingFn", this.windowMappingFn).add("pCollection", this.pCollection).toString();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
            return Collections.singletonMap(this.tag, this.pCollection);
        }
    }

    private static class StructuralValueMap<@UnknownKeyFor K, @UnknownKeyFor V>
    implements Map<K, V> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Map.Entry<K, V>> entries;

        private static <K, V> @UnknownKeyFor @NonNull @Initialized Map<K, V> createMap(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<K, V>> kvs, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
            if (keyCoder.consistentWithEquals()) {
                HashMap<K, V> map = new HashMap<K, V>();
                for (KV<K, V> elem : kvs) {
                    if (map.containsKey(elem.getKey())) {
                        throw new IllegalArgumentException("Duplicate values for " + elem.getKey());
                    }
                    map.put(elem.getKey(), elem.getValue());
                }
                return Collections.unmodifiableMap(map);
            }
            HashMap<Object, Map.Entry<Object, AbstractMap.SimpleImmutableEntry<K, V>>> entries = new HashMap<Object, Map.Entry<Object, AbstractMap.SimpleImmutableEntry<K, V>>>();
            for (KV<K, V> elem : kvs) {
                AbstractMap.SimpleImmutableEntry<K, V> oldValue = entries.putIfAbsent(keyCoder.structuralValue(elem.getKey()), new AbstractMap.SimpleImmutableEntry<K, V>(elem.getKey(), elem.getValue()));
                if (oldValue == null) continue;
                throw new IllegalArgumentException("Duplicate values for " + elem.getKey());
            }
            return new StructuralValueMap<K, V>(entries, keyCoder);
        }

        private static <K, V> @UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> createMultimap(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<K, V>> kvs, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
            if (keyCoder.consistentWithEquals()) {
                ArrayListMultimap<K, V> multimap = ArrayListMultimap.create();
                for (KV<K, V> elem : kvs) {
                    multimap.put(elem.getKey(), elem.getValue());
                }
                return ImmutableMap.copyOf(Maps.transformValues(multimap.asMap(), v -> ImmutableList.copyOf(v)));
            }
            HashMap<Object, Map.Entry<Object, AbstractMap.SimpleEntry<K, ArrayList<Object>>>> entries = new HashMap<Object, Map.Entry<Object, AbstractMap.SimpleEntry<K, ArrayList<Object>>>>();
            for (KV<K, V> elem : kvs) {
                Object sk = keyCoder.structuralValue(elem.getKey());
                AbstractMap.SimpleEntry<K, ArrayList<Object>> e = (AbstractMap.SimpleEntry<K, ArrayList<Object>>)entries.get(sk);
                if (e == null) {
                    e = new AbstractMap.SimpleEntry<K, ArrayList<Object>>(elem.getKey(), Lists.newArrayList(elem.getValue()));
                    entries.put(sk, e);
                    continue;
                }
                ((List)e.getValue()).add(elem.getValue());
            }
            for (Map.Entry e : entries.values()) {
                e.setValue(ImmutableList.copyOf((Collection)e.getValue()));
            }
            HashMap<Object, Map.Entry<Object, AbstractMap.SimpleEntry<K, ArrayList<Object>>>> typedEntries = entries;
            return new StructuralValueMap<K, V>(typedEntries, keyCoder);
        }

        protected StructuralValueMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Map.Entry<K, V>> entries, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
            this.keyCoder = keyCoder;
            this.entries = entries;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int size() {
            return this.entries.size();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return this.entries.isEmpty();
        }

        @Override
        @EnsuresKeyForIf(expression={"#1"}, result=true, map={"this"})
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean containsKey(@UnknownKeyFor @NonNull @Initialized Object key) {
            try {
                return this.entries.containsKey(this.keyCoder.structuralValue(key));
            }
            catch (ClassCastException exn) {
                return false;
            }
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean containsValue(@UnknownKeyFor @NonNull @Initialized Object value) {
            return this.values().contains(value);
        }

        @Override
        @Pure
        public V get(@UnknownKeyFor @NonNull @Initialized Object key) {
            try {
                return this.entries.get(this.keyCoder.structuralValue(key)).getValue();
            }
            catch (ClassCastException exn) {
                return null;
            }
        }

        @Override
        @ReleasesNoLocks
        @EnsuresKeyFor(value={"#1"}, map={"this"})
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(@UnknownKeyFor @NonNull @Initialized Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(@UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends K, @KeyForBottom @NonNull @Initialized ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized Set<K> keySet() {
            return new AbstractSet<K>(){

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized Iterator<K> iterator() {
                    return Iterators.transform(entries.values().iterator(), e -> e.getKey());
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int size() {
                    return entries.size();
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized Object key) {
                    return this.containsKey(key);
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean containsAll(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> c) {
                    for (Object o : c) {
                        if (this.containsKey(o)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized Collection<V> values() {
            return Collections2.transform(this.entries.values(), e -> e.getValue());
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Map.Entry<K, V>> iterator() {
                    return entries.values().iterator();
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int size() {
                    return entries.size();
                }
            };
        }
    }

    public static class InMemoryMapFromVoidKeyViewFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, V>> {
        private @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public InMemoryMapFromVoidKeyViewFn(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, V> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>> primitiveView) {
            return StructuralValueMap.createMap(primitiveView.get(null), this.keyCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, V>> getTypeDescriptor() {
            return TypeDescriptors.maps(this.keyCoder.getEncodedTypeDescriptor(), this.valueCoder.getEncodedTypeDescriptor());
        }
    }

    public static class InMemoryMapViewFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.IterableView<KV<K, V>>, Map<K, V>> {
        private @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public InMemoryMapViewFn(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, V> apply(@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<@UnknownKeyFor @NonNull @Initialized KV<K, V>> primitiveView) {
            return StructuralValueMap.createMap(primitiveView.get(), this.keyCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, V>> getTypeDescriptor() {
            return TypeDescriptors.maps(this.keyCoder.getEncodedTypeDescriptor(), this.valueCoder.getEncodedTypeDescriptor());
        }
    }

    @Deprecated
    public static class MapViewFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, V>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MapViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, V> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>> primitiveViewT) {
            HashMap<K, V> map = new HashMap<K, V>();
            for (KV<K, V> elem : primitiveViewT.get(null)) {
                if (map.containsKey(elem.getKey())) {
                    throw new IllegalArgumentException("Duplicate values for " + elem.getKey());
                }
                map.put(elem.getKey(), elem.getValue());
            }
            return Collections.unmodifiableMap(map);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, V>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), (TypeDescriptor)this.valueTypeDescriptorSupplier.get());
        }
    }

    @Internal
    public static class MapViewFn2<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.MultimapView<K, V>, Map<K, V>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MapViewFn2(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, V> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> primitiveViewT) {
            return Collections.unmodifiableMap(new MultimapViewToMapAdapter(primitiveViewT));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, V>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), (TypeDescriptor)this.valueTypeDescriptorSupplier.get());
        }
    }

    @Deprecated
    public static class MultimapViewFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, Iterable<V>>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MultimapViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>> primitiveViewT) {
            ArrayListMultimap<K, V> multimap = ArrayListMultimap.create();
            for (KV<K, V> elem : primitiveViewT.get(null)) {
                multimap.put(elem.getKey(), elem.getValue());
            }
            Map resultMap = multimap.asMap();
            return Collections.unmodifiableMap(resultMap);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), TypeDescriptors.iterables((TypeDescriptor)this.valueTypeDescriptorSupplier.get()));
        }
    }

    public static class InMemoryMultimapFromVoidKeyViewFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, Iterable<V>>> {
        private @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public InMemoryMultimapFromVoidKeyViewFn(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized KV<K, V>> primitiveView) {
            return StructuralValueMap.createMultimap(primitiveView.get(null), this.keyCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> getTypeDescriptor() {
            return TypeDescriptors.maps(this.keyCoder.getEncodedTypeDescriptor(), TypeDescriptors.iterables(this.valueCoder.getEncodedTypeDescriptor()));
        }
    }

    public static class InMemoryMultimapViewFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.IterableView<KV<K, V>>, Map<K, Iterable<V>>> {
        private @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
        private @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

        public InMemoryMultimapViewFn(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
            this.keyCoder = keyCoder;
            this.valueCoder = valueCoder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> apply(@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<@UnknownKeyFor @NonNull @Initialized KV<K, V>> primitiveView) {
            return StructuralValueMap.createMultimap(primitiveView.get(), this.keyCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> getTypeDescriptor() {
            return TypeDescriptors.maps(this.keyCoder.getEncodedTypeDescriptor(), TypeDescriptors.iterables(this.valueCoder.getEncodedTypeDescriptor()));
        }
    }

    @Internal
    public static class MultimapViewFn2<@UnknownKeyFor K, @UnknownKeyFor V>
    extends ViewFn<Materializations.MultimapView<K, V>, Map<K, Iterable<V>>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier;
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier;

        public MultimapViewFn2(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<K> keyTypeDescriptorSupplier, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<V> valueTypeDescriptorSupplier) {
            this.keyTypeDescriptorSupplier = keyTypeDescriptorSupplier;
            this.valueTypeDescriptorSupplier = valueTypeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<K, V> primitiveViewT) {
            return Collections.unmodifiableMap(new MultimapViewToMultimapAdapter(primitiveViewT));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> getTypeDescriptor() {
            return TypeDescriptors.maps((TypeDescriptor)this.keyTypeDescriptorSupplier.get(), TypeDescriptors.iterables((TypeDescriptor)this.valueTypeDescriptorSupplier.get()));
        }
    }

    public static class InMemoryListFromMultimapViewFn<@UnknownKeyFor T>
    extends ViewFn<Materializations.MultimapView<Void, T>, List<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public InMemoryListFromMultimapViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T> primitiveView) {
            return ImmutableList.copyOf(primitiveView.get(null));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof InMemoryListFromMultimapViewFn;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return InMemoryListFromMultimapViewFn.class.hashCode();
        }
    }

    public static class InMemoryListViewFn<@UnknownKeyFor T>
    extends ViewFn<Materializations.IterableView<T>, List<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public InMemoryListViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> apply(@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T> primitiveView) {
            return ImmutableList.copyOf(primitiveView.get());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof InMemoryListViewFn;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return InMemoryListViewFn.class.hashCode();
        }
    }

    @Deprecated
    public static class ListViewFn<@UnknownKeyFor T>
    extends ViewFn<Materializations.MultimapView<Void, T>, List<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public ListViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T> primitiveViewT) {
            ArrayList<T> list = new ArrayList<T>();
            for (T t : primitiveViewT.get(null)) {
                list.add(t);
            }
            return Collections.unmodifiableList(list);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof ListViewFn;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return ListViewFn.class.hashCode();
        }
    }

    public static class IterableBackedListViewFn<@UnknownKeyFor T>
    extends ViewFn<Materializations.IterableView<T>, List<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public IterableBackedListViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> apply(final @UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T> primitiveViewT) {
            final org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier<Integer> size = Suppliers.memoize(() -> Iterables.size(primitiveViewT.get()));
            return new List<T>(){

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int size() {
                    return (Integer)size.get();
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
                    return Iterables.isEmpty(primitiveViewT.get());
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized Object o) {
                    return Iterables.contains(primitiveViewT.get(), o);
                }

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator() {
                    return primitiveViewT.get().iterator();
                }

                @Override
                @Pure
                public T get(@UnknownKeyFor @NonNull @Initialized int index) {
                    return Iterables.get(primitiveViewT.get(), index);
                }

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] toArray() {
                    return Iterables.toArray(primitiveViewT.get(), Object.class);
                }

                @Override
                @SideEffectFree
                public <T1> T1 @UnknownKeyFor @NonNull @Initialized [] toArray(T1 @UnknownKeyFor @NonNull @Initialized [] a) {
                    return Iterables.toArray(primitiveViewT.get(), a.getClass().getComponentType());
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized boolean containsAll(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> c) {
                    for (Object o : c) {
                        if (this.contains(o)) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int indexOf(@UnknownKeyFor @NonNull @Initialized Object o) {
                    return Iterables.indexOf(primitiveViewT.get(), v -> Objects.equals(v, o));
                }

                @Override
                @Pure
                public @UnknownKeyFor @NonNull @Initialized int lastIndexOf(@UnknownKeyFor @NonNull @Initialized Object o) {
                    return ImmutableList.copyOf(primitiveViewT.get()).lastIndexOf(o);
                }

                @Override
                @SideEffectFree
                public @UnknownKeyFor @NonNull @Initialized List<T> subList(@UnknownKeyFor @NonNull @Initialized int fromIndex, @UnknownKeyFor @NonNull @Initialized int toIndex) {
                    Iterator iterator = primitiveViewT.get().iterator();
                    if (Iterators.advance(iterator, fromIndex) != fromIndex) {
                        throw new IndexOutOfBoundsException();
                    }
                    ImmutableList subList = ImmutableList.copyOf(Iterators.limit(iterator, toIndex - fromIndex));
                    if (subList.size() != toIndex - fromIndex) {
                        throw new IndexOutOfBoundsException();
                    }
                    return subList;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized ListIterator<T> listIterator() {
                    return ImmutableList.copyOf(primitiveViewT.get()).listIterator();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized ListIterator<T> listIterator(@UnknownKeyFor @NonNull @Initialized int index) {
                    return ImmutableList.copyOf(primitiveViewT.get()).listIterator(index);
                }

                @Override
                @ReleasesNoLocks
                public @UnknownKeyFor @NonNull @Initialized boolean add(T t) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean remove(@UnknownKeyFor @NonNull @Initialized Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean addAll(@UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends T> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean addAll(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends T> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean removeAll(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean retainAll(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public T set(@UnknownKeyFor @NonNull @Initialized int index, T element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                @ReleasesNoLocks
                public void add(@UnknownKeyFor @NonNull @Initialized int index, T element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                @ReleasesNoLocks
                public T remove(@UnknownKeyFor @NonNull @Initialized int index) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
            return other instanceof IterableBackedListViewFn;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return ListViewFn.class.hashCode();
        }
    }

    public static class ValueOrMetadataCoder<@UnknownKeyFor T, @UnknownKeyFor MetaT>
    extends StructuredCoder<ValueOrMetadata<T, MetaT>> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<MetaT> metadataCoder;

        public static <T, MetaT> @UnknownKeyFor @NonNull @Initialized ValueOrMetadataCoder<T, MetaT> create(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<MetaT> metadataCoder) {
            return new ValueOrMetadataCoder<T, MetaT>(valueCoder, metadataCoder);
        }

        private ValueOrMetadataCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<MetaT> metadataCoder) {
            this.valueCoder = valueCoder;
            this.metadataCoder = metadataCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, MetaT> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            BooleanCoder.of().encode(value.isMetadata(), outStream);
            if (value.isMetadata()) {
                this.metadataCoder.encode(value.getMetadata(), outStream);
            } else {
                this.valueCoder.encode(value.get(), outStream);
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, MetaT> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            boolean isMetadata = BooleanCoder.of().decode(inStream);
            if (isMetadata) {
                return ValueOrMetadata.createMetadata(this.metadataCoder.decode(inStream));
            }
            return ValueOrMetadata.create(this.valueCoder.decode(inStream));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder, this.metadataCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            ValueOrMetadataCoder.verifyDeterministic(this.valueCoder, "value coder", new Coder[0]);
            ValueOrMetadataCoder.verifyDeterministic(this.metadataCoder, "metadata coder", new Coder[0]);
        }
    }

    public static class ValueOrMetadata<@UnknownKeyFor T, @UnknownKeyFor MetaT> {
        private final T value;
        private final @UnknownKeyFor @NonNull @Initialized boolean isMetadata;
        private final MetaT metadata;

        public static <T, MetaT> @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, MetaT> create(T value) {
            return new ValueOrMetadata<T, Object>(false, value, null);
        }

        public static <T, MetaT> @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, MetaT> createMetadata(MetaT metadata) {
            return new ValueOrMetadata<Object, MetaT>(true, null, metadata);
        }

        public ValueOrMetadata(@UnknownKeyFor @NonNull @Initialized boolean isMetadata, T value, MetaT metadata) {
            this.isMetadata = isMetadata;
            this.value = value;
            this.metadata = metadata;
        }

        public T get() {
            Preconditions.checkState(!this.isMetadata);
            return this.value;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isMetadata() {
            return this.isMetadata;
        }

        public MetaT getMetadata() {
            Preconditions.checkState(this.isMetadata);
            return this.metadata;
        }
    }

    @VisibleForTesting
    static class OffsetRangeComparator
    implements Comparator<OffsetRange> {
        private static final @UnknownKeyFor @NonNull @Initialized OffsetRangeComparator INSTANCE = new OffsetRangeComparator();

        OffsetRangeComparator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized OffsetRange o1, @UnknownKeyFor @NonNull @Initialized OffsetRange o2) {
            int fromComparison = Longs.compare(o1.getFrom(), o2.getFrom());
            if (fromComparison != 0) {
                return fromComparison;
            }
            return Longs.compare(o1.getTo(), o2.getTo());
        }
    }

    @VisibleForTesting
    public static class ListViewFn2<@UnknownKeyFor T>
    extends ViewFn<Materializations.MultimapView<Long, ValueOrMetadata<T, OffsetRange>>, List<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;
        private static final @UnknownKeyFor @NonNull @Initialized Counter listViewIteratorCount = Metrics.counter(ListViewFn2.class, "iteratorCount");
        private static final @UnknownKeyFor @NonNull @Initialized Counter listViewGetCount = Metrics.counter(ListViewFn2.class, "getCount");

        public ListViewFn2(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<T> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>> primitiveViewT) {
            return Collections.unmodifiableList(new ListOverMultimapView((Materializations.MultimapView)primitiveViewT));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized List<T>> getTypeDescriptor() {
            return TypeDescriptors.lists((TypeDescriptor)this.typeDescriptorSupplier.get());
        }

        private static class ListOverMultimapView<@UnknownKeyFor T>
        extends AbstractList<T>
        implements RandomAccess {
            private final @UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>> primitiveView;
            private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Integer>> nonOverlappingRangesToNumElementsPerPosition;
            private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> size;
            private final @UnknownKeyFor @NonNull @Initialized boolean recordGets;

            private ListOverMultimapView(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>> primitiveView) {
                this(primitiveView, Suppliers.memoize(() -> PCollectionViews.computeOverlappingRanges(Iterables.transform(primitiveView.get(Long.MIN_VALUE), value -> (OffsetRange)value.getMetadata()))));
            }

            private ListOverMultimapView(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>> primitiveView, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Integer>> nonOverlappingRangesToNumElementsPerPosition) {
                this(primitiveView, nonOverlappingRangesToNumElementsPerPosition, Suppliers.memoize(() -> PCollectionViews.computeTotalNumElements((Map)nonOverlappingRangesToNumElementsPerPosition.get())), true);
            }

            private ListOverMultimapView(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized ValueOrMetadata<T, @UnknownKeyFor @NonNull @Initialized OffsetRange>> primitiveView, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Integer>> nonOverlappingRangesToNumElementsPerPosition, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Integer> size, @UnknownKeyFor @NonNull @Initialized boolean recordGets) {
                this.primitiveView = primitiveView;
                this.nonOverlappingRangesToNumElementsPerPosition = nonOverlappingRangesToNumElementsPerPosition;
                this.size = size;
                this.recordGets = recordGets;
            }

            @Override
            @Pure
            public T get(@UnknownKeyFor @NonNull @Initialized int index) {
                if (this.recordGets) {
                    listViewGetCount.inc();
                }
                if (index < 0 || index >= this.size.get()) {
                    throw new IndexOutOfBoundsException();
                }
                KV<Long, Integer> position = PCollectionViews.computePositionForIndex((Map<OffsetRange, Integer>)this.nonOverlappingRangesToNumElementsPerPosition.get(), index);
                return Iterables.get(this.primitiveView.get(position.getKey()), position.getValue()).get();
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized int size() {
                return this.size.get();
            }

            @Override
            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized Iterator<T> iterator() {
                return this.listIterator();
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized ListIterator<T> listIterator() {
                listViewIteratorCount.inc();
                if (this.recordGets) {
                    return new ListOverMultimapView<T>(this.primitiveView, this.nonOverlappingRangesToNumElementsPerPosition, this.size, false).listIterator();
                }
                return super.listIterator();
            }
        }
    }

    @Deprecated
    public static class IterableViewFn<@UnknownKeyFor T>
    extends ViewFn<Materializations.MultimapView<Void, T>, Iterable<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public IterableViewFn(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T> primitiveViewT) {
            return Iterables.unmodifiableIterable(primitiveViewT.get(null));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Iterable<T>> getTypeDescriptor() {
            return TypeDescriptors.iterables((TypeDescriptor)this.typeDescriptorSupplier.get());
        }
    }

    @Internal
    public static class IterableViewFn2<@UnknownKeyFor T>
    extends ViewFn<Materializations.IterableView<T>, Iterable<T>> {
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        public IterableViewFn2(@UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.typeDescriptorSupplier = typeDescriptorSupplier;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<T> apply(@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T> primitiveViewT) {
            return Iterables.unmodifiableIterable(primitiveViewT.get());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Iterable<T>> getTypeDescriptor() {
            return TypeDescriptors.iterables((TypeDescriptor)this.typeDescriptorSupplier.get());
        }
    }

    @Deprecated
    public static class SingletonViewFn<@UnknownKeyFor T>
    extends ViewFn<Materializations.MultimapView<Void, T>, T>
    implements HasDefaultValue<T>,
    IsSingletonView<T> {
        private @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] encodedDefaultValue;
        private transient @Nullable T defaultValue;
        private @Nullable @UnknownKeyFor @Initialized Coder<T> valueCoder;
        private @UnknownKeyFor @NonNull @Initialized boolean hasDefault;
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        private SingletonViewFn(@UnknownKeyFor @NonNull @Initialized boolean hasDefault, T defaultValue, @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
            this.valueCoder = valueCoder;
            this.typeDescriptorSupplier = typeDescriptorSupplier;
            if (hasDefault) {
                try {
                    this.encodedDefaultValue = CoderUtils.encodeToByteArray(valueCoder, defaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasDefault() {
            return this.hasDefault;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getDefaultValue() {
            if (!this.hasDefault) {
                throw new NoSuchElementException("Empty PCollection accessed as a singleton view.");
            }
            SingletonViewFn singletonViewFn = this;
            synchronized (singletonViewFn) {
                if (this.encodedDefaultValue != null) {
                    try {
                        this.defaultValue = CoderUtils.decodeFromByteArray(this.valueCoder, this.encodedDefaultValue);
                        this.encodedDefaultValue = null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unexpected IOException: ", e);
                    }
                }
                return this.defaultValue;
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public T apply(@UnknownKeyFor @NonNull @Initialized Materializations.MultimapView<@UnknownKeyFor @Nullable @Initialized Void, T> primitiveViewT) {
            try {
                return Iterables.getOnlyElement(primitiveViewT.get(null));
            }
            catch (NoSuchElementException exc) {
                return this.getDefaultValue();
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view.");
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getTypeDescriptor() {
            return (TypeDescriptor)this.typeDescriptorSupplier.get();
        }
    }

    @Internal
    public static interface IsSingletonView<@UnknownKeyFor T> {
    }

    @Internal
    public static interface HasDefaultValue<@UnknownKeyFor T> {
        public T getDefaultValue();
    }

    @Internal
    public static class SingletonViewFn2<@UnknownKeyFor T>
    extends ViewFn<Materializations.IterableView<T>, T>
    implements HasDefaultValue<T>,
    IsSingletonView<T> {
        private @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] encodedDefaultValue;
        private transient @Nullable T defaultValue;
        private @Nullable @UnknownKeyFor @Initialized Coder<T> valueCoder;
        private @UnknownKeyFor @NonNull @Initialized boolean hasDefault;
        private @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier;

        private SingletonViewFn2(@UnknownKeyFor @NonNull @Initialized boolean hasDefault, T defaultValue, @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder, @UnknownKeyFor @NonNull @Initialized TypeDescriptorSupplier<T> typeDescriptorSupplier) {
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
            this.valueCoder = valueCoder;
            this.typeDescriptorSupplier = typeDescriptorSupplier;
            if (hasDefault) {
                try {
                    this.encodedDefaultValue = CoderUtils.encodeToByteArray(valueCoder, defaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
        }

        @Internal
        public @UnknownKeyFor @NonNull @Initialized boolean hasDefault() {
            return this.hasDefault;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getDefaultValue() {
            if (!this.hasDefault) {
                throw new NoSuchElementException("Empty PCollection accessed as a singleton view.");
            }
            SingletonViewFn2 singletonViewFn2 = this;
            synchronized (singletonViewFn2) {
                if (this.encodedDefaultValue != null) {
                    try {
                        this.defaultValue = CoderUtils.decodeFromByteArray(this.valueCoder, this.encodedDefaultValue);
                        this.encodedDefaultValue = null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unexpected IOException: ", e);
                    }
                }
                return this.defaultValue;
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Materialization<@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T>> getMaterialization() {
            return Materializations.iterable();
        }

        @Override
        public T apply(@UnknownKeyFor @NonNull @Initialized Materializations.IterableView<T> primitiveViewT) {
            try {
                return Iterables.getOnlyElement(primitiveViewT.get());
            }
            catch (NoSuchElementException exc) {
                return this.getDefaultValue();
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view.");
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getTypeDescriptor() {
            return (TypeDescriptor)this.typeDescriptorSupplier.get();
        }
    }

    public static interface TypeDescriptorSupplier<@UnknownKeyFor T>
    extends Supplier<TypeDescriptor<T>>,
    Serializable {
    }
}

