/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class PCollectionList<@UnknownKeyFor T>
implements PInput,
POutput {
    final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedPValue> pcollections;

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionList<T> empty(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return new PCollectionList<T>(pipeline);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionList<T> of(@UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        return new PCollectionList<T>(pc.getPipeline()).and(pc);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PCollectionList<T> of(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollection<T>> pcs) {
        Iterator<PCollection<T>> pcsIter = pcs.iterator();
        if (!pcsIter.hasNext()) {
            throw new IllegalArgumentException("must either have a non-empty list of PCollections, or must first call empty(Pipeline)");
        }
        return new PCollectionList<T>(pcsIter.next().getPipeline()).and(pcs);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionList<T> and(@UnknownKeyFor @NonNull @Initialized PCollection<T> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionList<T>(this.pipeline, (List<TaggedPValue>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.pcollections)).add(TaggedPValue.of(new TupleTag(Integer.toString(this.pcollections.size())), pc))).build()));
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionList<T> and(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollection<T>> pcs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.pcollections);
        int nextIndex = this.pcollections.size();
        for (PCollection<T> pc : pcs) {
            if (pc.getPipeline() != this.pipeline) {
                throw new IllegalArgumentException("PCollections come from different Pipelines");
            }
            builder.add(TaggedPValue.of(new TupleTag(Integer.toString(nextIndex)), pc));
            ++nextIndex;
        }
        return new PCollectionList<T>(this.pipeline, (List<TaggedPValue>)((Object)builder.build()));
    }

    public @UnknownKeyFor @NonNull @Initialized int size() {
        return this.pcollections.size();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> get(@UnknownKeyFor @NonNull @Initialized int index) {
        PCollection<?> value = this.pcollections.get(index).getValue();
        return value;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection<T>> getAll() {
        ImmutableList.Builder res = ImmutableList.builder();
        for (TaggedPValue value : this.pcollections) {
            PCollection<?> typedValue = value.getValue();
            res.add(typedValue);
        }
        return res.build();
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionList(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this(pipeline, ImmutableList.of());
    }

    PCollectionList(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TaggedPValue> values) {
        this.pipeline = pipeline;
        this.pcollections = ImmutableList.copyOf(values);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        ImmutableMap.Builder<TupleTag<?>, PCollection<?>> expanded = ImmutableMap.builder();
        for (TaggedPValue tagged : this.pcollections) {
            expanded.put(tagged.getTag(), tagged.getValue());
        }
        return expanded.build();
    }

    @Override
    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        int i = 0;
        for (TaggedPValue tpv : this.pcollections) {
            PCollection<?> pc = tpv.getValue();
            if (pc.getName().equals(PValueBase.defaultName(transformName))) {
                pc.setName(String.format("%s.%s%s", transformName, "out", i));
            }
            ++i;
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof PCollectionList)) {
            return false;
        }
        PCollectionList that = (PCollectionList)other;
        return this.pipeline.equals(that.pipeline) && this.getAll().equals(that.getAll());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.pipeline, this.getAll());
    }
}

