/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.SyntheticComponents;
import org.apache.beam.sdk.util.construction.graph.AutoValue_OutputDeduplicator_DeduplicationResult;
import org.apache.beam.sdk.util.construction.graph.AutoValue_OutputDeduplicator_PTransformDeduplication;
import org.apache.beam.sdk.util.construction.graph.AutoValue_OutputDeduplicator_StageDeduplication;
import org.apache.beam.sdk.util.construction.graph.AutoValue_OutputDeduplicator_StageOrTransform;
import org.apache.beam.sdk.util.construction.graph.ExecutableStage;
import org.apache.beam.sdk.util.construction.graph.ImmutableExecutableStage;
import org.apache.beam.sdk.util.construction.graph.PipelineNode;
import org.apache.beam.sdk.util.construction.graph.QueryablePipeline;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class OutputDeduplicator {
    OutputDeduplicator() {
    }

    static @UnknownKeyFor @NonNull @Initialized DeduplicationResult ensureSingleProducer(@UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ExecutableStage> stages, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> unfusedTransforms) {
        RunnerApi.Components.Builder unzippedComponents = pipeline.getComponents().toBuilder();
        Multimap<PipelineNode.PCollectionNode, StageOrTransform> pcollectionProducers = OutputDeduplicator.getProducers(pipeline, stages, unfusedTransforms);
        HashMultimap<StageOrTransform, PipelineNode.PCollectionNode> requiresNewOutput = HashMultimap.create();
        for (Map.Entry<PipelineNode.PCollectionNode, Collection<StageOrTransform>> collectionProducer : pcollectionProducers.asMap().entrySet()) {
            if (collectionProducer.getValue().size() <= 1) continue;
            for (StageOrTransform stageOrTransform : collectionProducer.getValue()) {
                requiresNewOutput.put(stageOrTransform, collectionProducer.getKey());
            }
        }
        LinkedHashMap<ExecutableStage, ExecutableStage> updatedStages = new LinkedHashMap<ExecutableStage, ExecutableStage>();
        LinkedHashMap<String, PipelineNode.PTransformNode> updatedTransforms = new LinkedHashMap<String, PipelineNode.PTransformNode>();
        HashMultimap<String, PipelineNode.PCollectionNode> originalToPartial = HashMultimap.create();
        for (Map.Entry deduplicationTargets : requiresNewOutput.asMap().entrySet()) {
            if (((StageOrTransform)deduplicationTargets.getKey()).getStage() != null) {
                StageDeduplication stageDeduplication = OutputDeduplicator.deduplicatePCollections(((StageOrTransform)deduplicationTargets.getKey()).getStage(), (Collection<PipelineNode.PCollectionNode>)((Collection)deduplicationTargets.getValue()), arg_0 -> ((RunnerApi.Components.Builder)unzippedComponents).containsPcollections(arg_0));
                for (Map.Entry<String, PipelineNode.PCollectionNode> originalToPartialReplacement : stageDeduplication.getOriginalToPartialPCollections().entrySet()) {
                    originalToPartial.put(originalToPartialReplacement.getKey(), originalToPartialReplacement.getValue());
                    unzippedComponents.putPcollections(originalToPartialReplacement.getValue().getId(), originalToPartialReplacement.getValue().getPCollection());
                }
                updatedStages.put(((StageOrTransform)deduplicationTargets.getKey()).getStage(), stageDeduplication.getUpdatedStage());
                continue;
            }
            if (((StageOrTransform)deduplicationTargets.getKey()).getTransform() != null) {
                PTransformDeduplication pTransformDeduplication = OutputDeduplicator.deduplicatePCollections(((StageOrTransform)deduplicationTargets.getKey()).getTransform(), (Collection<PipelineNode.PCollectionNode>)((Collection)deduplicationTargets.getValue()), arg_0 -> ((RunnerApi.Components.Builder)unzippedComponents).containsPcollections(arg_0));
                for (Map.Entry<String, PipelineNode.PCollectionNode> originalToPartialReplacement : pTransformDeduplication.getOriginalToPartialPCollections().entrySet()) {
                    originalToPartial.put(originalToPartialReplacement.getKey(), originalToPartialReplacement.getValue());
                    unzippedComponents.putPcollections(originalToPartialReplacement.getValue().getId(), originalToPartialReplacement.getValue().getPCollection());
                }
                updatedTransforms.put(((StageOrTransform)deduplicationTargets.getKey()).getTransform().getId(), pTransformDeduplication.getUpdatedTransform());
                continue;
            }
            throw new IllegalStateException(String.format("%s with no %s or %s", StageOrTransform.class.getSimpleName(), ExecutableStage.class.getSimpleName(), PipelineNode.PTransformNode.class.getSimpleName()));
        }
        LinkedHashSet<PipelineNode.PTransformNode> linkedHashSet = new LinkedHashSet<PipelineNode.PTransformNode>();
        for (Map.Entry entry : originalToPartial.asMap().entrySet()) {
            String flattenId = SyntheticComponents.uniqueId("unzipped_flatten", arg_0 -> ((RunnerApi.Components.Builder)unzippedComponents).containsTransforms(arg_0));
            RunnerApi.PTransform flattenPartialPCollections = OutputDeduplicator.createFlattenOfPartials(flattenId, (String)entry.getKey(), (Collection)entry.getValue());
            unzippedComponents.putTransforms(flattenId, flattenPartialPCollections);
            linkedHashSet.add(PipelineNode.pTransform(flattenId, flattenPartialPCollections));
        }
        RunnerApi.Components components = unzippedComponents.build();
        return DeduplicationResult.of(components, linkedHashSet, updatedStages, updatedTransforms);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform createFlattenOfPartials(@UnknownKeyFor @NonNull @Initialized String transformId, @UnknownKeyFor @NonNull @Initialized String outputId, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> generatedInputs) {
        RunnerApi.PTransform.Builder newFlattenBuilder = RunnerApi.PTransform.newBuilder();
        int i = 0;
        for (PipelineNode.PCollectionNode generatedInput : generatedInputs) {
            String localInputId = String.format("input_%s", i);
            ++i;
            newFlattenBuilder.putInputs(localInputId, generatedInput.getId());
        }
        return newFlattenBuilder.setUniqueName(transformId).putOutputs("output", outputId).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:flatten:v1")).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode, @UnknownKeyFor @NonNull @Initialized StageOrTransform> getProducers(@UnknownKeyFor @NonNull @Initialized QueryablePipeline pipeline, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ExecutableStage> stages, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> unfusedTransforms) {
        HashMultimap<PipelineNode.PCollectionNode, StageOrTransform> pcollectionProducers = HashMultimap.create();
        for (ExecutableStage stage : stages) {
            for (PipelineNode.PCollectionNode output : stage.getOutputPCollections()) {
                pcollectionProducers.put(output, StageOrTransform.stage(stage));
            }
        }
        for (PipelineNode.PTransformNode unfused : unfusedTransforms) {
            for (PipelineNode.PCollectionNode output : pipeline.getOutputPCollections(unfused)) {
                pcollectionProducers.put(output, StageOrTransform.transform(unfused));
            }
        }
        return pcollectionProducers;
    }

    private static @UnknownKeyFor @NonNull @Initialized PTransformDeduplication deduplicatePCollections(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> duplicates, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> existingPCollectionIds) {
        Map<String, PipelineNode.PCollectionNode> unzippedOutputs = OutputDeduplicator.createPartialPCollections(duplicates, existingPCollectionIds);
        RunnerApi.PTransform pTransform = OutputDeduplicator.updateOutputs(transform.getTransform(), unzippedOutputs);
        return PTransformDeduplication.of(PipelineNode.pTransform(transform.getId(), pTransform), unzippedOutputs);
    }

    private static @UnknownKeyFor @NonNull @Initialized StageDeduplication deduplicatePCollections(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> duplicates, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> existingPCollectionIds) {
        Map<String, PipelineNode.PCollectionNode> unzippedOutputs = OutputDeduplicator.createPartialPCollections(duplicates, existingPCollectionIds);
        ExecutableStage updatedStage = OutputDeduplicator.deduplicateStageOutput(stage, unzippedOutputs);
        return StageDeduplication.of(updatedStage, unzippedOutputs);
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> createPartialPCollections(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> duplicates, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> existingPCollectionIds) {
        LinkedHashMap<String, PipelineNode.PCollectionNode> unzippedOutputs = new LinkedHashMap<String, PipelineNode.PCollectionNode>();
        Predicate<String> existingOrNewIds = existingPCollectionIds.or(id -> unzippedOutputs.values().stream().map(PipelineNode.PCollectionNode::getId).anyMatch(id::equals));
        for (PipelineNode.PCollectionNode duplicateOutput : duplicates) {
            String id2 = SyntheticComponents.uniqueId(duplicateOutput.getId(), existingOrNewIds);
            RunnerApi.PCollection partial = duplicateOutput.getPCollection().toBuilder().setUniqueName(id2).build();
            PipelineNode.PCollectionNode alreadyDeduplicated = unzippedOutputs.put(duplicateOutput.getId(), PipelineNode.pCollection(id2, partial));
            Preconditions.checkArgument(alreadyDeduplicated == null, "a duplicate should only appear once per stage");
        }
        return unzippedOutputs;
    }

    private static @UnknownKeyFor @NonNull @Initialized ExecutableStage deduplicateStageOutput(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> originalToPartial) {
        ArrayList<PipelineNode.PTransformNode> updatedTransforms = new ArrayList<PipelineNode.PTransformNode>();
        for (PipelineNode.PTransformNode pTransformNode : stage.getTransforms()) {
            RunnerApi.PTransform updatedTransform = OutputDeduplicator.updateOutputs(pTransformNode.getTransform(), originalToPartial);
            updatedTransforms.add(PipelineNode.pTransform(pTransformNode.getId(), updatedTransform));
        }
        ArrayList<PipelineNode.PCollectionNode> updatedOutputs = new ArrayList<PipelineNode.PCollectionNode>();
        for (PipelineNode.PCollectionNode output : stage.getOutputPCollections()) {
            updatedOutputs.add(originalToPartial.getOrDefault(output.getId(), output));
        }
        RunnerApi.Components components = stage.getComponents().toBuilder().clearTransforms().putAllTransforms(updatedTransforms.stream().collect(Collectors.toMap(PipelineNode.PTransformNode::getId, PipelineNode.PTransformNode::getTransform))).putAllPcollections(originalToPartial.values().stream().collect(Collectors.toMap(PipelineNode.PCollectionNode::getId, PipelineNode.PCollectionNode::getPCollection))).build();
        return ImmutableExecutableStage.of(components, stage.getEnvironment(), stage.getInputPCollection(), stage.getSideInputs(), stage.getUserStates(), stage.getTimers(), updatedTransforms, updatedOutputs, stage.getWireCoderSettings());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform updateOutputs(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform transform, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> originalToPartial) {
        RunnerApi.PTransform.Builder updatedTransformBuilder = transform.toBuilder();
        for (Map.Entry output : transform.getOutputsMap().entrySet()) {
            if (!originalToPartial.containsKey(output.getValue())) continue;
            updatedTransformBuilder.putOutputs((String)output.getKey(), originalToPartial.get(output.getValue()).getId());
        }
        updatedTransformBuilder.setEnvironmentId(transform.getEnvironmentId());
        return updatedTransformBuilder.build();
    }

    @AutoValue
    static abstract class StageOrTransform {
        StageOrTransform() {
        }

        public static @UnknownKeyFor @NonNull @Initialized StageOrTransform stage(@UnknownKeyFor @NonNull @Initialized ExecutableStage stage) {
            return new AutoValue_OutputDeduplicator_StageOrTransform(stage, null);
        }

        public static @UnknownKeyFor @NonNull @Initialized StageOrTransform transform(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode transform) {
            return new AutoValue_OutputDeduplicator_StageOrTransform(null, transform);
        }

        abstract @Nullable @UnknownKeyFor @Initialized ExecutableStage getStage();

        abstract @Nullable @UnknownKeyFor @Initialized PipelineNode.PTransformNode getTransform();
    }

    @AutoValue
    static abstract class StageDeduplication {
        StageDeduplication() {
        }

        public static @UnknownKeyFor @NonNull @Initialized StageDeduplication of(@UnknownKeyFor @NonNull @Initialized ExecutableStage updatedStage, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> originalToPartial) {
            return new AutoValue_OutputDeduplicator_StageDeduplication(updatedStage, originalToPartial);
        }

        abstract @UnknownKeyFor @NonNull @Initialized ExecutableStage getUpdatedStage();

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> getOriginalToPartialPCollections();
    }

    @AutoValue
    static abstract class PTransformDeduplication {
        PTransformDeduplication() {
        }

        public static @UnknownKeyFor @NonNull @Initialized PTransformDeduplication of(@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode updatedTransform, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> originalToPartial) {
            return new AutoValue_OutputDeduplicator_PTransformDeduplication(updatedTransform, originalToPartial);
        }

        abstract @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode getUpdatedTransform();

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PCollectionNode> getOriginalToPartialPCollections();
    }

    @AutoValue
    static abstract class DeduplicationResult {
        DeduplicationResult() {
        }

        private static @UnknownKeyFor @NonNull @Initialized DeduplicationResult of(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Components components, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> introducedTransforms, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ExecutableStage, @UnknownKeyFor @NonNull @Initialized ExecutableStage> stages, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> unfused) {
            return new AutoValue_OutputDeduplicator_DeduplicationResult(components, introducedTransforms, stages, unfused);
        }

        abstract // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.Components getDeduplicatedComponents();

        abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getIntroducedTransforms();

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ExecutableStage, @UnknownKeyFor @NonNull @Initialized ExecutableStage> getDeduplicatedStages();

        abstract @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineNode.PTransformNode> getDeduplicatedTransforms();
    }
}

