/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class AfterFirst
extends Trigger.OnceTrigger {
    AfterFirst(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterFirst of(Trigger.OnceTrigger ... triggers) {
        return new AfterFirst(Arrays.asList(triggers));
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterFirst of(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> triggers) {
        return new AfterFirst(triggers);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isAfter((ReadableInstant)subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
        return new AfterFirst(continuationTriggers);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterFirst.of(");
        Joiner.on(", ").appendTo(builder, (Iterable<? extends Object>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

