/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

public class AfterEach
extends Trigger {
    private AfterEach(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static @UnknownKeyFor @NonNull @Initialized AfterEach inOrder(Trigger ... triggers) {
        return new AfterEach(Arrays.asList(triggers));
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterEach inOrder(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> triggers) {
        return new AfterEach(triggers);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        return ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean mayFinish() {
        return this.subTriggers.stream().allMatch(trigger -> trigger.mayFinish());
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Trigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
        return Repeatedly.forever(new AfterFirst(continuationTriggers));
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder builder = new StringBuilder("AfterEach.inOrder(");
        Joiner.on(", ").appendTo(builder, (Iterable<? extends Object>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

