/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import javax.annotation.CheckForNull;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WithKeys<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<V>, PCollection<KV<K, V>>> {
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<V, K> fn;
    @CheckForNull
    private transient @UnknownKeyFor @Nullable @Initialized TypeDescriptor<K> keyType;

    public static <K, V> @UnknownKeyFor @NonNull @Initialized WithKeys<K, V> of(@UnknownKeyFor @NonNull @Initialized SerializableFunction<V, K> fn) {
        Preconditions.checkNotNull(fn, "WithKeys constructed with null function. Did you mean WithKeys.of((Void) null)?");
        return new WithKeys<K, V>(fn, null);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized WithKeys<K, V> of(@Nullable K key) {
        return new WithKeys<Void, Object>(value -> key, key == null ? TypeDescriptors.voids() : TypeDescriptor.of(key.getClass()));
    }

    private WithKeys(@UnknownKeyFor @NonNull @Initialized SerializableFunction<V, K> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<K> keyType) {
        this.fn = fn;
        this.keyType = keyType;
    }

    public @UnknownKeyFor @NonNull @Initialized WithKeys<K, V> withKeyType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<K> keyType) {
        return new WithKeys<K, V>(this.fn, keyType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<V> in) {
        PCollection result;
        block4: {
            result = (PCollection)in.apply("AddKeys", MapElements.via(new SimpleFunction<V, KV<K, V>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<K, V> apply(V element) {
                    return KV.of(WithKeys.this.fn.apply(element), element);
                }
            }));
            try {
                CoderRegistry coderRegistry = in.getPipeline().getCoderRegistry();
                Coder<K> keyCoder = this.keyType == null ? coderRegistry.getOutputCoder(this.fn, in.getCoder()) : coderRegistry.getCoder(this.keyType);
                result.setCoder(KvCoder.of(keyCoder, in.getCoder()));
            }
            catch (CannotProvideCoderException exc) {
                if (this.keyType == null) break block4;
                try {
                    SchemaRegistry schemaRegistry = SchemaRegistry.createDefault();
                    SchemaCoder<K> schemaCoder = SchemaCoder.of(schemaRegistry.getSchema(this.keyType), this.keyType, schemaRegistry.getToRowFunction(this.keyType), schemaRegistry.getFromRowFunction(this.keyType));
                    result.setCoder(KvCoder.of(schemaCoder, in.getCoder()));
                }
                catch (NoSuchSchemaException noSuchSchemaException) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

