/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.state.TimerSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.AutoValue_GroupIntoBatches_BatchingParams;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupIntoBatches<@UnknownKeyFor K, @UnknownKeyFor InputT>
extends PTransform<PCollection<KV<K, InputT>>, PCollection<KV<K, Iterable<InputT>>>> {
    private final @UnknownKeyFor @NonNull @Initialized BatchingParams<InputT> params;
    private static final @UnknownKeyFor @NonNull @Initialized UUID workerUuid = UUID.randomUUID();

    private GroupIntoBatches(@UnknownKeyFor @NonNull @Initialized BatchingParams<InputT> params) {
        this.params = params;
    }

    public static <K, InputT> @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> ofSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
        Preconditions.checkState(batchSize < Long.MAX_VALUE);
        return new GroupIntoBatches(BatchingParams.createDefault()).withSize(batchSize);
    }

    public static <K, InputT> @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> ofByteSize(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes) {
        return new GroupIntoBatches(BatchingParams.createDefault()).withByteSize(batchSizeBytes);
    }

    public static <K, InputT> @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> ofByteSize(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> getElementByteSize) {
        return new GroupIntoBatches<K, InputT>(BatchingParams.createDefault()).withByteSize(batchSizeBytes, getElementByteSize);
    }

    public @UnknownKeyFor @NonNull @Initialized BatchingParams<InputT> getBatchingParams() {
        return this.params;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return super.toString() + ", params=" + this.params;
    }

    public @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> withSize(@UnknownKeyFor @NonNull @Initialized long batchSize) {
        Preconditions.checkState(batchSize < Long.MAX_VALUE);
        return new GroupIntoBatches<K, InputT>(BatchingParams.create(batchSize, this.params.getBatchSizeBytes(), this.params.getElementByteSize(), this.params.getMaxBufferingDuration()));
    }

    public @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> withByteSize(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes) {
        Preconditions.checkState(batchSizeBytes < Long.MAX_VALUE);
        return new GroupIntoBatches<K, InputT>(BatchingParams.create(this.params.getBatchSize(), batchSizeBytes, this.params.getElementByteSize(), this.params.getMaxBufferingDuration()));
    }

    public @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> withByteSize(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> getElementByteSize) {
        Preconditions.checkState(batchSizeBytes < Long.MAX_VALUE);
        return new GroupIntoBatches<K, InputT>(BatchingParams.create(this.params.getBatchSize(), batchSizeBytes, getElementByteSize, this.params.getMaxBufferingDuration()));
    }

    public @UnknownKeyFor @NonNull @Initialized GroupIntoBatches<K, InputT> withMaxBufferingDuration(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        Preconditions.checkArgument(duration != null && !duration.isShorterThan((ReadableDuration)Duration.ZERO), "max buffering duration should be a non-negative value");
        return new GroupIntoBatches<K, InputT>(BatchingParams.create(this.params.getBatchSize(), this.params.getBatchSizeBytes(), this.params.getElementByteSize(), duration));
    }

    public @UnknownKeyFor @NonNull @Initialized GroupIntoBatches. @UnknownKeyFor @NonNull @Initialized WithShardedKey withShardedKey() {
        return new WithShardedKey();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
        Duration allowedLateness = input.getWindowingStrategy().getAllowedLateness();
        Preconditions.checkArgument(input.getCoder() instanceof KvCoder, "coder specified in the input PCollection is not a KvCoder");
        KvCoder inputCoder = (KvCoder)input.getCoder();
        Coder<?> valueCoder = inputCoder.getCoderArguments().get(1);
        SerializableFunction<InputT, Long> weigher = this.params.getWeigher(valueCoder);
        return (PCollection)input.apply(ParDo.of(new GroupIntoBatchesDoFn(this.params.getBatchSize(), this.params.getBatchSizeBytes(), weigher, this.params.getMaxBufferingDuration(), allowedLateness, valueCoder)));
    }

    @VisibleForTesting
    private static class GroupIntoBatchesDoFn<@UnknownKeyFor K, @UnknownKeyFor InputT>
    extends DoFn<KV<K, InputT>, KV<K, Iterable<InputT>>> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GroupIntoBatchesDoFn.class);
        private final @UnknownKeyFor @NonNull @Initialized long batchSize;
        private final @UnknownKeyFor @NonNull @Initialized long batchSizeBytes;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> weigher;
        private final @UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration;
        private final @UnknownKeyFor @NonNull @Initialized Duration allowedLateness;
        private static final @UnknownKeyFor @NonNull @Initialized String END_OF_WINDOW_ID = "endOFWindow";
        @DoFn.TimerId(value="endOFWindow")
        private final @UnknownKeyFor @NonNull @Initialized TimerSpec windowTimer = TimerSpecs.timer(TimeDomain.EVENT_TIME);
        private static final @UnknownKeyFor @NonNull @Initialized String TIMER_HOLD_ID = "watermarkHold";
        @DoFn.TimerId(value="watermarkHold")
        private final @UnknownKeyFor @NonNull @Initialized TimerSpec holdTimerSpec = TimerSpecs.timer(TimeDomain.EVENT_TIME);
        private static final @UnknownKeyFor @NonNull @Initialized String END_OF_BUFFERING_ID = "endOfBuffering";
        @DoFn.TimerId(value="endOfBuffering")
        private final @UnknownKeyFor @NonNull @Initialized TimerSpec bufferingTimer = TimerSpecs.timer(TimeDomain.PROCESSING_TIME);
        private static final @UnknownKeyFor @NonNull @Initialized String BATCH_ID = "batch";
        @DoFn.StateId(value="batch")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<InputT>> batchSpec;
        private static final @UnknownKeyFor @NonNull @Initialized String NUM_ELEMENTS_IN_BATCH_ID = "numElementsInBatch";
        @DoFn.StateId(value="numElementsInBatch")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long>> batchSizeSpec;
        private static final @UnknownKeyFor @NonNull @Initialized String NUM_BYTES_IN_BATCH_ID = "numBytesInBatch";
        @DoFn.StateId(value="numBytesInBatch")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long>> batchSizeBytesSpec;
        private static final @UnknownKeyFor @NonNull @Initialized String TIMER_TIMESTAMP = "timerTs";
        @DoFn.StateId(value="timerTs")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long>> timerTsSpec;
        private static final @UnknownKeyFor @NonNull @Initialized String MIN_BUFFERED_TS = "minBufferedTs";
        @DoFn.StateId(value="minBufferedTs")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long>> minBufferedTsSpec;
        private final @UnknownKeyFor @NonNull @Initialized long prefetchFrequency;

        GroupIntoBatchesDoFn(@UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized long batchSizeBytes, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> weigher, @UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration, @UnknownKeyFor @NonNull @Initialized Duration allowedLateness, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputValueCoder) {
            this.batchSize = batchSize;
            this.batchSizeBytes = batchSizeBytes;
            this.weigher = weigher;
            this.maxBufferingDuration = maxBufferingDuration;
            this.allowedLateness = allowedLateness;
            this.batchSpec = StateSpecs.bag(inputValueCoder);
            Combine.BinaryCombineLongFn sumCombineFn = new Combine.BinaryCombineLongFn(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized long identity() {
                    return 0L;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized long apply(@UnknownKeyFor @NonNull @Initialized long left, @UnknownKeyFor @NonNull @Initialized long right) {
                    return left + right;
                }
            };
            Combine.BinaryCombineLongFn minCombineFn = new Combine.BinaryCombineLongFn(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized long identity() {
                    return BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized long apply(@UnknownKeyFor @NonNull @Initialized long left, @UnknownKeyFor @NonNull @Initialized long right) {
                    return Math.min(left, right);
                }
            };
            this.batchSizeSpec = StateSpecs.combining(sumCombineFn);
            this.batchSizeBytesSpec = StateSpecs.combining(sumCombineFn);
            this.timerTsSpec = StateSpecs.value();
            this.minBufferedTsSpec = StateSpecs.combining(minCombineFn);
            this.prefetchFrequency = batchSize / 5L <= 1L ? Long.MAX_VALUE : batchSize / 5L;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
            return Duration.millis((long)Long.MAX_VALUE);
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.TimerId(value="endOfBuffering") @UnknownKeyFor @NonNull @Initialized Timer bufferingTimer, @DoFn.TimerId(value="watermarkHold") @UnknownKeyFor @NonNull @Initialized Timer holdTimer, @DoFn.StateId(value="batch") @UnknownKeyFor @NonNull @Initialized BagState<InputT> batch, @DoFn.StateId(value="numElementsInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSize, @DoFn.StateId(value="numBytesInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSizeBytes, @DoFn.StateId(value="timerTs") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> timerTs, @DoFn.StateId(value="minBufferedTs") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> minBufferedTs, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, InputT> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant elementTs, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> receiver) {
            boolean needsNewTimer;
            boolean shouldCareAboutWeight = this.weigher != null && this.batchSizeBytes != Long.MAX_VALUE;
            boolean shouldCareAboutMaxBufferingDuration = this.maxBufferingDuration.isLongerThan((ReadableDuration)Duration.ZERO);
            if (shouldCareAboutWeight) {
                storedBatchSizeBytes.readLater();
            }
            storedBatchSize.readLater();
            minBufferedTs.readLater();
            minBufferedTs.add(elementTs.getMillis());
            LOG.debug("*** BATCH *** Add element for window {} ", (Object)window);
            if (shouldCareAboutWeight) {
                long elementWeight = this.weigher.apply(element.getValue());
                if (elementWeight + storedBatchSizeBytes.read() > this.batchSizeBytes) {
                    LOG.debug("*** EARLY FIRE OF BATCH *** for window {}", (Object)window.toString());
                    this.flushBatch(receiver, element.getKey(), batch, storedBatchSize, storedBatchSizeBytes, timerTs, minBufferedTs);
                    bufferingTimer.clear();
                    holdTimer.clear();
                }
                storedBatchSizeBytes.add(elementWeight);
            }
            batch.add(element.getValue());
            storedBatchSize.add(1L);
            minBufferedTs.add(elementTs.getMillis());
            long num = storedBatchSize.read();
            long oldOutputTs = MoreObjects.firstNonNull(minBufferedTs.read(), BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis());
            boolean bl = needsNewTimer = num == 1L || minBufferedTs.read() != oldOutputTs;
            if (needsNewTimer) {
                if (shouldCareAboutMaxBufferingDuration) {
                    long targetTs = MoreObjects.firstNonNull(timerTs.read(), bufferingTimer.getCurrentRelativeTime().getMillis() + this.maxBufferingDuration.getMillis());
                    bufferingTimer.withOutputTimestamp(Instant.ofEpochMilli((long)minBufferedTs.read())).set(Instant.ofEpochMilli((long)targetTs));
                } else {
                    Instant windowEnd = window.maxTimestamp().plus((ReadableDuration)this.allowedLateness);
                    holdTimer.withOutputTimestamp(Instant.ofEpochMilli((long)minBufferedTs.read())).set(windowEnd);
                }
            }
            if (num % this.prefetchFrequency == 0L) {
                batch.readLater();
            }
            if (num >= this.batchSize || shouldCareAboutWeight && storedBatchSizeBytes.read() >= this.batchSizeBytes) {
                LOG.debug("*** END OF BATCH *** for window {}", (Object)window.toString());
                this.flushBatch(receiver, element.getKey(), batch, storedBatchSize, storedBatchSizeBytes, timerTs, minBufferedTs);
                bufferingTimer.clear();
                holdTimer.clear();
            }
        }

        @DoFn.OnTimer(value="endOfBuffering")
        public void onBufferingTimer(@UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> receiver, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @DoFn.Key K key, @DoFn.StateId(value="batch") @UnknownKeyFor @NonNull @Initialized BagState<InputT> batch, @DoFn.StateId(value="numElementsInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSize, @DoFn.StateId(value="numBytesInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSizeBytes, @DoFn.StateId(value="timerTs") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> timerTs, @DoFn.StateId(value="minBufferedTs") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> minBufferedTs, @DoFn.TimerId(value="endOfBuffering") @UnknownKeyFor @NonNull @Initialized Timer bufferingTimer, @DoFn.TimerId(value="watermarkHold") @UnknownKeyFor @NonNull @Initialized Timer holdTimer) {
            LOG.debug("*** END OF BUFFERING *** for timer timestamp {} with buffering duration {}", (Object)timestamp, (Object)this.maxBufferingDuration);
            this.flushBatch(receiver, key, batch, storedBatchSize, storedBatchSizeBytes, timerTs, minBufferedTs);
            holdTimer.clear();
        }

        @DoFn.OnWindowExpiration
        public void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> receiver, @DoFn.Key K key, @DoFn.StateId(value="batch") @UnknownKeyFor @NonNull @Initialized BagState<InputT> batch, @DoFn.StateId(value="numElementsInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSize, @DoFn.StateId(value="numBytesInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSizeBytes, @DoFn.StateId(value="timerTs") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> timerTs, @DoFn.StateId(value="minBufferedTs") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> minBufferedTs) {
            this.flushBatch(receiver, key, batch, storedBatchSize, storedBatchSizeBytes, timerTs, minBufferedTs);
        }

        @DoFn.OnTimer(value="watermarkHold")
        public void onHoldTimer() {
        }

        @DoFn.OnTimer(value="endOFWindow")
        public void onWindowTimer(@UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> receiver, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @DoFn.Key K key, @DoFn.StateId(value="batch") @UnknownKeyFor @NonNull @Initialized BagState<InputT> batch, @DoFn.StateId(value="numElementsInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSize, @DoFn.StateId(value="numBytesInBatch") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSizeBytes, @DoFn.StateId(value="timerTs") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> timerTs, @DoFn.StateId(value="minBufferedTs") @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> minBufferedTs, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            LOG.debug("*** END OF WINDOW *** for timer timestamp {} in windows {}", (Object)timestamp, (Object)window.toString());
            this.flushBatch(receiver, key, batch, storedBatchSize, storedBatchSizeBytes, timerTs, minBufferedTs);
        }

        private void flushBatch(@UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> receiver, K key, @UnknownKeyFor @NonNull @Initialized BagState<InputT> batch, @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSize, @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSizeBytes, @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> timerTs, @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> minBufferedTs) {
            Object values = batch.read();
            if (!Iterables.isEmpty(values)) {
                receiver.outputWithTimestamp(KV.of(key, values), Instant.ofEpochMilli((long)minBufferedTs.read()));
            }
            this.clearState(batch, storedBatchSize, storedBatchSizeBytes, timerTs, minBufferedTs);
        }

        private void clearState(@UnknownKeyFor @NonNull @Initialized BagState<InputT> batch, @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSize, @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> storedBatchSizeBytes, @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Long> timerTs, @UnknownKeyFor @NonNull @Initialized CombiningState<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized long @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Long> minBufferedTs) {
            batch.clear();
            storedBatchSize.clear();
            storedBatchSizeBytes.clear();
            timerTs.clear();
            minBufferedTs.clear();
        }
    }

    private static class ByteSizeObserver
    extends ElementByteSizeObserver {
        private @UnknownKeyFor @NonNull @Initialized long elementByteSize = 0L;

        private ByteSizeObserver() {
        }

        @Override
        protected void reportElementSize(@UnknownKeyFor @NonNull @Initialized long elementByteSize) {
            this.elementByteSize += elementByteSize;
        }

        public @UnknownKeyFor @NonNull @Initialized long getElementByteSize() {
            return this.elementByteSize;
        }
    }

    public class WithShardedKey
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<KV<ShardedKey<K>, Iterable<InputT>>>> {
        private WithShardedKey() {
        }

        public @UnknownKeyFor @NonNull @Initialized BatchingParams<InputT> getBatchingParams() {
            return GroupIntoBatches.this.params;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
            Preconditions.checkArgument(input.getCoder() instanceof KvCoder, "coder specified in the input PCollection is not a KvCoder");
            KvCoder inputCoder = (KvCoder)input.getCoder();
            Coder<?> keyCoder = inputCoder.getCoderArguments().get(0);
            Coder<?> valueCoder = inputCoder.getCoderArguments().get(1);
            return (PCollection)((PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, InputT>, KV<ShardedKey<K>, InputT>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<K>, InputT> apply(@UnknownKeyFor @NonNull @Initialized KV<K, InputT> input) {
                    long tid = Thread.currentThread().getId();
                    ByteBuffer buffer = ByteBuffer.allocate(24);
                    buffer.putLong(workerUuid.getMostSignificantBits());
                    buffer.putLong(workerUuid.getLeastSignificantBits());
                    buffer.putLong(tid);
                    return KV.of(ShardedKey.of(input.getKey(), buffer.array()), input.getValue());
                }
            }))).setCoder(KvCoder.of(ShardedKey.Coder.of(keyCoder), valueCoder)).apply(new GroupIntoBatches(this.getBatchingParams()));
        }
    }

    @AutoValue
    public static abstract class BatchingParams<@UnknownKeyFor InputT>
    implements Serializable {
        public static <InputT> @UnknownKeyFor @NonNull @Initialized BatchingParams<InputT> createDefault() {
            return new AutoValue_GroupIntoBatches_BatchingParams(Long.MAX_VALUE, Long.MAX_VALUE, null, Duration.ZERO);
        }

        public static <InputT> @UnknownKeyFor @NonNull @Initialized BatchingParams<InputT> create(@UnknownKeyFor @NonNull @Initialized long batchSize, @UnknownKeyFor @NonNull @Initialized long batchSizeBytes, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> elementByteSize, @UnknownKeyFor @NonNull @Initialized Duration maxBufferingDuration) {
            return new AutoValue_GroupIntoBatches_BatchingParams<InputT>(batchSize, batchSizeBytes, elementByteSize, maxBufferingDuration);
        }

        public abstract @UnknownKeyFor @NonNull @Initialized long getBatchSize();

        public abstract @UnknownKeyFor @NonNull @Initialized long getBatchSizeBytes();

        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> getElementByteSize();

        public abstract @UnknownKeyFor @NonNull @Initialized Duration getMaxBufferingDuration();

        public @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Long> getWeigher(@UnknownKeyFor @NonNull @Initialized Coder<InputT> valueCoder) {
            SerializableFunction<Object, Long> weigher = this.getElementByteSize();
            if (this.getBatchSizeBytes() < Long.MAX_VALUE && weigher == null) {
                weigher = element -> {
                    try {
                        ByteSizeObserver observer = new ByteSizeObserver();
                        valueCoder.registerByteSizeObserver(element, observer);
                        observer.advance();
                        return observer.getElementByteSize();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            return weigher;
        }
    }
}

