/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class FixedString
extends PassThroughLogicalType<String> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = (String)SchemaApi.LogicalTypes.Enum.FIXED_CHAR.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private final @Nullable @UnknownKeyFor @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized int stringLength;

    public static @UnknownKeyFor @NonNull @Initialized FixedString of(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int stringLength) {
        return new FixedString(name, stringLength);
    }

    public static @UnknownKeyFor @NonNull @Initialized FixedString of(@UnknownKeyFor @NonNull @Initialized int stringLength) {
        return new FixedString(null, stringLength);
    }

    private FixedString(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int stringLength) {
        super(IDENTIFIER, Schema.FieldType.INT32, stringLength, Schema.FieldType.STRING);
        this.name = name;
        this.stringLength = stringLength;
    }

    public @UnknownKeyFor @NonNull @Initialized int getLength() {
        return this.stringLength;
    }

    public @Nullable @UnknownKeyFor @Initialized String getName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String toInputType(@UnknownKeyFor @NonNull @Initialized String base) {
        Preconditions.checkArgument(base.length() <= this.stringLength);
        return StringUtils.rightPad((String)base, (int)this.stringLength);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "FixedString: " + this.stringLength;
    }
}

