/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.runners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValues;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class TransformHierarchy {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TransformHierarchy.class);
    private final @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node root;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node, @UnknownKeyFor @NonNull @Initialized PInput> unexpandedInputs;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> producers = new HashMap();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PInput> producerInput = new HashMap();
    private @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node current;

    public TransformHierarchy(@UnknownKeyFor @NonNull @Initialized ResourceHints resourceHints) {
        this.unexpandedInputs = new HashMap<Node, PInput>();
        this.current = this.root = new Node(resourceHints);
    }

    public @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node pushNode(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        Preconditions.checkNotNull(transform, "A %s must be provided for all Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(name, "A name must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Preconditions.checkNotNull(input, "An input must be provided for all %s Nodes", (Object)PTransform.class.getSimpleName());
        Node node = new Node(this.current, transform, name, input);
        this.unexpandedInputs.put(node, input);
        this.current.addComposite(node);
        this.current = node;
        return this.current;
    }

    public @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node replaceNode(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node existing, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        Preconditions.checkNotNull(existing);
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(transform);
        Preconditions.checkState(this.unexpandedInputs.isEmpty(), "Replacing a node when the graph has an unexpanded input. This is an SDK bug.");
        Node replacement = new Node(existing.getEnclosingNode(), transform, existing.getFullName(), input);
        for (PCollection<?> output : existing.getOutputs().values()) {
            Node producer = this.producers.get(output);
            boolean producedInExisting = false;
            do {
                if (producer.equals(existing)) {
                    producedInExisting = true;
                    continue;
                }
                producer = producer.getEnclosingNode();
            } while (!producedInExisting && !producer.isRootNode());
            if (producedInExisting) {
                this.producers.remove(output);
                LOG.debug("Removed producer for value {} as it is part of a replaced composite {}", output, (Object)existing.getFullName());
                continue;
            }
            LOG.debug("Value {} not produced in existing node {}", output, (Object)existing.getFullName());
        }
        existing.getEnclosingNode().replaceChild(existing, replacement);
        this.unexpandedInputs.remove(existing);
        this.unexpandedInputs.put(replacement, input);
        this.current = replacement;
        return replacement;
    }

    public void finishSpecifyingInput() {
        for (PCollection<?> inputValue : this.current.getInputs().values()) {
            PInput input = this.producerInput.remove(inputValue);
            Node producerNode = this.maybeGetProducer(inputValue);
            if (producerNode == null) continue;
            inputValue.finishSpecifying(input, producerNode.getTransform());
        }
    }

    public void setOutput(@UnknownKeyFor @NonNull @Initialized POutput output) {
        for (PCollection<?> value : PValues.fullyExpand(output.expand()).values()) {
            if (!this.producers.containsKey(value)) {
                this.producers.put(value, this.current);
                value.finishSpecifyingOutput(this.current.getFullName(), this.unexpandedInputs.get(this.current), this.current.transform);
            }
            this.producerInput.put(value, this.unexpandedInputs.get(this.current));
        }
        output.finishSpecifyingOutput(this.current.getFullName(), this.unexpandedInputs.get(this.current), this.current.transform);
        this.current.setOutput(output);
    }

    public void replaceOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> originalToReplacement) {
        this.current.replaceOutputs(originalToReplacement);
    }

    public void popNode() {
        this.current.finishSpecifying();
        this.unexpandedInputs.remove(this.current);
        this.current = this.current.getEnclosingNode();
        Preconditions.checkState(this.current != null, "Can't pop the root node of a TransformHierarchy");
    }

    @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node maybeGetProducer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> produced) {
        return this.producers.get(produced);
    }

    @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node getProducer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> produced) {
        return Preconditions.checkNotNull(this.maybeGetProducer(produced), "No producer found for %s", produced);
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> visit(@UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor visitor) {
        this.finishSpecifying();
        HashSet<PValue> visitedValues = new HashSet<PValue>();
        this.root.visit(visitor, visitedValues, new HashSet(), new HashSet());
        return visitedValues;
    }

    private void finishSpecifying() {
        for (Map.Entry<PCollection<?>, PInput> producerInputEntry : this.producerInput.entrySet()) {
            PCollection<?> pCollection = producerInputEntry.getKey();
            pCollection.finishSpecifying(producerInputEntry.getValue(), this.getProducer(pCollection).getTransform());
        }
        this.producerInput.clear();
    }

    public @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node getCurrent() {
        return this.current;
    }

    public class Node {
        private final @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @Nullable @UnknownKeyFor @Initialized Node enclosingNode;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform;
        private final @UnknownKeyFor @NonNull @Initialized String fullName;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> parts = new ArrayList<Node>();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs;
        private final @UnknownKeyFor @NonNull @Initialized ResourceHints resourceHints;
        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized boolean finishedSpecifying = false;

        private Node(ResourceHints resourceHints) {
            this.enclosingNode = null;
            this.transform = null;
            this.fullName = "";
            this.inputs = Collections.emptyMap();
            this.outputs = Collections.emptyMap();
            this.resourceHints = resourceHints;
        }

        private Node(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized TransformHierarchy.Node enclosingNode, @UnknownKeyFor @NonNull @Initialized PTransform<?, ?> transform, @UnknownKeyFor @NonNull @Initialized String fullName, PInput input) {
            this.enclosingNode = enclosingNode;
            this.transform = transform;
            this.fullName = fullName;
            ImmutableMap.Builder<TupleTag<?>, PCollection<?>> inputs = ImmutableMap.builder();
            inputs.putAll(PValues.expandInput(input));
            inputs.putAll(PValues.fullyExpand(transform.getAdditionalInputs()));
            this.inputs = inputs.build();
            this.resourceHints = transform.getResourceHints().mergeWithOuter(enclosingNode.resourceHints);
        }

        private Node(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @Initialized TransformHierarchy.Node enclosingNode, @UnknownKeyFor @NonNull @Initialized PTransform<?, ?> transform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @Initialized String fullName, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, Map<TupleTag<?>, PCollection<?>> outputs) {
            this.enclosingNode = enclosingNode;
            this.transform = transform;
            this.fullName = fullName;
            this.inputs = inputs == null ? Collections.emptyMap() : inputs;
            this.outputs = outputs == null ? Collections.emptyMap() : outputs;
            this.resourceHints = transform.getResourceHints().mergeWithOuter(enclosingNode.resourceHints);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getTransform() {
            return this.transform;
        }

        public @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node getEnclosingNode() {
            return this.enclosingNode;
        }

        public void addComposite(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            this.parts.add(node);
        }

        public void replaceChild(@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node existing, @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node replacement) {
            Preconditions.checkNotNull(existing);
            Preconditions.checkNotNull(replacement);
            int existingIndex = this.parts.indexOf(existing);
            Preconditions.checkArgument(existingIndex >= 0, "Tried to replace a node %s that doesn't exist as a component of node %s", (Object)existing.getFullName(), (Object)this.getFullName());
            LOG.debug("Replaced original node {} with replacement {} at index {}", new Object[]{existing, replacement, existingIndex});
            this.parts.set(existingIndex, replacement);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isCompositeNode() {
            return !this.parts.isEmpty() || this.isRootNode() || this.returnsOthersOutput();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean returnsOthersOutput() {
            PTransform<?, ?> transform = this.getTransform();
            if (this.outputs != null) {
                for (PCollection<?> outputValue : this.outputs.values()) {
                    if (TransformHierarchy.this.getProducer(outputValue).getTransform().equals(transform)) continue;
                    return true;
                }
            }
            return false;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRootNode() {
            return this.transform == null;
        }

        public @UnknownKeyFor @NonNull @Initialized String getFullName() {
            return this.fullName;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs() {
            return this.inputs;
        }

        private void setOutput(@UnknownKeyFor @NonNull @Initialized POutput output) {
            Preconditions.checkState(!this.finishedSpecifying);
            Preconditions.checkState(this.outputs == null, "Tried to specify more than one output for %s", (Object)this.getFullName());
            Preconditions.checkNotNull(output, "Tried to set the output of %s to null", (Object)this.getFullName());
            this.outputs = PValues.expandOutput(output);
            HashSet<Node> outputProducers = new HashSet<Node>();
            for (PCollection<?> outputValue : PValues.expandOutput(output).values()) {
                outputProducers.add(TransformHierarchy.this.getProducer(outputValue));
            }
            if (outputProducers.contains(this) && (!this.parts.isEmpty() || outputProducers.size() > 1)) {
                HashSet<String> otherProducerNames = new HashSet<String>();
                for (Node outputProducer : outputProducers) {
                    if (outputProducer == this) continue;
                    otherProducerNames.add(outputProducer.getFullName());
                }
                throw new IllegalArgumentException(String.format("Output of composite transform [%s] contains a %s produced by it. Only primitive transforms are permitted to produce %ss.%n    Outputs: %s%n    Other Producers: %s%n    Components: %s", this.getFullName(), PCollection.class.getSimpleName(), PCollection.class.getSimpleName(), output.expand(), otherProducerNames, this.parts));
            }
        }

        void replaceOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> originalToReplacement) {
            Preconditions.checkNotNull(this.outputs, "Outputs haven't been specified for node %s yet", (Object)this.getFullName());
            for (Node node : this.parts) {
                node.replaceOutputs(originalToReplacement);
            }
            ImmutableMap.Builder<TupleTag<?>, PCollection<?>> newOutputsBuilder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, PCollection<?>> entry : this.outputs.entrySet()) {
                PTransformOverrideFactory.ReplacementOutput mapping = originalToReplacement.get(entry.getValue());
                if (mapping != null) {
                    if (this.equals(TransformHierarchy.this.producers.get(mapping.getReplacement().getValue()))) {
                        TransformHierarchy.this.producerInput.remove(mapping.getReplacement().getValue());
                        TransformHierarchy.this.producers.remove(mapping.getReplacement().getValue());
                        TransformHierarchy.this.producers.put(mapping.getOriginal().getValue(), this);
                    }
                    LOG.debug("Replacing output {} with original {}", (Object)mapping.getReplacement(), (Object)mapping.getOriginal());
                    newOutputsBuilder.put(entry.getKey(), mapping.getOriginal().getValue());
                    continue;
                }
                newOutputsBuilder.put(entry);
            }
            ImmutableMap<TupleTag<?>, PCollection<?>> immutableMap = newOutputsBuilder.build();
            Preconditions.checkState(this.outputs.size() == immutableMap.size(), "Number of outputs must be stable across replacement");
            this.outputs = immutableMap;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs() {
            return this.outputs == null ? Collections.emptyMap() : this.outputs;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> toAppliedPTransform(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            return AppliedPTransform.of(this.getFullName(), this.inputs, this.outputs, this.getTransform(), this.resourceHints, pipeline);
        }

        private void visit(@UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor visitor, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> visitedValues, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> visitedNodes, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> skippedComposites) {
            if (this.getEnclosingNode() != null && !visitedNodes.contains(this.getEnclosingNode())) {
                this.getEnclosingNode().visit(visitor, visitedValues, visitedNodes, skippedComposites);
            }
            if (!visitedNodes.add(this)) {
                LOG.debug("Not revisiting previously visited node {}", (Object)this);
                return;
            }
            if (this.childNodeOf(skippedComposites)) {
                LOG.debug("Not revisiting Node {} which is a child of a previously passed composite", (Object)this);
                return;
            }
            if (!this.finishedSpecifying) {
                this.finishSpecifying();
            }
            if (!this.isRootNode()) {
                for (PCollection<?> pCollection : this.inputs.values()) {
                    Node valueProducer = TransformHierarchy.this.maybeGetProducer(pCollection);
                    if (valueProducer == null) continue;
                    if (!visitedNodes.contains(valueProducer)) {
                        valueProducer.visit(visitor, visitedValues, visitedNodes, skippedComposites);
                    }
                    if (!visitedValues.add(pCollection)) continue;
                    LOG.debug("Visiting input value {}", pCollection);
                    visitor.visitValue(pCollection, valueProducer);
                }
            }
            if (this.isCompositeNode()) {
                LOG.debug("Visiting composite node {}", (Object)this);
                Pipeline.PipelineVisitor.CompositeBehavior recurse = visitor.enterCompositeTransform(this);
                if (recurse.equals((Object)Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM)) {
                    for (Node child : this.parts) {
                        child.visit(visitor, visitedValues, visitedNodes, skippedComposites);
                    }
                } else {
                    skippedComposites.add(this);
                }
                visitor.leaveCompositeTransform(this);
            } else {
                LOG.debug("Visiting primitive node {}", (Object)this);
                visitor.visitPrimitiveTransform(this);
            }
            if (!this.isRootNode()) {
                Preconditions.checkNotNull(this.outputs, "Outputs for non-root node %s are null", (Object)this.getFullName());
                for (PValue pValue : this.outputs.values()) {
                    if (!visitedValues.add(pValue)) continue;
                    LOG.debug("Visiting output value {}", (Object)pValue);
                    visitor.visitValue(pValue, this);
                }
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean childNodeOf(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> nodes) {
            if (this.isRootNode()) {
                return false;
            }
            Node parent = this.getEnclosingNode();
            while (!parent.isRootNode() && !nodes.contains(parent)) {
                parent = parent.getEnclosingNode();
            }
            return nodes.contains(parent);
        }

        private void finishSpecifying() {
            if (this.finishedSpecifying) {
                return;
            }
            this.finishedSpecifying = true;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            if (this.isRootNode()) {
                return "RootNode";
            }
            return MoreObjects.toStringHelper(this.getClass()).add("fullName", this.fullName).add("transform", this.transform).toString();
        }
    }
}

