/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@VisibleForTesting
public class TextSource
extends FileBasedSource<String> {
    @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter;
    @UnknownKeyFor @NonNull @Initialized int skipHeaderLines;

    public TextSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileSpec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized int skipHeaderLines) {
        super(fileSpec, emptyMatchTreatment, 1L);
        this.delimiter = delimiter;
        this.skipHeaderLines = skipHeaderLines;
    }

    public TextSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileSpec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
        this(fileSpec, emptyMatchTreatment, delimiter, 0);
    }

    public TextSource( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized int skipHeaderLines) {
        super(metadata, 1L, start, end);
        this.delimiter = delimiter;
        this.skipHeaderLines = skipHeaderLines;
    }

    public TextSource( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
        this(metadata, start, end, delimiter, 0);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized String> createForSubrangeOfFile( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata metadata, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        return new TextSource(metadata, start, end, this.delimiter, this.skipHeaderLines);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized FileBasedSource.FileBasedReader<@UnknownKeyFor @NonNull @Initialized String> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new TextBasedReader(this, this.delimiter, this.skipHeaderLines);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized String> getOutputCoder() {
        return StringUtf8Coder.of();
    }

    @VisibleForTesting
    static class TextBasedReader
    extends FileBasedSource.FileBasedReader<String> {
        private static final @UnknownKeyFor @NonNull @Initialized int READ_BUFFER_SIZE = 8192;
        private static final @UnknownKeyFor @NonNull @Initialized ByteString UTF8_BOM = ByteString.copyFrom((byte[])new byte[]{-17, -69, -65});
        private static final @UnknownKeyFor @NonNull @Initialized byte CR = 13;
        private static final @UnknownKeyFor @NonNull @Initialized byte LF = 10;
        private final @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] delimiter;
        private final @UnknownKeyFor @NonNull @Initialized int skipHeaderLines;
        private final @UnknownKeyFor @NonNull @Initialized ByteArrayOutputStream str;
        private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer = new byte[8192];
        private final @UnknownKeyFor @NonNull @Initialized ByteBuffer byteBuffer;
        private @UnknownKeyFor @NonNull @Initialized ReadableByteChannel inChannel;
        private @UnknownKeyFor @NonNull @Initialized long startOfRecord;
        private volatile @UnknownKeyFor @NonNull @Initialized long startOfNextRecord;
        private volatile @UnknownKeyFor @NonNull @Initialized boolean eof;
        private volatile @Nullable @UnknownKeyFor @Initialized String currentValue;
        private @UnknownKeyFor @NonNull @Initialized int bufferLength = 0;
        private @UnknownKeyFor @NonNull @Initialized int bufferPosn = 0;
        private @UnknownKeyFor @NonNull @Initialized boolean skipLineFeedAtStart;

        private TextBasedReader(@UnknownKeyFor @NonNull @Initialized TextSource source, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            this(source, delimiter, 0);
        }

        private TextBasedReader(@UnknownKeyFor @NonNull @Initialized TextSource source, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter, @UnknownKeyFor @NonNull @Initialized int skipHeaderLines) {
            super(source);
            this.str = new ByteArrayOutputStream();
            this.byteBuffer = ByteBuffer.wrap(this.buffer);
            this.delimiter = delimiter;
            this.skipHeaderLines = skipHeaderLines;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized long getCurrentOffset() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentValue == null) {
                throw new NoSuchElementException();
            }
            return this.startOfRecord;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long getSplitPointsRemaining() {
            if (this.isStarted() && this.startOfNextRecord >= this.getCurrentSource().getEndOffset()) {
                return this.isDone() ? 0L : 1L;
            }
            return super.getSplitPointsRemaining();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentValue == null) {
                throw new NoSuchElementException();
            }
            return this.currentValue;
        }

        @Override
        protected void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.inChannel = channel;
            long startOffset = this.getCurrentSource().getStartOffset();
            if (startOffset > 0L) {
                Preconditions.checkState(channel instanceof SeekableByteChannel, "%s only supports reading from a SeekableByteChannel when given a start offset greater than 0.", (Object)TextSource.class.getSimpleName());
                long requiredPosition = startOffset - 1L;
                if (this.delimiter != null && startOffset >= (long)this.delimiter.length) {
                    requiredPosition = startOffset - (long)this.delimiter.length;
                }
                if (requiredPosition < (long)UTF8_BOM.size()) {
                    ((SeekableByteChannel)channel).position(0L);
                    if (this.fileStartsWithBom()) {
                        this.bufferPosn = UTF8_BOM.size();
                        this.startOfNextRecord = this.bufferPosn;
                    } else {
                        this.bufferPosn = (int)requiredPosition;
                        this.startOfNextRecord = this.bufferPosn;
                    }
                    this.skipHeader(this.skipHeaderLines, true);
                } else {
                    this.skipHeader(this.skipHeaderLines, false);
                    if (requiredPosition > this.startOfNextRecord) {
                        ((SeekableByteChannel)channel).position(requiredPosition);
                        this.startOfNextRecord = requiredPosition;
                        this.bufferPosn = 0;
                        this.bufferLength = 0;
                    }
                    this.readNextRecord();
                    this.currentValue = null;
                }
            } else {
                if (this.fileStartsWithBom()) {
                    this.bufferPosn = UTF8_BOM.size();
                    this.startOfNextRecord = this.bufferPosn;
                }
                this.skipHeader(this.skipHeaderLines, false);
            }
        }

        private void skipHeader(@UnknownKeyFor @NonNull @Initialized int headerLines, @UnknownKeyFor @NonNull @Initialized boolean skipFirstLine) throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (headerLines == 1) {
                this.readNextRecord();
            } else if (headerLines > 1) {
                ((SeekableByteChannel)this.inChannel).position(0L);
                for (int line = 0; line < headerLines; ++line) {
                    this.readNextRecord();
                }
            } else if (headerLines == 0 && skipFirstLine) {
                this.readNextRecord();
            }
            this.currentValue = null;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean fileStartsWithBom() throws @UnknownKeyFor @NonNull @Initialized IOException {
            int i;
            do {
                int bytesRead;
                if ((bytesRead = this.inChannel.read(this.byteBuffer)) == -1) {
                    return false;
                }
                this.bufferLength += bytesRead;
            } while (this.bufferLength < UTF8_BOM.size());
            for (i = 0; i < UTF8_BOM.size() && this.buffer[i] == UTF8_BOM.byteAt(i); ++i) {
            }
            return i == UTF8_BOM.size();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.startOfRecord = this.startOfNextRecord;
            if (this.eof) {
                this.currentValue = null;
                return false;
            }
            if (this.delimiter == null) {
                return this.readDefaultLine();
            }
            return this.readCustomLine();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean readDefaultLine() throws @UnknownKeyFor @NonNull @Initialized IOException {
            long bytesConsumed;
            block12: {
                int appendLength;
                int startPosn;
                assert (!this.eof);
                int newlineLength = 0;
                boolean prevCharCR = false;
                bytesConsumed = 0L;
                while (true) {
                    startPosn = this.bufferPosn;
                    while (this.bufferPosn == this.bufferLength) {
                        this.bufferPosn = 0;
                        startPosn = 0;
                        this.byteBuffer.clear();
                        this.bufferLength = this.inChannel.read(this.byteBuffer);
                        if (this.bufferLength >= 0) continue;
                        this.eof = true;
                        if (this.str.size() == 0) {
                            return false;
                        }
                        this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                        break block12;
                    }
                    if (this.skipLineFeedAtStart && this.buffer[this.bufferPosn] == 10) {
                        ++startPosn;
                        ++this.bufferPosn;
                        this.skipLineFeedAtStart = false;
                        ++this.startOfRecord;
                    }
                    while (this.bufferPosn < this.bufferLength) {
                        if (this.buffer[this.bufferPosn] == 10) {
                            newlineLength = prevCharCR ? 2 : 1;
                            ++this.bufferPosn;
                            break;
                        }
                        if (prevCharCR) {
                            newlineLength = 1;
                            break;
                        }
                        prevCharCR = this.buffer[this.bufferPosn] == 13;
                        ++this.bufferPosn;
                    }
                    if (newlineLength == 0 && prevCharCR) {
                        this.skipLineFeedAtStart = true;
                        newlineLength = 1;
                    } else {
                        this.skipLineFeedAtStart = false;
                    }
                    int readLength = this.bufferPosn - startPosn;
                    bytesConsumed += (long)readLength;
                    appendLength = readLength - newlineLength;
                    if (newlineLength != 0) break;
                    this.str.write(this.buffer, startPosn, appendLength);
                }
                if (this.str.size() == 0) {
                    this.currentValue = new String(this.buffer, startPosn, appendLength, StandardCharsets.UTF_8);
                } else {
                    this.str.write(this.buffer, startPosn, appendLength);
                    this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                }
            }
            this.startOfNextRecord = this.startOfRecord + bytesConsumed;
            this.str.reset();
            return true;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean readCustomLine() throws @UnknownKeyFor @NonNull @Initialized IOException {
            long bytesConsumed;
            block16: {
                int appendLength;
                int startPosn;
                assert (!this.eof);
                bytesConsumed = 0L;
                int delPosn = 0;
                while (true) {
                    int prevDelPosn;
                    block17: {
                        startPosn = this.bufferPosn;
                        while (this.bufferPosn >= this.bufferLength) {
                            this.bufferPosn = 0;
                            startPosn = 0;
                            this.byteBuffer.clear();
                            this.bufferLength = this.inChannel.read(this.byteBuffer);
                            if (this.bufferLength >= 0) continue;
                            this.eof = true;
                            if (delPosn != 0) {
                                this.str.write(this.delimiter, 0, delPosn);
                            }
                            if (this.str.size() == 0) {
                                return false;
                            }
                            this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                            break block16;
                        }
                        prevDelPosn = delPosn;
                        if (delPosn > 0) {
                            while (this.bufferPosn < this.bufferLength) {
                                if (this.buffer[this.bufferPosn] == this.delimiter[delPosn]) {
                                    if (++delPosn == this.delimiter.length) {
                                        ++this.bufferPosn;
                                        break block17;
                                    }
                                } else {
                                    this.str.write(this.delimiter, 0, prevDelPosn);
                                    delPosn = 0;
                                    break;
                                }
                                ++this.bufferPosn;
                            }
                        }
                        while (this.bufferPosn < this.bufferLength) {
                            if (this.buffer[this.bufferPosn] == this.delimiter[delPosn]) {
                                if (++delPosn == this.delimiter.length) {
                                    ++this.bufferPosn;
                                    break;
                                }
                            } else {
                                delPosn = 0;
                            }
                            ++this.bufferPosn;
                        }
                    }
                    int readLength = this.bufferPosn - startPosn;
                    bytesConsumed += (long)readLength;
                    appendLength = readLength - (delPosn - prevDelPosn);
                    if (delPosn >= this.delimiter.length) break;
                    this.str.write(this.buffer, startPosn, appendLength);
                }
                if (this.str.size() == 0) {
                    this.currentValue = new String(this.buffer, startPosn, appendLength, StandardCharsets.UTF_8);
                } else {
                    this.str.write(this.buffer, startPosn, appendLength);
                    this.currentValue = this.str.toString(StandardCharsets.UTF_8.name());
                }
            }
            this.startOfNextRecord = this.startOfRecord + bytesConsumed;
            this.str.reset();
            return true;
        }
    }
}

