/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NullableCoder<@UnknownKeyFor T>
extends StructuredCoder<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder;
    private static final @UnknownKeyFor @NonNull @Initialized int ENCODE_NULL = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int ENCODE_PRESENT = 1;

    public static <T> @UnknownKeyFor @NonNull @Initialized NullableCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        if (valueCoder instanceof NullableCoder) {
            return (NullableCoder)valueCoder;
        }
        return new NullableCoder<T>(valueCoder);
    }

    private NullableCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> valueCoder) {
        this.valueCoder = valueCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getValueCoder() {
        return this.valueCoder;
    }

    @Override
    public void encode(@Nullable T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@Nullable T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (value == null) {
            outStream.write(0);
        } else {
            outStream.write(1);
            this.valueCoder.encode(value, outStream, context);
        }
    }

    @Override
    public @Nullable T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @Nullable T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        int b = inStream.read();
        if (b == 0) {
            return null;
        }
        if (b != 1) {
            throw new CoderException(String.format("NullableCoder expects either a byte valued %s (null) or %s (present), got %s", 0, 1, b));
        }
        return this.valueCoder.decode(inStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<T>> getCoderArguments() {
        return ImmutableList.of(this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        NullableCoder.verifyDeterministic(this, "Value coder must be deterministic", this.valueCoder);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.valueCoder.consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@Nullable T value) {
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of(this.valueCoder.structuralValue(value));
    }

    @Override
    public void registerByteSizeObserver(@Nullable T value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        observer.update(1);
        if (value != null) {
            this.valueCoder.registerByteSizeObserver(value, observer);
        }
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@Nullable T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (value == null) {
            return 1L;
        }
        if (this.valueCoder instanceof StructuredCoder) {
            return 1L + ((StructuredCoder)this.valueCoder).getEncodedElementByteSize(value);
        }
        return super.getEncodedElementByteSize(value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@Nullable T value) {
        if (value == null) {
            return true;
        }
        return this.valueCoder.isRegisterByteSizeObserverCheap(value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@Nullable T> getEncodedTypeDescriptor() {
        return this.valueCoder.getEncodedTypeDescriptor();
    }
}

