/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.core.metrics.LabeledMetrics;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ServiceCallMetric {
    public static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized String> CANONICAL_STATUS_MAP = ImmutableMap.builder().put(200, "ok").put(400, "out_of_range").put(401, "unauthenticated").put(403, "permission_denied").put(404, "not_found").put(409, "already_exists").put(429, "resource_exhausted").put(499, "cancelled").put(500, "internal").put(501, "not_implemented").put(503, "unavailable").put(504, "deadline_exceeded").build();
    public static final @UnknownKeyFor @NonNull @Initialized String CANONICAL_STATUS_UNKNOWN = "unknown";
    public static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> STATUS_NORMALIZATION_MAP = ImmutableMap.builder().put("outofrange", "out_of_range").put("permissiondenied", "permission_denied").put("notfound", "not_found").put("alreadyexists", "already_exists").put("resourceexhausted", "resource_exhausted").put("notimplemented", "not_implemented").put("unavailable", "unavailable").put("deadlineexceeded", "deadline_exceeded").build();
    private @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels;
    private final @UnknownKeyFor @NonNull @Initialized String requestCountUrn;

    public ServiceCallMetric(@UnknownKeyFor @NonNull @Initialized String requestCountUrn, @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> baseLabels) {
        this.requestCountUrn = requestCountUrn;
        this.labels = baseLabels;
    }

    public void call(@UnknownKeyFor @NonNull @Initialized int httpStatusCode) {
        String canonicalStatusCode = ServiceCallMetric.convertToCanonicalStatusString(httpStatusCode);
        this.call(canonicalStatusCode);
    }

    public void call(@UnknownKeyFor @NonNull @Initialized String statusCode) {
        this.labels.put("STATUS", ServiceCallMetric.convertToCanonicalStatusString(statusCode));
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named(this.requestCountUrn, this.labels);
        Counter counter = LabeledMetrics.counter(name, true);
        counter.inc();
    }

    public static @UnknownKeyFor @NonNull @Initialized String convertToCanonicalStatusString(@UnknownKeyFor @NonNull @Initialized int httpStatusCode) {
        return CANONICAL_STATUS_MAP.getOrDefault(httpStatusCode, CANONICAL_STATUS_UNKNOWN);
    }

    public static @UnknownKeyFor @NonNull @Initialized String convertToCanonicalStatusString(@UnknownKeyFor @NonNull @Initialized String statusCode) {
        if (statusCode == null) {
            return CANONICAL_STATUS_UNKNOWN;
        }
        String normalizedStatus = STATUS_NORMALIZATION_MAP.get(statusCode.toLowerCase());
        if (normalizedStatus != null) {
            return normalizedStatus;
        }
        return statusCode.toLowerCase();
    }
}

