/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class StateNamespaces {
    private static final @UnknownKeyFor @NonNull @Initialized Splitter SLASH_SPLITTER = Splitter.on('/');

    public static @UnknownKeyFor @NonNull @Initialized StateNamespace global() {
        return new GlobalNamespace();
    }

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateNamespace window(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, W window) {
        return new WindowNamespace(windowCoder, window, null);
    }

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateNamespace windowAndTrigger(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, W window, @UnknownKeyFor @NonNull @Initialized int triggerIdx) {
        return new WindowAndTriggerNamespace(windowCoder, window, triggerIdx, null);
    }

    private StateNamespaces() {
    }

    public static <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized StateNamespace fromString(@UnknownKeyFor @NonNull @Initialized String stringKey, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        if (!stringKey.startsWith("/") || !stringKey.endsWith("/")) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'");
        }
        if ("/".equals(stringKey)) {
            return StateNamespaces.global();
        }
        List<String> parts = SLASH_SPLITTER.splitToList(stringKey);
        if (parts.size() != 3 && parts.size() != 4) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'");
        }
        if (!parts.get(0).isEmpty() || !parts.get(parts.size() - 1).isEmpty()) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'");
        }
        try {
            BoundedWindow window = (BoundedWindow)CoderUtils.decodeFromBase64(windowCoder, parts.get(1));
            if (parts.size() > 3) {
                int index = Integer.parseInt(parts.get(2), 36);
                return StateNamespaces.windowAndTrigger(windowCoder, window, index);
            }
            return StateNamespaces.window(windowCoder, window);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid namespace string: '" + stringKey + "'", e);
        }
    }

    public static class WindowAndTriggerNamespace<@UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    implements StateNamespace {
        private static final @UnknownKeyFor @NonNull @Initialized int TRIGGER_RADIX = 36;
        private @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;
        private W window;
        private @UnknownKeyFor @NonNull @Initialized int triggerIndex;

        private WindowAndTriggerNamespace(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, W window, @UnknownKeyFor @NonNull @Initialized int triggerIndex) {
            this.windowCoder = windowCoder;
            this.window = window;
            this.triggerIndex = triggerIndex;
        }

        public W getWindow() {
            return this.window;
        }

        public @UnknownKeyFor @NonNull @Initialized int getTriggerIndex() {
            return this.triggerIndex;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String stringKey() {
            try {
                return "/" + CoderUtils.encodeToBase64(this.windowCoder, this.window) + "/" + Integer.toString(this.triggerIndex, 36).toUpperCase() + "/";
            }
            catch (CoderException e) {
                throw new RuntimeException("Unable to generate string key from window " + this.window, e);
            }
        }

        @Override
        public void appendTo(@UnknownKeyFor @NonNull @Initialized Appendable sb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            sb.append('/').append(CoderUtils.encodeToBase64(this.windowCoder, this.window));
            sb.append('/').append(Integer.toString(this.triggerIndex, 36).toUpperCase());
            sb.append('/');
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object getCacheKey() {
            return this.window;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WindowAndTriggerNamespace)) {
                return false;
            }
            WindowAndTriggerNamespace that = (WindowAndTriggerNamespace)obj;
            return this.triggerIndex == that.triggerIndex && Objects.equals(this.windowStructuralValue(), that.windowStructuralValue());
        }

        private @UnknownKeyFor @NonNull @Initialized Object windowStructuralValue() {
            return this.windowCoder.structuralValue(this.window);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(new Object[]{Namespace.WINDOW_AND_TRIGGER, this.window, this.triggerIndex});
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "WindowAndTrigger(" + this.window + "," + this.triggerIndex + ")";
        }

        /* synthetic */ WindowAndTriggerNamespace(Coder x0, BoundedWindow x1, int x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class WindowNamespace<@UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    implements StateNamespace {
        private @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;
        private W window;

        private WindowNamespace(@UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder, W window) {
            this.windowCoder = windowCoder;
            this.window = window;
        }

        public W getWindow() {
            return this.window;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String stringKey() {
            try {
                return "/" + CoderUtils.encodeToBase64(this.windowCoder, this.window) + "/";
            }
            catch (CoderException e) {
                throw new RuntimeException("Unable to generate string key from window " + this.window, e);
            }
        }

        @Override
        public void appendTo(@UnknownKeyFor @NonNull @Initialized Appendable sb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            sb.append('/').append(CoderUtils.encodeToBase64(this.windowCoder, this.window)).append('/');
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object getCacheKey() {
            return this.window;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WindowNamespace)) {
                return false;
            }
            WindowNamespace that = (WindowNamespace)obj;
            return Objects.equals(this.windowStructuralValue(), that.windowStructuralValue());
        }

        private @UnknownKeyFor @NonNull @Initialized Object windowStructuralValue() {
            return this.windowCoder.structuralValue(this.window);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(new Object[]{Namespace.WINDOW, this.window});
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "Window(" + this.window + ")";
        }

        /* synthetic */ WindowNamespace(Coder x0, BoundedWindow x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class GlobalNamespace
    implements StateNamespace {
        private static final @UnknownKeyFor @NonNull @Initialized String GLOBAL_STRING = "/";

        @Override
        public @UnknownKeyFor @NonNull @Initialized String stringKey() {
            return GLOBAL_STRING;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object getCacheKey() {
            return GLOBAL_STRING;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return obj == this || obj instanceof GlobalNamespace;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(new Object[]{Namespace.GLOBAL});
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "Global";
        }

        @Override
        public void appendTo(@UnknownKeyFor @NonNull @Initialized Appendable sb) throws @UnknownKeyFor @NonNull @Initialized IOException {
            sb.append(GLOBAL_STRING);
        }
    }

    private static enum Namespace {
        GLOBAL,
        WINDOW,
        WINDOW_AND_TRIGGER;

    }
}

