/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.server.HopServerMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.www.HopServer;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WorkflowMap;

public class HopServerSingleton {
    private static final Class<?> PKG = HopServer.class;
    private static HopServerConfig hopServerConfig;
    private static HopServerSingleton hopServerSingleton;
    private static HopServer hopServer;
    private ILogChannel log;
    private PipelineMap pipelineMap;
    private WorkflowMap workflowMap;

    private HopServerSingleton(HopServerConfig config) throws HopException {
        HopEnvironment.init();
        HopLogStore.init();
        this.log = new LogChannel((Object)"HopServer");
        this.pipelineMap = new PipelineMap();
        this.pipelineMap.setHopServerConfig(config);
        this.workflowMap = new WorkflowMap();
        this.workflowMap.setHopServerConfig(config);
        HopServerSingleton.installPurgeTimer(config, this.log, this.pipelineMap, this.workflowMap);
        HopServerMeta hopServer = config.getHopServer();
        if (hopServer != null) {
            int port = 80;
            if (!Utils.isEmpty((CharSequence)hopServer.getPort())) {
                try {
                    port = Integer.parseInt(hopServer.getPort());
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"HopServer.Error.CanNotPartPort", (String[])new String[]{hopServer.getHostname(), "" + port}), (Throwable)e);
                }
            }
        }
    }

    public static void installPurgeTimer(HopServerConfig config, final ILogChannel log, final PipelineMap pipelineMap, final WorkflowMap workflowMap) {
        String systemTimeout = EnvUtil.getSystemProperty((String)"HOP_SERVER_OBJECT_TIMEOUT_MINUTES", null);
        final int objectTimeout = config.getObjectTimeoutMinutes() > 0 ? config.getObjectTimeoutMinutes() : (!Utils.isEmpty((CharSequence)systemTimeout) ? Const.toInt((String)systemTimeout, (int)1440) : 1440);
        if (objectTimeout > 0) {
            log.logBasic("Installing timer to purge stale objects after " + objectTimeout + " minutes.");
            Timer timer = new Timer(true);
            final AtomicBoolean busy = new AtomicBoolean(false);
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!busy.get()) {
                        busy.set(true);
                        try {
                            int diffInMinutes;
                            for (HopServerObjectEntry entry : pipelineMap.getPipelineObjects()) {
                                IPipelineEngine<PipelineMeta> pipeline = pipelineMap.getPipeline(entry);
                                if (pipeline == null || !pipeline.isFinished() && !pipeline.isStopped() || pipeline.getExecutionStartDate() == null || (diffInMinutes = (int)Math.floor((System.currentTimeMillis() - pipeline.getExecutionStartDate().getTime()) / 60000L)) < objectTimeout) continue;
                                pipelineMap.removePipeline(entry);
                                LoggingRegistry.getInstance().removeIncludingChildren(pipeline.getLogChannelId());
                                HopLogStore.discardLines((String)pipeline.getLogChannelId(), (boolean)false);
                                log.logBasic("Cleaned up pipeline " + entry.getName() + " with id " + entry.getId() + " from " + pipeline.getExecutionStartDate() + ", diff=" + diffInMinutes);
                            }
                            for (HopServerObjectEntry entry : workflowMap.getWorkflowObjects()) {
                                IWorkflowEngine<WorkflowMeta> workflow = workflowMap.getWorkflow(entry);
                                if (workflow == null || !workflow.isFinished() && !workflow.isStopped() || workflow.getExecutionStartDate() == null || (diffInMinutes = (int)Math.floor((System.currentTimeMillis() - workflow.getExecutionStartDate().getTime()) / 60000L)) < objectTimeout) continue;
                                String id = workflowMap.getWorkflow(entry).getLogChannelId();
                                LoggingRegistry.getInstance().removeLogChannelFileWriterBuffer(id);
                                workflowMap.removeWorkflow(entry);
                                log.logBasic("Cleaned up workflow " + entry.getName() + " with id " + entry.getId() + " from " + workflow.getExecutionStartDate());
                            }
                        }
                        finally {
                            busy.set(false);
                        }
                    }
                }
            };
            timer.schedule(timerTask, 20000L, 20000L);
        }
    }

    public static HopServerSingleton getInstance() {
        try {
            if (hopServerSingleton == null) {
                if (hopServerConfig == null) {
                    hopServerConfig = new HopServerConfig();
                    HopServerMeta hopServer = new HopServerMeta();
                    hopServerConfig.setHopServer(hopServer);
                }
                hopServerSingleton = new HopServerSingleton(hopServerConfig);
                String serverObjectId = UUID.randomUUID().toString();
                SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject("HopServerSingleton", LoggingObjectType.HOP_SERVER, null);
                servletLoggingObject.setContainerObjectId(serverObjectId);
                servletLoggingObject.setLogLevel(LogLevel.BASIC);
                return hopServerSingleton;
            }
            return hopServerSingleton;
        }
        catch (HopException ke) {
            throw new RuntimeException(ke);
        }
    }

    public PipelineMap getPipelineMap() {
        return this.pipelineMap;
    }

    public void setPipelineMap(PipelineMap pipelineMap) {
        this.pipelineMap = pipelineMap;
    }

    public WorkflowMap getWorkflowMap() {
        return this.workflowMap;
    }

    public void setWorkflowMap(WorkflowMap workflowMap) {
        this.workflowMap = workflowMap;
    }

    public static HopServerConfig getHopServerConfig() {
        return hopServerConfig;
    }

    public static void setHopServerConfig(HopServerConfig hopServerConfig) {
        HopServerSingleton.hopServerConfig = hopServerConfig;
    }

    public static void setHopServer(HopServer hopServer) {
        HopServerSingleton.hopServer = hopServer;
    }

    public static HopServer getHopServer() {
        return hopServer;
    }

    public ILogChannel getLog() {
        return this.log;
    }
}

